/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import docking.widgets.fieldpanel.support.RowColLocation;
import ghidra.app.util.PseudoDisassembler;
import ghidra.app.util.RefRepeatComment;
import ghidra.docking.settings.Settings;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DefaultDataType;
import ghidra.program.model.data.StringDataInstance;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.util.AutomaticCommentFieldLocation;
import ghidra.program.util.CommentFieldLocation;
import ghidra.program.util.EolCommentFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.RefRepeatCommentFieldLocation;
import ghidra.program.util.RepeatableCommentFieldLocation;
import ghidra.util.StringUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class DisplayableEol {
    private static final String POINTER_ARROW = "-> ";
    public static final int MY_EOLS = 0;
    public static final int MY_REPEATABLES = 1;
    public static final int REF_REPEATABLES = 2;
    public static final int MY_AUTOMATIC = 3;
    private CodeUnit codeUnit;
    private Object[][] displayCommentArrays = new Object[][]{null, null, null, null};
    private boolean alwaysShowRepeatable = false;
    private boolean alwaysShowRefRepeats = false;
    private boolean alwaysShowAutomatic = false;
    private boolean showAutomaticFunctions;
    private boolean operandsFollowPointerRefs = false;
    private int maxDisplayLines;
    private int totalCommentsFound;
    private boolean useAbbreviatedAutomatic;

    public DisplayableEol(CodeUnit cu, boolean alwaysShowRepeatable, boolean alwaysShowRefRepeats, boolean alwaysShowAutomatic, boolean operandsFollowPointerRefs, int maxDisplayLines, boolean useAbbreviatedAutomatic, boolean showAutomaticFunctions) {
        this.codeUnit = cu;
        this.alwaysShowRepeatable = alwaysShowRepeatable;
        this.alwaysShowRefRepeats = alwaysShowRefRepeats;
        this.alwaysShowAutomatic = alwaysShowAutomatic;
        this.operandsFollowPointerRefs = operandsFollowPointerRefs;
        this.maxDisplayLines = maxDisplayLines;
        this.useAbbreviatedAutomatic = useAbbreviatedAutomatic;
        this.showAutomaticFunctions = showAutomaticFunctions;
        this.initComments();
    }

    private void initComments() {
        this.displayCommentArrays[0] = this.codeUnit.getCommentAsArray(0);
        this.totalCommentsFound += this.displayCommentArrays[0].length;
        this.displayCommentArrays[1] = this.codeUnit.getCommentAsArray(4);
        this.totalCommentsFound += this.displayCommentArrays[1].length;
        this.displayCommentArrays[2] = new RefRepeatComment[0];
        this.displayCommentArrays[3] = new String[0];
        if (this.totalCommentsFound > this.maxDisplayLines) {
            return;
        }
        Object[] refs = this.getReferencesFrom(this.codeUnit, 100);
        Arrays.sort(refs);
        Program program = this.codeUnit.getProgram();
        this.displayCommentArrays[2] = this.getRepeatableComments(program.getListing(), (Reference[])refs, true);
        this.totalCommentsFound += this.displayCommentArrays[2].length;
        this.displayCommentArrays[3] = this.getReferencePreviews(program, (Reference[])refs);
        this.totalCommentsFound += this.displayCommentArrays[3].length;
    }

    private Reference[] getReferencesFrom(CodeUnit cu, int maxReferences) {
        ArrayList<Reference> list = new ArrayList<Reference>();
        Program program = cu.getProgram();
        ReferenceManager referenceManager = program.getReferenceManager();
        AddressSet set = new AddressSet(cu.getMinAddress(), cu.getMaxAddress());
        AddressIterator iter = referenceManager.getReferenceSourceIterator((AddressSetView)set, true);
        while (iter.hasNext() && list.size() < maxReferences) {
            Reference[] refs;
            Address fromAddress = iter.next();
            for (Reference element : refs = referenceManager.getReferencesFrom(fromAddress)) {
                list.add(element);
            }
        }
        return list.toArray(new Reference[list.size()]);
    }

    public boolean hasEOL() {
        return this.displayCommentArrays[0] != null && ((String[])this.displayCommentArrays[0]).length > 0;
    }

    public boolean hasRepeatable() {
        return this.displayCommentArrays[1] != null && ((String[])this.displayCommentArrays[1]).length > 0;
    }

    public boolean hasReferencedRepeatable() {
        return this.displayCommentArrays[2] != null && this.displayCommentArrays[2].length > 0;
    }

    public boolean hasAutomatic() {
        return this.displayCommentArrays[3] != null && this.displayCommentArrays[3].length > 0;
    }

    private String[] getReferencePreviews(Program program, Reference[] refs) {
        if (refs.length == 0) {
            return this.getPreviewForNoReferences();
        }
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Reference reference : refs) {
            if (this.reachedMaximumResults(set.size())) break;
            if (!this.isValidReference(program, reference)) continue;
            this.addReferencePreview(set, program, reference);
        }
        String[] array = new String[set.size()];
        set.toArray(array);
        return array;
    }

    private String[] getPreviewForNoReferences() {
        String undefinedPointerText = this.getUndefinedPointer(this.codeUnit);
        if (undefinedPointerText != null) {
            return new String[]{undefinedPointerText};
        }
        return new String[0];
    }

    private boolean isValidReference(Program program, Reference reference) {
        if (!reference.isMemoryReference()) {
            return false;
        }
        Address toAddr = reference.getToAddress();
        return this.isGoodAddress(program, toAddr);
    }

    private boolean reachedMaximumResults(int newCount) {
        return this.totalCommentsFound + newCount >= this.maxDisplayLines;
    }

    private void addReferencePreview(Set<String> results, Program program, Reference reference) {
        Address toAddr = reference.getToAddress();
        if (this.handleDirectFlow(results, reference, program, toAddr)) {
            return;
        }
        Data data = this.getData(program, toAddr);
        if (data == null) {
            return;
        }
        if (this.handleIndirectDataReference(results, reference, program, toAddr, data)) {
            return;
        }
        this.handleDirectDataReference(results, toAddr, data);
    }

    private Data getData(Program program, Address toAddr) {
        Data data = program.getListing().getDataAt(toAddr);
        if (data == null) {
            data = program.getListing().getDataContaining(toAddr);
        }
        return data;
    }

    private void handleDirectDataReference(Set<String> set, Address dataAccessAddress, Data data) {
        Scalar scalar;
        Object value = data.getValue();
        if (value instanceof Scalar && (scalar = (Scalar)value).getSignedValue() == 0L) {
            return;
        }
        String dataRepresentation = this.getDataValueRepresentation(dataAccessAddress, data);
        if (!StringUtils.isBlank((CharSequence)dataRepresentation)) {
            set.add("= " + dataRepresentation);
        }
    }

    private String getDataValueRepresentation(Address dataAccessAddress, Data data) {
        if (!this.useAbbreviatedAutomatic) {
            return data.getDefaultValueRepresentation();
        }
        if (this.isOffcut(dataAccessAddress, (CodeUnit)data)) {
            return this.getOffcutDataString(dataAccessAddress, data);
        }
        return data.getDefaultValueRepresentation();
    }

    private boolean isOffcut(Address address, CodeUnit cu) {
        if (cu == null) {
            return false;
        }
        return !cu.getMinAddress().equals((Object)address);
    }

    private String getOffcutDataString(Address offcutAddress, Data data) {
        Address dataAddress = data.getMinAddress();
        int diff = (int)offcutAddress.subtract(dataAddress);
        DataType dt = data.getBaseDataType();
        return this.getOffcutForStringData(data, dataAddress, diff, dt);
    }

    private String getOffcutForStringData(Data data, Address dataAddress, int diff, DataType dt) {
        if (StringDataInstance.isString((Data)data)) {
            StringDataInstance string = StringDataInstance.getStringDataInstance((Data)data);
            string = string.getByteOffcut(diff);
            return string.getStringRepresentation();
        }
        if (!data.hasStringValue()) {
            return null;
        }
        int len = data.getLength();
        if (diff >= len) {
            return data.getDefaultValueRepresentation();
        }
        DumbMemBufferImpl mb = new DumbMemBufferImpl(data.getMemory(), dataAddress.add((long)diff));
        String s = dt.getRepresentation((MemBuffer)mb, (Settings)data, len - diff);
        return s;
    }

    private boolean handleIndirectDataReference(Set<String> set, Reference reference, Program program, Address toAddress, Data data) {
        RefType type = reference.getReferenceType();
        if (!type.isIndirect()) {
            return false;
        }
        if (this.handlePointer(set, program, reference, data)) {
            return true;
        }
        this.handlePotentialPointer(set, program, toAddress, data);
        return true;
    }

    private boolean handlePointer(Set<String> set, Program program, Reference reference, Data data) {
        if (!data.isPointer()) {
            return false;
        }
        SymbolTable symbolTable = program.getSymbolTable();
        ReferenceManager referenceManager = program.getReferenceManager();
        Reference pointerReference = referenceManager.getPrimaryReferenceFrom(reference.getToAddress(), 0);
        if (pointerReference != null) {
            Address addr = pointerReference.getToAddress();
            Symbol sym = symbolTable.getPrimarySymbol(addr);
            if (this.operandsFollowPointerRefs && reference.getOperandIndex() != -1 && !sym.isDynamic()) {
                return true;
            }
            set.add(POINTER_ARROW + sym.getName());
            return true;
        }
        Address address = (Address)data.getValue();
        if (address != null && address.getOffset() != 0L) {
            set.add(POINTER_ARROW + address);
        }
        return true;
    }

    private void handlePotentialPointer(Set<String> list, Program program, Address toAddress, Data data) {
        if (data.isDefined()) {
            return;
        }
        SymbolTable symbolTable = program.getSymbolTable();
        PseudoDisassembler dis = new PseudoDisassembler(program);
        Address pointerAddress = dis.getIndirectAddr(toAddress);
        if (!this.isGoodAddress(program, pointerAddress)) {
            return;
        }
        Symbol symbol = symbolTable.getPrimarySymbol(pointerAddress);
        if (symbol != null) {
            list.add(POINTER_ARROW + symbol.getName());
        } else {
            list.add(POINTER_ARROW + pointerAddress);
        }
    }

    private boolean handleDirectFlow(Set<String> set, Reference reference, Program program, Address toAddr) {
        boolean showName;
        String signature;
        if (!this.showAutomaticFunctions) {
            return false;
        }
        RefType type = reference.getReferenceType();
        if (!type.isFlow()) {
            return false;
        }
        if (type.isIndirect()) {
            return false;
        }
        if (type.isCall() && (signature = this.getFunctionSignature(program, toAddr, showName = reference.isMnemonicReference())) != null) {
            set.add(signature);
        }
        return true;
    }

    private String getUndefinedPointer(CodeUnit cu) {
        if (!(cu instanceof Data)) {
            return null;
        }
        Data data = (Data)cu;
        DataType dataType = data.getDataType();
        if (!(dataType instanceof Undefined) && !(dataType instanceof DefaultDataType)) {
            return null;
        }
        Program program = cu.getProgram();
        if (this.programIsEntireMemorySpace(program)) {
            return null;
        }
        int align = program.getLanguage().getInstructionAlignment();
        Address codeUnitAddress = cu.getAddress();
        long codeUnitOffset = codeUnitAddress.getOffset();
        if (codeUnitOffset % (long)align != 0L) {
            return null;
        }
        int pointerSize = program.getDefaultPointerSize();
        long addrLong = 0L;
        Memory memory = program.getMemory();
        try {
            switch (pointerSize) {
                case 4: {
                    int addrInt = memory.getInt(codeUnitAddress);
                    addrLong = (long)addrInt & 0xFFFFFFFFL;
                    addrLong *= (long)codeUnitAddress.getAddressSpace().getAddressableUnitSize();
                    break;
                }
                case 8: {
                    addrLong = memory.getLong(codeUnitAddress);
                }
            }
        }
        catch (MemoryAccessException addrInt) {
            // empty catch block
        }
        if (addrLong != 0L) {
            try {
                Address potentialAddr = codeUnitAddress.getNewAddress(addrLong);
                if (memory.contains(potentialAddr)) {
                    return "?  ->  " + potentialAddr.toString();
                }
            }
            catch (AddressOutOfBoundsException addressOutOfBoundsException) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean programIsEntireMemorySpace(Program program) {
        Address minAddress = program.getMinAddress();
        Address maxAddress = program.getMaxAddress();
        AddressSpace addressSpace = maxAddress.getAddressSpace();
        Address spaceMaxAddress = addressSpace.getMaxAddress();
        long minOffset = minAddress.getOffset();
        return minOffset == 0L && maxAddress.equals((Object)spaceMaxAddress);
    }

    private String getFunctionSignature(Program program, Address funcAddr, boolean displayFuncName) {
        Function function = program.getFunctionManager().getFunctionAt(funcAddr);
        if (function == null) {
            return null;
        }
        return function.getPrototypeString(false, false);
    }

    private boolean isGoodAddress(Program program, Address addr) {
        if (addr == null) {
            return false;
        }
        if (!program.getMemory().contains(addr)) {
            return false;
        }
        long offset = addr.getOffset();
        return offset != 0L && offset != -1L && offset != 65535L && offset != 255L;
    }

    private RefRepeatComment[] getRepeatableComments(Listing listing, Reference[] memRefs, boolean showAll) {
        LinkedHashSet<RefRepeatComment> set = new LinkedHashSet<RefRepeatComment>();
        for (int i = 0; i < memRefs.length && this.totalCommentsFound < this.maxDisplayLines; ++i) {
            Address address;
            String[] comment;
            if (!showAll && !memRefs[i].isPrimary() || (comment = this.getComment(listing, address = memRefs[i].getToAddress())) == null || comment.length <= 0) continue;
            set.add(new RefRepeatComment(address, comment));
            ++this.totalCommentsFound;
        }
        return set.toArray(new RefRepeatComment[set.size()]);
    }

    private String[] getComment(Listing listing, Address address) {
        String repeatableComment = listing.getComment(4, address);
        if (repeatableComment != null) {
            return StringUtilities.toLines((String)repeatableComment);
        }
        CodeUnit cu = listing.getCodeUnitAt(address);
        if (cu == null) {
            return null;
        }
        Function func = listing.getFunctionAt(address);
        if (func != null) {
            return func.getRepeatableCommentAsArray();
        }
        return cu.getCommentAsArray(4);
    }

    public String[] getComments() {
        ArrayList<String> list = new ArrayList<String>();
        boolean hasEol = this.hasEOL();
        boolean hasRepeatable = this.hasRepeatable();
        boolean hasRefRepeats = this.hasReferencedRepeatable();
        list.addAll(Arrays.asList((String[])this.displayCommentArrays[0]));
        if (this.alwaysShowRepeatable || !hasEol) {
            list.addAll(Arrays.asList((String[])this.displayCommentArrays[1]));
        }
        if (this.alwaysShowRefRepeats || !hasEol && !hasRepeatable) {
            RefRepeatComment[] refRepeatComments;
            for (RefRepeatComment refRepeatComment : refRepeatComments = (RefRepeatComment[])this.displayCommentArrays[2]) {
                list.addAll(Arrays.asList(refRepeatComment.getCommentLines()));
            }
        }
        if (this.alwaysShowAutomatic || !hasEol && !hasRepeatable && !hasRefRepeats) {
            list.addAll(Arrays.asList((String[])this.displayCommentArrays[3]));
        }
        return list.toArray(new String[list.size()]);
    }

    public String[] getEOLComments() {
        return (String[])this.displayCommentArrays[0];
    }

    public String[] getRepeatableComments() {
        return (String[])this.displayCommentArrays[1];
    }

    public int getReferencedRepeatableCommentsCount() {
        return this.displayCommentArrays[2].length;
    }

    public String[] getReferencedRepeatableComments() {
        ArrayList<String> stringList = new ArrayList<String>();
        int refRepeatCount = this.getReferencedRepeatableCommentsCount();
        for (int i = 0; i < refRepeatCount; ++i) {
            RefRepeatComment refRepeatComment = this.getReferencedRepeatableComments(i);
            String[] refRepeatComments = refRepeatComment.getCommentLines();
            stringList.addAll(Arrays.asList(refRepeatComments));
        }
        return stringList.toArray(new String[stringList.size()]);
    }

    public RefRepeatComment getReferencedRepeatableComments(int index) {
        return (RefRepeatComment)this.displayCommentArrays[2][index];
    }

    public String[] getReferencedRepeatableComments(Address refAddress) {
        Object[] refRepeatArray;
        for (Object element : refRepeatArray = this.displayCommentArrays[2]) {
            RefRepeatComment refRepeatComment = (RefRepeatComment)element;
            if (!refRepeatComment.getAddress().equals((Object)refAddress)) continue;
            return refRepeatComment.getCommentLines();
        }
        return null;
    }

    public String[] getAutomaticComment() {
        return (String[])this.displayCommentArrays[3];
    }

    public String toString() {
        Object[] myAutomatic;
        Object[] refRepeatables;
        Object[] myRepeatables;
        StringBuilder buffy = new StringBuilder();
        Object[] eols = (String[])this.displayCommentArrays[0];
        if (eols.length != 0) {
            buffy.append("EOLs: ").append(Arrays.toString(eols));
        }
        if ((myRepeatables = (String[])this.displayCommentArrays[1]).length != 0) {
            buffy.append("My Repeatables: ").append(Arrays.toString(myRepeatables));
        }
        if ((refRepeatables = this.displayCommentArrays[2]).length != 0) {
            buffy.append("Ref Repeatables: ").append(Arrays.toString(refRepeatables));
        }
        if ((myAutomatic = (String[])this.displayCommentArrays[3]).length != 0) {
            buffy.append("My Automatic: ").append(Arrays.toString(myAutomatic));
        }
        return buffy.toString();
    }

    public int getCommentLineCount(int subType) {
        switch (subType) {
            case 0: {
                return ((String[])this.displayCommentArrays[0]).length;
            }
            case 1: {
                return ((String[])this.displayCommentArrays[1]).length;
            }
            case 2: {
                Object[] refRepeatArray;
                int count = 0;
                for (Object element : refRepeatArray = this.displayCommentArrays[2]) {
                    count += ((RefRepeatComment)element).getCommentLines().length;
                }
                return count;
            }
            case 3: {
                return ((String[])this.displayCommentArrays[3]).length;
            }
        }
        throw new IllegalArgumentException(subType + " is not a valid Eol Comment subType indicator.");
    }

    public int getRefRepeatableCommentLineCount(Address refAddress) {
        Object[] refRepeatArray;
        for (Object element : refRepeatArray = this.displayCommentArrays[2]) {
            RefRepeatComment refRepeatComment = (RefRepeatComment)element;
            if (!refRepeatComment.getAddress().equals((Object)refAddress)) continue;
            return refRepeatComment.getCommentLines().length;
        }
        return 0;
    }

    private int getEolRow(ProgramLocation loc) {
        int numBefore = 0;
        boolean hasEol = this.hasEOL();
        boolean hasRepeatable = this.hasRepeatable();
        boolean hasRefRepeats = this.hasReferencedRepeatable();
        if (loc instanceof EolCommentFieldLocation) {
            EolCommentFieldLocation commentLoc = (EolCommentFieldLocation)loc;
            return numBefore + commentLoc.getCurrentCommentRow();
        }
        numBefore += this.getCommentLineCount(0);
        if (loc instanceof RepeatableCommentFieldLocation) {
            RepeatableCommentFieldLocation commentLoc = (RepeatableCommentFieldLocation)loc;
            return numBefore + commentLoc.getCurrentCommentRow();
        }
        if (this.alwaysShowRepeatable || !hasEol) {
            numBefore += this.getCommentLineCount(1);
        }
        if (loc instanceof RefRepeatCommentFieldLocation) {
            RefRepeatCommentFieldLocation commentLoc = (RefRepeatCommentFieldLocation)loc;
            Address desiredAddress = commentLoc.getReferencedRepeatableAddress();
            int startRowInRefRepeats = this.getCommentStartRow(desiredAddress);
            int rowInComment = this.hasRefRepeatComment(desiredAddress) ? commentLoc.getCurrentCommentRow() : 0;
            return numBefore + startRowInRefRepeats + rowInComment;
        }
        if (this.alwaysShowRefRepeats || !hasEol && !hasRepeatable) {
            numBefore += this.getCommentLineCount(2);
        }
        if (loc instanceof AutomaticCommentFieldLocation) {
            AutomaticCommentFieldLocation commentLoc = (AutomaticCommentFieldLocation)loc;
            return numBefore + commentLoc.getCurrentCommentRow();
        }
        if (this.alwaysShowAutomatic || !hasEol && !hasRepeatable && !hasRefRepeats) {
            numBefore += this.getCommentLineCount(3);
        }
        return numBefore;
    }

    private boolean hasRefRepeatComment(Address desiredAddress) {
        RefRepeatComment[] refRepeatComments;
        for (RefRepeatComment comment : refRepeatComments = (RefRepeatComment[])this.displayCommentArrays[2]) {
            Address checkAddress = comment.getAddress();
            if (!desiredAddress.equals((Object)checkAddress)) continue;
            return true;
        }
        return false;
    }

    public RowColLocation getRowCol(CommentFieldLocation cloc) {
        RefRepeatCommentFieldLocation commentLoc;
        Address desiredAddress;
        int strOffset = cloc.getCharOffset();
        if (cloc instanceof RefRepeatCommentFieldLocation && !this.hasRefRepeatComment(desiredAddress = (commentLoc = (RefRepeatCommentFieldLocation)cloc).getReferencedRepeatableAddress())) {
            strOffset = 0;
        }
        int eolRow = this.getEolRow((ProgramLocation)cloc);
        return new RowColLocation(eolRow, strOffset);
    }

    public ProgramLocation getLocation(int eolRow, int eolColumn) {
        int beforeRepeatable;
        boolean hasEol = this.hasEOL();
        boolean hasRepeatable = this.hasRepeatable();
        boolean hasRefRepeats = this.hasReferencedRepeatable();
        int numEol = this.getCommentLineCount(0);
        int numRepeatable = this.getCommentLineCount(1);
        int numRefRepeats = this.getCommentLineCount(2);
        int numAutomatic = this.getCommentLineCount(3);
        int[] cpath = null;
        if (this.codeUnit instanceof Data) {
            cpath = ((Data)this.codeUnit).getComponentPath();
        }
        int beforeEol = 0;
        int beforeRefRepeats = beforeRepeatable = beforeEol + numEol;
        if (this.alwaysShowRepeatable || !hasEol) {
            beforeRefRepeats += numRepeatable;
        }
        int beforeAutomatic = beforeRefRepeats;
        if (this.alwaysShowRefRepeats || !hasEol && !hasRepeatable) {
            beforeAutomatic += numRefRepeats;
        }
        int numTotal = beforeAutomatic;
        if (this.alwaysShowAutomatic || !hasEol && !hasRepeatable && !hasRefRepeats) {
            numTotal += numAutomatic;
        }
        if (eolRow < 0) {
            return null;
        }
        Program program = this.codeUnit.getProgram();
        if (eolRow < beforeRepeatable) {
            return new EolCommentFieldLocation(program, this.codeUnit.getMinAddress(), cpath, this.getComments(), eolRow, eolColumn, eolRow);
        }
        if (eolRow < beforeRefRepeats) {
            return new RepeatableCommentFieldLocation(program, this.codeUnit.getMinAddress(), cpath, this.getComments(), eolRow, eolColumn, eolRow - beforeRepeatable);
        }
        if (eolRow < beforeAutomatic) {
            int rowInAllRefRepeats = eolRow - beforeRefRepeats;
            return new RefRepeatCommentFieldLocation(program, this.codeUnit.getMinAddress(), cpath, this.getComments(), eolRow, eolColumn, this.getRefRepeatRow(rowInAllRefRepeats), this.getRefRepeatAddress(rowInAllRefRepeats));
        }
        if (eolRow < numTotal) {
            return new AutomaticCommentFieldLocation(program, this.codeUnit.getMinAddress(), cpath, this.getComments(), eolRow, eolColumn, eolRow - beforeAutomatic);
        }
        return null;
    }

    private Address getRefRepeatAddress(int rowInAllRefRepeats) {
        RefRepeatComment[] refRepeatComments = (RefRepeatComment[])this.displayCommentArrays[2];
        int currentStartRow = 0;
        for (RefRepeatComment comment : refRepeatComments) {
            int numRows = comment.getCommentLineCount();
            if (rowInAllRefRepeats < currentStartRow + numRows) {
                return comment.getAddress();
            }
            currentStartRow += numRows;
        }
        return null;
    }

    private int getRefRepeatRow(int rowInAllRefRepeats) {
        RefRepeatComment[] refRepeatComments = (RefRepeatComment[])this.displayCommentArrays[2];
        int currentStartRow = 0;
        for (RefRepeatComment comment : refRepeatComments) {
            int numRows = comment.getCommentLineCount();
            if (rowInAllRefRepeats < currentStartRow + numRows) {
                return rowInAllRefRepeats - currentStartRow;
            }
            currentStartRow += numRows;
        }
        return -1;
    }

    private int getCommentStartRow(Address refAddress) {
        RefRepeatComment[] refRepeatComments = (RefRepeatComment[])this.displayCommentArrays[2];
        int currentStartRow = 0;
        for (RefRepeatComment comment : refRepeatComments) {
            Address checkAddress = comment.getAddress();
            if (refAddress.compareTo((Object)checkAddress) <= 0) {
                return currentStartRow;
            }
            currentStartRow += comment.getCommentLineCount();
        }
        return currentStartRow;
    }

    public boolean isRefRepeatRow(int eolRow) {
        int beforeRepeatable;
        boolean hasEol = this.hasEOL();
        boolean hasRepeatable = this.hasRepeatable();
        int numEol = this.getCommentLineCount(0);
        int numRepeatable = this.getCommentLineCount(1);
        int numRefRepeats = this.getCommentLineCount(2);
        int beforeEol = 0;
        int beforeRefRepeats = beforeRepeatable = beforeEol + numEol;
        if (this.alwaysShowRepeatable || !hasEol) {
            beforeRefRepeats += numRepeatable;
        }
        int beforeAutomatic = beforeRefRepeats;
        if (this.alwaysShowRefRepeats || !hasEol && !hasRepeatable) {
            beforeAutomatic += numRefRepeats;
        }
        return eolRow >= beforeRefRepeats && eolRow < beforeAutomatic;
    }
}

