/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem;

import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemEventListener;
import ghidra.formats.gfilesystem.FileSystemRef;
import ghidra.formats.gfilesystem.FileSystemRefManager;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.util.Msg;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class FileSystemInstanceManager
implements FileSystemEventListener {
    private static final int filesystemPurgeDelayMS = 60000;
    private Map<FSRLRoot, FSCacheInfo> filesystems = new HashMap<FSRLRoot, FSCacheInfo>();
    private GFileSystem rootFS;
    private FSRLRoot rootFSRL;

    public FileSystemInstanceManager(GFileSystem rootFS) {
        this.rootFS = rootFS;
        this.rootFSRL = rootFS.getFSRL();
    }

    public synchronized void clear() {
        for (Map.Entry<FSRLRoot, FSCacheInfo> entry : this.filesystems.entrySet()) {
            try {
                FSCacheInfo fci = entry.getValue();
                FileSystemRef ref = fci.ref;
                GFileSystem fs = ref.getFilesystem();
                if (!ref.getFilesystem().getRefManager().canClose(ref)) {
                    Msg.warn((Object)this, (Object)("Forcing filesystem closed: " + fs));
                }
                fs.close();
            }
            catch (IOException e) {
                Msg.warn((Object)this, (Object)("Error closing filesystem: " + e));
            }
        }
        this.filesystems.clear();
    }

    public synchronized void closeAllUnused() {
        List<FSCacheInfo> recsToPurge = this.getUnusedFSes();
        if (!recsToPurge.isEmpty()) {
            Msg.info((Object)this, (Object)("Removing " + recsToPurge.size() + " unused filesystems from cache"));
        }
        for (FSCacheInfo fsci : recsToPurge) {
            this.release(fsci);
        }
    }

    public synchronized List<FSRLRoot> getMountedFilesystems() {
        return new ArrayList<FSRLRoot>(this.filesystems.keySet());
    }

    public synchronized void add(GFileSystem fs) {
        FSCacheInfo fsci = new FSCacheInfo(fs);
        fs.getRefManager().addListener(this);
        if (this.filesystems.put(fs.getFSRL(), fsci) != null) {
            Msg.warn((Object)this, (Object)("Added second instance of same filesystem!  " + fs.getFSRL()));
        }
    }

    public synchronized FileSystemRef getRef(FSRLRoot fsrl) {
        if (this.rootFSRL.equals(fsrl)) {
            return this.rootFS.getRefManager().create();
        }
        FSCacheInfo fsci = this.filesystems.get(fsrl);
        if (fsci != null) {
            return fsci.ref.dup();
        }
        if (fsrl.getMD5() == null) {
            for (Map.Entry<FSRLRoot, FSCacheInfo> entry : this.filesystems.entrySet()) {
                if (!entry.getKey().isEquivalent(fsrl)) continue;
                return entry.getValue().ref.dup();
            }
        }
        return null;
    }

    public synchronized boolean isFilesystemMountedAt(FSRL containerFSRL) {
        for (Map.Entry<FSRLRoot, FSCacheInfo> entry : this.filesystems.entrySet()) {
            FSRLRoot fsFSRL = entry.getKey();
            FSRL fsContainer = fsFSRL.getContainer();
            FileSystemRef ref = entry.getValue().ref;
            GFileSystem fs = ref.getFilesystem();
            if (fs == null || fsContainer == null || !fsContainer.isEquivalent(containerFSRL)) continue;
            return true;
        }
        return false;
    }

    public synchronized FileSystemRef getFilesystemRefMountedAt(FSRL containerFSRL) {
        for (Map.Entry<FSRLRoot, FSCacheInfo> entry : this.filesystems.entrySet()) {
            FSRLRoot fsFSRL = entry.getKey();
            FSRL fsContainer = fsFSRL.getContainer();
            FileSystemRef ref = entry.getValue().ref;
            GFileSystem fs = ref.getFilesystem();
            if (fs == null || fsContainer == null || !containerFSRL.isEquivalent(fsContainer)) continue;
            return ref.dup();
        }
        return null;
    }

    @Override
    public synchronized void onFilesystemClose(GFileSystem fs) {
        FSRLRoot fsFSRL = fs.getFSRL();
        this.filesystems.remove(fsFSRL);
        Msg.warn((Object)this, (Object)("Filesystem " + fs.getFSRL() + " was closed outside of cache"));
    }

    @Override
    public synchronized void onFilesystemRefChange(GFileSystem fs, FileSystemRefManager refManager) {
    }

    public synchronized void cacheMaint() {
        List<FSCacheInfo> recsToPurge = this.getExpired(this.getUnusedFSes());
        if (!recsToPurge.isEmpty()) {
            Msg.info((Object)this, (Object)("Evicting " + recsToPurge.size() + " filesystems from cache"));
        }
        for (FSCacheInfo fsci : recsToPurge) {
            this.release(fsci);
        }
    }

    private List<FSCacheInfo> getExpired(List<FSCacheInfo> recs) {
        long lastUsedCutoffMS = System.currentTimeMillis() - 60000L;
        ArrayList<FSCacheInfo> results = new ArrayList<FSCacheInfo>();
        for (FSCacheInfo fsci : recs) {
            FileSystemRefManager refManager = fsci.ref.getFilesystem().getRefManager();
            long lastUsedTS = refManager.getLastUsedTimestamp();
            if (lastUsedTS >= lastUsedCutoffMS) continue;
            results.add(fsci);
        }
        return results;
    }

    private List<FSCacheInfo> getUnusedFSes() {
        ArrayList<FSCacheInfo> results = new ArrayList<FSCacheInfo>();
        for (Map.Entry<FSRLRoot, FSCacheInfo> entry : this.filesystems.entrySet()) {
            FSCacheInfo fsci = entry.getValue();
            FileSystemRefManager refManager = fsci.ref.getFilesystem().getRefManager();
            if (!refManager.canClose(fsci.ref)) continue;
            results.add(fsci);
        }
        return results;
    }

    private void release(FSCacheInfo fsci) {
        try {
            GFileSystem fs = fsci.ref.getFilesystem();
            FSRLRoot fsFSRL = fs.getFSRL();
            this.filesystems.remove(fsFSRL);
            fs.getRefManager().removeListener(this);
            fsci.ref.close();
            fs.close();
            Msg.debug((Object)this, (Object)("Closing unused filesystem [" + fsFSRL.getContainer() + "]"));
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)"Error closing filesystem", (Throwable)e);
        }
    }

    public synchronized void releaseImmediate(FileSystemRef ref) {
        FSCacheInfo fsci = this.filesystems.get(ref.getFilesystem().getFSRL());
        ref.close();
        if (fsci == null) {
            Msg.warn((Object)this, (Object)("Unknown file system reference: " + ref.getFilesystem().getFSRL()));
            return;
        }
        FileSystemRefManager refManager = fsci.ref.getFilesystem().getRefManager();
        if (refManager.canClose(fsci.ref)) {
            this.release(fsci);
        }
    }

    private static class FSCacheInfo {
        FileSystemRef ref;

        FSCacheInfo(GFileSystem fs) {
            this.ref = fs.getRefManager().create();
        }
    }
}

