/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem.crypto;

import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.crypto.CryptoProvider;
import ghidra.formats.gfilesystem.crypto.PasswordProvider;
import ghidra.framework.generic.auth.Password;
import ghidra.util.Msg;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import utilities.util.FileUtilities;

public class CmdLinePasswordProvider
implements PasswordProvider {
    public static final String CMDLINE_PASSWORD_PROVIDER_PROPERTY_NAME = "filesystem.passwords";

    @Override
    public Iterator<Password> getPasswordsFor(FSRL fsrl, String prompt, CryptoProvider.Session session) {
        String propertyValue = System.getProperty(CMDLINE_PASSWORD_PROVIDER_PROPERTY_NAME);
        if (propertyValue == null) {
            return Collections.emptyIterator();
        }
        File passwordFile = new File(propertyValue);
        return this.load(passwordFile, fsrl).iterator();
    }

    private List<Password> load(File f, FSRL fsrl) {
        ArrayList<Password> result = new ArrayList<Password>();
        try {
            for (String s : FileUtilities.getLines((File)f)) {
                String fileIdStr;
                String[] fields = s.split("\t");
                String password = fields[0];
                if (password.isBlank()) continue;
                String string = fileIdStr = fields.length > 1 ? fields[1] : null;
                if (fileIdStr == null) {
                    result.add(Password.wrap((char[])password.toCharArray()));
                    continue;
                }
                try {
                    FSRL currentFSRL = FSRL.fromString(fileIdStr);
                    if (!currentFSRL.isEquivalent(fsrl)) continue;
                    result.add(Password.wrap((char[])password.toCharArray()));
                }
                catch (MalformedURLException currentFSRL) {
                    String nameOnly = FilenameUtils.getName((String)fileIdStr);
                    if (!nameOnly.equals(fileIdStr)) {
                        if (!fileIdStr.equals(fsrl.getPath())) continue;
                        result.add(Password.wrap((char[])password.toCharArray()));
                        continue;
                    }
                    if (!nameOnly.equals(fsrl.getName())) continue;
                    result.add(Password.wrap((char[])password.toCharArray()));
                }
            }
        }
        catch (IOException e) {
            Msg.warn((Object)this, (Object)("Error reading passwords from file: " + f), (Throwable)e);
        }
        return result;
    }
}

