/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.bean.field;

import docking.widgets.fieldpanel.field.AbstractTextFieldElement;
import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.support.RowColLocation;
import ghidra.app.nav.Navigatable;
import ghidra.app.util.viewer.field.Annotation;
import ghidra.framework.plugintool.ServiceProvider;

public final class AnnotatedTextFieldElement
extends AbstractTextFieldElement {
    private final Annotation annotation;

    private AnnotatedTextFieldElement(Annotation annotation, AttributedString displayString, int row, int column) {
        super(displayString, row, column);
        this.annotation = annotation;
    }

    public AnnotatedTextFieldElement(Annotation annotation, int row, int column) {
        this(annotation, annotation.getDisplayString(), row, column);
    }

    public String getRawText() {
        return this.annotation.getAnnotationText();
    }

    public String getDisplayString() {
        return this.annotation.getDisplayString().getText();
    }

    public boolean handleMouseClicked(Navigatable sourceNavigatable, ServiceProvider serviceProvider) {
        return this.annotation.handleMouseClick(sourceNavigatable, serviceProvider);
    }

    public RowColLocation getDataLocationForCharacterIndex(int characterIndex) {
        return new RowColLocation(this.row, this.column);
    }

    public int getCharacterIndexForDataLocation(int dataRow, int dataColumn) {
        if (this.row == dataRow && dataColumn >= this.column && dataColumn < this.column + this.attributedString.length()) {
            return 0;
        }
        return -1;
    }

    public FieldElement substring(int start, int end) {
        AttributedString as = this.attributedString.substring(start, end);
        if (as == this.attributedString) {
            return this;
        }
        return new AnnotatedTextFieldElement(this.annotation, as, this.row, this.column + start);
    }

    public FieldElement replaceAll(char[] targets, char replacement) {
        return new AnnotatedTextFieldElement(this.annotation, this.attributedString.replaceAll(targets, replacement), this.row, this.column);
    }
}

