/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.state;

import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;

public class VarnodeOperation
extends Varnode {
    private final PcodeOp pcodeOp;
    private final Varnode[] inputValues;
    private boolean simplified;

    public VarnodeOperation(PcodeOp pcodeOp, Varnode[] inputValues) {
        super(pcodeOp.getSeqnum().getTarget(), VarnodeOperation.getSize(pcodeOp));
        this.pcodeOp = pcodeOp;
        this.inputValues = inputValues;
    }

    private static int getSize(PcodeOp op) {
        Varnode v = op.getOutput();
        return v != null ? v.getSize() : 0;
    }

    public boolean isSimplified() {
        return this.simplified;
    }

    public void setSimplified(boolean simplified) {
        this.simplified = simplified;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VarnodeOperation)) {
            return false;
        }
        VarnodeOperation other = (VarnodeOperation)((Object)o);
        if (this.pcodeOp.getOpcode() != other.pcodeOp.getOpcode()) {
            return false;
        }
        for (int i = 0; i < this.inputValues.length; ++i) {
            if (this.inputValues[i].equals((Object)other.inputValues[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.pcodeOp.getSeqnum().hashCode();
    }

    public PcodeOp getPCodeOp() {
        return this.pcodeOp;
    }

    public Varnode[] getInputValues() {
        return this.inputValues;
    }

    private String getIndirectString(Language language) {
        Varnode output = this.pcodeOp.getOutput();
        if (language == null) {
            return this.pcodeOp.getMnemonic() + "[" + output.toString() + ", @" + this.pcodeOp.getSeqnum().getTarget() + "]";
        }
        return this.pcodeOp.getMnemonic() + "[" + output.toString(language) + ", @" + this.pcodeOp.getSeqnum().getTarget() + "]";
    }

    public String toString() {
        if (this.pcodeOp.getOpcode() == 61) {
            return this.getIndirectString(null);
        }
        String s = this.pcodeOp.getMnemonic() + " ";
        for (int i = 0; i < this.inputValues.length; ++i) {
            s = this.inputValues[i] == null ? s + "null" : (this.inputValues[i] instanceof VarnodeOperation ? s + "{" + this.inputValues[i].toString() + "}" : s + this.inputValues[i].toString());
            if (i >= this.inputValues.length - 1) continue;
            s = s + ", ";
        }
        return s;
    }

    public String toString(Language language) {
        if (this.pcodeOp.getOpcode() == 61) {
            return this.getIndirectString(language);
        }
        String s = this.pcodeOp.getMnemonic() + " ";
        for (int i = 0; i < this.inputValues.length; ++i) {
            AddressSpace space;
            if (i == 0 && (this.pcodeOp.getOpcode() == 2 || this.pcodeOp.getOpcode() == 3) && (space = language.getAddressFactory().getAddressSpace((int)this.inputValues[0].getOffset())) != null) {
                s = s + "[" + space.getName() + "], ";
                continue;
            }
            s = this.inputValues[i] == null ? s + "null" : (this.inputValues[i] instanceof VarnodeOperation ? s + "{" + this.inputValues[i].toString(language) + "}" : s + this.inputValues[i].toString(language));
            if (i >= this.inputValues.length - 1) continue;
            s = s + ", ";
        }
        return s;
    }

    public boolean isAddress() {
        return false;
    }

    public boolean isAddrTied() {
        return false;
    }

    public boolean isConstant() {
        return false;
    }

    public boolean isFree() {
        return false;
    }

    public boolean isInput() {
        return false;
    }

    public boolean isPersistent() {
        return false;
    }

    public boolean isRegister() {
        return false;
    }

    public boolean isUnaffected() {
        return false;
    }

    public boolean isUnique() {
        return false;
    }

    public void trim() {
    }
}

