/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import ghidra.app.decompiler.ClangToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ClangLine {
    private int indent_level;
    private ArrayList<ClangToken> tokens = new ArrayList();
    private int lineNumber;

    public ClangLine(int lineNumber, int indent) {
        this.indent_level = indent;
        this.lineNumber = lineNumber;
    }

    public String getIndentString() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.indent_level; ++i) {
            buffer.append(" ");
        }
        return buffer.toString();
    }

    public int getIndent() {
        return this.indent_level;
    }

    public void addToken(ClangToken tok) {
        this.tokens.add(tok);
        tok.setLineParent(this);
    }

    public ArrayList<ClangToken> getAllTokens() {
        return this.tokens;
    }

    public int getNumTokens() {
        return this.tokens.size();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public ClangToken getToken(int i) {
        return this.tokens.get(i);
    }

    public int indexOfToken(ClangToken token) {
        return this.tokens.indexOf(token);
    }

    public String toDebugString(List<ClangToken> calloutTokens) {
        return this.toDebugString(calloutTokens, "[", "]");
    }

    public String toDebugString(List<ClangToken> calloutTokens, String start, String end) {
        if (calloutTokens == null) {
            calloutTokens = Collections.emptyList();
        }
        StringBuilder buffy = new StringBuilder(this.getLineNumber() + ": ");
        for (ClangToken token : this.tokens) {
            boolean isCallout = calloutTokens.contains(token);
            if (isCallout) {
                buffy.append(start);
            }
            buffy.append(token.getText());
            if (!isCallout) continue;
            buffy.append(end);
        }
        return buffy.toString();
    }

    public String toString() {
        return this.toDebugString(Collections.emptyList());
    }
}

