/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.objects.actions;

import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import generic.theme.GIcon;
import ghidra.app.plugin.core.debug.gui.objects.DebuggerObjectsProvider;
import ghidra.app.plugin.core.debug.gui.objects.ObjectContainer;
import ghidra.app.plugin.core.debug.gui.objects.actions.DisplayAsAction;
import ghidra.app.services.GraphDisplayBroker;
import ghidra.framework.plugintool.PluginTool;
import ghidra.service.graph.AttributedGraph;
import ghidra.service.graph.AttributedVertex;
import ghidra.service.graph.EmptyGraphType;
import ghidra.service.graph.GraphDisplay;
import ghidra.service.graph.GraphDisplayProvider;
import ghidra.service.graph.GraphType;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.GraphException;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.util.HashMap;
import java.util.Set;
import javax.swing.Icon;

public class DisplayAsGraphAction
extends DisplayAsAction {
    protected GraphDisplayBroker graphBroker;
    protected static final Icon ICON_GRAPH = new GIcon("icon.debugger.display.graph");

    public DisplayAsGraphAction(PluginTool tool, String owner, DebuggerObjectsProvider provider) {
        super("DisplayGraph", tool, owner, provider);
        String[] path = new String[]{"Display as...", "Graph"};
        this.setPopupMenuData(new MenuData(path, ICON_GRAPH));
        this.setKeyBindingData(new KeyBindingData(71, 128));
        this.setHelpLocation(new HelpLocation(owner, "display_as_graph"));
        provider.addLocalAction((DockingActionIf)this);
    }

    @Override
    protected void doAction(ObjectContainer container) {
        this.graphBroker = this.provider.getGraphBroker();
        if (this.graphBroker == null) {
            Msg.showError((Object)((Object)this), (Component)this.tool.getToolFrame(), (String)"DisplayAsGraph Error", (Object)"GraphBroker not found: Please add a graph provider to your tool");
            return;
        }
        this.addGraph(container);
    }

    public void addGraph(ObjectContainer container) {
        GraphDisplayProvider graphProvider = this.graphBroker.getDefaultGraphDisplayProvider();
        AttributedGraph graph = new AttributedGraph(container.getName(), (GraphType)new EmptyGraphType());
        AttributedVertex start = graph.addVertex(container.toString(), container.getName());
        this.graphContainer(container, graph, start);
        try {
            GraphDisplay graphDisplay = graphProvider.getGraphDisplay(true, TaskMonitor.DUMMY);
            graphDisplay.setGraph(graph, container.getName(), false, TaskMonitor.DUMMY);
        }
        catch (GraphException e) {
            e.printStackTrace();
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
    }

    private void graphContainer(ObjectContainer container, AttributedGraph graph, AttributedVertex start) {
        HashMap<ObjectContainer, AttributedVertex> starts = new HashMap<ObjectContainer, AttributedVertex>();
        Set<ObjectContainer> children = container.getCurrentChildren();
        for (ObjectContainer c : children) {
            if (!c.isVisible()) continue;
            AttributedVertex end = graph.addVertex(c.toString(), c.getName());
            graph.addEdge(start, end, start + ":" + end);
            starts.put(c, end);
        }
        for (ObjectContainer c : starts.keySet()) {
            AttributedVertex s = (AttributedVertex)starts.get(c);
            this.graphContainer(c, graph, s);
        }
    }
}

