/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.breakpoint;

import ghidra.app.plugin.core.debug.service.breakpoint.BreakpointActionItem;
import ghidra.app.plugin.core.debug.service.breakpoint.DeleteEmuBreakpointActionItem;
import ghidra.app.plugin.core.debug.service.breakpoint.DeleteTargetBreakpointActionItem;
import ghidra.app.plugin.core.debug.service.breakpoint.DisableEmuBreakpointActionItem;
import ghidra.app.plugin.core.debug.service.breakpoint.DisableTargetBreakpointActionItem;
import ghidra.app.plugin.core.debug.service.breakpoint.EnableEmuBreakpointActionItem;
import ghidra.app.plugin.core.debug.service.breakpoint.EnableTargetBreakpointActionItem;
import ghidra.async.AsyncFence;
import ghidra.dbg.target.TargetBreakpointLocation;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetDeletable;
import ghidra.dbg.target.TargetTogglable;
import ghidra.trace.model.breakpoint.TraceBreakpoint;
import java.util.LinkedHashSet;
import java.util.concurrent.CompletableFuture;

public class BreakpointActionSet
extends LinkedHashSet<BreakpointActionItem> {
    public EnableTargetBreakpointActionItem planEnableTarget(TargetBreakpointLocation loc) {
        if (loc instanceof TargetTogglable) {
            EnableTargetBreakpointActionItem action = new EnableTargetBreakpointActionItem((TargetTogglable)loc);
            this.add(action);
            return action;
        }
        TargetBreakpointSpec spec = loc.getSpecification();
        if (spec instanceof TargetTogglable) {
            EnableTargetBreakpointActionItem action = new EnableTargetBreakpointActionItem((TargetTogglable)spec);
            this.add(action);
            return action;
        }
        return null;
    }

    public EnableEmuBreakpointActionItem planEnableEmu(TraceBreakpoint bpt) {
        EnableEmuBreakpointActionItem action = new EnableEmuBreakpointActionItem(bpt);
        this.add(action);
        return action;
    }

    public DisableTargetBreakpointActionItem planDisableTarget(TargetBreakpointLocation loc) {
        if (loc instanceof TargetTogglable) {
            DisableTargetBreakpointActionItem action = new DisableTargetBreakpointActionItem((TargetTogglable)loc);
            this.add(action);
            return action;
        }
        TargetBreakpointSpec spec = loc.getSpecification();
        if (spec instanceof TargetTogglable) {
            DisableTargetBreakpointActionItem action = new DisableTargetBreakpointActionItem((TargetTogglable)spec);
            this.add(action);
            return action;
        }
        return null;
    }

    public DisableEmuBreakpointActionItem planDisableEmu(TraceBreakpoint bpt) {
        DisableEmuBreakpointActionItem action = new DisableEmuBreakpointActionItem(bpt);
        this.add(action);
        return action;
    }

    public DeleteTargetBreakpointActionItem planDeleteTarget(TargetBreakpointLocation loc) {
        if (loc instanceof TargetDeletable) {
            DeleteTargetBreakpointActionItem action = new DeleteTargetBreakpointActionItem((TargetDeletable)loc);
            this.add(action);
            return action;
        }
        TargetBreakpointSpec spec = loc.getSpecification();
        if (spec instanceof TargetTogglable) {
            DeleteTargetBreakpointActionItem action = new DeleteTargetBreakpointActionItem((TargetDeletable)spec);
            this.add(action);
            return action;
        }
        return null;
    }

    public DeleteEmuBreakpointActionItem planDeleteEmu(TraceBreakpoint bpt) {
        DeleteEmuBreakpointActionItem action = new DeleteEmuBreakpointActionItem(bpt);
        this.add(action);
        return action;
    }

    public CompletableFuture<Void> execute() {
        AsyncFence fence = new AsyncFence();
        for (BreakpointActionItem item : this) {
            fence.include(item.execute());
        }
        return fence.ready();
    }
}

