/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.model;

import db.Transaction;
import docking.ActionContext;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.builder.ActionBuilder;
import docking.action.builder.MultiStateActionBuilder;
import docking.menu.ActionState;
import docking.menu.MultiStateDockingAction;
import docking.widgets.EventTrigger;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.mapping.DebuggerTargetTraceMapper;
import ghidra.app.plugin.core.debug.service.model.DebuggerModelServiceInternal;
import ghidra.app.plugin.core.debug.service.model.DebuggerModelServicePlugin;
import ghidra.app.plugin.core.debug.service.model.launch.DebuggerProgramLaunchOffer;
import ghidra.app.plugin.core.debug.utils.BackgroundUtils;
import ghidra.app.services.ActionSource;
import ghidra.app.services.DebuggerModelService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.TraceRecorder;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerModelFactory;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetThread;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginException;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.framework.plugintool.util.PluginUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramUserData;
import ghidra.program.model.util.StringPropertyMap;
import ghidra.trace.model.Trace;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.Msg;
import ghidra.util.datastruct.CollectionChangeListener;
import ghidra.util.datastruct.ListenerSet;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.exception.ExceptionUtils;

@PluginInfo(shortDescription="Debugger models manager service (proxy to front-end)", description="Manage debug sessions, connections, and trace recording", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={ProgramActivatedPluginEvent.class, ProgramClosedPluginEvent.class}, servicesRequired={DebuggerTraceManagerService.class}, servicesProvided={DebuggerModelService.class})
public class DebuggerModelServiceProxyPlugin
extends Plugin
implements DebuggerModelServiceInternal {
    private static final String KEY_MOST_RECENT_LAUNCHES = "mostRecentLaunches";
    private static final DebuggerProgramLaunchOffer DUMMY_LAUNCH_OFFER = new DebuggerProgramLaunchOffer(){

        @Override
        public CompletableFuture<DebuggerProgramLaunchOffer.LaunchResult> launchProgram(TaskMonitor monitor, DebuggerProgramLaunchOffer.PromptMode prompt, DebuggerProgramLaunchOffer.LaunchConfigurator configurator) {
            throw new AssertionError((Object)"Who clicked me?");
        }

        @Override
        public String getConfigName() {
            return "DUMMY";
        }

        @Override
        public String getMenuParentTitle() {
            return "";
        }

        @Override
        public String getMenuTitle() {
            return "";
        }

        @Override
        public String getQuickTitle() {
            return "";
        }

        @Override
        public String getButtonTitle() {
            return "No quick launcher for the current program";
        }
    };
    private static final ActionState<DebuggerProgramLaunchOffer> DUMMY_LAUNCH_STATE = new ActionState(DUMMY_LAUNCH_OFFER.getButtonTitle(), DUMMY_LAUNCH_OFFER.getIcon(), (Object)DUMMY_LAUNCH_OFFER);
    protected DebuggerModelServicePlugin delegate;
    protected DebuggerObjectModel currentModel;
    protected Program currentProgram;
    protected File currentProgramPath;
    protected final ProxiedFactoryChangeListener factoryChangeListener = new ProxiedFactoryChangeListener();
    protected final ProxiedModelChangeListener modelChangeListener = new ProxiedModelChangeListener();
    protected final ProxiedRecorderChangeListener recorderChangeListener = new ProxiedRecorderChangeListener();
    MultiStateDockingAction<DebuggerProgramLaunchOffer> actionDebugProgram;
    Set<DockingAction> actionDebugProgramMenus = new HashSet<DockingAction>();
    DockingAction actionDisconnectAll;
    protected final ListenerSet<CollectionChangeListener<DebuggerModelFactory>> factoryListeners = new ListenerSet(CollectionChangeListener.of(DebuggerModelFactory.class));
    protected final ListenerSet<CollectionChangeListener<DebuggerObjectModel>> modelListeners = new ListenerSet(CollectionChangeListener.of(DebuggerObjectModel.class));
    protected final ListenerSet<CollectionChangeListener<TraceRecorder>> recorderListeners = new ListenerSet(CollectionChangeListener.of(TraceRecorder.class));

    protected static DebuggerModelServicePlugin getOrCreateFrontEndDelegate() {
        FrontEndTool frontEnd = AppInfo.getFrontEndTool();
        for (Plugin plugin : frontEnd.getManagedPlugins()) {
            if (!(plugin instanceof DebuggerModelServicePlugin)) continue;
            return (DebuggerModelServicePlugin)plugin;
        }
        try {
            DebuggerModelServicePlugin plugin = (DebuggerModelServicePlugin)PluginUtils.instantiatePlugin(DebuggerModelServicePlugin.class, (PluginTool)frontEnd);
            frontEnd.addPlugin((Plugin)plugin);
            return plugin;
        }
        catch (PluginException e) {
            throw new AssertionError((Object)e);
        }
    }

    public DebuggerModelServiceProxyPlugin(PluginTool tool) {
        super(tool);
    }

    protected void init() {
        super.init();
        this.delegate = DebuggerModelServiceProxyPlugin.getOrCreateFrontEndDelegate();
        this.delegate.addProxy(this);
        this.delegate.addFactoriesChangedListener(this.factoryChangeListener);
        this.delegate.addModelsChangedListener(this.modelChangeListener);
        this.delegate.addTraceRecordersChangedListener(this.recorderChangeListener);
        this.createActions();
    }

    protected void createActions() {
        MultiStateActionBuilder builderDebugProgram = DebuggerResources.DebugProgramAction.buttonBuilder(this, this.delegate);
        this.actionDebugProgram = (MultiStateDockingAction)((MultiStateActionBuilder)((MultiStateActionBuilder)builderDebugProgram.enabledWhen(ctx -> this.currentProgram != null)).onAction(this::debugProgramButtonActivated)).onActionStateChanged(this::debugProgramStateActivated).addState(DUMMY_LAUNCH_STATE).buildAndInstall((Tool)this.tool);
        this.actionDisconnectAll = (DockingAction)((ActionBuilder)((ActionBuilder)DebuggerResources.DisconnectAllAction.builder(this, this.delegate).menuPath(new String[]{"Debugger", "Disconnect All"})).onAction(this::activatedDisconnectAll)).buildAndInstall((Tool)this.tool);
        this.updateActionDebugProgram();
    }

    private void activatedDisconnectAll(ActionContext context) {
        this.closeAllModels();
    }

    @Override
    public CompletableFuture<DebuggerObjectModel> showConnectDialog() {
        return this.delegate.doShowConnectDialog(this.tool, null, null);
    }

    @Override
    public CompletableFuture<DebuggerObjectModel> showConnectDialog(Program program) {
        return this.delegate.doShowConnectDialog(this.tool, null, program);
    }

    @Override
    public CompletableFuture<DebuggerObjectModel> showConnectDialog(DebuggerModelFactory factory) {
        return this.delegate.doShowConnectDialog(this.tool, factory, null);
    }

    @Override
    public Stream<DebuggerProgramLaunchOffer> getProgramLaunchOffers(Program program) {
        return this.orderOffers(this.delegate.doGetProgramLaunchOffers(this.tool, program), program);
    }

    protected List<String> readMostRecentLaunches(Program program) {
        StringPropertyMap prop = program.getProgramUserData().getStringProperty(this.getName(), KEY_MOST_RECENT_LAUNCHES, false);
        if (prop == null) {
            return List.of();
        }
        Address min = program.getAddressFactory().getDefaultAddressSpace().getMinAddress();
        String str = prop.getString(min);
        if (str == null) {
            return List.of();
        }
        return List.of(str.split(";"));
    }

    protected void writeMostRecentLaunches(Program program, List<String> mrl) {
        ProgramUserData userData = program.getProgramUserData();
        try (Transaction tid = userData.openTransaction();){
            StringPropertyMap prop = userData.getStringProperty(this.getName(), KEY_MOST_RECENT_LAUNCHES, true);
            Address min = program.getAddressFactory().getDefaultAddressSpace().getMinAddress();
            prop.add(min, mrl.stream().collect(Collectors.joining(";")));
        }
    }

    protected Stream<DebuggerProgramLaunchOffer> orderOffers(Stream<DebuggerProgramLaunchOffer> offers, Program program) {
        List<String> mrl = this.readMostRecentLaunches(program);
        return offers.sorted(Comparator.comparingInt(o -> -mrl.indexOf(o.getConfigName())));
    }

    private void debugProgram(DebuggerProgramLaunchOffer offer, Program program, DebuggerProgramLaunchOffer.PromptMode prompt) {
        BackgroundUtils.asyncModal(this.tool, offer.getButtonTitle(), true, true, m -> {
            ArrayList<String> recent = new ArrayList<String>(this.readMostRecentLaunches(program));
            recent.remove(offer.getConfigName());
            recent.add(offer.getConfigName());
            this.writeMostRecentLaunches(program, recent);
            CompletableFuture.runAsync(() -> this.updateActionDebugProgram(), AsyncUtils.SWING_EXECUTOR).exceptionally(ex -> {
                Msg.error((Object)this, (Object)"Trouble writing recent launches to program user data");
                return null;
            });
            return ((CompletableFuture)offer.launchProgram((TaskMonitor)m, prompt).exceptionally(ex -> {
                Throwable t = AsyncUtils.unwrapThrowable((Throwable)ex);
                if (t instanceof CancellationException || t instanceof CancelledException) {
                    return null;
                }
                return (DebuggerProgramLaunchOffer.LaunchResult)ExceptionUtils.rethrow((Throwable)ex);
            })).whenCompleteAsync((v, e) -> this.updateActionDebugProgram(), (Executor)AsyncUtils.SWING_EXECUTOR);
        });
    }

    private void debugProgramButtonActivated(ActionContext ctx) {
        DebuggerProgramLaunchOffer offer = (DebuggerProgramLaunchOffer)this.actionDebugProgram.getCurrentUserData();
        Program program = this.currentProgram;
        if (offer == null || program == null) {
            return;
        }
        this.debugProgram(offer, program, DebuggerProgramLaunchOffer.PromptMode.ON_ERROR);
    }

    private void debugProgramStateActivated(ActionState<DebuggerProgramLaunchOffer> offer, EventTrigger trigger) {
        if (trigger == EventTrigger.GUI_ACTION) {
            this.debugProgramButtonActivated(null);
        }
    }

    private void debugProgramMenuActivated(DebuggerProgramLaunchOffer offer) {
        Program program = this.currentProgram;
        if (program == null) {
            return;
        }
        this.debugProgram(offer, program, DebuggerProgramLaunchOffer.PromptMode.ALWAYS);
    }

    private void updateActionDebugProgram() {
        if (this.actionDebugProgram == null) {
            return;
        }
        Program program = this.currentProgram;
        List<Object> offers = program == null ? List.of() : this.getProgramLaunchOffers(program).collect(Collectors.toList());
        List states = offers.stream().map(o -> new ActionState(o.getButtonTitle(), o.getIcon(), o)).collect(Collectors.toList());
        if (!states.isEmpty()) {
            this.actionDebugProgram.setActionStates(states);
            this.actionDebugProgram.setEnabled(true);
            this.actionDebugProgram.setCurrentActionState((ActionState)states.get(0));
        } else {
            this.actionDebugProgram.setActionStates(List.of(DUMMY_LAUNCH_STATE));
            this.actionDebugProgram.setEnabled(false);
            this.actionDebugProgram.setCurrentActionState(DUMMY_LAUNCH_STATE);
        }
        Iterator<DockingAction> it = this.actionDebugProgramMenus.iterator();
        while (it.hasNext()) {
            DockingAction action = it.next();
            it.remove();
            this.tool.removeAction((DockingActionIf)action);
            String[] path = action.getMenuBarData().getMenuPath();
            this.tool.setMenuGroup(Arrays.copyOf(path, path.length - 1), null);
        }
        for (DebuggerProgramLaunchOffer offer : offers) {
            DockingAction action = ((ActionBuilder)DebuggerResources.DebugProgramAction.menuBuilder(offer, this, this.delegate).onAction(ctx -> this.debugProgramMenuActivated(offer))).build();
            this.actionDebugProgramMenus.add(action);
            String[] path = action.getMenuBarData().getMenuPath();
            this.tool.setMenuGroup(Arrays.copyOf(path, path.length - 1), "Dbg1. General", "zz");
            this.tool.addAction((DockingActionIf)action);
        }
    }

    protected void dispose() {
        super.dispose();
        if (this.delegate != null) {
            this.delegate.removeProxy(this);
            this.delegate.removeFactoriesChangedListener(this.factoryChangeListener);
            this.delegate.removeModelsChangedListener(this.modelChangeListener);
            this.delegate.removeTraceRecordersChangedListener(this.recorderChangeListener);
        }
        this.currentModel = null;
    }

    private File getProgramPath(Program program) {
        if (program == null) {
            return null;
        }
        String path = program.getExecutablePath();
        if (path == null) {
            return null;
        }
        File file = new File(path);
        try {
            if (!file.canExecute()) {
                return null;
            }
            return file.getCanonicalFile();
        }
        catch (IOException | SecurityException e) {
            Msg.error((Object)this, (Object)("Cannot examine file " + path), (Throwable)e);
            return null;
        }
    }

    public void processEvent(PluginEvent event) {
        ProgramActivatedPluginEvent evt;
        super.processEvent(event);
        if (event instanceof ProgramActivatedPluginEvent) {
            evt = (ProgramActivatedPluginEvent)event;
            this.currentProgram = evt.getActiveProgram();
            this.currentProgramPath = this.getProgramPath(this.currentProgram);
            this.updateActionDebugProgram();
        }
        if (event instanceof ProgramClosedPluginEvent && this.currentProgram == (evt = (ProgramClosedPluginEvent)event).getProgram()) {
            this.currentProgram = null;
            this.currentProgramPath = null;
            this.updateActionDebugProgram();
        }
    }

    @Override
    public void refreshFactoryInstances() {
        this.delegate.refreshFactoryInstances();
    }

    @Override
    public void setModelFactories(Collection<DebuggerModelFactory> factories) {
        this.delegate.setModelFactories(factories);
    }

    @Override
    public Set<DebuggerModelFactory> getModelFactories() {
        return this.delegate.getModelFactories();
    }

    @Override
    public Set<DebuggerObjectModel> getModels() {
        return this.delegate.getModels();
    }

    @Override
    public CompletableFuture<Void> closeAllModels() {
        return this.delegate.closeAllModels();
    }

    @Override
    public Collection<TraceRecorder> getTraceRecorders() {
        return this.delegate.getTraceRecorders();
    }

    @Override
    public boolean addModel(DebuggerObjectModel model) {
        return this.delegate.addModel(model);
    }

    @Override
    public boolean removeModel(DebuggerObjectModel model) {
        return this.delegate.removeModel(model);
    }

    @Override
    public TraceRecorder recordTarget(TargetObject target, DebuggerTargetTraceMapper mapper, ActionSource source) throws IOException {
        return this.delegate.recordTarget(target, mapper, source);
    }

    @Override
    public TraceRecorder recordTargetBestOffer(TargetObject target) {
        return this.delegate.recordTargetBestOffer(target);
    }

    @Override
    public TraceRecorder recordTargetPromptOffers(TargetObject target) {
        return this.delegate.doRecordTargetPromptOffers(this.tool, target);
    }

    @Override
    public synchronized boolean doActivateModel(DebuggerObjectModel model) {
        if (model == this.currentModel) {
            return false;
        }
        this.currentModel = model;
        return true;
    }

    @Override
    public synchronized DebuggerObjectModel getCurrentModel() {
        return this.currentModel;
    }

    @Override
    public void addFactoriesChangedListener(CollectionChangeListener<DebuggerModelFactory> listener) {
        this.factoryListeners.add(listener);
    }

    @Override
    public void removeFactoriesChangedListener(CollectionChangeListener<DebuggerModelFactory> listener) {
        this.factoryListeners.remove(listener);
    }

    @Override
    public void addModelsChangedListener(CollectionChangeListener<DebuggerObjectModel> listener) {
        this.modelListeners.add(listener);
    }

    @Override
    public void removeModelsChangedListener(CollectionChangeListener<DebuggerObjectModel> listener) {
        this.modelListeners.remove(listener);
    }

    @Override
    public void addTraceRecordersChangedListener(CollectionChangeListener<TraceRecorder> listener) {
        this.recorderListeners.add(listener);
    }

    @Override
    public void removeTraceRecordersChangedListener(CollectionChangeListener<TraceRecorder> listener) {
        this.recorderListeners.remove(listener);
    }

    @Override
    public TraceRecorder recordTargetAndActivateTrace(TargetObject target, DebuggerTargetTraceMapper mapper, DebuggerTraceManagerService traceManager) throws IOException {
        return this.delegate.recordTargetAndActivateTrace(target, mapper, traceManager);
    }

    @Override
    public TraceRecorder recordTargetAndActivateTrace(TargetObject target, DebuggerTargetTraceMapper mapper) throws IOException {
        DebuggerTraceManagerService traceManager = (DebuggerTraceManagerService)this.tool.getService(DebuggerTraceManagerService.class);
        return this.delegate.recordTargetAndActivateTrace(target, mapper, traceManager);
    }

    @Override
    public TraceRecorder getRecorder(TargetObject target) {
        return this.delegate.getRecorder(target);
    }

    @Override
    public TraceRecorder getRecorderForSuccessor(TargetObject obj) {
        return this.delegate.getRecorderForSuccessor(obj);
    }

    @Override
    public TraceRecorder getRecorder(Trace trace) {
        return this.delegate.getRecorder(trace);
    }

    @Override
    public TargetThread getTargetThread(TraceThread thread) {
        return this.delegate.getTargetThread(thread);
    }

    @Override
    public TargetObject getTarget(Trace trace) {
        return this.delegate.getTarget(trace);
    }

    @Override
    public Trace getTrace(TargetObject target) {
        return this.delegate.getTrace(target);
    }

    @Override
    public TraceThread getTraceThread(TargetThread thread) {
        return this.delegate.getTraceThread(thread);
    }

    @Override
    public TraceThread getTraceThread(TargetObject target, TargetThread thread) {
        return this.delegate.getTraceThread(target, thread);
    }

    @Override
    public TargetObject getTargetFocus(TargetObject target) {
        return this.delegate.getTargetFocus(target);
    }

    protected class ProxiedFactoryChangeListener
    implements CollectionChangeListener<DebuggerModelFactory> {
        protected ProxiedFactoryChangeListener() {
        }

        public void elementAdded(DebuggerModelFactory element) {
            ((CollectionChangeListener)DebuggerModelServiceProxyPlugin.this.factoryListeners.fire).elementAdded((Object)element);
        }

        public void elementRemoved(DebuggerModelFactory element) {
            ((CollectionChangeListener)DebuggerModelServiceProxyPlugin.this.factoryListeners.fire).elementRemoved((Object)element);
        }

        public void elementModified(DebuggerModelFactory element) {
            ((CollectionChangeListener)DebuggerModelServiceProxyPlugin.this.factoryListeners.fire).elementModified((Object)element);
        }
    }

    protected class ProxiedModelChangeListener
    implements CollectionChangeListener<DebuggerObjectModel> {
        protected ProxiedModelChangeListener() {
        }

        public void elementAdded(DebuggerObjectModel element) {
            ((CollectionChangeListener)DebuggerModelServiceProxyPlugin.this.modelListeners.fire).elementAdded((Object)element);
            if (DebuggerModelServiceProxyPlugin.this.currentModel == null) {
                DebuggerModelServiceProxyPlugin.this.activateModel(element);
            }
        }

        public void elementRemoved(DebuggerObjectModel element) {
            if (DebuggerModelServiceProxyPlugin.this.currentModel == element) {
                DebuggerModelServiceProxyPlugin.this.activateModel(null);
            }
            ((CollectionChangeListener)DebuggerModelServiceProxyPlugin.this.modelListeners.fire).elementRemoved((Object)element);
        }

        public void elementModified(DebuggerObjectModel element) {
            ((CollectionChangeListener)DebuggerModelServiceProxyPlugin.this.modelListeners.fire).elementModified((Object)element);
        }
    }

    protected class ProxiedRecorderChangeListener
    implements CollectionChangeListener<TraceRecorder> {
        protected ProxiedRecorderChangeListener() {
        }

        public void elementAdded(TraceRecorder element) {
            ((CollectionChangeListener)DebuggerModelServiceProxyPlugin.this.recorderListeners.fire).elementAdded((Object)element);
        }

        public void elementRemoved(TraceRecorder element) {
            ((CollectionChangeListener)DebuggerModelServiceProxyPlugin.this.recorderListeners.fire).elementRemoved((Object)element);
        }

        public void elementModified(TraceRecorder element) {
            ((CollectionChangeListener)DebuggerModelServiceProxyPlugin.this.recorderListeners.fire).elementModified((Object)element);
        }
    }

    static class OfferComparator
    implements Comparator<DebuggerProgramLaunchOffer> {
        Map<String, Integer> fastIndex = new HashMap<String, Integer>();

        public OfferComparator(List<String> mostRecentNames) {
            int i = 0;
            for (String name : mostRecentNames) {
                this.fastIndex.put(name, i++);
            }
        }

        @Override
        public int compare(DebuggerProgramLaunchOffer o1, DebuggerProgramLaunchOffer o2) {
            int i2;
            int i1 = this.fastIndex.getOrDefault(o1, -1);
            int result = i1 - (i2 = this.fastIndex.getOrDefault(o2, -1).intValue());
            if (result != 0) {
                return result;
            }
            return o1.defaultPriority() - o2.defaultPriority();
        }
    }
}

