/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.modules;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import ghidra.app.plugin.core.debug.service.modules.DebuggerStaticMappingUtils;
import ghidra.app.plugin.core.debug.service.modules.PeekOpenedDomainObject;
import ghidra.app.plugin.core.debug.utils.DomainFolderChangeAdapter;
import ghidra.app.plugin.core.debug.utils.ProgramURLUtils;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainFolderChangeListener;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectClosedListener;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectData;
import ghidra.framework.options.Options;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.trace.model.modules.TraceModule;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ProgramModuleIndexer
implements DomainFolderChangeAdapter {
    public static final String MODULE_PATHS_PROPERTY = "Module Paths";
    private static final Gson JSON = new Gson();
    private final Project project;
    private final ProjectData projectData;
    private volatile boolean disposed;
    private final Map<Program, ModuleChangeListener> openedForUpdate = new HashMap<Program, ModuleChangeListener>();
    private final ModuleIndex index = new ModuleIndex();

    public static void setModulePaths(Program program, Collection<String> moduleNames) {
        LinkedHashSet<String> linkedHashSet;
        Options options = program.getOptions("Program Information");
        if (moduleNames instanceof LinkedHashSet) {
            LinkedHashSet yes = (LinkedHashSet)moduleNames;
            linkedHashSet = yes;
        } else {
            linkedHashSet = new LinkedHashSet<String>(moduleNames);
        }
        LinkedHashSet<String> distinct = linkedHashSet;
        options.setString(MODULE_PATHS_PROPERTY, JSON.toJson(distinct));
    }

    public static Collection<String> getModulePaths(DomainFile df) {
        return ProgramModuleIndexer.getModulePaths(df.getMetadata());
    }

    public static Collection<String> getModulePaths(Map<String, String> metadata) {
        String json = metadata.get(MODULE_PATHS_PROPERTY);
        if (json == null) {
            return List.of();
        }
        return (Collection)JSON.fromJson(json, new TypeToken<List<String>>(){}.getType());
    }

    public static void addModulePaths(Program program, Collection<String> moduleNames) {
        LinkedHashSet<String> union = new LinkedHashSet<String>(ProgramModuleIndexer.getModulePaths(program.getMetadata()));
        union.addAll(moduleNames);
        ProgramModuleIndexer.setModulePaths(program, union);
    }

    public ProgramModuleIndexer(PluginTool tool) {
        this.project = tool.getProject();
        this.projectData = tool.getProject().getProjectData();
        this.projectData.addDomainFolderChangeListener((DomainFolderChangeListener)this);
        this.indexFolder(this.projectData.getRootFolder());
    }

    void dispose() {
        this.disposed = true;
        this.projectData.removeDomainFolderChangeListener((DomainFolderChangeListener)this);
    }

    protected void indexFolder(DomainFolder folder) {
        for (DomainFile domainFile : folder.getFiles()) {
            this.addToIndex(domainFile);
        }
        for (DomainFile domainFile : folder.getFolders()) {
            this.indexFolder((DomainFolder)domainFile);
        }
    }

    protected void addToIndex(DomainFile file, Program program) {
        if (this.disposed) {
            return;
        }
        this.addToIndex(file, program.getMetadata());
    }

    protected void addToIndex(DomainFile file) {
        if (this.disposed) {
            return;
        }
        if (!Program.class.isAssignableFrom(file.getDomainObjectClass())) {
            return;
        }
        this.addToIndex(file, file.getMetadata());
    }

    protected void addToIndex(DomainFile file, Map<String, String> metadata) {
        String exePath;
        String dfID = file.getFileID();
        String dfName = file.getName().toLowerCase();
        String progName = metadata.get("Program Name");
        if (progName != null) {
            progName = progName.toLowerCase();
        }
        if ((exePath = metadata.get("Executable Location")) != null) {
            exePath = exePath.toLowerCase();
        }
        String exeName = exePath == null ? null : new File(exePath).getName();
        for (String modPath : ProgramModuleIndexer.getModulePaths(metadata)) {
            String modName;
            if (!modPath.equals(modName = new File(modPath).getName())) {
                this.index.addEntry(modPath, dfID, NameSource.MODULE_PATH);
            }
            this.index.addEntry(modName, dfID, NameSource.MODULE_NAME);
        }
        this.index.addEntry(dfName, dfID, NameSource.DOMAIN_FILE_NAME);
        if (progName != null) {
            this.index.addEntry(progName, dfID, NameSource.DOMAIN_FILE_NAME);
        }
        if (exeName != null) {
            if (!exePath.equals(exeName)) {
                this.index.addEntry(exePath, dfID, NameSource.PROGRAM_EXECUTABLE_PATH);
            }
            this.index.addEntry(exeName, dfID, NameSource.PROGRAM_EXECUTABLE_NAME);
        }
    }

    protected void removeFromIndex(String fileID) {
        this.index.removeFile(fileID);
    }

    protected void refreshIndex(DomainFile file) {
        this.removeFromIndex(file.getFileID());
        this.addToIndex(file);
    }

    protected void refreshIndex(DomainFile file, Program program) {
        this.removeFromIndex(file.getFileID());
        this.addToIndex(file, program);
    }

    @Override
    public void domainFileAdded(DomainFile file) {
        this.addToIndex(file);
    }

    @Override
    public void domainFileRemoved(DomainFolder parent, String name, String fileID) {
        this.removeFromIndex(fileID);
    }

    @Override
    public void domainFileRenamed(DomainFile file, String oldName) {
        this.refreshIndex(file);
    }

    @Override
    public void domainFileMoved(DomainFile file, DomainFolder oldParent, String oldName) {
        this.refreshIndex(file);
    }

    @Override
    public void domainFileObjectReplaced(DomainFile file, DomainObject oldObject) {
        this.refreshIndex(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void domainFileObjectOpenedForUpdate(DomainFile file, DomainObject object) {
        if (this.disposed) {
            return;
        }
        if (object instanceof Program) {
            Program program = (Program)object;
            Map<Program, ModuleChangeListener> map = this.openedForUpdate;
            synchronized (map) {
                this.openedForUpdate.computeIfAbsent(program, x$0 -> new ModuleChangeListener((Program)x$0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void domainFileObjectClosed(DomainFile file, DomainObject object) {
        if (this.disposed) {
            return;
        }
        Map<Program, ModuleChangeListener> map = this.openedForUpdate;
        synchronized (map) {
            ModuleChangeListener listener = this.openedForUpdate.remove(object);
            if (listener != null) {
                listener.dispose();
            }
        }
    }

    private DomainFile selectBest(Collection<IndexEntry> entries, Set<DomainFile> libraries, Map<DomainFolder, Integer> folderUses, Program currentProgram) {
        DomainFile currentFile;
        if (currentProgram != null && (currentFile = currentProgram.getDomainFile()) != null) {
            String currentID = currentFile.getFileID();
            for (IndexEntry entry : entries) {
                if (!entry.dfID.equals(currentID)) continue;
                return currentFile;
            }
        }
        Comparator<IndexEntry> byIsLibrary = Comparator.comparing(e -> {
            DomainFile df = this.projectData.getFileByID(e.dfID);
            return libraries.contains(df) ? 1 : 0;
        });
        Comparator<IndexEntry> byNameSource = Comparator.comparing(e -> -e.source.ordinal());
        HashMap folderScores = new HashMap();
        Comparator<IndexEntry> byFolderUses = Comparator.comparing(e -> folderScores.computeIfAbsent(e, k -> {
            DomainFile df = this.projectData.getFileByID(k.dfID);
            int score = 0;
            for (DomainFolder folder = df.getParent(); folder != null; folder = folder.getParent()) {
                score += folderUses.getOrDefault(folder, 0).intValue();
            }
            return score;
        }));
        Comparator<IndexEntry> comparator = byIsLibrary.thenComparing(byNameSource).thenComparing(byFolderUses);
        return this.projectData.getFileByID(entries.stream().max(comparator).get().dfID);
    }

    public DomainFile getBestMatch(AddressSpace space, TraceModule module, Program currentProgram, Collection<IndexEntry> entries) {
        if (entries.isEmpty()) {
            return null;
        }
        HashMap<DomainFolder, Integer> folderUses = new HashMap<DomainFolder, Integer>();
        Set<DomainFile> alreadyMapped = module.getTrace().getStaticMappingManager().findAllOverlapping((AddressRange)new AddressRangeImpl(space.getMinAddress(), space.getMaxAddress()), module.getLifespan()).stream().map(m -> ProgramURLUtils.getFileForHackedUpGhidraURL(this.project, m.getStaticProgramURL())).collect(Collectors.toSet());
        Set<DomainFile> libraries = DebuggerStaticMappingUtils.collectLibraries(alreadyMapped);
        alreadyMapped.stream().map(df -> df.getParent()).filter(folder -> folder.getProjectData() == this.projectData).forEach(folder -> {
            while (folder != null) {
                folderUses.compute((DomainFolder)folder, (f, c) -> c == null ? 1 : c + 1);
                folder = folder.getParent();
            }
        });
        return this.selectBest(entries, libraries, folderUses, currentProgram);
    }

    public DomainFile getBestMatch(TraceModule module, Program currentProgram, Collection<IndexEntry> entries) {
        return this.getBestMatch(module.getBase().getAddressSpace(), module, currentProgram, entries);
    }

    public List<IndexEntry> getBestEntries(TraceModule module) {
        String modulePathName = module.getName().toLowerCase();
        ArrayList<IndexEntry> entries = new ArrayList<IndexEntry>(this.index.getByName(modulePathName));
        if (!entries.isEmpty()) {
            return entries;
        }
        String moduleFileName = new File(modulePathName).getName();
        entries.addAll(this.index.getByName(moduleFileName));
        return entries;
    }

    public DomainFile getBestMatch(AddressSpace space, TraceModule module, Program currentProgram) {
        return this.getBestMatch(space, module, currentProgram, this.getBestEntries(module));
    }

    public Collection<IndexEntry> filter(Collection<IndexEntry> entries, Collection<? extends Program> programs) {
        ArrayList<IndexEntry> result = new ArrayList<IndexEntry>();
        for (IndexEntry e : entries) {
            DomainFile df = this.projectData.getFileByID(e.dfID);
            if (df == null) continue;
            try (PeekOpenedDomainObject peek = new PeekOpenedDomainObject(df);){
                if (!programs.contains(peek.object)) continue;
                result.add(e);
            }
        }
        return result;
    }

    protected static class ModuleIndex {
        final MapOfSets<String, IndexEntry> entriesByName = new MapOfSets();
        final MapOfSets<String, IndexEntry> entriesByFile = new MapOfSets();

        protected ModuleIndex() {
        }

        void addEntry(String name, String dfID, NameSource source) {
            IndexEntry entry = new IndexEntry(name, dfID, source);
            this.entriesByName.put(name, entry);
            this.entriesByFile.put(dfID, entry);
        }

        void removeEntry(IndexEntry entry) {
            this.entriesByName.remove(entry.name, entry);
            this.entriesByFile.remove(entry.dfID, entry);
        }

        void removeFile(String fileID) {
            Set remove = this.entriesByFile.map.remove(fileID);
            if (remove == null) {
                return;
            }
            for (IndexEntry entry : remove) {
                this.entriesByName.remove(entry.name, entry);
            }
        }

        public Collection<IndexEntry> getByName(String name) {
            return this.entriesByName.map.getOrDefault(name, Set.of());
        }
    }

    protected static enum NameSource {
        MODULE_PATH,
        MODULE_NAME,
        PROGRAM_EXECUTABLE_PATH,
        PROGRAM_EXECUTABLE_NAME,
        PROGRAM_NAME,
        DOMAIN_FILE_NAME;

    }

    protected class ModuleChangeListener
    implements DomainObjectListener,
    DomainObjectClosedListener {
        private final Program program;

        public ModuleChangeListener(Program program) {
            this.program = program;
            program.addListener((DomainObjectListener)this);
            program.addCloseListener((DomainObjectClosedListener)this);
        }

        protected void dispose() {
            this.program.removeListener((DomainObjectListener)this);
            this.program.removeCloseListener((DomainObjectClosedListener)this);
        }

        public void domainObjectClosed() {
            this.dispose();
        }

        public void domainObjectChanged(DomainObjectChangedEvent ev) {
            if (ProgramModuleIndexer.this.disposed) {
                return;
            }
            if (ev.containsEvent(4)) {
                ProgramModuleIndexer.this.refreshIndex(this.program.getDomainFile(), this.program);
                return;
            }
            if (ev.containsEvent(5)) {
                for (DomainObjectChangeRecord rec : ev) {
                    String propertyName;
                    if (rec.getEventType() != 5 || !"Program Information.Module Paths".equals(propertyName = (String)rec.getOldValue())) continue;
                    ProgramModuleIndexer.this.refreshIndex(this.program.getDomainFile(), this.program);
                    return;
                }
            }
        }
    }

    protected record IndexEntry(String name, String dfID, NameSource source) {
    }

    protected static class MapOfSets<K, V> {
        public final Map<K, Set<V>> map = new HashMap<K, Set<V>>();

        protected MapOfSets() {
        }

        public void put(K key, V value) {
            this.map.computeIfAbsent(key, k -> new HashSet()).add(value);
        }

        public void remove(K key, V value) {
            Set<V> set = this.map.get(key);
            if (set == null) {
                return;
            }
            set.remove(value);
            if (set.isEmpty()) {
                this.map.remove(key);
            }
        }
    }
}

