/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.debug;

import docking.widgets.table.GTable;
import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableFilterPanel;
import docking.widgets.table.RowObjectTableModel;
import ghidra.feature.fid.db.FidDB;
import ghidra.feature.fid.db.FidQueryCloseListener;
import ghidra.feature.fid.db.FidQueryService;
import ghidra.feature.fid.db.FunctionRecord;
import ghidra.feature.fid.debug.FidDebugUtils;
import ghidra.feature.fid.debug.FidFunctionRecordTableModel;
import ghidra.feature.fid.service.FidService;
import ghidra.util.Msg;
import ghidra.util.ReadOnlyException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class FidSearchResultFrame
extends JFrame
implements FidQueryCloseListener {
    static final int NAME_WIDTH = 480;
    static final int HASH_WIDTH = 160;
    static final int SIZE_WIDTH = 50;
    static final int MINI_WIDTH = 50;
    static final int SMALLER_WIDTH = 240;
    static int[] PREFERRED_WIDTHS = new int[]{480, 160, 240, 240, 160, 160, 50, 160, 50, 160, 50, 160, 50};
    private FidService service;
    private FidQueryService dbService;
    private List<FunctionRecord> funcList;
    private FidFunctionRecordTableModel model;
    private GTable table;

    public FidSearchResultFrame(String title, List<FunctionRecord> funcList, FidService service, FidQueryService dbService) {
        super(title);
        this.service = service;
        this.dbService = dbService;
        this.funcList = funcList;
        this.model = new FidFunctionRecordTableModel(dbService, funcList);
        this.table = new GTable((TableModel)((Object)this.model));
        this.buildFrame();
        dbService.addCloseListener(this);
    }

    private void buildFrame() {
        GTableCellRenderer renderer = new GTableCellRenderer();
        renderer.setFont(renderer.getFixedWidthFont());
        int columnCount = this.table.getColumnCount();
        for (int ii = 0; ii < columnCount; ++ii) {
            Class columnClass = this.table.getColumnClass(ii);
            this.table.setDefaultRenderer(columnClass, (TableCellRenderer)renderer);
        }
        JScrollPane scrollPane = new JScrollPane((Component)this.table);
        this.table.setPreferredScrollableViewportSize(new Dimension(400, 100));
        this.table.setSelectionMode(0);
        final GTableFilterPanel filterPanel = new GTableFilterPanel((JTable)this.table, (RowObjectTableModel)this.model);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && FidSearchResultFrame.this.table.getSelectedRowCount() == 1) {
                    int selectedRow = FidSearchResultFrame.this.table.getSelectedRow();
                    int modelRow = filterPanel.getModelRow(selectedRow);
                    FunctionRecord functionRecord = FidSearchResultFrame.this.funcList.get(modelRow);
                    FidDebugUtils.openFunctionWindow(functionRecord, FidSearchResultFrame.this.service, FidSearchResultFrame.this.dbService);
                }
            }
        });
        JMenuBar menuBar = this.buildMenuActions();
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)scrollPane, "Center");
        mainPanel.add((Component)filterPanel, "South");
        this.setJMenuBar(menuBar);
        this.setDefaultCloseOperation(2);
        this.setContentPane(mainPanel);
        this.setSize(2500, Math.min(600, 150 + 20 * this.funcList.size()));
        this.setVisible(true);
        TableColumnModel columnModel = this.table.getColumnModel();
        Enumeration<TableColumn> columns = columnModel.getColumns();
        int ii = 0;
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            column.setMinWidth(PREFERRED_WIDTHS[ii]);
            ++ii;
        }
    }

    private JMenuBar buildMenuActions() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("Edit");
        menuBar.add(menu);
        JMenuItem item1 = new JMenuItem("Set auto-fail");
        item1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (FidSearchResultFrame.this.funcList.isEmpty()) {
                    return;
                }
                try {
                    FidSearchResultFrame.this.funcList = FidSearchResultFrame.this.service.markRecordsAutoFail(FidSearchResultFrame.this.funcList, true);
                    FidSearchResultFrame.this.model.resetWholeTable(FidSearchResultFrame.this.funcList);
                }
                catch (ReadOnlyException e) {
                    Msg.info((Object)this, (Object)e.getMessage());
                }
                catch (IOException e) {
                    Msg.error((Object)this, (Object)"Error performing 'Set auto-fail'", (Throwable)e);
                }
            }
        });
        menu.add(item1);
        JMenuItem item2 = new JMenuItem("Set auto-pass");
        item2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FidSearchResultFrame.this.funcList.isEmpty()) {
                    return;
                }
                try {
                    FidSearchResultFrame.this.funcList = FidSearchResultFrame.this.service.markRecordsAutoPass(FidSearchResultFrame.this.funcList, true);
                    FidSearchResultFrame.this.model.resetWholeTable(FidSearchResultFrame.this.funcList);
                }
                catch (IOException e1) {
                    Msg.error((Object)this, (Object)"Error performing 'Set auto-pass'", (Throwable)e1);
                }
            }
        });
        menu.add(item2);
        JMenuItem item3 = new JMenuItem("Set force-specific");
        item3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FidSearchResultFrame.this.funcList.isEmpty()) {
                    return;
                }
                try {
                    FidSearchResultFrame.this.funcList = FidSearchResultFrame.this.service.markRecordsForceSpecific(FidSearchResultFrame.this.funcList, true);
                    FidSearchResultFrame.this.model.resetWholeTable(FidSearchResultFrame.this.funcList);
                }
                catch (IOException e1) {
                    Msg.error((Object)this, (Object)"Error performing 'Set force-specific'", (Throwable)e1);
                }
            }
        });
        menu.add(item3);
        JMenuItem item4 = new JMenuItem("Set force-relation");
        item4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FidSearchResultFrame.this.funcList.isEmpty()) {
                    return;
                }
                try {
                    FidSearchResultFrame.this.funcList = FidSearchResultFrame.this.service.markRecordsForceRelation(FidSearchResultFrame.this.funcList, true);
                    FidSearchResultFrame.this.model.resetWholeTable(FidSearchResultFrame.this.funcList);
                }
                catch (IOException e1) {
                    Msg.error((Object)this, (Object)"Error performing 'Set force-relation'", (Throwable)e1);
                }
            }
        });
        menu.add(item4);
        JMenuItem item5 = new JMenuItem("Clear auto-fail");
        item5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FidSearchResultFrame.this.funcList.isEmpty()) {
                    return;
                }
                try {
                    FidSearchResultFrame.this.funcList = FidSearchResultFrame.this.service.markRecordsAutoFail(FidSearchResultFrame.this.funcList, false);
                    FidSearchResultFrame.this.model.resetWholeTable(FidSearchResultFrame.this.funcList);
                }
                catch (IOException e1) {
                    Msg.error((Object)this, (Object)"Error performing 'Clear auto-fail'", (Throwable)e1);
                }
            }
        });
        menu.add(item5);
        JMenuItem item6 = new JMenuItem("Clear auto-pass");
        item6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FidSearchResultFrame.this.funcList.isEmpty()) {
                    return;
                }
                try {
                    FidSearchResultFrame.this.funcList = FidSearchResultFrame.this.service.markRecordsAutoPass(FidSearchResultFrame.this.funcList, false);
                    FidSearchResultFrame.this.model.resetWholeTable(FidSearchResultFrame.this.funcList);
                }
                catch (IOException e1) {
                    Msg.error((Object)this, (Object)"Error performing 'Clear auto-pass'", (Throwable)e1);
                }
            }
        });
        menu.add(item6);
        JMenuItem item7 = new JMenuItem("Clear force-specific");
        item7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FidSearchResultFrame.this.funcList.isEmpty()) {
                    return;
                }
                try {
                    FidSearchResultFrame.this.funcList = FidSearchResultFrame.this.service.markRecordsForceSpecific(FidSearchResultFrame.this.funcList, false);
                    FidSearchResultFrame.this.model.resetWholeTable(FidSearchResultFrame.this.funcList);
                }
                catch (IOException e1) {
                    Msg.error((Object)this, (Object)"Error performing 'Clear force-specific'", (Throwable)e1);
                }
            }
        });
        menu.add(item7);
        JMenuItem item8 = new JMenuItem("Clear force-relation");
        item8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FidSearchResultFrame.this.funcList.isEmpty()) {
                    return;
                }
                try {
                    FidSearchResultFrame.this.funcList = FidSearchResultFrame.this.service.markRecordsForceRelation(FidSearchResultFrame.this.funcList, false);
                    FidSearchResultFrame.this.model.resetWholeTable(FidSearchResultFrame.this.funcList);
                }
                catch (IOException e1) {
                    Msg.error((Object)this, (Object)"Error performing 'Clear force-relation'", (Throwable)e1);
                }
            }
        });
        menu.add(item8);
        JMenuItem item9 = new JMenuItem("Save changes");
        item9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FidSearchResultFrame.this.funcList.isEmpty()) {
                    return;
                }
                HashSet<FidDB> dedupMap = new HashSet<FidDB>();
                for (FunctionRecord funcRec : FidSearchResultFrame.this.funcList) {
                    FidDB fidDb = funcRec.getFidDb();
                    if (dedupMap.contains(fidDb)) continue;
                    dedupMap.add(fidDb);
                    try {
                        fidDb.saveDatabase("saving", TaskMonitor.DUMMY);
                    }
                    catch (IOException e1) {
                        Msg.error((Object)this, (Object)"Error performing 'Save changes'", (Throwable)e1);
                    }
                    catch (CancelledException cancelledException) {}
                }
            }
        });
        menu.add(item9);
        return menuBar;
    }

    @Override
    public void dispose() {
        this.table.dispose();
        this.dbService.removeCloseListener(this);
        super.dispose();
    }

    @Override
    public void fidQueryClosed(FidQueryService service) {
        this.dispose();
    }
}

