/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.matchtable;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.action.ToolBarData;
import generic.theme.GIcon;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.OptionsService;
import ghidra.util.HelpLocation;
import javax.swing.Icon;

public class VTMatchApplySettingsAction
extends DockingAction {
    public static final String VERSION_TRACKING_OPTIONS_NAME = "Version Tracking";
    public static final String VERSION_TRACKING_APPLY_MARKUP_OPTIONS = "Apply Markup Options";
    static final Icon ICON = new GIcon("icon.version.tracking.action.show.settings");
    private static final String MENU_GROUP = "ZZ_VT_SETTINGS";
    private static final String TITLE = "Version Tracking Options";
    private final VTController controller;

    public VTMatchApplySettingsAction(VTController controller) {
        super(TITLE, VTPlugin.OWNER);
        this.controller = controller;
        this.setToolBarData(new ToolBarData(ICON, MENU_GROUP));
        this.setPopupMenuData(new MenuData(new String[]{"Options..."}, ICON, MENU_GROUP));
        this.setDescription("Adjust the Apply Mark-up Settings for Applying Matches");
        this.setEnabled(true);
        this.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Match_Table_Settings"));
    }

    public void actionPerformed(ActionContext context) {
        PluginTool tool = this.controller.getTool();
        OptionsService service = (OptionsService)tool.getService(OptionsService.class);
        service.showOptionsDialog("Version Tracking.Apply Markup Options", "Apply");
    }

    public boolean isEnabledForContext(ActionContext context) {
        return true;
    }

    public boolean isAddToPopup(ActionContext context) {
        return true;
    }
}

