/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.memview;

import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.gui.memview.MemoryBox;
import ghidra.app.plugin.core.debug.gui.memview.MemviewBoxType;
import ghidra.app.plugin.core.debug.gui.memview.MemviewProvider;
import ghidra.app.services.TraceRecorder;
import ghidra.async.AsyncDebouncer;
import ghidra.async.AsyncTimer;
import ghidra.framework.model.DomainObjectListener;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.breakpoint.TraceBreakpoint;
import ghidra.trace.model.breakpoint.TraceBreakpointManager;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.modules.TraceModuleManager;
import ghidra.trace.model.modules.TraceSection;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.thread.TraceThreadManager;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.Swing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class DebuggerMemviewTraceListener
extends TraceDomainObjectListener {
    protected MemviewProvider provider;
    DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    Trace currentTrace;
    TraceRecorder currentRecorder;
    private boolean trackTrace = false;
    private boolean trackThreads = true;
    private boolean trackRegions = true;
    private boolean trackModules = true;
    private boolean trackSections = true;
    private boolean trackBreakpoints = true;
    private boolean trackBytes = true;
    List<MemoryBox> updateList = new ArrayList<MemoryBox>();
    private final AsyncDebouncer<Void> updateLabelDebouncer = new AsyncDebouncer(AsyncTimer.DEFAULT_TIMER, 100L);

    public DebuggerMemviewTraceListener(MemviewProvider provider) {
        this.provider = provider;
        this.updateLabelDebouncer.addListener(__ -> Swing.runIfSwingOrRunLater(() -> this.doUpdate()));
        this.listenFor((TraceChangeType)Trace.TraceThreadChangeType.ADDED, this::threadChanged);
        this.listenFor((TraceChangeType)Trace.TraceThreadChangeType.CHANGED, this::threadChanged);
        this.listenFor((TraceChangeType)Trace.TraceThreadChangeType.LIFESPAN_CHANGED, this::threadChanged);
        this.listenFor((TraceChangeType)Trace.TraceThreadChangeType.DELETED, this::threadChanged);
        this.listenFor((TraceChangeType)Trace.TraceMemoryRegionChangeType.ADDED, this::regionChanged);
        this.listenFor((TraceChangeType)Trace.TraceMemoryRegionChangeType.CHANGED, this::regionChanged);
        this.listenFor((TraceChangeType)Trace.TraceMemoryRegionChangeType.LIFESPAN_CHANGED, this::regionChanged);
        this.listenFor((TraceChangeType)Trace.TraceMemoryRegionChangeType.DELETED, this::regionChanged);
        this.listenFor((TraceChangeType)Trace.TraceModuleChangeType.ADDED, this::moduleChanged);
        this.listenFor((TraceChangeType)Trace.TraceModuleChangeType.CHANGED, this::moduleChanged);
        this.listenFor((TraceChangeType)Trace.TraceModuleChangeType.LIFESPAN_CHANGED, this::moduleChanged);
        this.listenFor((TraceChangeType)Trace.TraceModuleChangeType.DELETED, this::moduleChanged);
        this.listenFor((TraceChangeType)Trace.TraceSectionChangeType.ADDED, this::sectionChanged);
        this.listenFor((TraceChangeType)Trace.TraceSectionChangeType.CHANGED, this::sectionChanged);
        this.listenFor((TraceChangeType)Trace.TraceSectionChangeType.DELETED, this::sectionChanged);
        this.listenFor((TraceChangeType)Trace.TraceBreakpointChangeType.ADDED, this::breakpointChanged);
        this.listenFor((TraceChangeType)Trace.TraceBreakpointChangeType.CHANGED, this::breakpointChanged);
        this.listenFor((TraceChangeType)Trace.TraceBreakpointChangeType.LIFESPAN_CHANGED, this::breakpointChanged);
        this.listenFor((TraceChangeType)Trace.TraceBreakpointChangeType.DELETED, this::breakpointChanged);
        this.listenFor((TraceChangeType)Trace.TraceMemoryBytesChangeType.CHANGED, this::bytesChanged);
    }

    public MemviewProvider getProvider() {
        return this.provider;
    }

    protected AddressRange rng(AddressSpace space, long min, long max) {
        return new AddressRangeImpl(space.getAddress(min), space.getAddress(max));
    }

    private void threadChanged(TraceThread thread) {
        if (!this.trackThreads || !this.trackTrace) {
            return;
        }
        AddressFactory factory = thread.getTrace().getBaseAddressFactory();
        AddressSpace defaultSpace = factory.getDefaultAddressSpace();
        Long threadId = thread.getKey();
        AddressRange rng = this.rng(defaultSpace, threadId, threadId);
        MemoryBox box = new MemoryBox("Thread " + thread.getName(), MemviewBoxType.THREAD, rng, thread.getLifespan());
        this.updateList.add(box);
        this.updateLabelDebouncer.contact(null);
    }

    private void regionChanged(TraceMemoryRegion region) {
        if (!this.trackRegions || !this.trackTrace) {
            return;
        }
        MemoryBox box = new MemoryBox("Region " + region.getName(), MemviewBoxType.VIRTUAL_ALLOC, region.getRange(), region.getLifespan());
        this.updateList.add(box);
        this.updateLabelDebouncer.contact(null);
    }

    private void moduleChanged(TraceModule module) {
        if (!this.trackModules || !this.trackTrace) {
            return;
        }
        AddressRange range = module.getRange();
        if (range == null) {
            return;
        }
        MemoryBox box = new MemoryBox("Module " + module.getName(), MemviewBoxType.MODULE, range, module.getLifespan());
        this.updateList.add(box);
        this.updateLabelDebouncer.contact(null);
    }

    private void sectionChanged(TraceSection section) {
        if (!this.trackSections || !this.trackTrace) {
            return;
        }
        MemoryBox box = new MemoryBox("Section " + section.getName(), MemviewBoxType.IMAGE, section.getRange(), section.getModule().getLifespan());
        this.updateList.add(box);
        this.updateLabelDebouncer.contact(null);
    }

    private void breakpointChanged(TraceBreakpoint bpt) {
        if (!this.trackBreakpoints || !this.trackTrace) {
            return;
        }
        MemoryBox box = new MemoryBox("Breakpoint " + bpt.getName(), MemviewBoxType.BREAKPOINT, bpt.getRange(), bpt.getLifespan());
        this.updateList.add(box);
        this.updateLabelDebouncer.contact(null);
    }

    private void bytesChanged(TraceAddressSnapRange range) {
        if (!this.trackBytes || !this.trackTrace) {
            return;
        }
        Lifespan lifespan = range.getLifespan();
        MemoryBox box = new MemoryBox("BytesChanged " + range.description(), MemviewBoxType.WRITE_MEMORY, range.getRange(), lifespan);
        this.updateList.add(box);
        this.updateLabelDebouncer.contact(null);
    }

    private void doUpdate() {
        this.provider.addBoxes(this.updateList);
    }

    protected void addListener() {
        Trace trace = this.current.getTrace();
        if (trace != null) {
            trace.addListener((DomainObjectListener)this);
        }
    }

    protected void removeListener() {
        Trace trace = this.current.getTrace();
        if (trace != null) {
            trace.removeListener((DomainObjectListener)this);
        }
    }

    public void setCoordinates(DebuggerCoordinates coordinates) {
        boolean doListeners;
        if (this.current.equals(coordinates)) {
            this.current = coordinates;
            return;
        }
        boolean bl = doListeners = !Objects.equals(this.current.getTrace(), coordinates.getTrace());
        if (doListeners) {
            this.removeListener();
        }
        this.current = coordinates;
        if (doListeners) {
            this.addListener();
        }
    }

    protected DebuggerCoordinates adjustCoordinates(DebuggerCoordinates coordinates) {
        return this.current.time(coordinates.getTime());
    }

    public void coordinatesActivated(DebuggerCoordinates coordinates) {
        this.setCoordinates(coordinates);
        final Trace trace = coordinates.getTrace();
        if (trace != null) {
            Swing.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    DebuggerMemviewTraceListener.this.processTrace(trace);
                }
            });
        } else {
            this.provider.reset();
        }
    }

    public void traceClosed(Trace trace) {
        if (this.current.getTrace() == trace) {
            this.setCoordinates(DebuggerCoordinates.NOWHERE);
        }
    }

    public void toggleTrackTrace() {
        this.trackTrace = !this.trackTrace;
    }

    private void processTrace(Trace trace) {
        this.updateList.clear();
        this.provider.reset();
        TraceThreadManager threadManager = trace.getThreadManager();
        for (Object thread : threadManager.getAllThreads()) {
            this.threadChanged((TraceThread)thread);
        }
        TraceModuleManager moduleManager = trace.getModuleManager();
        for (Object module : moduleManager.getAllModules()) {
            this.moduleChanged((TraceModule)module);
            Collection sections = module.getSections();
            for (TraceSection section : sections) {
                this.sectionChanged(section);
            }
        }
        TraceMemoryManager memoryManager = trace.getMemoryManager();
        for (TraceMemoryRegion region : memoryManager.getAllRegions()) {
            this.regionChanged(region);
        }
        TraceBreakpointManager breakpointManager = trace.getBreakpointManager();
        for (TraceBreakpoint bpt : breakpointManager.getAllBreakpoints()) {
            this.breakpointChanged(bpt);
        }
        this.updateLabelDebouncer.contact(null);
    }
}

