/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.mapping;

import ghidra.app.plugin.core.debug.disassemble.TraceDisassembleCommand;
import ghidra.app.plugin.core.debug.mapping.DebuggerPlatformMapper;
import ghidra.app.plugin.core.debug.mapping.DebuggerPlatformOpinion;
import ghidra.app.plugin.core.debug.mapping.DisassemblyResult;
import ghidra.app.plugin.core.debug.workflow.DisassemblyInject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.lang.Language;
import ghidra.trace.model.Trace;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.Set;

public abstract class AbstractDebuggerPlatformMapper
implements DebuggerPlatformMapper {
    protected final PluginTool tool;
    protected final Trace trace;

    public AbstractDebuggerPlatformMapper(PluginTool tool, Trace trace) {
        this.tool = tool;
        this.trace = trace;
    }

    protected boolean canInterpret(TraceObject newFocus, long snap, TraceObject env, String debugger, String arch, String os, Endian endian) {
        return true;
    }

    @Override
    public boolean canInterpret(TraceObject newFocus, long snap) {
        TraceObject env = DebuggerPlatformOpinion.getEnvironment(newFocus, snap);
        if (env == null) {
            return this.canInterpret(newFocus, snap, env, null, null, null, null);
        }
        String debugger = DebuggerPlatformOpinion.getDebugggerFromEnv(env, snap);
        String arch = DebuggerPlatformOpinion.getArchitectureFromEnv(env, snap);
        String os = DebuggerPlatformOpinion.getOperatingSystemFromEnv(env, snap);
        Endian endian = DebuggerPlatformOpinion.getEndianFromEnv(env, snap);
        return this.canInterpret(newFocus, snap, env, debugger, arch, os, endian);
    }

    protected boolean isCancelSilently(Address start, long snap) {
        return this.trace.getCodeManager().definedUnits().containsAddress(snap, start);
    }

    protected Collection<DisassemblyInject> getDisassemblyInjections(TraceObject object) {
        return Set.of();
    }

    @Override
    public DisassemblyResult disassemble(TraceThread thread, TraceObject object, Address start, AddressSetView restricted, long snap, TaskMonitor monitor) {
        if (this.isCancelSilently(start, snap)) {
            return DisassemblyResult.CANCELLED;
        }
        TracePlatform platform = this.trace.getPlatformManager().getPlatform(this.getCompilerSpec(object));
        Collection<DisassemblyInject> injects = this.getDisassemblyInjections(object);
        TraceDisassembleCommand dis = new TraceDisassembleCommand(platform, start, restricted);
        Language language = platform.getLanguage();
        AddressSet startSet = new AddressSet(start);
        for (DisassemblyInject i : injects) {
            i.pre(this.tool, dis, this.trace, language, snap, thread, (AddressSetView)startSet, restricted);
        }
        boolean result = dis.applyToTyped(this.trace.getFixedProgramView(snap), monitor);
        if (!result) {
            return DisassemblyResult.failed(dis.getStatusMsg());
        }
        for (DisassemblyInject i : injects) {
            i.post(this.tool, this.trace, snap, dis.getDisassembledAddressSet());
        }
        return DisassemblyResult.success(!dis.getDisassembledAddressSet().isEmpty());
    }
}

