/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.platform.dbgeng;

import ghidra.app.plugin.core.debug.mapping.DebuggerMappingOffer;
import ghidra.app.plugin.core.debug.mapping.DebuggerMappingOpinion;
import ghidra.app.plugin.core.debug.mapping.DebuggerRegisterMapper;
import ghidra.app.plugin.core.debug.mapping.DebuggerTargetTraceMapper;
import ghidra.app.plugin.core.debug.mapping.DefaultDebuggerMappingOffer;
import ghidra.app.plugin.core.debug.mapping.DefaultDebuggerTargetTraceMapper;
import ghidra.app.plugin.core.debug.mapping.LargestSubDebuggerRegisterMapper;
import ghidra.dbg.target.TargetEnvironment;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetProcess;
import ghidra.dbg.target.TargetRegisterContainer;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.CompilerSpecNotFoundException;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import java.util.Collection;
import java.util.Set;

public class DbgengX64DebuggerMappingOpinion
implements DebuggerMappingOpinion {
    protected static final LanguageID LANG_ID_X86_64 = new LanguageID("x86:LE:64:default");
    protected static final CompilerSpecID COMP_ID_VS = new CompilerSpecID("windows");

    @Override
    public Set<DebuggerMappingOffer> offersForEnv(TargetEnvironment env, TargetObject target, boolean includeOverrides) {
        boolean is64Bit;
        if (!(target instanceof TargetProcess)) {
            return Set.of();
        }
        if (env == null || !env.getDebugger().toLowerCase().contains("dbg")) {
            return Set.of();
        }
        boolean bl = is64Bit = env.getArchitecture().contains("x86_64") || env.getArchitecture().contains("x64_32");
        if (is64Bit) {
            return Set.of(new DbgI386X86_64WindowsOffer((TargetProcess)target));
        }
        return null;
    }

    protected static class DbgI386X86_64WindowsOffer
    extends DefaultDebuggerMappingOffer {
        public DbgI386X86_64WindowsOffer(TargetProcess process) {
            super((TargetObject)process, 100, "Dbgeng on Windows x64", LANG_ID_X86_64, COMP_ID_VS, Set.of());
        }

        @Override
        public DebuggerTargetTraceMapper createMapper() throws LanguageNotFoundException, CompilerSpecNotFoundException {
            return new DbgI386X86_64WindowsTraceMapper(this.target, this.langID, this.csID, this.extraRegNames);
        }
    }

    protected static class DbgI386X86_64WindowsTraceMapper
    extends DefaultDebuggerTargetTraceMapper {
        public DbgI386X86_64WindowsTraceMapper(TargetObject target, LanguageID langID, CompilerSpecID csId, Collection<String> extraRegNames) throws LanguageNotFoundException, CompilerSpecNotFoundException {
            super(target, langID, csId, extraRegNames);
        }

        @Override
        protected DebuggerRegisterMapper createRegisterMapper(TargetRegisterContainer registers) {
            return new DbgI386X86_64RegisterMapper(this.cSpec, registers);
        }
    }

    protected static class DbgI386X86_64RegisterMapper
    extends LargestSubDebuggerRegisterMapper {
        public DbgI386X86_64RegisterMapper(CompilerSpec cSpec, TargetRegisterContainer targetRegContainer) {
            super(cSpec, targetRegContainer, false);
        }

        @Override
        protected String normalizeName(String name) {
            if ("efl".equals(name = super.normalizeName(name))) {
                return "eflags";
            }
            if ("rfl".equals(name)) {
                return "eflags";
            }
            if ("rflags".equals(name)) {
                return "eflags";
            }
            return name;
        }
    }
}

