/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.model.record;

import ghidra.app.plugin.core.debug.service.model.RecorderPermanentTransaction;
import ghidra.app.plugin.core.debug.service.model.record.ObjectBasedTraceRecorder;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.time.TraceSnapshot;

class TimeRecorder {
    protected final ObjectBasedTraceRecorder recorder;
    protected TraceSnapshot snapshot = null;

    protected TimeRecorder(ObjectBasedTraceRecorder recorder) {
        this.recorder = recorder;
    }

    protected TraceSnapshot getSnapshot() {
        return this.snapshot;
    }

    protected long getSnap() {
        return this.snapshot.getKey();
    }

    protected synchronized TraceSnapshot doCreateSnapshot(String description, TraceThread eventThread) {
        this.snapshot = this.recorder.trace.getTimeManager().createSnapshot(description);
        this.snapshot.setEventThread(eventThread);
        return this.snapshot;
    }

    protected TraceSnapshot createSnapshot(String description, TraceThread eventThread, RecorderPermanentTransaction tid) {
        TraceSnapshot snapshot;
        if (tid != null) {
            snapshot = this.doCreateSnapshot(description, eventThread);
        } else {
            try (RecorderPermanentTransaction tid2 = RecorderPermanentTransaction.start((UndoableDomainObject)this.recorder.trace, description);){
                snapshot = this.doCreateSnapshot(description, eventThread);
            }
        }
        this.recorder.fireSnapAdvanced(snapshot.getKey());
        return snapshot;
    }

    protected TraceSnapshot forceSnapshot() {
        return this.createSnapshot("User-forced snapshot", null, null);
    }
}

