/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.services;

import ghidra.app.plugin.core.debug.mapping.DebuggerMemoryMapper;
import ghidra.app.plugin.core.debug.mapping.DebuggerRegisterMapper;
import ghidra.app.services.TraceRecorderListener;
import ghidra.dbg.target.TargetBreakpointLocation;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetBreakpointSpecContainer;
import ghidra.dbg.target.TargetDataTypeNamespace;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetMemoryRegion;
import ghidra.dbg.target.TargetModule;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetRegisterBank;
import ghidra.dbg.target.TargetSection;
import ghidra.dbg.target.TargetStackFrame;
import ghidra.dbg.target.TargetSymbolNamespace;
import ghidra.dbg.target.TargetThread;
import ghidra.pcode.utils.Utils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.trace.model.Trace;
import ghidra.trace.model.breakpoint.TraceBreakpoint;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.modules.TraceSection;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.trace.util.TraceRegisterUtils;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public interface TraceRecorder {
    public static TraceBreakpointKind targetToTraceBreakpointKind(TargetBreakpointSpec.TargetBreakpointKind kind) {
        switch (kind) {
            case READ: {
                return TraceBreakpointKind.READ;
            }
            case WRITE: {
                return TraceBreakpointKind.WRITE;
            }
            case HW_EXECUTE: {
                return TraceBreakpointKind.HW_EXECUTE;
            }
            case SW_EXECUTE: {
                return TraceBreakpointKind.SW_EXECUTE;
            }
        }
        throw new AssertionError();
    }

    public static Set<TraceBreakpointKind> targetToTraceBreakpointKinds(Collection<TargetBreakpointSpec.TargetBreakpointKind> kinds) {
        return kinds.stream().map(TraceRecorder::targetToTraceBreakpointKind).collect(Collectors.toSet());
    }

    public static TargetBreakpointSpec.TargetBreakpointKind traceToTargetBreakpointKind(TraceBreakpointKind kind) {
        switch (kind) {
            case READ: {
                return TargetBreakpointSpec.TargetBreakpointKind.READ;
            }
            case WRITE: {
                return TargetBreakpointSpec.TargetBreakpointKind.WRITE;
            }
            case HW_EXECUTE: {
                return TargetBreakpointSpec.TargetBreakpointKind.HW_EXECUTE;
            }
            case SW_EXECUTE: {
                return TargetBreakpointSpec.TargetBreakpointKind.SW_EXECUTE;
            }
        }
        throw new AssertionError();
    }

    public static Set<TargetBreakpointSpec.TargetBreakpointKind> traceToTargetBreakpointKinds(Collection<TraceBreakpointKind> kinds) {
        return kinds.stream().map(TraceRecorder::traceToTargetBreakpointKind).collect(Collectors.toSet());
    }

    public CompletableFuture<Void> init();

    public TargetObject getTarget();

    public Trace getTrace();

    public long getSnap();

    public TraceSnapshot forceSnapshot();

    public boolean isRecording();

    public void stopRecording();

    public void addListener(TraceRecorderListener var1);

    public void removeListener(TraceRecorderListener var1);

    public TargetObject getTargetObject(TraceObject var1);

    public TraceObject getTraceObject(TargetObject var1);

    public TargetBreakpointLocation getTargetBreakpoint(TraceBreakpoint var1);

    public TraceBreakpoint getTraceBreakpoint(TargetBreakpointLocation var1);

    public TargetMemoryRegion getTargetMemoryRegion(TraceMemoryRegion var1);

    public TraceMemoryRegion getTraceMemoryRegion(TargetMemoryRegion var1);

    public TargetModule getTargetModule(TraceModule var1);

    public TraceModule getTraceModule(TargetModule var1);

    public TargetSection getTargetSection(TraceSection var1);

    public TraceSection getTraceSection(TargetSection var1);

    public TargetThread getTargetThread(TraceThread var1);

    public TargetExecutionStateful.TargetExecutionState getTargetThreadState(TargetThread var1);

    public TargetExecutionStateful.TargetExecutionState getTargetThreadState(TraceThread var1);

    public Set<TargetRegisterBank> getTargetRegisterBanks(TraceThread var1, int var2);

    public TraceThread getTraceThread(TargetThread var1);

    public TraceThread getTraceThreadForSuccessor(TargetObject var1);

    public TraceStackFrame getTraceStackFrame(TargetStackFrame var1);

    public TraceStackFrame getTraceStackFrameForSuccessor(TargetObject var1);

    public TargetStackFrame getTargetStackFrame(TraceThread var1, int var2);

    public Set<TargetThread> getLiveTargetThreads();

    public DebuggerRegisterMapper getRegisterMapper(TraceThread var1);

    public DebuggerMemoryMapper getMemoryMapper();

    @Deprecated
    public boolean isRegisterBankAccessible(TargetRegisterBank var1);

    @Deprecated
    public boolean isRegisterBankAccessible(TraceThread var1, int var2);

    public AddressSetView getAccessibleMemory();

    public CompletableFuture<Void> captureThreadRegisters(TracePlatform var1, TraceThread var2, int var3, Set<Register> var4);

    public CompletableFuture<Void> writeThreadRegisters(TracePlatform var1, TraceThread var2, int var3, Map<Register, RegisterValue> var4);

    public CompletableFuture<byte[]> readMemory(Address var1, int var2);

    public CompletableFuture<Void> writeMemory(Address var1, byte[] var2);

    public CompletableFuture<Void> readMemoryBlocks(AddressSetView var1, TaskMonitor var2);

    default public CompletableFuture<Void> writeVariable(TracePlatform platform, TraceThread thread, int frameLevel, Address address, byte[] data) {
        if (address.isMemoryAddress()) {
            return this.writeMemory(address, data);
        }
        if (address.isRegisterAddress()) {
            return this.writeRegister(platform, Objects.requireNonNull(thread), frameLevel, address, data);
        }
        throw new IllegalArgumentException("Address is not in a recognized space: " + address);
    }

    default public CompletableFuture<Void> writeRegister(TracePlatform platform, TraceThread thread, int frameLevel, Address address, byte[] data) {
        Register register = platform.getLanguage().getRegister(address, data.length);
        if (register == null) {
            throw new IllegalArgumentException("Cannot identify the (single) register to write: " + address);
        }
        RegisterValue rv = new RegisterValue(register, Utils.bytesToBigInteger((byte[])data, (int)data.length, (boolean)register.isBigEndian(), (boolean)false));
        TraceMemorySpace regs = this.getTrace().getMemoryManager().getMemoryRegisterSpace(thread, frameLevel, false);
        Register parent = this.isRegisterOnTarget(platform, thread, frameLevel, register);
        if (parent == null) {
            throw new IllegalArgumentException("Cannot find register " + register + " on target");
        }
        rv = TraceRegisterUtils.combineWithTraceParentRegisterValue((Register)parent, (RegisterValue)rv, (TracePlatform)platform, (long)this.getSnap(), (TraceMemorySpace)regs, (boolean)true);
        return this.writeThreadRegisters(platform, thread, frameLevel, Map.of(rv.getRegister(), rv));
    }

    public Register isRegisterOnTarget(TracePlatform var1, TraceThread var2, int var3, Register var4);

    default public boolean isMemoryOnTarget(Address address) {
        return this.getMemoryMapper().traceToTarget(address) != null;
    }

    default public boolean isVariableOnTarget(TracePlatform platform, TraceThread thread, int frameLevel, Address address, int size) {
        if (address.isMemoryAddress()) {
            return this.isMemoryOnTarget(address);
        }
        if (thread == null) {
            return false;
        }
        Register register = platform.getLanguage().getRegister(address, size);
        if (register == null) {
            throw new IllegalArgumentException("Cannot identify the (single) register: " + address);
        }
        if (frameLevel != 0) {
            return false;
        }
        return this.isRegisterOnTarget(platform, thread, frameLevel, register) != null;
    }

    public CompletableFuture<Void> captureDataTypes(TraceModule var1, TaskMonitor var2);

    public CompletableFuture<Void> captureDataTypes(TargetDataTypeNamespace var1, TaskMonitor var2);

    public CompletableFuture<Void> captureSymbols(TraceModule var1, TaskMonitor var2);

    public CompletableFuture<Void> captureSymbols(TargetSymbolNamespace var1, TaskMonitor var2);

    public List<TargetBreakpointSpecContainer> collectBreakpointContainers(TargetThread var1);

    public List<TargetBreakpointLocation> collectBreakpoints(TargetThread var1);

    public Set<TraceBreakpointKind> getSupportedBreakpointKinds();

    public boolean isSupportsFocus();

    public boolean isSupportsActivation();

    public TargetObject getFocus();

    public CompletableFuture<Boolean> requestFocus(TargetObject var1);

    public CompletableFuture<Boolean> requestActivation(TargetObject var1);

    public CompletableFuture<Void> flushTransactions();
}

