/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.gadp.client;

import ghidra.dbg.agent.SpiTargetObject;
import ghidra.dbg.gadp.client.DelegateGadpClientTargetObject;
import ghidra.dbg.gadp.client.GadpClient;
import ghidra.dbg.gadp.client.annot.GadpEventHandler;
import ghidra.dbg.gadp.protocol.Gadp;
import ghidra.dbg.target.TargetConsole;
import ghidra.dbg.target.TargetObject;
import ghidra.util.Msg;
import java.lang.invoke.MethodHandles;

public interface GadpClientTargetObject
extends SpiTargetObject {
    public static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();

    public GadpClient getModel();

    public DelegateGadpClientTargetObject getDelegate();

    @GadpEventHandler(value=Gadp.EventNotification.EvtCase.MODEL_OBJECT_EVENT)
    default public void handleModelObjectEvent(Gadp.EventNotification notification) {
        Gadp.ModelObjectEvent evt = notification.getModelObjectEvent();
        this.getDelegate().updateWithDeltas(evt.getElementDelta(), evt.getAttributeDelta());
    }

    @GadpEventHandler(value=Gadp.EventNotification.EvtCase.OBJECT_INVALIDATE_EVENT)
    default public void handleObjectInvalidateEvent(Gadp.EventNotification notification) {
        Gadp.ObjectInvalidateEvent evt = notification.getObjectInvalidateEvent();
        this.getDelegate().invalidateSubtree((TargetObject)this, evt.getReason());
    }

    @GadpEventHandler(value=Gadp.EventNotification.EvtCase.CACHE_INVALIDATE_EVENT)
    default public void handleCacheInvalidateEvent(Gadp.EventNotification notification) {
        this.getDelegate().doClearCaches();
    }

    @GadpEventHandler(value=Gadp.EventNotification.EvtCase.CONSOLE_OUTPUT_EVENT)
    default public void handleConsoleOutputEvent(Gadp.EventNotification notification) {
        Gadp.ConsoleOutputEvent evt = notification.getConsoleOutputEvent();
        int channelIndex = evt.getChannel();
        TargetConsole.Channel[] allChannels = TargetConsole.Channel.values();
        if (0 <= channelIndex && channelIndex < allChannels.length) {
            this.broadcast().consoleOutput((TargetObject)this, allChannels[channelIndex], evt.getData().toByteArray());
        } else {
            Msg.error((Object)this, (Object)("Received output for unknown channel " + channelIndex + ": " + evt.getData().toString()));
        }
    }
}

