/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.RecordIterator;
import db.Transaction;
import db.util.ErrorHandler;
import generic.jar.ResourceFile;
import ghidra.app.plugin.core.datamgr.archive.BuiltInSourceArchive;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.docking.settings.StringSettingsDefinition;
import ghidra.framework.Application;
import ghidra.framework.model.RuntimeIOException;
import ghidra.framework.store.db.PackedDBHandle;
import ghidra.framework.store.db.PackedDatabase;
import ghidra.graph.DefaultGEdge;
import ghidra.graph.GDirectedGraph;
import ghidra.graph.GEdge;
import ghidra.graph.GraphAlgorithms;
import ghidra.graph.GraphFactory;
import ghidra.graph.algo.GraphNavigator;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.DBStringMapAdapter;
import ghidra.program.database.data.ArrayDB;
import ghidra.program.database.data.ArrayDBAdapter;
import ghidra.program.database.data.BitFieldDBDataType;
import ghidra.program.database.data.BuiltinDBAdapter;
import ghidra.program.database.data.CallingConventionDBAdapter;
import ghidra.program.database.data.CategoryDB;
import ghidra.program.database.data.CategoryDBAdapter;
import ghidra.program.database.data.ComponentDBAdapter;
import ghidra.program.database.data.CompositeDB;
import ghidra.program.database.data.CompositeDBAdapter;
import ghidra.program.database.data.DataTypeComponentDB;
import ghidra.program.database.data.DataTypeDB;
import ghidra.program.database.data.DataTypeSettingsDB;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.database.data.EnumDB;
import ghidra.program.database.data.EnumDBAdapter;
import ghidra.program.database.data.EnumValueDBAdapter;
import ghidra.program.database.data.FunctionDefinitionDB;
import ghidra.program.database.data.FunctionDefinitionDBAdapter;
import ghidra.program.database.data.FunctionParameterAdapter;
import ghidra.program.database.data.ParentChildAdapter;
import ghidra.program.database.data.PointerDB;
import ghidra.program.database.data.PointerDBAdapter;
import ghidra.program.database.data.SettingDB;
import ghidra.program.database.data.SettingsCache;
import ghidra.program.database.data.SettingsDBAdapter;
import ghidra.program.database.data.SourceArchiveAdapter;
import ghidra.program.database.data.SourceArchiveDB;
import ghidra.program.database.data.SourceArchiveUpgradeMap;
import ghidra.program.database.data.StructureDB;
import ghidra.program.database.data.TypedefDB;
import ghidra.program.database.data.TypedefDBAdapter;
import ghidra.program.database.data.UnionDB;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.symbol.VariableStorageManager;
import ghidra.program.database.util.DBRecordAdapter;
import ghidra.program.model.data.ArchiveType;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.BadDataType;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.BuiltInDataType;
import ghidra.program.model.data.BuiltInDataTypeManager;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataOrganizationImpl;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeDependencyException;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeManagerChangeListener;
import ghidra.program.model.data.DataTypeManagerChangeListenerHandler;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.GenericCallingConvention;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.InvalidatedListener;
import ghidra.program.model.data.MissingBuiltInDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.SourceArchive;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureInternal;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.TypeDefSettingsDefinition;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.data.Union;
import ghidra.program.model.data.UnionInternal;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageVersionException;
import ghidra.program.model.lang.ProgramArchitecture;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.util.InvalidNameException;
import ghidra.util.Lock;
import ghidra.util.Msg;
import ghidra.util.ReadOnlyException;
import ghidra.util.UniversalID;
import ghidra.util.UniversalIdGenerator;
import ghidra.util.UserSearchUtils;
import ghidra.util.classfinder.ClassTranslator;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.ClosedException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.help.UnsupportedOperationException;

public abstract class DataTypeManagerDB
implements DataTypeManager {
    static final int DB_VERSION = 2;
    static long ROOT_CATEGORY_ID = 0L;
    static final int BUILT_IN = 0;
    static final int COMPOSITE = 1;
    static final int COMPONENT = 2;
    static final int ARRAY = 3;
    static final int POINTER = 4;
    static final int TYPEDEF = 5;
    static final int FUNCTION_DEF = 6;
    static final int PARAMETER = 7;
    static final int ENUM = 8;
    static final int BITFIELD = 9;
    static final int DATA_TYPE_KIND_SHIFT = 56;
    private static final String MAP_TABLE_NAME = "DataTypeManager";
    private static final String DTM_DB_VERSION_KEY = "DB Version";
    private static final String DTM_GHIDRA_VERSION_KEY = "GHIDRA Version";
    private static final String SETTINGS_TABLE_NAME = "Default Settings";
    public static final byte UNKNOWN_CALLING_CONVENTION_ID = 0;
    public static final byte DEFAULT_CALLING_CONVENTION_ID = 1;
    private BuiltinDBAdapter builtinAdapter;
    private ComponentDBAdapter componentAdapter;
    private CompositeDBAdapter compositeAdapter;
    private ArrayDBAdapter arrayAdapter;
    private PointerDBAdapter pointerAdapter;
    private TypedefDBAdapter typedefAdapter;
    private SettingsDBAdapter settingsAdapter;
    private CategoryDBAdapter categoryAdapter;
    private FunctionDefinitionDBAdapter functionDefAdapter;
    private FunctionParameterAdapter paramAdapter;
    private EnumDBAdapter enumAdapter;
    private EnumValueDBAdapter enumValueAdapter;
    private ParentChildAdapter parentChildAdapter;
    protected SourceArchiveAdapter sourceArchiveAdapter;
    private CallingConventionDBAdapter callingConventionAdapter;
    private TreeSet<String> knownCallingConventions;
    private TreeSet<String> definedCallingConventions;
    protected final boolean readOnlyMode;
    protected final DBHandle dbHandle;
    protected final String tablePrefix;
    protected final ErrorHandler errHandler;
    private DataTypeConflictHandler currentHandler;
    private CategoryDB root;
    private DBObjectCache<DataTypeDB> dtCache;
    private DBObjectCache<SourceArchiveDB> sourceArchiveDBCache;
    private HashMap<Long, DataType> builtInMap = new HashMap();
    private HashMap<DataType, Long> builtIn2IdMap = new HashMap();
    private DBObjectCache<CategoryDB> catCache = new DBObjectCache(50);
    private SettingsCache<Long> settingsCache = new SettingsCache(200);
    private List<DataType> sortedDataTypes;
    private Map<Long, Set<String>> enumValueMap;
    private Map<String, Set<String>> previouslyUsedSettingsValuesMap = new HashMap<String, Set<String>>();
    private List<InvalidatedListener> invalidatedListeners = new ArrayList<InvalidatedListener>();
    protected DataTypeManagerChangeListenerHandler defaultListener = new DataTypeManagerChangeListenerHandler();
    private NameComparator nameComparator = new NameComparator();
    private int creatingDataType = 0;
    protected UniversalID universalID;
    private Map<UniversalID, SourceArchive> sourceArchiveMap;
    private LinkedList<Long> idsToDelete = new LinkedList();
    private List<DataType> favoritesList = new ArrayList<DataType>();
    private IdsToDataTypeMap idsToDataTypeMap = new IdsToDataTypeMap();
    private ThreadLocal<EquivalenceCache> equivalenceCache = new ThreadLocal();
    private IdentityHashMap<DataType, DataType> resolveCache;
    private TreeSet<ResolvePair> resolveQueue;
    private boolean isBulkRemoving;
    protected AddressMap addrMap;
    private DataOrganization dataOrganization;
    private ProgramArchitecture programArchitecture;
    private VariableStorageManager variableStorageMgr;
    protected final Lock lock;

    protected DataTypeManagerDB(DataOrganization dataOrganization) throws RuntimeIOException {
        this.lock = new Lock("DataTypeManagerDB");
        this.errHandler = new DbErrorHandler();
        this.dataOrganization = dataOrganization;
        this.tablePrefix = "";
        try {
            this.dbHandle = new DBHandle();
            this.readOnlyMode = false;
            int id = this.startTransaction("");
            try {
                this.init(0, TaskMonitor.DUMMY);
            }
            catch (CancelledException | VersionException e) {
                throw new AssertException(e);
            }
            finally {
                this.endTransaction(id, true);
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataTypeManagerDB(ResourceFile packedDBfile, int openMode, TaskMonitor monitor) throws IOException, CancelledException {
        this.errHandler = new DbErrorHandler();
        this.lock = new Lock("DataTypeManagerDB");
        this.tablePrefix = "";
        this.readOnlyMode = openMode == 2;
        File file = packedDBfile.getFile(false);
        if (file == null && openMode != 2) {
            throw new IOException("Unsupported mode (" + openMode + ") for read-only Datatype Archive: " + packedDBfile.getAbsolutePath());
        }
        boolean openSuccess = false;
        PackedDatabase pdb = null;
        try {
            if (openMode == 0) {
                this.dbHandle = new PackedDBHandle("Archive");
            } else {
                pdb = PackedDatabase.getPackedDatabase((ResourceFile)packedDBfile, (boolean)false, (TaskMonitor)monitor);
                this.dbHandle = openMode == 2 ? pdb.open(monitor) : pdb.openForUpdate(monitor);
            }
            openSuccess = true;
        }
        finally {
            if (!openSuccess && pdb != null) {
                pdb.dispose();
            }
        }
        boolean initSuccess = false;
        try {
            this.initPackedDatabase(packedDBfile, openMode, monitor);
            if (openMode == 0) {
                Long uid = this.universalID != null ? Long.valueOf(this.universalID.getValue()) : null;
                ((PackedDBHandle)this.dbHandle).saveAs("Archive", file.getParentFile(), packedDBfile.getName(), uid, monitor);
            }
            initSuccess = true;
        }
        finally {
            if (!initSuccess) {
                this.dbHandle.close();
            }
        }
    }

    private void initPackedDatabase(ResourceFile packedDBfile, int openMode, TaskMonitor monitor) throws CancelledException, IOException {
        try (Transaction tx = this.openTransaction("");){
            this.init(openMode, monitor);
            if (openMode != 0 && this.hasDataOrganizationChange()) {
                this.handleDataOrganizationChange(openMode, monitor);
            }
            if (openMode == 3) {
                this.migrateOldFlexArrayComponentsIfRequired(monitor);
                Msg.showInfo((Object)this, null, (String)"Archive Upgraded", (Object)("Data type archive has been upgraded: " + packedDBfile.getName()));
            }
        }
        catch (VersionException e) {
            if (openMode == 1 && e.isUpgradable()) {
                this.initPackedDatabase(packedDBfile, 3, monitor);
            }
            throw new IOException(e);
        }
    }

    protected DataTypeManagerDB(DBHandle handle, AddressMap addrMap, int openMode, String tablePrefix, ErrorHandler errHandler, Lock lock, TaskMonitor monitor) throws CancelledException, IOException, VersionException {
        this.tablePrefix = tablePrefix != null ? tablePrefix : "";
        this.dbHandle = handle;
        this.readOnlyMode = openMode == 2;
        this.addrMap = addrMap;
        this.errHandler = errHandler;
        this.lock = lock;
        this.init(openMode, monitor);
    }

    private void init(int openMode, TaskMonitor monitor) throws CancelledException, IOException, VersionException {
        this.updateID();
        this.initializeAdapters(openMode, monitor);
        if (this.checkForSourceArchiveUpdatesNeeded(openMode, monitor)) {
            this.doSourceArchiveUpdates(monitor);
        }
        this.dtCache = new DBObjectCache(10);
        this.sourceArchiveDBCache = new DBObjectCache(10);
        this.builtInMap = new HashMap();
        this.builtIn2IdMap = new HashMap();
        this.root = new CategoryDB(this, this.catCache);
        if (this.parentChildAdapter.needsInitializing()) {
            this.initializedParentChildTable();
        }
    }

    private void initializeAdapters(int openMode, TaskMonitor monitor) throws CancelledException, IOException, VersionException {
        this.checkManagerVersion(openMode);
        VersionException versionExc = null;
        try {
            this.callingConventionAdapter = CallingConventionDBAdapter.getAdapter(this.dbHandle, openMode, this.tablePrefix, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        try {
            this.builtinAdapter = BuiltinDBAdapter.getAdapter(this.dbHandle, openMode, this.tablePrefix);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        try {
            this.categoryAdapter = CategoryDBAdapter.getAdapter(this.dbHandle, openMode, this.tablePrefix);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        try {
            this.arrayAdapter = ArrayDBAdapter.getAdapter(this.dbHandle, openMode, this.tablePrefix, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        try {
            this.typedefAdapter = TypedefDBAdapter.getAdapter(this.dbHandle, openMode, this.tablePrefix, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        try {
            this.compositeAdapter = CompositeDBAdapter.getAdapter(this.dbHandle, openMode, this.tablePrefix, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        try {
            this.componentAdapter = ComponentDBAdapter.getAdapter(this.dbHandle, openMode, this.tablePrefix);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        try {
            this.functionDefAdapter = FunctionDefinitionDBAdapter.getAdapter(this.dbHandle, openMode, this.tablePrefix, this.callingConventionAdapter, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        try {
            this.paramAdapter = FunctionParameterAdapter.getAdapter(this.dbHandle, openMode, this.tablePrefix, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        try {
            this.settingsAdapter = SettingsDBAdapter.getAdapter(this.tablePrefix + SETTINGS_TABLE_NAME, this.dbHandle, openMode, null, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        try {
            this.pointerAdapter = PointerDBAdapter.getAdapter(this.dbHandle, openMode, this.tablePrefix, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        try {
            this.enumAdapter = EnumDBAdapter.getAdapter(this.dbHandle, openMode, this.tablePrefix, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        try {
            this.enumValueAdapter = EnumValueDBAdapter.getAdapter(this.dbHandle, openMode, this.tablePrefix, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        try {
            this.parentChildAdapter = ParentChildAdapter.getAdapter(this.dbHandle, openMode, this.tablePrefix);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        try {
            this.sourceArchiveAdapter = SourceArchiveAdapter.getAdapter(this.dbHandle, openMode, this.tablePrefix, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        try {
            this.initializeOtherAdapters(openMode, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        if (versionExc != null) {
            throw versionExc;
        }
        this.updateManagerAndAppVersion(openMode);
    }

    protected void initializeOtherAdapters(int openMode, TaskMonitor monitor) throws CancelledException, IOException, VersionException {
    }

    protected void handleDataOrganizationChange(int openMode, TaskMonitor monitor) throws IOException, LanguageVersionException, CancelledException {
        if (openMode == 1) {
            throw new LanguageVersionException("Data organization change detected", true);
        }
        if (openMode == 3) {
            this.compilerSpecChanged(monitor);
        }
    }

    private void initializedParentChildTable() {
        this.buildSortedDataTypeList();
        for (DataType dt : this.sortedDataTypes) {
            ParameterDefinition[] vars;
            if (dt instanceof Array) {
                ((Array)dt).getDataType().addParent(dt);
                continue;
            }
            if (dt instanceof Pointer) {
                DataType pdt = ((Pointer)dt).getDataType();
                if (pdt == null) continue;
                pdt.addParent(dt);
                continue;
            }
            if (dt instanceof TypeDef) {
                ((TypeDef)dt).getDataType().addParent(dt);
                continue;
            }
            if (dt instanceof Composite) {
                DataTypeComponent[] comps;
                for (DataTypeComponent comp : comps = ((Composite)dt).getDefinedComponents()) {
                    comp.getDataType().addParent(dt);
                }
                continue;
            }
            if (!(dt instanceof FunctionDefinition)) continue;
            FunctionDefinition funDef = (FunctionDefinition)dt;
            DataType retType = funDef.getReturnType();
            if (retType != null) {
                retType.addParent(dt);
            }
            for (ParameterDefinition var : vars = funDef.getArguments()) {
                var.getDataType().addParent(dt);
            }
        }
    }

    private void checkManagerVersion(int openMode) throws IOException, VersionException {
        if (openMode == 0) {
            return;
        }
        DBStringMapAdapter dataMap = this.getDataMap(openMode == 3);
        if (dataMap != null) {
            int dbVersion = dataMap.getInt(DTM_DB_VERSION_KEY, 1);
            if (dbVersion > 2) {
                throw new VersionException(false);
            }
            if (dbVersion < 2 && openMode == 1) {
                throw new VersionException(true);
            }
        } else if (openMode == 1) {
            throw new VersionException(true);
        }
    }

    private void updateManagerAndAppVersion(int openMode) throws IOException {
        if (openMode == 0 || openMode == 3) {
            DBStringMapAdapter dataMap = this.getDataMap(true);
            dataMap.put(DTM_DB_VERSION_KEY, Integer.toString(2));
            dataMap.put(DTM_GHIDRA_VERSION_KEY, Application.getApplicationVersion());
        }
    }

    protected DBStringMapAdapter getDataMap(boolean createIfNeeded) throws IOException {
        boolean exists;
        DBStringMapAdapter dataMap = null;
        boolean bl = exists = this.dbHandle.getTable(MAP_TABLE_NAME) != null;
        if (exists) {
            dataMap = new DBStringMapAdapter(this.dbHandle, MAP_TABLE_NAME, false);
        } else if (createIfNeeded) {
            dataMap = new DBStringMapAdapter(this.dbHandle, MAP_TABLE_NAME, true);
        }
        return dataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean clearSetting(long dataTypeId, String name) {
        this.lock.acquire();
        try {
            this.settingsCache.remove(dataTypeId, name);
            boolean bl = this.settingsAdapter.removeSettingsRecord(dataTypeId, name);
            return bl;
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean clearAllSettings(long dataTypeId) {
        this.lock.acquire();
        try {
            Field[] keys;
            boolean changed = false;
            for (Field key : keys = this.settingsAdapter.getSettingsKeys(dataTypeId)) {
                long settingsId = key.getLongValue();
                DBRecord rec = this.settingsAdapter.getSettingsRecord(settingsId);
                String name = this.settingsAdapter.getSettingName(rec);
                this.settingsAdapter.removeSettingsRecord(settingsId);
                this.settingsCache.remove(dataTypeId, name);
                changed = true;
            }
            boolean bl = changed;
            return bl;
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getSettingsNames(long dataTypeId) {
        this.lock.acquire();
        try {
            String[] stringArray = this.settingsAdapter.getSettingsNames(dataTypeId);
            return stringArray;
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SettingDB getSetting(long dataTypeId, String name) {
        this.lock.acquire();
        try {
            SettingDB setting = this.settingsCache.get(dataTypeId, name);
            if (setting != null) {
                SettingDB settingDB = setting;
                return settingDB;
            }
            DBRecord rec = this.settingsAdapter.getSettingsRecord(dataTypeId, name);
            if (rec != null) {
                setting = new SettingDB(rec, this.settingsAdapter.getSettingName(rec));
                this.settingsCache.put(dataTypeId, name, setting);
                SettingDB settingDB = setting;
                return settingDB;
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateSettingsRecord(long dataTypeId, String name, String strValue, long longValue) {
        this.lock.acquire();
        try {
            DBRecord rec = this.settingsAdapter.updateSettingsRecord(dataTypeId, name, strValue, longValue);
            if (rec != null) {
                Set<String> suggestions;
                SettingDB setting = new SettingDB(rec, this.settingsAdapter.getSettingName(rec));
                this.settingsCache.put(dataTypeId, name, setting);
                if (strValue != null && (suggestions = this.previouslyUsedSettingsValuesMap.get(name)) != null) {
                    suggestions.add(strValue);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return false;
    }

    private Set<String> generateSuggestions(StringSettingsDefinition settingsDefinition) {
        TreeSet<String> set = new TreeSet<String>();
        try {
            this.settingsAdapter.addAllValues(settingsDefinition.getStorageKey(), set);
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getSuggestedValues(StringSettingsDefinition settingsDefinition) {
        if (!settingsDefinition.supportsSuggestedValues()) {
            return Settings.EMPTY_STRING_ARRAY;
        }
        this.lock.acquire();
        try {
            Set previouslyUsedSet = this.previouslyUsedSettingsValuesMap.computeIfAbsent(settingsDefinition.getStorageKey(), n -> this.generateSuggestions(settingsDefinition));
            TreeSet set = new TreeSet(previouslyUsedSet);
            settingsDefinition.addPreferredValues((Object)this, set);
            if (set.isEmpty()) {
                String[] stringArray = Settings.EMPTY_STRING_ARRAY;
                return stringArray;
            }
            String[] stringArray = set.toArray(new String[set.size()]);
            return stringArray;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setProgramArchitecture(ProgramArchitecture programArchitecture, VariableStorageManager variableStorageMgr, boolean store, TaskMonitor monitor) throws IOException, CancelledException {
        this.programArchitecture = programArchitecture;
        this.variableStorageMgr = programArchitecture != null ? variableStorageMgr : null;
        DataOrganization dataOrganization = this.dataOrganization = programArchitecture != null ? programArchitecture.getCompilerSpec().getDataOrganization() : DataOrganizationImpl.getDefaultOrganization();
        if (store) {
            try {
                this.compilerSpecChanged(monitor);
                this.updateLastChangeTime();
            }
            finally {
                this.invalidateCache();
            }
        }
    }

    protected void compilerSpecChanged(TaskMonitor monitor) throws IOException, CancelledException {
        if (this.readOnlyMode) {
            throw new ReadOnlyException();
        }
        boolean hasDataOrgChange = this.hasDataOrganizationChange();
        this.saveDataOrganization();
        if (hasDataOrgChange) {
            this.doCompositeFixup(monitor);
        }
    }

    protected final boolean hasDataOrganizationChange() throws IOException {
        return !Objects.equals(this.readDataOrganization(), this.getDataOrganization());
    }

    protected void saveDataOrganization() throws IOException {
        DataOrganizationImpl.save(this.getDataOrganization(), this.getDataMap(true), "dataOrg.");
    }

    protected DataOrganization readDataOrganization() throws IOException {
        DBStringMapAdapter dataMap = this.getDataMap(false);
        if (dataMap == null) {
            return null;
        }
        DataOrganizationImpl dataOrg = DataOrganizationImpl.restore(dataMap, "dataOrg.");
        if (dataOrg == null) {
            ProgramArchitecture arch = this.getProgramArchitecture();
            return DataOrganizationImpl.getDefaultOrganization(arch != null ? arch.getLanguage() : null);
        }
        return dataOrg;
    }

    @Override
    public ProgramArchitecture getProgramArchitecture() {
        return this.programArchitecture;
    }

    protected static String getProgramArchitectureSummary(LanguageID languageId, int languageVersion, CompilerSpecID compilerSpecId) {
        StringBuilder buf = new StringBuilder();
        buf.append(languageId.getIdAsString());
        buf.append(" / ");
        buf.append(compilerSpecId.getIdAsString());
        return buf.toString();
    }

    @Override
    public String getProgramArchitectureSummary() {
        if (this.programArchitecture != null) {
            return DataTypeManagerDB.getProgramArchitectureSummary(this.programArchitecture.getLanguage().getLanguageID(), this.programArchitecture.getLanguage().getVersion(), this.programArchitecture.getCompilerSpec().getCompilerSpecID());
        }
        return null;
    }

    protected VariableStorageManager getVariableStorageManager() {
        return this.variableStorageMgr;
    }

    protected final boolean isTransactionActive() {
        return this.dbHandle.isTransactionActive();
    }

    protected abstract String getDomainFileID();

    protected abstract String getPath();

    private void buildSortedDataTypeList() {
        if (this.sortedDataTypes != null) {
            return;
        }
        ArrayList<DataType> list = new ArrayList<DataType>();
        this.popuplateDataTypeList(list, this.root);
        Collections.sort(list, this.nameComparator);
        this.sortedDataTypes = list;
    }

    private void buildEnumValueMap() {
        if (this.enumValueMap != null) {
            return;
        }
        HashMap<Long, Set<String>> map = new HashMap<Long, Set<String>>();
        this.populateEnumValueMap(map, this.root);
        this.enumValueMap = map;
    }

    private void removeDataTypeFromSortedList(DataTypePath dataTypePath) {
        if (this.sortedDataTypes == null) {
            return;
        }
        String name = dataTypePath.getDataTypeName();
        TypedefDataType compareDataType = new TypedefDataType(name, DataType.DEFAULT);
        try {
            compareDataType.setCategoryPath(dataTypePath.getCategoryPath());
        }
        catch (DuplicateNameException duplicateNameException) {
            // empty catch block
        }
        int index = Collections.binarySearch(this.sortedDataTypes, compareDataType, this.nameComparator);
        if (index >= 0) {
            this.sortedDataTypes.remove(index);
        }
    }

    private void insertDataTypeIntoSortedList(DataType dataType) {
        if (this.sortedDataTypes == null) {
            return;
        }
        int index = Collections.binarySearch(this.sortedDataTypes, dataType, this.nameComparator);
        if (index < 0) {
            index = -index - 1;
            this.sortedDataTypes.add(index, dataType);
        } else {
            this.sortedDataTypes.set(index, dataType);
        }
    }

    private void popuplateDataTypeList(List<DataType> list, Category category) {
        for (Category childCategory : category.getCategories()) {
            this.popuplateDataTypeList(list, childCategory);
        }
        list.addAll(Arrays.asList(category.getDataTypes()));
    }

    private void populateEnumValueMap(Map<Long, Set<String>> map, Category category) {
        DataType[] dataTypeCollection;
        for (Category childCategory : category.getCategories()) {
            this.populateEnumValueMap(map, childCategory);
        }
        for (DataType type : dataTypeCollection = category.getDataTypes()) {
            long[] values;
            if (!(type instanceof Enum)) continue;
            Enum enumDt = (Enum)type;
            for (long value : values = enumDt.getValues()) {
                Set<String> namesForValue = map.get(value);
                if (namesForValue == null) {
                    namesForValue = new HashSet<String>();
                    map.put(value, namesForValue);
                }
                namesForValue.add(enumDt.getName(value));
            }
        }
    }

    @Override
    public UniversalID getUniversalID() {
        return this.universalID;
    }

    public void updateID() {
        long databaseID = this.dbHandle.getDatabaseId();
        this.universalID = databaseID == 0L ? null : new UniversalID(databaseID);
        this.invalidateSourceArchiveCache();
    }

    @Override
    public List<DataType> getFavorites() {
        this.lock.acquire();
        try {
            ArrayList<DataType> arrayList = new ArrayList<DataType>(this.favoritesList);
            return arrayList;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean isFavorite(DataType dataType) {
        this.lock.acquire();
        try {
            boolean bl = this.favoritesList.contains(dataType);
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFavorite(DataType dataType, boolean isFavorite) {
        if (dataType.getDataTypeManager() != this) {
            throw new IllegalArgumentException("Datatype does not belong to this datatype manager.");
        }
        this.lock.acquire();
        try {
            boolean isInFavorites = this.favoritesList.contains(dataType);
            if (isInFavorites == isFavorite) {
                return;
            }
            if (isFavorite) {
                this.favoritesList.add(dataType);
            } else {
                this.favoritesList.remove(dataType);
            }
            this.favoritesChanged(dataType, isFavorite);
        }
        finally {
            this.lock.release();
        }
    }

    DataTypeConflictHandler.ConflictResult resolveConflict(DataTypeConflictHandler handler, DataType addedDataType, DataType existingDataType) {
        return handler.resolveConflict(addedDataType, existingDataType);
    }

    @Override
    public String getUniqueName(CategoryPath path, String baseName) {
        int pos = baseName.lastIndexOf(95);
        int oneUpNumber = 0;
        Object name = baseName;
        if (pos > 0) {
            String numString = baseName.substring(pos + 1);
            try {
                oneUpNumber = Integer.parseInt(numString);
                name = baseName;
                baseName = baseName.substring(0, pos);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        while (this.getDataType(path, (String)name) != null) {
            name = baseName + "_" + ++oneUpNumber;
        }
        return name;
    }

    String getUniqueName(CategoryPath path1, CategoryPath path2, String baseName) {
        int pos = baseName.lastIndexOf(95);
        int oneUpNumber = 0;
        Object name = baseName;
        if (pos > 0) {
            String numString = baseName.substring(pos + 1);
            try {
                oneUpNumber = Integer.parseInt(numString);
                name = baseName;
                baseName = baseName.substring(0, pos);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        while (this.getDataType(path1, (String)name) != null || this.getDataType(path2, (String)name) != null) {
            name = baseName + "_" + ++oneUpNumber;
        }
        return name;
    }

    @Override
    public Category getCategory(CategoryPath path) {
        if (path == null) {
            return null;
        }
        if (path.equals(CategoryPath.ROOT)) {
            return this.root;
        }
        Category parent = this.getCategory(path.getParent());
        if (parent == null) {
            return null;
        }
        return parent.getCategory(path.getName());
    }

    CategoryDB getCategoryDB(long id) throws IOException {
        DBRecord rec;
        if (id == ROOT_CATEGORY_ID) {
            return this.root;
        }
        CategoryDB cat = this.catCache.get(id);
        if (cat == null && (rec = this.categoryAdapter.getRecord(id)) != null) {
            long parentID = rec.getLongValue(1);
            CategoryDB parent = this.getCategoryDB(parentID);
            String name = rec.getString(0);
            cat = new CategoryDB(this, this.catCache, id, parent, name);
        }
        return cat;
    }

    CategoryDB createCategoryDB(CategoryDB parent, String categoryName) throws IOException {
        CategoryDB c = parent.getCategory(categoryName);
        if (c != null) {
            return c;
        }
        DBRecord rec = this.categoryAdapter.createCategory(categoryName, parent.getKey());
        String name = rec.getString(0);
        CategoryDB cat = new CategoryDB(this, this.catCache, rec.getKey(), parent, name);
        parent.categoryAdded(cat);
        this.categoryCreated(cat);
        return cat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Category getCategory(long id) {
        this.lock.acquire();
        try {
            CategoryDB categoryDB = this.getCategoryDB(id);
            return categoryDB;
        }
        catch (IOException e) {
            this.dbError(e);
            Category category = null;
            return category;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataType resolve(DataType dataType, DataTypeConflictHandler handler) {
        if (dataType == DataType.DEFAULT) {
            return dataType;
        }
        if (dataType instanceof BitFieldDataType) {
            return this.resolveBitFieldDataType((BitFieldDataType)dataType, handler);
        }
        this.lock.acquire();
        DataTypeConflictHandler originalHandler = null;
        boolean isEquivalenceCacheOwner = this.activateEquivalenceCache();
        boolean isResolveCacheOwner = this.activateResolveCache();
        DataType resolvedDataType = null;
        try {
            originalHandler = this.currentHandler;
            if (this.contains(dataType)) {
                DataType dataType2 = dataType;
                return dataType2;
            }
            this.currentHandler = handler != null ? handler : (this.currentHandler == null ? DataTypeConflictHandler.DEFAULT_HANDLER : this.currentHandler.getSubsequentHandler());
            resolvedDataType = this.getCachedResolve(dataType);
            if (resolvedDataType != null) {
                DataType dataType3 = resolvedDataType;
                return dataType3;
            }
            SourceArchive sourceArchive = dataType.getSourceArchive();
            resolvedDataType = sourceArchive != null && sourceArchive.getArchiveType() == ArchiveType.BUILT_IN ? this.resolveBuiltIn(dataType, this.currentHandler) : (sourceArchive == null || dataType.getUniversalID() == null ? this.resolveDataTypeNoSource(dataType, this.currentHandler) : (!sourceArchive.getSourceArchiveID().equals((Object)this.getUniversalID()) && sourceArchive.getArchiveType() == ArchiveType.PROGRAM ? this.resolveDataTypeNoSource(dataType, this.currentHandler) : this.resolveDataTypeWithSource(dataType, this.currentHandler)));
            this.cacheResolvedDataType(dataType, resolvedDataType);
            if (resolvedDataType instanceof DataTypeDB) {
                this.setCachedEquivalence((DataTypeDB)resolvedDataType, dataType);
            }
            DataType dataType4 = resolvedDataType;
            return dataType4;
        }
        finally {
            try {
                if (isResolveCacheOwner) {
                    this.flushResolveQueue(true);
                }
            }
            finally {
                if (isEquivalenceCacheOwner) {
                    this.clearEquivalenceCache();
                }
                this.currentHandler = originalHandler;
                this.lock.release();
            }
        }
    }

    private DataType resolveBuiltIn(DataType dataType, DataTypeConflictHandler handler) {
        if (dataType instanceof Pointer) {
            return this.resolveDataTypeNoSource(dataType, this.currentHandler);
        }
        DataType existingDataType = this.getDataType(dataType.getCategoryPath(), dataType.getName());
        if (existingDataType != null) {
            if (existingDataType.isEquivalent(dataType)) {
                return existingDataType;
            }
            String dtName = this.getUnusedConflictName(dataType);
            try {
                existingDataType.setName(dtName);
            }
            catch (Exception e) {
                throw new AssertException("Failed to rename conflicting datatype: " + existingDataType.getPathName(), (Throwable)e);
            }
        }
        return this.createDataType(dataType, dataType.getName(), BuiltInSourceArchive.INSTANCE, handler);
    }

    private DataType resolveBitFieldDataType(BitFieldDataType bitFieldDataType, DataTypeConflictHandler handler) {
        int storageSize;
        int storageSizeBits;
        DataType baseDt = bitFieldDataType.getBaseDataType();
        DataType resolvedBaseDt = this.resolve(baseDt, handler);
        int baseLength = resolvedBaseDt.getLength();
        int baseLengthBits = 8 * baseLength;
        int bitSize = bitFieldDataType.getDeclaredBitSize();
        int bitOffset = bitFieldDataType.getBitOffset();
        if (bitOffset + bitSize > (storageSizeBits = 8 * (storageSize = bitFieldDataType.getStorageSize()))) {
            int effectiveBitSize = Math.min(bitSize, baseLengthBits);
            bitOffset = this.getDataOrganization().isBigEndian() ? baseLengthBits - effectiveBitSize : 0;
            storageSize = baseLength;
        }
        try {
            return new BitFieldDBDataType(resolvedBaseDt, bitSize, bitOffset);
        }
        catch (InvalidDataTypeException e) {
            throw new AssertException("unexpected", (Throwable)((Object)e));
        }
    }

    private void renameToUnusedConflictName(DataType dataType) {
        String name = this.getUnusedConflictName(dataType);
        try {
            dataType.setName(name);
        }
        catch (InvalidNameException e) {
            throw new AssertException("This should not occur here, all we did is tack more on the end", (Throwable)e);
        }
        catch (DuplicateNameException e) {
            throw new AssertException("This should not occur here, we already looked to see if it existed", (Throwable)e);
        }
    }

    private boolean updateExistingDataType(DataType existingDataType, DataType dataType, SourceArchive sourceArchive) throws DataTypeDependencyException {
        try {
            if (existingDataType instanceof StructureDB) {
                if (!(dataType instanceof StructureInternal)) {
                    return false;
                }
                StructureDB existingStruct = (StructureDB)existingDataType;
                existingStruct.doReplaceWith((StructureInternal)dataType, true);
            } else if (existingDataType instanceof UnionDB) {
                if (!(dataType instanceof UnionInternal)) {
                    return false;
                }
                UnionDB existingUnion = (UnionDB)existingDataType;
                existingUnion.doReplaceWith((UnionInternal)dataType, true);
            } else if (existingDataType instanceof FunctionDefinitionDB) {
                if (!(dataType instanceof FunctionDefinition)) {
                    return false;
                }
                existingDataType.replaceWith(dataType);
            } else if (existingDataType instanceof EnumDB) {
                if (!(dataType instanceof Enum)) {
                    return false;
                }
                existingDataType.replaceWith(dataType);
            } else if (existingDataType instanceof TypedefDB) {
                if (!(dataType instanceof TypeDef)) {
                    return false;
                }
                existingDataType.replaceWith(dataType);
            } else {
                return false;
            }
            if (sourceArchive != null) {
                existingDataType.setSourceArchive(sourceArchive);
                ((DataTypeDB)existingDataType).setUniversalID(dataType.getUniversalID());
                long lastChangeTime = dataType.getLastChangeTime();
                existingDataType.setLastChangeTime(lastChangeTime);
                existingDataType.setLastChangeTimeInSourceArchive(lastChangeTime);
            }
            return true;
        }
        catch (IOException e) {
            this.dbError(e);
            return false;
        }
    }

    public String getUnusedConflictName(DataType dt) {
        String name = dt.getName();
        if (dt instanceof Array || dt instanceof Pointer || dt instanceof BuiltInDataType) {
            return name;
        }
        return this.getUnusedConflictName(dt.getCategoryPath(), name);
    }

    public String getUnusedConflictName(CategoryPath path, String name) {
        int index = name.indexOf(".conflict");
        if (index > 0) {
            name = name.substring(0, index);
        }
        String baseName = name + ".conflict";
        Object testName = name;
        int count = 0;
        while (this.getDataType(path, (String)testName) != null) {
            String countSuffix = "";
            if (count != 0) {
                countSuffix = Integer.toString(count);
            }
            testName = baseName + countSuffix;
            ++count;
        }
        return testName;
    }

    private List<DataType> findDataTypesSameLocation(DataType dataType) {
        Category category = this.getCategory(dataType.getCategoryPath());
        if (category == null) {
            return List.of();
        }
        if (!(dataType instanceof Pointer) && !(dataType instanceof Array)) {
            return category.getDataTypesByBaseName(dataType.getName());
        }
        DataType existingDataType = category.getDataType(dataType.getName());
        DataType baseDataType = DataTypeUtilities.getBaseDataType(dataType);
        if (baseDataType == null) {
            return existingDataType != null ? List.of(existingDataType) : List.of();
        }
        SourceArchive sourceArchive = baseDataType.getSourceArchive();
        if (sourceArchive != null && sourceArchive.getArchiveType() == ArchiveType.BUILT_IN) {
            return existingDataType != null ? List.of(existingDataType) : List.of();
        }
        String baseTypeName = baseDataType.getName();
        String decorations = dataType.getName().substring(baseTypeName.length());
        ArrayList<DataType> list = new ArrayList<DataType>();
        for (DataType existingBaseDt : category.getDataTypesByBaseName(baseTypeName)) {
            String name = existingBaseDt.getName() + decorations;
            DataType dt = category.getDataType(name);
            if (dt == null) continue;
            list.add(dt);
        }
        return list;
    }

    private DataType findEquivalentDataTypeSameLocation(DataType dataType) {
        DataType existingDataType = this.getDataType(dataType.getCategoryPath(), dataType.getName());
        if (existingDataType != null && existingDataType.isEquivalent(dataType)) {
            return existingDataType;
        }
        List<DataType> relatedByName = this.findDataTypesSameLocation(dataType);
        for (DataType candidate : relatedByName) {
            if (candidate == existingDataType || !candidate.isEquivalent(dataType)) continue;
            return candidate;
        }
        return null;
    }

    private DataType findDataTypeSameLocation(DataType dataType) {
        DataType existingDataType = this.getDataType(dataType.getCategoryPath(), dataType.getName());
        if (existingDataType != null && DataTypeUtilities.isSameKindDataType(dataType, existingDataType)) {
            return existingDataType;
        }
        List<DataType> relatedByName = this.findDataTypesSameLocation(dataType);
        for (DataType candidate : relatedByName) {
            if (existingDataType == null) {
                existingDataType = candidate;
            }
            if (!DataTypeUtilities.isSameKindDataType(dataType, candidate)) continue;
            return candidate;
        }
        return existingDataType;
    }

    private DataType resolveDataTypeNoSource(DataType dataType, DataTypeConflictHandler handler) {
        DataType existingDataType = this.findEquivalentDataTypeSameLocation(dataType);
        if (existingDataType != null) {
            return existingDataType;
        }
        return this.resolveNoEquivalentFound(dataType, null, handler);
    }

    private DataType resolveDataTypeWithSource(DataType dataType, DataTypeConflictHandler handler) {
        SourceArchive sourceArchive = dataType.getSourceArchive();
        DataType existingDataType = this.getDataType(sourceArchive, dataType.getUniversalID());
        if (existingDataType != null) {
            if (!existingDataType.isEquivalent(dataType) && handler.shouldUpdate(dataType, existingDataType)) {
                existingDataType.replaceWith(dataType);
                existingDataType.setLastChangeTime(dataType.getLastChangeTime());
            }
            return existingDataType;
        }
        if (sourceArchive.getSourceArchiveID().equals((Object)this.getUniversalID())) {
            return this.createDataType(dataType, sourceArchive, handler);
        }
        existingDataType = this.findEquivalentDataTypeSameLocation(dataType);
        if (existingDataType != null) {
            if (this.isLocalSource(existingDataType)) {
                this.replaceEquivalentLocalWithSourceDataType(dataType, sourceArchive, existingDataType);
            }
            return existingDataType;
        }
        return this.resolveNoEquivalentFound(dataType, sourceArchive, handler);
    }

    private DataType resolveNoEquivalentFound(DataType dataType, SourceArchive sourceArchive, DataTypeConflictHandler handler) {
        DataType existingDataType;
        if (sourceArchive != null && sourceArchive.getArchiveType() == ArchiveType.PROGRAM) {
            sourceArchive = null;
        }
        if ((existingDataType = this.findDataTypeSameLocation(dataType)) == null) {
            return this.createDataType(dataType, sourceArchive, handler);
        }
        DataTypeConflictHandler.ConflictResult result = handler.resolveConflict(dataType, existingDataType);
        switch (result) {
            case REPLACE_EXISTING: {
                try {
                    if (this.updateExistingDataType(existingDataType, dataType, sourceArchive)) {
                        return existingDataType;
                    }
                    this.renameToUnusedConflictName(existingDataType);
                    DataType newDataType = this.createDataType(dataType, dataType.getName(), sourceArchive, handler);
                    try {
                        this.replace(existingDataType, newDataType);
                    }
                    catch (DataTypeDependencyException e) {
                        throw new IllegalArgumentException("Invalid datatype replacement: " + newDataType.getName(), e);
                    }
                    return newDataType;
                }
                catch (DataTypeDependencyException dataTypeDependencyException) {
                    // empty catch block
                }
            }
            case RENAME_AND_ADD: {
                return this.createDataType(dataType, sourceArchive, handler);
            }
        }
        return existingDataType;
    }

    private DataType createDataType(DataType dataType, SourceArchive sourceArchive, DataTypeConflictHandler handler) {
        String dtName = this.getUnusedConflictName(dataType);
        DataType newDataType = this.createDataType(dataType, dtName, sourceArchive, handler);
        DataType existingDataType = this.findEquivalentDataTypeSameLocation(dataType);
        if (existingDataType != null && existingDataType != newDataType) {
            this.removeInternal(newDataType, TaskMonitor.DUMMY);
            return existingDataType;
        }
        return newDataType;
    }

    private void replaceEquivalentLocalWithSourceDataType(DataType dataType, SourceArchive sourceArchive, DataType existingDataType) {
        existingDataType.setSourceArchive(sourceArchive);
        ((DataTypeDB)existingDataType).setUniversalID(dataType.getUniversalID());
        existingDataType.replaceWith(dataType);
        long lastChangeTime = dataType.getLastChangeTime();
        existingDataType.setLastChangeTime(lastChangeTime);
        existingDataType.setLastChangeTimeInSourceArchive(lastChangeTime);
        this.dataTypeChanged(existingDataType, false);
    }

    private boolean isLocalSource(DataType dataType) {
        SourceArchive sourceArchive = dataType.getSourceArchive();
        return sourceArchive.equals(this.getLocalSourceArchive());
    }

    @Override
    public DataType addDataType(DataType originalDataType, DataTypeConflictHandler handler) {
        return this.resolve(originalDataType, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDataTypes(Collection<DataType> dataTypes, DataTypeConflictHandler handler, TaskMonitor monitor) throws CancelledException {
        this.lock.acquire();
        boolean isEquivalenceCacheOwner = this.activateEquivalenceCache();
        boolean isResolveCacheOwner = this.activateResolveCache();
        try {
            monitor.setMessage("Adding datatypes...");
            monitor.setMaximum((long)dataTypes.size());
            monitor.setProgress(0L);
            int i = 0;
            for (DataType dt : dataTypes) {
                monitor.checkCancelled();
                this.resolve(dt, handler);
                if (isResolveCacheOwner) {
                    this.flushResolveQueue(false);
                }
                monitor.setProgress((long)(++i));
            }
        }
        finally {
            if (isResolveCacheOwner) {
                this.flushResolveQueue(true);
            }
            if (isEquivalenceCacheOwner) {
                this.clearEquivalenceCache();
            }
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SourceArchive resolveSourceArchive(SourceArchive sourceArchive) {
        if (sourceArchive == null) {
            return null;
        }
        this.lock.acquire();
        try {
            SourceArchive existingArchive = this.getSourceArchive(sourceArchive.getSourceArchiveID());
            if (existingArchive != null) {
                SourceArchive sourceArchive2 = existingArchive;
                return sourceArchive2;
            }
            DBRecord record = this.sourceArchiveAdapter.createRecord(sourceArchive);
            SourceArchiveDB newSourceArchive = this.getSourceArchiveDB(record);
            this.invalidateSourceArchiveCache();
            this.sourceArchiveAdded(newSourceArchive.getSourceArchiveID());
            SourceArchiveDB sourceArchiveDB = newSourceArchive;
            return sourceArchiveDB;
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    @Override
    public void removeSourceArchive(SourceArchive sourceArchive) {
        this.lock.acquire();
        try {
            UniversalID sourceArchiveID = sourceArchive.getSourceArchiveID();
            if (sourceArchiveID.equals((Object)this.universalID) || sourceArchiveID.equals((Object)LOCAL_ARCHIVE_UNIVERSAL_ID)) {
                throw new IllegalArgumentException("Attempted to delete the local archive!");
            }
            this.disassociateAllDataTypes(sourceArchiveID);
            this.sourceArchiveAdapter.deleteRecord(sourceArchiveID);
            this.sourceArchiveChanged(sourceArchiveID);
            this.invalidateSourceArchiveCache();
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    private void disassociateAllDataTypes(UniversalID sourceArchiveID) {
        ArrayList<DataType> dataTypes = new ArrayList<DataType>();
        this.getAllDataTypes(dataTypes);
        for (DataType dataType : dataTypes) {
            SourceArchive sourceArchive = dataType.getSourceArchive();
            if (sourceArchive == null || !sourceArchive.getSourceArchiveID().equals((Object)sourceArchiveID)) continue;
            this.disassociate(dataType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataType replaceDataType(DataType existingDt, DataType replacementDt, boolean updateCategoryPath) throws DataTypeDependencyException {
        this.lock.acquire();
        try {
            if (replacementDt instanceof Dynamic || replacementDt instanceof FactoryDataType) {
                throw new IllegalArgumentException("Datatype replacment with dynamic or factory type not permitted.");
            }
            if (this.getID(existingDt) < 0L) {
                throw new IllegalArgumentException("Datatype to replace is not contained in this datatype manager.");
            }
            boolean fixupName = false;
            if (!this.contains(replacementDt)) {
                replacementDt = replacementDt.clone(this);
                try {
                    replacementDt.setCategoryPath(existingDt.getCategoryPath());
                }
                catch (DuplicateNameException e) {
                    throw new AssertException();
                }
                if (replacementDt.getName().equals(existingDt.getName())) {
                    fixupName = true;
                }
                replacementDt = this.resolve(replacementDt, null);
            }
            if (existingDt == replacementDt) {
                DataType e = existingDt;
                return e;
            }
            this.replace(existingDt, replacementDt);
            if (fixupName) {
                try {
                    long lastChangeTime = replacementDt.getLastChangeTime();
                    replacementDt.setName(existingDt.getName());
                    replacementDt.setLastChangeTime(lastChangeTime);
                }
                catch (Exception e) {
                    Msg.error((Object)this, (Object)("Unable to set the name to " + existingDt.getName() + "on " + replacementDt + " while replacing the original datatype"), (Throwable)e);
                }
            }
            CategoryPath path = existingDt.getCategoryPath();
            if (updateCategoryPath && !replacementDt.getCategoryPath().equals(path)) {
                try {
                    replacementDt.setCategoryPath(path);
                }
                catch (Exception e) {
                    Msg.error((Object)this, (Object)("Unable to set the CatagoryPath to " + path + "on " + replacementDt + " while replacing the original datatype"), (Throwable)e);
                }
            }
            DataType dataType = replacementDt;
            return dataType;
        }
        finally {
            this.lock.release();
        }
    }

    private void replace(DataType existingDt, DataType replacementDt) throws DataTypeDependencyException {
        if (existingDt == replacementDt) {
            return;
        }
        DataTypePath replacedDtPath = existingDt.getDataTypePath();
        long replacedId = this.getID(existingDt);
        UniversalID id = existingDt.getUniversalID();
        this.idsToDataTypeMap.removeDataType(existingDt.getSourceArchive(), id);
        if (replacementDt.dependsOn(existingDt)) {
            throw new DataTypeDependencyException("Replace failed: " + replacementDt.getDisplayName() + " depends on " + existingDt.getDisplayName());
        }
        this.replaceUsesInOtherDataTypes(existingDt, replacementDt);
        try {
            this.replaceDataTypeIDs(replacedId, this.getID(replacementDt));
            this.parentChildAdapter.removeAllRecordsForParent(replacedId);
        }
        catch (IOException e) {
            this.dbError(e);
        }
        this.deleteDataTypeRecord(replacedId);
        this.dtCache.delete(replacedId);
        this.dataTypeReplaced(replacedId, replacedDtPath, replacementDt);
    }

    private void replaceUsesInOtherDataTypes(DataType existingDt, DataType newDt) {
        if (existingDt instanceof DataTypeDB) {
            for (DataType dt : existingDt.getParents()) {
                dt.dataTypeReplaced(existingDt, newDt);
            }
        } else {
            this.buildSortedDataTypeList();
            for (DataType dt : new ArrayList<DataType>(this.sortedDataTypes)) {
                dt.dataTypeReplaced(existingDt, newDt);
            }
        }
    }

    protected abstract void replaceDataTypeIDs(long var1, long var3);

    public void replaceSourceArchive(SourceArchive oldSourceArchive, SourceArchive newSourceArchive) {
        UniversalID newSourceArchiveID;
        UniversalID oldSourceArchiveID = oldSourceArchive.getSourceArchiveID();
        if (oldSourceArchiveID.equals((Object)(newSourceArchiveID = newSourceArchive.getSourceArchiveID()))) {
            throw new IllegalArgumentException("Cannot replace source archive \"" + oldSourceArchive.getName() + "\" with \"" + newSourceArchive.getName() + "\" in data type archive \"" + this.getName() + "\" since they have the same ID (" + oldSourceArchiveID.getValue() + ").");
        }
        if (this.getSourceArchive(oldSourceArchiveID) == null) {
            throw new IllegalArgumentException("The source archive \"" + oldSourceArchive.getName() + "\" with ID (" + oldSourceArchiveID.getValue() + ") isn't used in data type archive \"" + this.getName() + "\".");
        }
        this.resolveSourceArchive(newSourceArchive);
        Iterator<DataType> allDataTypes = this.getAllDataTypes();
        while (allDataTypes.hasNext()) {
            DataType dt = allDataTypes.next();
            SourceArchive sourceArchive = dt.getSourceArchive();
            if (sourceArchive == null || !oldSourceArchiveID.equals((Object)sourceArchive.getSourceArchiveID())) continue;
            dt.setSourceArchive(newSourceArchive);
        }
        this.removeSourceArchive(oldSourceArchive);
        SourceArchive sourceArchive = this.getSourceArchive(newSourceArchiveID);
        sourceArchive.setLastSyncTime(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void findDataTypes(String name, List<DataType> list) {
        if (name == null || name.length() == 0) {
            return;
        }
        if (name.equals(DataType.DEFAULT.getName())) {
            list.add(DataType.DEFAULT);
            return;
        }
        this.lock.acquire();
        try {
            this.buildSortedDataTypeList();
            TypedefDataType compareDataType = new TypedefDataType(name, DataType.DEFAULT);
            int index = Collections.binarySearch(this.sortedDataTypes, compareDataType, this.nameComparator);
            if (index < 0) {
                index = -index - 1;
            }
            while (index < this.sortedDataTypes.size()) {
                DataType dt = this.sortedDataTypes.get(index);
                if (!name.equals(dt.getName())) {
                    break;
                }
                list.add(dt);
                ++index;
            }
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void findDataTypes(String name, List<DataType> list, boolean caseSensitive, TaskMonitor monitor) {
        if (name == null || name.length() == 0) {
            return;
        }
        if (name.equals(DataType.DEFAULT.getName())) {
            list.add(DataType.DEFAULT);
            return;
        }
        if (monitor == null) {
            monitor = TaskMonitor.DUMMY;
        }
        Pattern regexp = UserSearchUtils.createSearchPattern((String)name, (boolean)caseSensitive);
        this.lock.acquire();
        try {
            this.buildSortedDataTypeList();
            for (DataType dt : this.sortedDataTypes) {
                if (monitor.isCancelled()) {
                    return;
                }
                Matcher matcher = regexp.matcher(dt.getName());
                if (!matcher.matches()) continue;
                list.add(dt);
            }
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public DataType getDataType(DataTypePath dataTypePath) {
        Category cat = this.getCategory(dataTypePath.getCategoryPath());
        if (cat != null) {
            return cat.getDataType(dataTypePath.getDataTypeName());
        }
        return null;
    }

    @Override
    public DataType getDataType(String dataTypePath) {
        String name = this.getName();
        int nameLen = name.length();
        if (dataTypePath.length() > nameLen && dataTypePath.charAt(nameLen) == '/' && dataTypePath.startsWith(name)) {
            dataTypePath = dataTypePath.substring(nameLen);
        } else if (!dataTypePath.startsWith("/")) {
            return null;
        }
        CategoryPath parsedPath = new CategoryPath(dataTypePath);
        CategoryPath categoryPath = parsedPath.getParent();
        String dataTypeName = parsedPath.getName();
        Category category = this.getCategory(categoryPath);
        if (category == null) {
            return null;
        }
        return category.getDataType(dataTypeName);
    }

    @Override
    public DataType findDataType(String dataTypePath) {
        return this.getDataType(dataTypePath);
    }

    @Override
    public void findEnumValueNames(long value, Set<String> enumValueNames) {
        this.buildEnumValueMap();
        Set<String> names = this.enumValueMap.get(value);
        if (names != null) {
            enumValueNames.addAll(names);
        }
    }

    @Override
    public long getResolvedID(DataType dt) {
        if (dt == null) {
            return -1L;
        }
        if (dt == DataType.DEFAULT) {
            return 0L;
        }
        if (dt instanceof BadDataType) {
            return -2L;
        }
        dt = this.resolve(dt, this.currentHandler);
        return this.getID(dt);
    }

    DataTypeConflictHandler getDependencyConflictHandler() {
        if (this.currentHandler == null) {
            return DataTypeConflictHandler.DEFAULT_HANDLER;
        }
        return this.currentHandler.getSubsequentHandler();
    }

    @Override
    public long getID(DataType dt) {
        if (dt == null) {
            return -1L;
        }
        if (dt == DataType.DEFAULT) {
            return 0L;
        }
        if (dt instanceof BitFieldDataType) {
            return DataTypeManagerDB.createKey(9, BitFieldDBDataType.getId((BitFieldDataType)dt));
        }
        if (dt instanceof BadDataType) {
            return -2L;
        }
        if (dt instanceof DataTypeDB) {
            DataTypeDB dtDb = (DataTypeDB)dt;
            if (dtDb.isDeleted()) {
                return -2L;
            }
            return dtDb.getKey();
        }
        Long l = this.builtIn2IdMap.get(dt);
        if (l == null) {
            return -1L;
        }
        return l;
    }

    @Override
    public DataType getDataType(long dataTypeID) {
        if (dataTypeID == -1L) {
            return null;
        }
        if (dataTypeID == 0L) {
            return DataType.DEFAULT;
        }
        if (dataTypeID == -2L) {
            return BadDataType.dataType;
        }
        return this.getDataType(dataTypeID, null);
    }

    @Override
    public void addInvalidatedListener(InvalidatedListener listener) {
        this.invalidatedListeners.add(listener);
    }

    @Override
    public void removeInvalidatedListener(InvalidatedListener listener) {
        this.invalidatedListeners.remove(listener);
    }

    private void fireInvalidated() {
        for (InvalidatedListener listener : this.invalidatedListeners) {
            listener.dataTypeManagerInvalidated(this);
        }
    }

    private boolean removeInternal(DataType dataType, TaskMonitor monitor) {
        if (!this.contains(dataType)) {
            return false;
        }
        LinkedList<Long> deletedIds = new LinkedList<Long>();
        long id = this.getID(dataType);
        if (id < 0L) {
            return false;
        }
        this.idsToDelete.add(id);
        while (!this.idsToDelete.isEmpty()) {
            Long l = this.idsToDelete.removeFirst();
            id = l;
            this.removeUseOfDataType(id);
            deletedIds.addFirst(l);
        }
        for (Long l : deletedIds) {
            this.deleteDataType(l);
        }
        try {
            this.deleteDataTypeIDs(deletedIds, monitor);
        }
        catch (CancelledException e) {
            return false;
        }
        return true;
    }

    private void removeUseOfDataType(long id) {
        if (this.isBulkRemoving) {
            throw new IllegalStateException("Cannot remove data types with a bulk remove operation in place");
        }
        this.isBulkRemoving = true;
        try {
            this.notifyDeleted(id);
        }
        finally {
            this.isBulkRemoving = false;
        }
        this.removeAllParentChildRecordsForChild(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(DataType dataType, TaskMonitor monitor) {
        this.lock.acquire();
        try {
            boolean bl = this.removeInternal(dataType, monitor);
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void associateDataTypeWithArchive(DataType datatype, SourceArchive archive) {
        if (!this.contains(datatype)) {
            throw new IllegalArgumentException("The given datatype must exist in this DataTypeManager");
        }
        if (!datatype.getSourceArchive().equals(this.getLocalSourceArchive())) {
            return;
        }
        if (datatype.getSourceArchive().equals(archive)) {
            return;
        }
        this.resolveSourceArchive(archive);
        Collection<DataType> datatypes = DataTypeUtilities.getContainedDataTypes(datatype);
        datatypes = this.filterOutNonSourceSettableDataTypes(datatypes);
        for (DataType dt : datatypes) {
            dt.setSourceArchive(archive);
            long timeNow = System.currentTimeMillis();
            dt.setLastChangeTime(timeNow);
            dt.setLastChangeTimeInSourceArchive(timeNow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disassociate(DataType dataType) {
        this.lock.acquire();
        try {
            UniversalID id;
            UniversalID oldDtID = dataType.getUniversalID();
            SourceArchive sourceArchive = dataType.getSourceArchive();
            sourceArchive = this.resolveSourceArchive(sourceArchive);
            UniversalID universalID = id = sourceArchive == null ? DataTypeManager.LOCAL_ARCHIVE_UNIVERSAL_ID : sourceArchive.getSourceArchiveID();
            if (id.equals((Object)this.getUniversalID())) {
                id = DataTypeManager.LOCAL_ARCHIVE_UNIVERSAL_ID;
            }
            if (id == DataTypeManager.LOCAL_ARCHIVE_UNIVERSAL_ID) {
                return;
            }
            dataType.setSourceArchive(null);
            if (dataType instanceof DataTypeDB) {
                DataTypeDB dt = (DataTypeDB)dataType;
                dt.setUniversalID(UniversalIdGenerator.nextID());
            }
            if (oldDtID != null) {
                this.idsToDataTypeMap.removeDataType(sourceArchive, oldDtID);
            }
            this.dataTypeChanged(dataType, false);
        }
        finally {
            this.lock.release();
        }
    }

    private Collection<DataType> filterOutNonSourceSettableDataTypes(Collection<DataType> datatypes) {
        ArrayList<DataType> filteredList = new ArrayList<DataType>();
        for (DataType dataType : datatypes) {
            if (!this.isSourceSettable(dataType)) continue;
            filteredList.add(dataType);
        }
        return filteredList;
    }

    private boolean isSourceSettable(DataType dataType) {
        if (!(dataType instanceof DataTypeDB)) {
            return false;
        }
        SourceArchive sourceArchive = dataType.getSourceArchive();
        DataTypeManager dtm = dataType.getDataTypeManager();
        if (sourceArchive == null || dtm == null) {
            return false;
        }
        return sourceArchive.equals(dtm.getLocalSourceArchive());
    }

    protected void addDataTypeToDelete(long id) {
        this.idsToDelete.add(id);
    }

    protected abstract void deleteDataTypeIDs(LinkedList<Long> var1, TaskMonitor var2) throws CancelledException;

    private void notifyDeleted(long dataTypeID) {
        DataType dataType = this.getDataType(dataTypeID);
        if (dataType == null) {
            return;
        }
        if (dataType instanceof DataTypeDB) {
            DataTypeDB dt = (DataTypeDB)dataType;
            dt.notifyDeleted();
        } else {
            this.buildSortedDataTypeList();
            ArrayList<DataType> sortedDataTypesCopy = new ArrayList<DataType>(this.sortedDataTypes);
            for (DataType dt : sortedDataTypesCopy) {
                dt.dataTypeDeleted(dataType);
            }
        }
    }

    private void deleteDataType(long dataTypeID) {
        DataType dataType = this.getDataType(dataTypeID);
        if (dataType == null) {
            return;
        }
        UniversalID id = dataType.getUniversalID();
        if (id != null) {
            this.idsToDataTypeMap.removeDataType(dataType.getSourceArchive(), id);
        }
        this.deleteDataTypeRecord(dataTypeID);
        try {
            this.parentChildAdapter.removeAllRecordsForParent(dataTypeID);
        }
        catch (IOException e) {
            this.dbError(e);
        }
        this.dtCache.delete(dataTypeID);
        this.favoritesList.remove(dataType);
        DataTypePath deletedDtPath = dataType.getDataTypePath();
        this.dataTypeDeleted(dataTypeID, deletedDtPath);
    }

    private void deleteDataTypeRecord(long dataTypeID) {
        int tableID = DataTypeManagerDB.getTableID(dataTypeID);
        try {
            DataType dt = null;
            switch (tableID) {
                case 0: {
                    boolean status = this.builtinAdapter.removeRecord(dataTypeID);
                    if (!status) break;
                    dt = this.builtInMap.remove(dataTypeID);
                    this.builtIn2IdMap.remove(dt);
                    break;
                }
                case 1: {
                    this.removeComponents(dataTypeID);
                    boolean status = this.compositeAdapter.removeRecord(dataTypeID);
                    break;
                }
                case 2: {
                    boolean status = this.componentAdapter.removeRecord(dataTypeID);
                    break;
                }
                case 5: {
                    boolean status = this.typedefAdapter.removeRecord(dataTypeID);
                    break;
                }
                case 3: {
                    boolean status = this.arrayAdapter.removeRecord(dataTypeID);
                    break;
                }
                case 4: {
                    boolean status = this.pointerAdapter.removeRecord(dataTypeID);
                    break;
                }
                case 6: {
                    this.removeParameters(dataTypeID);
                    boolean status = this.functionDefAdapter.removeRecord(dataTypeID);
                    break;
                }
                case 7: {
                    boolean status = this.paramAdapter.removeRecord(dataTypeID);
                    break;
                }
                case 8: {
                    boolean bl = this.enumAdapter.removeRecord(dataTypeID);
                }
            }
            this.settingsAdapter.removeAllSettingsRecords(dataTypeID);
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
    }

    private void removeParameters(long parentID) throws IOException {
        Field[] paramIDs;
        for (Field paramID : paramIDs = this.paramAdapter.getParameterIdsInFunctionDef(parentID)) {
            this.deleteDataTypeRecord(paramID.getLongValue());
        }
    }

    private void removeComponents(long parentID) throws IOException {
        Field[] componentIDs;
        for (Field componentID : componentIDs = this.componentAdapter.getComponentIdsInComposite(parentID)) {
            this.deleteDataTypeRecord(componentID.getLongValue());
        }
    }

    @Override
    public boolean contains(DataType dataType) {
        if (dataType == null) {
            return false;
        }
        if (dataType.getDataTypeManager() != this) {
            return false;
        }
        if (dataType instanceof DataTypeDB) {
            DataTypeDB dtDb = (DataTypeDB)dataType;
            return this.dtCache.get(dtDb.getKey()) == dataType && !dtDb.isDeleted();
        }
        return this.builtIn2IdMap.containsKey(dataType);
    }

    @Override
    public boolean containsCategory(CategoryPath path) {
        return this.getCategory(path) != null;
    }

    @Override
    public Category createCategory(CategoryPath path) {
        this.lock.acquire();
        try {
            Category cat = this.getCategory(path);
            if (cat != null) {
                Category category = cat;
                return category;
            }
            CategoryPath parentPath = path.getParent();
            Category parentCat = this.getCategory(parentPath);
            if (parentCat == null) {
                parentCat = this.createCategory(parentPath);
            }
            Category category = parentCat.createCategory(path.getName());
            return category;
        }
        catch (InvalidNameException e) {
            throw new AssertException("Got invalid name exception here, but should be impossible.");
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Category getRootCategory() {
        return this.root;
    }

    public DataType[] getDataTypes(CategoryPath path) {
        Category cat = this.getCategory(path);
        if (cat != null) {
            return cat.getDataTypes();
        }
        return new DataType[0];
    }

    @Override
    public DataType getDataType(CategoryPath path, String name) {
        if (CategoryPath.ROOT.equals(path) && name.equals(DataType.DEFAULT.getName())) {
            return DataType.DEFAULT;
        }
        Category category = this.getCategory(path);
        if (category != null) {
            return category.getDataType(name);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<DataType> getDataTypesInCategory(long categoryID) {
        this.lock.acquire();
        ArrayList<DataType> list = new ArrayList<DataType>();
        try {
            Field[] ids = this.builtinAdapter.getRecordIdsInCategory(categoryID);
            this.getDataTypes(ids, list);
            ids = this.typedefAdapter.getRecordIdsInCategory(categoryID);
            this.getDataTypes(ids, list);
            ids = this.compositeAdapter.getRecordIdsInCategory(categoryID);
            this.getDataTypes(ids, list);
            ids = this.functionDefAdapter.getRecordIdsInCategory(categoryID);
            this.getDataTypes(ids, list);
            ids = this.enumAdapter.getRecordIdsInCategory(categoryID);
            this.getDataTypes(ids, list);
            ids = this.pointerAdapter.getRecordIdsInCategory(categoryID);
            this.getDataTypes(ids, list);
            ids = this.arrayAdapter.getRecordIdsInCategory(categoryID);
            this.getDataTypes(ids, list);
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return list;
    }

    @Override
    public int getCategoryCount() {
        return this.categoryAdapter.getRecordCount() + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDataTypeCount(boolean includePointersAndArrays) {
        this.lock.acquire();
        try {
            this.buildSortedDataTypeList();
            int count = this.sortedDataTypes.size();
            if (includePointersAndArrays) {
                int n = count;
                return n;
            }
            for (DataType dt : this.sortedDataTypes) {
                if (!(dt instanceof Pointer) && !(dt instanceof Array)) continue;
                --count;
            }
            int n = count;
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    private void getDataTypes(Field[] ids, ArrayList<DataType> list) {
        for (Field id : ids) {
            DataType dt = this.getDataType(id.getLongValue());
            if (dt == null) {
                throw new AssertException("Could not find data type id: " + id);
            }
            list.add(dt);
        }
    }

    static int getTableID(long dataID) {
        return (int)(dataID >> 56);
    }

    private DataType getDataType(long dataTypeID, DBRecord record) {
        int tableId = DataTypeManagerDB.getTableID(dataTypeID);
        DataType dt = null;
        switch (tableId) {
            case 0: {
                dt = this.getBuiltInDataType(dataTypeID, record);
                break;
            }
            case 1: {
                dt = this.getCompositeDataType(dataTypeID, record);
                break;
            }
            case 3: {
                dt = this.getArrayDataType(dataTypeID, record);
                break;
            }
            case 4: {
                dt = this.getPointerDataType(dataTypeID, record);
                break;
            }
            case 5: {
                dt = this.getTypedefDataType(dataTypeID, record);
                break;
            }
            case 6: {
                dt = this.getFunctionDefDataType(dataTypeID, record);
                break;
            }
            case 8: {
                dt = this.getEnumDataType(dataTypeID, record);
                break;
            }
            case 9: {
                dt = BitFieldDBDataType.getBitFieldDataType(dataTypeID, this);
                break;
            }
            default: {
                return null;
            }
        }
        return dt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataType getBuiltInDataType(long dataTypeID, DBRecord record) {
        this.lock.acquire();
        try {
            BuiltInDataType builtInDt;
            String name;
            String classPath;
            CategoryPath catPath;
            DataType dt;
            block21: {
                DataType datatype;
                Class<?> c;
                dt = this.builtInMap.get(dataTypeID);
                if (dt != null) {
                    DataType dataType = dt;
                    return dataType;
                }
                if (record == null && (record = this.builtinAdapter.getRecord(dataTypeID)) == null) {
                    DataType dataType = null;
                    return dataType;
                }
                long catID = record.getLongValue(2);
                CategoryDB catDB = this.getCategoryDB(catID);
                catPath = catDB.getCategoryPath();
                classPath = record.getString(1);
                name = record.getString(0);
                try {
                    c = Class.forName(classPath);
                }
                catch (ClassNotFoundException | NoClassDefFoundError e) {
                    String newClassPath = ClassTranslator.get((String)classPath);
                    if (newClassPath == null) {
                        throw e;
                    }
                    c = Class.forName(newClassPath);
                }
                BuiltInDataType bdt = (BuiltInDataType)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                bdt.setName(name);
                bdt.setCategoryPath(catPath);
                builtInDt = (BuiltInDataType)bdt.clone(this);
                Long id = this.builtIn2IdMap.get(builtInDt);
                if (id == null || (datatype = this.builtInMap.get(id)) == null) break block21;
                this.builtInMap.put(dataTypeID, datatype);
                DataType dataType = datatype;
                return dataType;
            }
            try {
                if (this.allowsDefaultBuiltInSettings() && builtInDt.getSettingsDefinitions().length != 0) {
                    DataTypeSettingsDB settings = new DataTypeSettingsDB(this, builtInDt, dataTypeID);
                    if (builtInDt instanceof TypeDef) {
                        Settings typedefSettings = builtInDt.getDefaultSettings();
                        for (String n2 : typedefSettings.getNames()) {
                            settings.setValue(n2, typedefSettings.getValue(n2));
                        }
                    }
                    settings.setAllowedSettingPredicate((com.google.common.base.Predicate<String>)((com.google.common.base.Predicate)n -> this.isBuiltInSettingAllowed(builtInDt, (String)n)));
                    builtInDt.setDefaultSettings(settings);
                }
                dt = builtInDt;
            }
            catch (Exception e) {
                Msg.error((Object)this, (Object)e);
                dt = new MissingBuiltInDataType(catPath, name, classPath, this);
            }
            this.builtInMap.put(dataTypeID, dt);
            this.builtIn2IdMap.put(dt, dataTypeID);
            DataType dataType = dt;
            return dataType;
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    private boolean isBuiltInSettingAllowed(BuiltInDataType bdt, String settingName) {
        SettingsDefinition def = null;
        for (SettingsDefinition sd : bdt.getSettingsDefinitions()) {
            if (!sd.getStorageKey().equals(settingName)) continue;
            def = sd;
            break;
        }
        return def != null && !(def instanceof TypeDefSettingsDefinition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Enum getEnumDataType(long dataTypeID, DBRecord record) {
        this.lock.acquire();
        try {
            EnumDB enu = (EnumDB)this.dtCache.get(dataTypeID);
            if (enu == null) {
                if (record == null) {
                    record = this.enumAdapter.getRecord(dataTypeID);
                }
                if (record != null) {
                    enu = new EnumDB(this, this.dtCache, this.enumAdapter, this.enumValueAdapter, record);
                }
            }
            EnumDB enumDB = enu;
            return enumDB;
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Composite getCompositeDataType(long dataTypeID, DBRecord record) {
        this.lock.acquire();
        try {
            CompositeDB comp = (CompositeDB)this.dtCache.get(dataTypeID);
            if (comp == null) {
                if (record == null) {
                    record = this.compositeAdapter.getRecord(dataTypeID);
                }
                if (record != null) {
                    comp = record.getBooleanValue(2) ? new UnionDB(this, this.dtCache, this.compositeAdapter, this.componentAdapter, record) : new StructureDB(this, this.dtCache, this.compositeAdapter, this.componentAdapter, record);
                }
            }
            CompositeDB compositeDB = comp;
            return compositeDB;
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TypeDef getTypedefDataType(long dataTypeID, DBRecord record) {
        this.lock.acquire();
        try {
            TypedefDB typeDB = (TypedefDB)this.dtCache.get(dataTypeID);
            if (typeDB == null) {
                if (record == null) {
                    record = this.typedefAdapter.getRecord(dataTypeID);
                }
                if (record != null) {
                    typeDB = new TypedefDB(this, this.dtCache, this.typedefAdapter, record);
                }
            }
            TypedefDB typedefDB = typeDB;
            return typedefDB;
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Array getArrayDataType(long dataTypeID, DBRecord record) {
        this.lock.acquire();
        try {
            ArrayDB arrayDB = (ArrayDB)this.dtCache.get(dataTypeID);
            if (arrayDB == null) {
                if (record == null) {
                    record = this.arrayAdapter.getRecord(dataTypeID);
                }
                if (record != null) {
                    arrayDB = new ArrayDB(this, this.dtCache, this.arrayAdapter, record);
                }
            }
            ArrayDB arrayDB2 = arrayDB;
            return arrayDB2;
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pointer getPointerDataType(long dataTypeID, DBRecord record) {
        this.lock.acquire();
        try {
            PointerDB ptrDB = (PointerDB)this.dtCache.get(dataTypeID);
            if (ptrDB == null) {
                if (record == null) {
                    record = this.pointerAdapter.getRecord(dataTypeID);
                }
                if (record != null) {
                    ptrDB = new PointerDB(this, this.dtCache, this.pointerAdapter, record);
                }
            }
            PointerDB pointerDB = ptrDB;
            return pointerDB;
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FunctionDefinition getFunctionDefDataType(long dataTypeID, DBRecord record) {
        this.lock.acquire();
        try {
            FunctionDefinitionDB funDef = (FunctionDefinitionDB)this.dtCache.get(dataTypeID);
            if (funDef == null) {
                if (record == null) {
                    record = this.functionDefAdapter.getRecord(dataTypeID);
                }
                if (record != null) {
                    funDef = new FunctionDefinitionDB(this, this.dtCache, this.functionDefAdapter, this.paramAdapter, record);
                }
            }
            FunctionDefinitionDB functionDefinitionDB = funDef;
            return functionDefinitionDB;
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    private DataType createDataType(DataType dt, String name, SourceArchive sourceArchive, DataTypeConflictHandler handler) {
        try {
            this.resolveSourceArchive(sourceArchive);
            CategoryPath cp = dt.getCategoryPath();
            CategoryDB cat = (CategoryDB)this.createCategory(cp);
            UniversalID id = dt.getUniversalID();
            long sourceArchiveIdValue = 0L;
            if (sourceArchive == null) {
                id = UniversalIdGenerator.nextID();
            } else if (!sourceArchive.getSourceArchiveID().equals((Object)this.getUniversalID())) {
                sourceArchiveIdValue = sourceArchive.getSourceArchiveID().getValue();
            }
            DataType newDataType = null;
            if (dt instanceof Array) {
                Array array = (Array)dt;
                newDataType = this.createArray(array.getDataType(), array.getNumElements(), array.getElementLength(), cat, handler);
            } else if (dt instanceof Pointer) {
                Pointer ptr = (Pointer)dt;
                int len = ptr.hasLanguageDependantLength() ? -1 : ptr.getLength();
                newDataType = this.createPointer(ptr.getDataType(), cat, (byte)len, handler);
            } else if (dt instanceof BuiltInDataType) {
                BuiltInDataType builtInDataType = (BuiltInDataType)dt;
                newDataType = this.createBuiltIn(builtInDataType, cat);
            } else if (dt instanceof StructureInternal) {
                StructureInternal structure = (StructureInternal)dt;
                newDataType = this.createStructure(structure, name, cat, sourceArchiveIdValue, id.getValue());
            } else if (dt instanceof TypeDef) {
                TypeDef typedef = (TypeDef)dt;
                newDataType = this.createTypeDef(typedef, name, cat, sourceArchiveIdValue, id.getValue());
            } else if (dt instanceof UnionInternal) {
                UnionInternal union = (UnionInternal)dt;
                newDataType = this.createUnion(union, name, cat, sourceArchiveIdValue, id.getValue());
            } else if (dt instanceof Enum) {
                Enum enumm = (Enum)dt;
                newDataType = this.createEnum(enumm, name, cat, sourceArchiveIdValue, id.getValue());
            } else if (dt instanceof FunctionDefinition) {
                FunctionDefinition funDef = (FunctionDefinition)dt;
                newDataType = this.createFunctionDefinition(funDef, name, cat, sourceArchiveIdValue, id.getValue());
            } else if (dt instanceof MissingBuiltInDataType) {
                MissingBuiltInDataType missingBuiltInDataType = (MissingBuiltInDataType)dt;
                newDataType = this.createMissingBuiltIn(missingBuiltInDataType, cat);
            } else {
                throw new AssertException("Unknown data Type:" + dt.getDisplayName());
            }
            this.dataTypeAdded(newDataType, dt);
            return newDataType;
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
            return null;
        }
    }

    private Structure createStructure(StructureInternal struct, String name, CategoryDB category, long sourceArchiveIdValue, long universalIdValue) throws IOException {
        try {
            if (name == null || name.length() == 0) {
                throw new IllegalArgumentException("Data type must have a valid name");
            }
            ++this.creatingDataType;
            int len = struct.getLength();
            if (struct.isZeroLength() || struct.isPackingEnabled()) {
                len = 0;
            }
            DBRecord record = this.compositeAdapter.createRecord(name, struct.getDescription(), false, category.getID(), len, -1, sourceArchiveIdValue, universalIdValue, struct.getLastChangeTime(), struct.getStoredPackingValue(), struct.getStoredMinimumAlignment());
            StructureDB structDB = new StructureDB(this, this.dtCache, this.compositeAdapter, this.componentAdapter, record);
            category.dataTypeAdded(structDB);
            structDB.doReplaceWith(struct, false);
            structDB.setDescription(struct.getDescription());
            structDB.setLastChangeTime(struct.getLastChangeTime());
            StructureDB structureDB = structDB;
            return structureDB;
        }
        catch (DataTypeDependencyException e) {
            throw new IllegalArgumentException("Invalid structure: " + struct.getName(), e);
        }
        finally {
            --this.creatingDataType;
        }
    }

    public boolean isChanged() {
        return this.dbHandle.isChanged();
    }

    private TypeDef createTypeDef(TypeDef typedef, String name, Category cat, long sourceArchiveIdValue, long universalIdValue) throws IOException {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Data type must have a valid name");
        }
        DataType dataType = this.resolve(typedef.getDataType(), this.getDependencyConflictHandler());
        boolean isAutoNamed = typedef.isAutoNamed();
        short flags = 0;
        if (isAutoNamed) {
            flags = 1;
            cat = this.getCategory(dataType.getCategoryPath());
        }
        DBRecord record = this.typedefAdapter.createRecord(this.getID(dataType), name, flags, cat.getID(), sourceArchiveIdValue, universalIdValue, typedef.getLastChangeTime());
        TypedefDB typedefDB = new TypedefDB(this, this.dtCache, this.typedefAdapter, record);
        DataTypeSettingsDB settings = (DataTypeSettingsDB)typedefDB.getDefaultSettings();
        boolean wasLocked = settings.setLock(false);
        TypedefDataType.copyTypeDefSettings(typedef, typedefDB, false);
        settings.setLock(wasLocked);
        typedefDB.updateAutoName(false);
        dataType.addParent(typedefDB);
        return typedefDB;
    }

    private Union createUnion(UnionInternal union, String name, CategoryDB category, long sourceArchiveIdValue, long universalIdValue) throws IOException {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Data type must have a valid name");
        }
        try {
            ++this.creatingDataType;
            DBRecord record = this.compositeAdapter.createRecord(name, null, true, category.getID(), 0, -1, sourceArchiveIdValue, universalIdValue, union.getLastChangeTime(), union.getStoredPackingValue(), union.getStoredMinimumAlignment());
            UnionDB unionDB = new UnionDB(this, this.dtCache, this.compositeAdapter, this.componentAdapter, record);
            category.dataTypeAdded(unionDB);
            unionDB.doReplaceWith(union, false);
            unionDB.setDescription(union.getDescription());
            unionDB.setLastChangeTime(union.getLastChangeTime());
            UnionDB unionDB2 = unionDB;
            return unionDB2;
        }
        catch (DataTypeDependencyException e) {
            throw new IllegalArgumentException("Invalid union: " + union.getName(), e);
        }
        finally {
            --this.creatingDataType;
        }
    }

    private Enum createEnum(Enum enumm, String name, Category cat, long sourceArchiveIdValue, long universalIdValue) throws IOException {
        String[] enumNames;
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Data type must have a valid name");
        }
        DBRecord record = this.enumAdapter.createRecord(name, enumm.getDescription(), cat.getID(), (byte)enumm.getLength(), sourceArchiveIdValue, universalIdValue, enumm.getLastChangeTime());
        long enumID = record.getKey();
        for (String enumName : enumNames = enumm.getNames()) {
            this.enumValueAdapter.createRecord(enumID, enumName, enumm.getValue(enumName), enumm.getComment(enumName));
        }
        EnumDB enumDB = new EnumDB(this, this.dtCache, this.enumAdapter, this.enumValueAdapter, record);
        return enumDB;
    }

    private Pointer createPointer(DataType dt, Category cat, byte length, DataTypeConflictHandler handler) throws IOException {
        if (dt != null) {
            dt = this.resolve(dt, handler);
        }
        long dataTypeID = this.getResolvedID(dt);
        DBRecord record = this.pointerAdapter.createRecord(dataTypeID, cat.getID(), length);
        PointerDB ptrDB = new PointerDB(this, this.dtCache, this.pointerAdapter, record);
        if (dt != null) {
            dt.addParent(ptrDB);
        }
        return ptrDB;
    }

    private Array createArray(DataType dt, int numElements, int elementLength, Category cat, DataTypeConflictHandler handler) throws IOException {
        dt = this.resolve(dt, handler);
        long dataTypeID = this.getResolvedID(dt);
        if (!(dt instanceof Dynamic)) {
            elementLength = -1;
        }
        new ArrayDataType(dt, numElements, elementLength, this);
        DBRecord record = this.arrayAdapter.createRecord(dataTypeID, numElements, elementLength, cat.getID());
        this.addParentChildRecord(record.getKey(), dataTypeID);
        ArrayDB arrayDB = new ArrayDB(this, this.dtCache, this.arrayAdapter, record);
        dt.addParent(arrayDB);
        return arrayDB;
    }

    protected void updateLastChangeTime() {
        SourceArchive mySourceArchive = this.getSourceArchive(this.getUniversalID());
        if (mySourceArchive == null) {
            return;
        }
        mySourceArchive.setLastSyncTime(System.currentTimeMillis());
    }

    private void setDirtyFlag(DataType dt) {
        SourceArchive sourceArchive = dt.getSourceArchive();
        if (sourceArchive == null) {
            return;
        }
        sourceArchive.setDirtyFlag(true);
    }

    @Override
    public List<SourceArchive> getSourceArchives() {
        Collection<SourceArchive> values = this.getSourceArchivesFromCache();
        ArrayList<SourceArchive> sourceArchives = new ArrayList<SourceArchive>();
        for (SourceArchive sourceArchive : values) {
            if (!this.isOtherAndNotBuiltIn(sourceArchive)) continue;
            sourceArchives.add(sourceArchive);
        }
        return sourceArchives;
    }

    private boolean isOtherAndNotBuiltIn(SourceArchive sourceArchive) {
        if (sourceArchive.getSourceArchiveID() == LOCAL_ARCHIVE_UNIVERSAL_ID) {
            return false;
        }
        if (sourceArchive.getSourceArchiveID() == this.universalID) {
            return false;
        }
        return sourceArchive.getSourceArchiveID() != BUILT_IN_ARCHIVE_UNIVERSAL_ID;
    }

    public SourceArchive getSourceArchive(String fileID) {
        for (SourceArchive archive : this.getSourceArchivesFromCache()) {
            if (!fileID.equals(archive.getDomainFileID())) continue;
            return archive;
        }
        return null;
    }

    @Override
    public SourceArchive getSourceArchive(UniversalID sourceID) {
        if (!LOCAL_ARCHIVE_UNIVERSAL_ID.equals((Object)sourceID)) {
            return this.getSourceArchiveFromCache(sourceID);
        }
        if (this.universalID == null) {
            return null;
        }
        return this.getSourceArchiveFromCache(this.universalID);
    }

    @Override
    public SourceArchive getLocalSourceArchive() {
        return this.getSourceArchive(this.getUniversalID());
    }

    private synchronized SourceArchive getSourceArchiveFromCache(UniversalID sourceID) {
        this.populateSourceArchiveCache();
        return this.sourceArchiveMap.get(sourceID);
    }

    private synchronized void invalidateSourceArchiveCache() {
        this.sourceArchiveMap = null;
    }

    private synchronized Collection<SourceArchive> getSourceArchivesFromCache() {
        this.populateSourceArchiveCache();
        return new ArrayList<SourceArchive>(this.sourceArchiveMap.values());
    }

    private synchronized void populateSourceArchiveCache() {
        if (this.sourceArchiveMap != null) {
            return;
        }
        HashMap<UniversalID, SourceArchive> archiveMap = new HashMap<UniversalID, SourceArchive>();
        archiveMap.put(BUILT_IN_ARCHIVE_UNIVERSAL_ID, BuiltInSourceArchive.INSTANCE);
        try {
            List<DBRecord> records = this.sourceArchiveAdapter.getRecords();
            for (DBRecord record : records) {
                SourceArchiveDB sourceArchive = this.getSourceArchiveDB(record);
                archiveMap.put(sourceArchive.getSourceArchiveID(), sourceArchive);
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
        this.sourceArchiveMap = archiveMap;
    }

    private SourceArchiveDB getSourceArchiveDB(DBRecord record) {
        SourceArchiveDB archive = this.sourceArchiveDBCache.get(record.getKey());
        if (archive == null) {
            archive = new SourceArchiveDB(this, this.sourceArchiveDBCache, this.sourceArchiveAdapter, record);
        }
        return archive;
    }

    @Override
    public boolean updateSourceArchiveName(String archiveFileID, String name) {
        SourceArchive sourceArchive = this.getSourceArchive(archiveFileID);
        if (sourceArchive != null && !sourceArchive.getName().equals(name)) {
            sourceArchive.setName(name);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateSourceArchiveName(UniversalID sourceID, String name) {
        SourceArchive sourceArchive = this.getSourceArchive(sourceID);
        if (sourceArchive != null && !sourceArchive.getName().equals(name)) {
            sourceArchive.setName(name);
            return true;
        }
        return false;
    }

    @Override
    public List<DataType> getDataTypes(SourceArchive sourceArchive) {
        ArrayList<DataType> sourceDataTypes = new ArrayList<DataType>();
        Iterator<DataType> allDataTypes = this.getAllDataTypes();
        while (allDataTypes.hasNext()) {
            DataType dt = allDataTypes.next();
            if (!sourceArchive.equals(dt.getSourceArchive())) continue;
            sourceDataTypes.add(dt);
        }
        return sourceDataTypes;
    }

    private DataType createMissingBuiltIn(MissingBuiltInDataType dt, Category category) throws IOException {
        DBRecord record = this.builtinAdapter.createRecord(dt.getMissingBuiltInName(), dt.getMissingBuiltInClassPath(), category.getID());
        return this.getBuiltInDataType(record.getKey(), record);
    }

    private DataType createBuiltIn(BuiltInDataType dt, Category category) throws IOException {
        DBRecord record = this.builtinAdapter.createRecord(dt.getName(), dt.getClass().getName(), category.getID());
        return this.getBuiltInDataType(record.getKey(), record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FunctionDefinition createFunctionDefinition(FunctionDefinition funDef, String name, CategoryDB cat, long sourceArchiveIdValue, long universalIdValue) throws IOException {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Data type must have a valid name");
        }
        try {
            ++this.creatingDataType;
            byte callingConventionId = this.callingConventionAdapter.getCallingConventionId(funDef.getCallingConventionName(), cc -> this.callingConventionNameAdded((String)cc));
            DBRecord record = this.functionDefAdapter.createRecord(name, funDef.getComment(), cat.getID(), 0L, funDef.hasNoReturn(), funDef.hasVarArgs(), callingConventionId, sourceArchiveIdValue, universalIdValue, funDef.getLastChangeTime());
            FunctionDefinitionDB funDefDb = new FunctionDefinitionDB(this, this.dtCache, this.functionDefAdapter, this.paramAdapter, record);
            cat.dataTypeAdded(funDefDb);
            funDefDb.setArguments(funDef.getArguments());
            funDefDb.setReturnType(funDef.getReturnType());
            funDefDb.setLastChangeTime(funDef.getLastChangeTime());
            FunctionDefinitionDB functionDefinitionDB = funDefDb;
            return functionDefinitionDB;
        }
        finally {
            --this.creatingDataType;
        }
    }

    public void dbError(IOException e) {
        this.errHandler.dbError(e);
    }

    SettingsDBAdapter getSettingsAdapter() {
        return this.settingsAdapter;
    }

    void dataTypeCategoryPathChanged(DataTypeDB dt, CategoryPath oldPath, long oldCatId) {
        try {
            DBRecord rec;
            long id;
            if (!(dt instanceof Array) && !(dt instanceof Pointer)) {
                for (Field arrayId : this.arrayAdapter.getRecordIdsInCategory(oldCatId)) {
                    id = arrayId.getLongValue();
                    rec = this.arrayAdapter.getRecord(id);
                    ArrayDB array = (ArrayDB)this.getDataType(id, rec);
                    array.updatePath(dt);
                }
                for (Field ptrId : this.pointerAdapter.getRecordIdsInCategory(oldCatId)) {
                    id = ptrId.getLongValue();
                    rec = this.pointerAdapter.getRecord(id);
                    PointerDB ptr = (PointerDB)this.getDataType(id, rec);
                    ptr.updatePath(dt);
                }
            }
            for (Field ptrId : this.typedefAdapter.getRecordIdsInCategory(oldCatId)) {
                id = ptrId.getLongValue();
                rec = this.typedefAdapter.getRecord(id);
                TypedefDB td = (TypedefDB)this.getDataType(id, rec);
                td.updatePath(dt);
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
        this.dataTypeMoved(dt, new DataTypePath(oldPath, dt.getName()), dt.getDataTypePath());
    }

    @Override
    public Iterator<DataType> getAllDataTypes() {
        this.lock.acquire();
        try {
            this.buildSortedDataTypeList();
            Iterator<DataType> iterator = new ArrayList<DataType>(this.sortedDataTypes).iterator();
            return iterator;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void getAllDataTypes(List<DataType> list) {
        this.lock.acquire();
        try {
            this.buildSortedDataTypeList();
            list.addAll(this.sortedDataTypes);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Iterator<FunctionDefinition> getAllFunctionDefinitions() {
        try {
            return new DataTypeIterator<FunctionDefinition>(this.functionDefAdapter, dt -> true);
        }
        catch (IOException e) {
            this.dbError(e);
            List emptyList = List.of();
            return emptyList.iterator();
        }
    }

    @Override
    public Iterator<Structure> getAllStructures() {
        try {
            return new DataTypeIterator<Structure>(this.compositeAdapter, dt -> dt instanceof Structure);
        }
        catch (IOException e) {
            this.dbError(e);
            return new ArrayList().iterator();
        }
    }

    @Override
    public Iterator<Composite> getAllComposites() {
        try {
            return new DataTypeIterator<Composite>(this.compositeAdapter, dt -> true);
        }
        catch (IOException e) {
            this.dbError(e);
            return new ArrayList().iterator();
        }
    }

    public void dispose() {
        this.sortedDataTypes = null;
        this.enumValueMap = null;
    }

    @Override
    public void close() {
        this.dispose();
    }

    public void invalidateCache() {
        this.lock.acquire();
        try {
            this.callingConventionAdapter.invalidateCache();
            this.knownCallingConventions = null;
            this.definedCallingConventions = null;
            this.dtCache.invalidate();
            this.sourceArchiveDBCache.invalidate();
            this.invalidateSourceArchiveCache();
            this.builtInMap.clear();
            this.builtIn2IdMap.clear();
            this.root.setInvalid();
            this.catCache.invalidate();
            this.settingsCache.clear();
            this.settingsAdapter.invalidateNameCache();
            this.sortedDataTypes = null;
            this.enumValueMap = null;
            this.fireInvalidated();
            this.updateFavorites();
            this.idsToDataTypeMap.clear();
        }
        finally {
            this.lock.release();
        }
    }

    private void updateFavorites() {
        Iterator<DataType> it = this.favoritesList.iterator();
        while (it.hasNext()) {
            DataType dt = it.next();
            if (this.contains(dt)) continue;
            it.remove();
            this.favoritesChanged(dt, false);
        }
    }

    @Override
    public boolean isUpdatable() {
        return this.dbHandle.canUpdate();
    }

    @Override
    public boolean allowsDefaultBuiltInSettings() {
        return false;
    }

    @Override
    public final boolean allowsDefaultComponentSettings() {
        return this.allowsDefaultBuiltInSettings();
    }

    static long createKey(int tableID, long tableKey) {
        long key = (long)tableID << 56;
        return key |= tableKey;
    }

    void addParentChildRecord(long parentID, long childID) {
        try {
            this.parentChildAdapter.createRecord(parentID, childID);
        }
        catch (IOException e) {
            this.dbError(e);
        }
    }

    private void removeAllParentChildRecordsForChild(long childID) {
        try {
            this.parentChildAdapter.removeAllRecordsForChild(childID);
        }
        catch (IOException e) {
            this.dbError(e);
        }
    }

    void removeParentChildRecord(long parentID, long childID) {
        if (this.isBulkRemoving) {
            return;
        }
        try {
            this.parentChildAdapter.removeRecord(parentID, childID);
        }
        catch (IOException e) {
            this.dbError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<DataType> getParentDataTypes(long dataTypeId) {
        this.lock.acquire();
        try {
            Set<Long> parentIds = this.parentChildAdapter.getParentIds(dataTypeId);
            ArrayList<DataType> dts = new ArrayList<DataType>();
            Object object = parentIds.iterator();
            while (object.hasNext()) {
                long id = object.next();
                DataType dt = this.getDataType(id);
                if (dt == null) {
                    this.attemptRecordRemovalForParent(id);
                    continue;
                }
                dts.add(dt);
            }
            object = dts;
            return object;
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    Set<DataType> getParentDataTypeSet(long dataTypeId) {
        this.lock.acquire();
        try {
            Set<Long> parentIds = this.parentChildAdapter.getParentIds(dataTypeId);
            HashSet<DataType> dts = new HashSet<DataType>();
            Object object = parentIds.iterator();
            while (object.hasNext()) {
                long id = object.next();
                DataType dt = this.getDataType(id);
                if (dt == null) {
                    this.attemptRecordRemovalForParent(id);
                    continue;
                }
                dts.add(dt);
            }
            object = dts;
            return object;
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    @Override
    public Set<DataType> getDataTypesContaining(DataType dataType) {
        if (dataType instanceof DataTypeDB) {
            DataTypeDB dataTypeDb = (DataTypeDB)dataType;
            if (dataTypeDb.getDataTypeManager() != this) {
                return Set.of();
            }
            return this.getParentDataTypeSet(dataTypeDb.getKey());
        }
        return Set.of();
    }

    private void attemptRecordRemovalForParent(long parentKey) throws IOException {
        this.lock.acquire();
        try {
            if (this.dbHandle.isTransactionActive()) {
                this.parentChildAdapter.removeAllRecordsForParent(parentKey);
            }
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public final Pointer getPointer(DataType dt) {
        return new PointerDataType(dt, this);
    }

    @Override
    public final Pointer getPointer(DataType dt, int size) {
        return new PointerDataType(dt, size, (DataTypeManager)this);
    }

    @Override
    public void addDataTypeManagerListener(DataTypeManagerChangeListener l) {
        this.defaultListener.addDataTypeManagerListener(l);
    }

    @Override
    public void removeDataTypeManagerListener(DataTypeManagerChangeListener l) {
        this.defaultListener.removeDataTypeManagerListener(l);
    }

    protected boolean isCreatingDataType() {
        return this.creatingDataType != 0;
    }

    public void dataTypeChanged(DataType dt, boolean isAutoChange) {
        if (dt instanceof Enum) {
            this.enumValueMap = null;
        }
        if (!isAutoChange && this.creatingDataType == 0) {
            this.updateLastChangeTime();
            this.setDirtyFlag(dt);
        }
        this.defaultListener.dataTypeChanged(this, dt.getDataTypePath());
    }

    public void dataTypeSettingsChanged(DataType dt) {
        if (dt instanceof TypedefDB) {
            TypedefDB td = (TypedefDB)dt;
            td.updateAutoName(true);
            if (this.creatingDataType == 0) {
                td.setLastChangeTime(System.currentTimeMillis());
                this.setDirtyFlag(dt);
            }
        }
        this.defaultListener.dataTypeChanged(this, dt.getDataTypePath());
    }

    protected void dataTypeAdded(DataType newDt, DataType originalDataType) {
        CategoryDB category = (CategoryDB)this.getCategory(newDt.getCategoryPath());
        category.dataTypeAdded(newDt);
        this.insertDataTypeIntoSortedList(newDt);
        if (newDt instanceof Enum) {
            this.enumValueMap = null;
        }
        this.updateLastChangeTime();
        this.defaultListener.dataTypeAdded(this, newDt.getDataTypePath());
    }

    protected void dataTypeReplaced(long existingDtID, DataTypePath replacedDataTypePath, DataType replacementDt) {
        CategoryDB category = (CategoryDB)this.getCategory(replacedDataTypePath.getCategoryPath());
        category.dataTypeRemoved(replacedDataTypePath.getDataTypeName());
        this.removeDataTypeFromSortedList(replacedDataTypePath);
        this.enumValueMap = null;
        this.updateLastChangeTime();
        this.defaultListener.dataTypeReplaced(this, replacedDataTypePath, replacementDt.getDataTypePath(), replacementDt);
    }

    protected void dataTypeDeleted(long deletedID, DataTypePath deletedDataTypePath) {
        CategoryDB category = (CategoryDB)this.getCategory(deletedDataTypePath.getCategoryPath());
        category.dataTypeRemoved(deletedDataTypePath.getDataTypeName());
        this.removeDataTypeFromSortedList(deletedDataTypePath);
        this.enumValueMap = null;
        this.updateLastChangeTime();
        this.defaultListener.dataTypeRemoved(this, deletedDataTypePath);
    }

    protected void dataTypeMoved(DataType dt, DataTypePath oldDataTypePath, DataTypePath newDataTypePath) {
        CategoryDB category = (CategoryDB)this.getCategory(oldDataTypePath.getCategoryPath());
        category.dataTypeRemoved(oldDataTypePath.getDataTypeName());
        this.removeDataTypeFromSortedList(oldDataTypePath);
        category = (CategoryDB)this.getCategory(newDataTypePath.getCategoryPath());
        category.dataTypeAdded(dt);
        this.insertDataTypeIntoSortedList(dt);
        this.updateLastChangeTime();
        this.defaultListener.dataTypeMoved(this, oldDataTypePath, newDataTypePath);
    }

    protected void dataTypeNameChanged(DataType dt, String oldName) {
        CategoryDB category = (CategoryDB)this.getCategory(dt.getCategoryPath());
        category.dataTypeRenamed(dt, oldName);
        if (this.sortedDataTypes != null) {
            Collections.sort(this.sortedDataTypes, this.nameComparator);
        }
        this.updateLastChangeTime();
        this.setDirtyFlag(dt);
        this.defaultListener.dataTypeRenamed(this, new DataTypePath(dt.getCategoryPath(), oldName), dt.getDataTypePath());
    }

    protected void categoryCreated(Category cat) {
        this.updateLastChangeTime();
        this.defaultListener.categoryAdded(this, cat.getCategoryPath());
    }

    protected void categoryRenamed(CategoryPath oldPath, Category category) {
        this.catCache.invalidate();
        this.updateLastChangeTime();
        this.defaultListener.categoryRenamed(this, oldPath, category.getCategoryPath());
    }

    protected void categoryRemoved(Category parent, String name, long categoryID) {
        this.catCache.delete(categoryID);
        this.updateLastChangeTime();
        this.defaultListener.categoryRemoved(this, new CategoryPath(parent.getCategoryPath(), name));
    }

    protected void categoryMoved(CategoryPath oldPath, Category category) {
        this.catCache.invalidate();
        this.updateLastChangeTime();
        this.defaultListener.categoryMoved(this, oldPath, category.getCategoryPath());
    }

    protected void favoritesChanged(DataType dataType, boolean isFavorite) {
        this.defaultListener.favoritesChanged(this, dataType.getDataTypePath(), isFavorite);
    }

    public void sourceArchiveChanged(UniversalID sourceArchiveID) {
        SourceArchive sourceArchive = this.getSourceArchive(sourceArchiveID);
        this.defaultListener.sourceArchiveChanged(this, sourceArchive);
    }

    protected void sourceArchiveAdded(UniversalID sourceArchiveID) {
        SourceArchive sourceArchive = this.getSourceArchive(sourceArchiveID);
        this.defaultListener.sourceArchiveAdded(this, sourceArchive);
    }

    CategoryDBAdapter getCategoryDBAdapter() {
        return this.categoryAdapter;
    }

    @Override
    public long getLastChangeTimeForMyManager() {
        SourceArchive archive = this.getSourceArchive(this.getUniversalID());
        if (archive != null) {
            return archive.getLastSyncTime();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataType getDataType(SourceArchive sourceArchive, UniversalID datatypeID) {
        UniversalID sourceID = sourceArchive == null ? null : sourceArchive.getSourceArchiveID();
        this.lock.acquire();
        try {
            DataType dataType = this.idsToDataTypeMap.getDataType(sourceID, datatypeID);
            return dataType;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public DataType findDataTypeForID(UniversalID datatypeID) {
        SourceArchive localSA = this.getLocalSourceArchive();
        DataType dt = this.getDataType(localSA, datatypeID);
        if (dt != null) {
            return dt;
        }
        for (SourceArchive sa : this.getSourceArchives()) {
            if (sa == localSA || (dt = this.getDataType(sa, datatypeID)) == null) continue;
            return dt;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataType findDataTypeForIDs(UniversalID sourceID, UniversalID datatypeID) {
        this.lock.acquire();
        DBRecord record = null;
        try {
            record = this.typedefAdapter.getRecordWithIDs(sourceID, datatypeID);
            if (record == null) {
                record = this.compositeAdapter.getRecordWithIDs(sourceID, datatypeID);
            }
            if (record == null) {
                record = this.functionDefAdapter.getRecordWithIDs(sourceID, datatypeID);
            }
            if (record == null) {
                record = this.enumAdapter.getRecordWithIDs(sourceID, datatypeID);
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        if (record != null) {
            return this.getDataType(record.getKey(), record);
        }
        return null;
    }

    @Override
    public AddressMap getAddressMap() {
        return this.addrMap;
    }

    @Override
    public final DataOrganization getDataOrganization() {
        if (this.dataOrganization == null) {
            this.dataOrganization = DataOrganizationImpl.getDefaultOrganization();
        }
        return this.dataOrganization;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCallingConventionName(byte id) {
        this.lock.acquire();
        try {
            String callingConvention = this.callingConventionAdapter.getCallingConventionName(id);
            String string = callingConvention != null ? callingConvention : "unknown";
            return string;
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getCallingConventionID(String name, boolean restrictive) throws InvalidInputException, IOException {
        if (name == null || "unknown".equals(name)) {
            return 0;
        }
        if ("default".equals(name)) {
            return 1;
        }
        this.lock.acquire();
        try {
            if (restrictive && GenericCallingConvention.getGenericCallingConvention(name) == GenericCallingConvention.unknown && !this.getKnownCallingConventionNames().contains(name) && this.getCallingConvention(name) == null) {
                throw new InvalidInputException("Invalid calling convention name: " + name);
            }
            byte by = this.callingConventionAdapter.getCallingConventionId(name, cc -> this.callingConventionNameAdded((String)cc));
            return by;
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return 0;
    }

    private void callingConventionNameAdded(String name) {
        this.getKnownCallingConventionSet().add(name);
    }

    private Set<String> getDefinedCallingConventionSet() {
        if (this.definedCallingConventions == null) {
            this.definedCallingConventions = this.buildDefinedCallingConventionSet();
        }
        return this.definedCallingConventions;
    }

    private TreeSet<String> buildDefinedCallingConventionSet() {
        TreeSet<String> nameSet = new TreeSet<String>();
        ProgramArchitecture arch = this.getProgramArchitecture();
        if (arch != null) {
            PrototypeModel[] namedCallingConventions;
            CompilerSpec compilerSpec = arch.getCompilerSpec();
            for (PrototypeModel model : namedCallingConventions = compilerSpec.getCallingConventions()) {
                nameSet.add(model.getName());
            }
        } else {
            for (GenericCallingConvention conv : GenericCallingConvention.values()) {
                if (conv == GenericCallingConvention.unknown) continue;
                nameSet.add(conv.getDeclarationName());
            }
        }
        return nameSet;
    }

    @Override
    public Collection<String> getDefinedCallingConventionNames() {
        this.lock.acquire();
        try {
            ArrayList<String> arrayList = new ArrayList<String>(this.getDefinedCallingConventionSet());
            return arrayList;
        }
        finally {
            this.lock.release();
        }
    }

    private Set<String> getKnownCallingConventionSet() {
        if (this.knownCallingConventions == null) {
            this.knownCallingConventions = this.buildKnownCallingConventionSet();
        }
        return this.knownCallingConventions;
    }

    private TreeSet<String> buildKnownCallingConventionSet() {
        TreeSet<String> nameSet = new TreeSet<String>();
        try {
            nameSet.addAll(this.getDefinedCallingConventionSet());
            for (String name : this.callingConventionAdapter.getCallingConventionNames()) {
                nameSet.add(name);
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
        return nameSet;
    }

    @Override
    public Collection<String> getKnownCallingConventionNames() {
        this.lock.acquire();
        try {
            ArrayList<String> arrayList = new ArrayList<String>(this.getKnownCallingConventionSet());
            return arrayList;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public PrototypeModel getDefaultCallingConvention() {
        ProgramArchitecture arch = this.getProgramArchitecture();
        if (arch != null) {
            CompilerSpec compilerSpec = arch.getCompilerSpec();
            return compilerSpec.getDefaultCallingConvention();
        }
        return null;
    }

    @Override
    public PrototypeModel getCallingConvention(String name) {
        ProgramArchitecture arch = this.getProgramArchitecture();
        if (arch != null) {
            CompilerSpec compilerSpec = arch.getCompilerSpec();
            return compilerSpec.getCallingConvention(name);
        }
        return null;
    }

    private boolean checkForSourceArchiveUpdatesNeeded(int openMode, TaskMonitor monitor) throws IOException, CancelledException {
        if (openMode == 0 || openMode == 2) {
            return false;
        }
        List<DBRecord> records = this.sourceArchiveAdapter.getRecords();
        for (DBRecord record : records) {
            monitor.checkCancelled();
            if (!SourceArchiveUpgradeMap.isReplacedSourceArchive(record.getKey())) continue;
            return true;
        }
        return false;
    }

    protected void migrateOldFlexArrayComponentsIfRequired(TaskMonitor monitor) throws IOException, CancelledException {
        if (!this.compositeAdapter.isFlexArrayMigrationRequired()) {
            return;
        }
        RecordIterator records = this.compositeAdapter.getRecords();
        while (records.hasNext()) {
            monitor.checkCancelled();
            DBRecord rec = records.next();
            if (rec.getBooleanValue(2)) continue;
            new StructureDB(this, this.dtCache, this.compositeAdapter, this.componentAdapter, rec);
        }
    }

    protected void doSourceArchiveUpdates(TaskMonitor monitor) throws CancelledException {
        SourceArchiveUpgradeMap upgradeMap = new SourceArchiveUpgradeMap();
        for (SourceArchive sourceArchive : this.getSourceArchives()) {
            SourceArchive mappedSourceArchive = upgradeMap.getMappedSourceArchive(sourceArchive);
            if (mappedSourceArchive == null) continue;
            this.replaceSourceArchive(sourceArchive, mappedSourceArchive);
        }
        BuiltInDataTypeManager builtInDTM = BuiltInDataTypeManager.getDataTypeManager();
        for (String name : SourceArchiveUpgradeMap.getTypedefReplacements()) {
            DataType builtIn;
            monitor.checkCancelled();
            DataType dataType = this.getDataType(CategoryPath.ROOT, name);
            if (!(dataType instanceof TypeDef) || (builtIn = builtInDTM.getDataType(CategoryPath.ROOT, name)) == null) continue;
            try {
                this.replace(dataType, this.resolve(builtIn, null));
            }
            catch (DataTypeDependencyException e) {
                throw new AssertException("Got DataTypeDependencyException on built in", (Throwable)e);
            }
        }
    }

    public void fixupComposites(TaskMonitor monitor) throws CancelledException {
        this.lock.acquire();
        try {
            this.doCompositeFixup(monitor);
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    private void doCompositeFixup(TaskMonitor monitor) throws CancelledException, IOException {
        List<CompositeDB> orderedComposites = this.getAllCompositesInPostDependencyOrder(monitor);
        monitor.setProgress(0L);
        monitor.setMaximum((long)orderedComposites.size());
        monitor.setMessage("Updating Datatype Sizes...");
        int count = 0;
        for (CompositeDB c : orderedComposites) {
            monitor.checkCancelled();
            if (c.isPackingEnabled()) {
                c.repack(true, false);
            } else {
                c.fixupComponents();
            }
            monitor.setProgress((long)(++count));
        }
    }

    private CompositeDB getCompositeBaseType(DataType dt) {
        while (dt instanceof Array || dt instanceof TypeDef) {
            if (dt instanceof Array) {
                dt = ((Array)dt).getDataType();
                continue;
            }
            dt = ((TypeDef)dt).getBaseDataType();
        }
        return dt instanceof CompositeDB ? (CompositeDB)dt : null;
    }

    private List<CompositeDB> getAllCompositesInPostDependencyOrder(TaskMonitor monitor) throws CancelledException {
        GDirectedGraph graph = GraphFactory.createDirectedGraph();
        Iterator<Composite> allComposites = this.getAllComposites();
        while (allComposites.hasNext()) {
            monitor.checkCancelled();
            CompositeDB c = (CompositeDB)allComposites.next();
            graph.addVertex((Object)c);
            for (DataTypeComponentDB m : c.getDefinedComponents()) {
                CompositeDB refC = this.getCompositeBaseType(m.getDataType());
                if (refC == null) continue;
                graph.addEdge((GEdge)new DefaultGEdge((Object)c, (Object)refC));
            }
        }
        return GraphAlgorithms.getVerticesInPostOrder((GDirectedGraph)graph, (GraphNavigator)GraphNavigator.topDownNavigator());
    }

    boolean activateResolveCache() {
        if (this.resolveCache != null) {
            return false;
        }
        this.resolveCache = new IdentityHashMap();
        return true;
    }

    void queuePostResolve(DataTypeDB resolvedDt, DataType definitionDt) {
        resolvedDt.resolving = true;
        if (this.resolveQueue == null) {
            this.resolveQueue = new TreeSet();
        }
        this.resolveQueue.add(new ResolvePair(resolvedDt, definitionDt));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushResolveQueue(boolean deactivateCache) {
        try {
            if (this.resolveQueue != null) {
                DataTypeConflictHandler handler = this.getDependencyConflictHandler();
                while (!this.resolveQueue.isEmpty()) {
                    ResolvePair resolvePair = this.resolveQueue.pollFirst();
                    DataTypeDB resolvedDt = resolvePair.resolvedDt;
                    try {
                        resolvedDt.postPointerResolve(resolvePair.definitionDt, handler);
                    }
                    finally {
                        resolvedDt.resolving = false;
                        resolvedDt.pointerPostResolveRequired = false;
                    }
                }
            }
        }
        finally {
            this.resolveQueue = null;
            if (deactivateCache) {
                this.resolveCache = null;
            }
        }
    }

    private DataType getCachedResolve(DataType dt) {
        if (this.resolveCache != null) {
            return this.resolveCache.get(dt);
        }
        return null;
    }

    private void cacheResolvedDataType(DataType dt, DataType resolvedDt) {
        if (this.resolveCache == null) {
            throw new AssertException("resolve cache inactive - unexpected condition");
        }
        this.resolveCache.put(dt, resolvedDt);
    }

    Boolean getCachedEquivalence(DataTypeDB dataTypeDB, DataType dataType) {
        long key;
        Boolean value;
        EquivalenceCache cache = this.equivalenceCache.get();
        if (cache == null) {
            cache = new EquivalenceCache();
            this.equivalenceCache.set(cache);
        }
        if ((value = cache.getValue(key = DataTypeManagerDB.getEquivalenceKey(dataTypeDB, dataType))) == null) {
            if (cache.contains(key)) {
                if (dataType.getUniversalID().equals((Object)this.getUniversalID())) {
                    return true;
                }
                return DataTypeUtilities.equalsIgnoreConflict(dataTypeDB.getPathName(), dataType.getPathName());
            }
            cache.putValue(key, null);
        }
        return value;
    }

    private void setCachedEquivalence(DataTypeDB dataTypeDB, DataType dataType) {
        EquivalenceCache cache = this.equivalenceCache.get();
        if (cache == null) {
            throw new IllegalStateException("equivalence cache not active - unexpected condition");
        }
        long key = DataTypeManagerDB.getEquivalenceKey(dataTypeDB, dataType);
        cache.setValue(key);
    }

    void putCachedEquivalence(DataTypeDB dataTypeDB, DataType dataType, boolean isEquivalent) {
        EquivalenceCache cache = this.equivalenceCache.get();
        if (cache == null) {
            throw new IllegalStateException("equivalence cache not active - unexpected condition");
        }
        long key = DataTypeManagerDB.getEquivalenceKey(dataTypeDB, dataType);
        cache.putValue(key, isEquivalent);
        if (!cache.isCacheActive()) {
            this.clearEquivalenceCache();
        }
    }

    private boolean activateEquivalenceCache() {
        EquivalenceCache cache = this.equivalenceCache.get();
        if (cache == null) {
            cache = new EquivalenceCache();
            this.equivalenceCache.set(cache);
            cache.putValue(0L, null);
            return true;
        }
        return false;
    }

    private void clearEquivalenceCache() {
        this.equivalenceCache.set(null);
    }

    private static long getEquivalenceKey(DataTypeDB dataTypeDB, DataType dataType) {
        return ((long)System.identityHashCode(dataTypeDB) << 32) + ((long)System.identityHashCode(dataType) & 0xFFFFFFFFL);
    }

    private class NameComparator
    implements Comparator<DataType> {
        private NameComparator() {
        }

        @Override
        public int compare(DataType d1, DataType d2) {
            int c = d1.getName().compareTo(d2.getName());
            if (c == 0) {
                return d1.getCategoryPath().compareTo(d2.getCategoryPath());
            }
            return c;
        }
    }

    private class IdsToDataTypeMap {
        private Map<UniversalID, Map<UniversalID, DataType>> map = new ConcurrentHashMap<UniversalID, Map<UniversalID, DataType>>();

        private IdsToDataTypeMap() {
        }

        DataType getDataType(UniversalID sourceID, UniversalID dataTypeID) {
            if (sourceID == null || sourceID.equals((Object)DataTypeManagerDB.this.universalID)) {
                sourceID = DataTypeManager.LOCAL_ARCHIVE_UNIVERSAL_ID;
            }
            Map idMap = this.map.computeIfAbsent(sourceID, k -> new ConcurrentHashMap());
            UniversalID sourceArchiveID = sourceID;
            return idMap.computeIfAbsent(dataTypeID, k -> DataTypeManagerDB.this.findDataTypeForIDs(sourceArchiveID, dataTypeID));
        }

        void clear() {
            this.map.clear();
        }

        void removeDataType(SourceArchive sourceArchive, UniversalID dataTypeID) {
            if (dataTypeID == null) {
                return;
            }
            UniversalID sourceID = sourceArchive == null || sourceArchive.getSourceArchiveID().equals((Object)DataTypeManagerDB.this.universalID) ? DataTypeManager.LOCAL_ARCHIVE_UNIVERSAL_ID : sourceArchive.getSourceArchiveID();
            Map<UniversalID, DataType> idMap = this.map.get(sourceID);
            if (idMap != null) {
                idMap.remove(dataTypeID);
            }
        }
    }

    private class DbErrorHandler
    implements ErrorHandler {
        private DbErrorHandler() {
        }

        public void dbError(IOException e) throws RuntimeIOException {
            Object message = e.getMessage();
            if (e instanceof ClosedException) {
                message = "Data type archive is closed: " + DataTypeManagerDB.this.getName();
                Msg.showError((Object)this, null, (String)"IO ERROR", (Object)message, (Throwable)e);
            }
            throw new RuntimeIOException(e);
        }
    }

    class DataTypeIterator<T extends DataType>
    implements Iterator<T> {
        private RecordIterator it;
        private T nextDataType;
        private Predicate<DataType> predicate;

        DataTypeIterator(DBRecordAdapter adapter, Predicate<DataType> predicate) throws IOException {
            this.it = adapter.getRecords();
            this.predicate = predicate;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported");
        }

        @Override
        public boolean hasNext() {
            if (this.nextDataType == null) {
                this.getNextDataType();
            }
            return this.nextDataType != null;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                T dt = this.nextDataType;
                this.nextDataType = null;
                return dt;
            }
            return null;
        }

        private void getNextDataType() {
            try {
                while (this.it.hasNext()) {
                    DBRecord rec = this.it.next();
                    DataType dt = DataTypeManagerDB.this.getDataType(rec.getKey(), rec);
                    if (!this.predicate.test(dt)) continue;
                    this.nextDataType = dt;
                    return;
                }
            }
            catch (IOException e) {
                Msg.error((Object)this, (Object)"Unexpected exception iterating structures", (Throwable)e);
            }
        }
    }

    private static class ResolvePair
    implements Comparable<ResolvePair> {
        private final DataTypeDB resolvedDt;
        private final DataType definitionDt;

        ResolvePair(DataTypeDB resolvedDt, DataType definitionDt) {
            this.resolvedDt = resolvedDt;
            this.definitionDt = definitionDt;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ResolvePair)) {
                return false;
            }
            return this.resolvedDt.getKey() == ((ResolvePair)obj).resolvedDt.getKey();
        }

        public int hashCode() {
            long value = this.resolvedDt.getKey();
            return (int)(value ^ value >>> 32);
        }

        @Override
        public int compareTo(ResolvePair o) {
            long r = this.resolvedDt.getKey() - o.resolvedDt.getKey();
            if (r == 0L) {
                return 0;
            }
            if (r < 0L) {
                return -1;
            }
            return 1;
        }
    }

    private static class EquivalenceCache {
        private Map<Long, Boolean> cacheMap = new HashMap<Long, Boolean>();
        int outstandingRequestCount;

        private EquivalenceCache() {
        }

        Boolean getValue(long key) {
            return this.cacheMap.get(key);
        }

        boolean contains(long key) {
            return this.cacheMap.containsKey(key);
        }

        void setValue(long key) {
            this.cacheMap.put(key, true);
        }

        void putValue(long key, Boolean value) {
            this.cacheMap.put(key, value);
            this.outstandingRequestCount = value != null ? --this.outstandingRequestCount : ++this.outstandingRequestCount;
        }

        boolean isCacheActive() {
            return this.outstandingRequestCount > 0;
        }
    }
}

