/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph;

import docking.ComponentProvider;
import generic.theme.GIcon;
import ghidra.app.events.ProgramHighlightPluginEvent;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.colorizer.ColorizingService;
import ghidra.app.plugin.core.functiongraph.DiscoverableFGLayoutFinder;
import ghidra.app.plugin.core.functiongraph.FGColorProvider;
import ghidra.app.plugin.core.functiongraph.FGProvider;
import ghidra.app.plugin.core.functiongraph.IndependentColorProvider;
import ghidra.app.plugin.core.functiongraph.ToolBasedColorProvider;
import ghidra.app.plugin.core.functiongraph.graph.layout.FGLayoutOptions;
import ghidra.app.plugin.core.functiongraph.graph.layout.FGLayoutProvider;
import ghidra.app.plugin.core.functiongraph.mvc.FunctionGraphOptions;
import ghidra.app.services.BlockModelService;
import ghidra.app.services.ClipboardService;
import ghidra.app.services.CodeViewerService;
import ghidra.app.services.GoToService;
import ghidra.app.services.ProgramManager;
import ghidra.app.util.viewer.format.FormatManager;
import ghidra.framework.model.DomainFile;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.OptionsService;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.exception.AssertException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Graph", shortDescription="Function Graph", description="Plugin for show a graphical representation of the code blocks of a function", servicesRequired={GoToService.class, BlockModelService.class, CodeViewerService.class, ProgramManager.class})
public class FunctionGraphPlugin
extends ProgramPlugin
implements OptionsChangeListener {
    static final String FUNCTION_GRAPH_NAME = "Function Graph";
    static final String OPTIONS_NAME_PATH = "Graph.Function Graph";
    static final Icon ICON = new GIcon("icon.plugin.functiongraph.action.provider");
    private static final String USER_DEFINED_FORMAT_CONFIG_NAME = "USER_DEFINED_FORMAT_MANAGER";
    private static final String PROVIDER_ID = "Provider";
    private static final String PROGRAM_PATH_ID = "Program Path";
    private static final String DISCONNECTED_COUNT_ID = "Disconnected Count";
    private FGProvider connectedProvider;
    private List<FGProvider> disconnectedProviders = new ArrayList<FGProvider>();
    private FormatManager userDefinedFormatManager;
    private FunctionGraphOptions functionGraphOptions = new FunctionGraphOptions();
    private FGColorProvider colorProvider;
    private List<FGLayoutProvider> layoutProviders;

    public FunctionGraphPlugin(PluginTool tool) {
        super(tool);
        this.colorProvider = new IndependentColorProvider(tool);
    }

    protected void init() {
        super.init();
        this.layoutProviders = this.loadLayoutProviders();
        this.createNewProvider();
        this.initializeOptions();
        ColorizingService colorizingService = (ColorizingService)this.tool.getService(ColorizingService.class);
        if (colorizingService != null) {
            this.colorProvider = new ToolBasedColorProvider(this, colorizingService);
        }
    }

    public void serviceAdded(Class<?> interfaceClass, Object service) {
        if (interfaceClass == ClipboardService.class) {
            this.connectedProvider.setClipboardService((ClipboardService)service);
            for (FGProvider disconnectedProvider : this.disconnectedProviders) {
                disconnectedProvider.setClipboardService((ClipboardService)service);
            }
        } else if (interfaceClass == ColorizingService.class) {
            this.colorProvider = new ToolBasedColorProvider(this, (ColorizingService)service);
            this.connectedProvider.refreshAndKeepPerspective();
        }
    }

    public void serviceRemoved(Class<?> interfaceClass, Object service) {
        if (interfaceClass == ClipboardService.class) {
            this.connectedProvider.setClipboardService((ClipboardService)service);
            for (FGProvider disconnectedProvider : this.disconnectedProviders) {
                disconnectedProvider.setClipboardService((ClipboardService)service);
            }
        } else if (interfaceClass == ColorizingService.class) {
            this.colorProvider = new IndependentColorProvider(this.tool);
            this.connectedProvider.refreshAndKeepPerspective();
        }
    }

    private List<FGLayoutProvider> loadLayoutProviders() {
        DiscoverableFGLayoutFinder layoutFinder = new DiscoverableFGLayoutFinder();
        List<FGLayoutProvider> instances = layoutFinder.findLayouts();
        if (instances.isEmpty()) {
            throw new AssertException("Could not find any layout providers. You project may not be configured properly.");
        }
        ArrayList<FGLayoutProvider> layouts = new ArrayList<FGLayoutProvider>(instances);
        Collections.sort(layouts, (o1, o2) -> -o1.getPriorityLevel() + o2.getPriorityLevel());
        return layouts;
    }

    private void initializeOptions() {
        ToolOptions options = this.tool.getOptions("Graph");
        options.addOptionsChangeListener((OptionsChangeListener)this);
        Options fgOptions = options.getOptions(FUNCTION_GRAPH_NAME);
        this.functionGraphOptions.registerOptions(fgOptions);
        this.functionGraphOptions.loadOptions(fgOptions);
        for (FGLayoutProvider layoutProvider : this.layoutProviders) {
            String layoutName;
            Options layoutToolOptions;
            FGLayoutOptions layoutOptions = layoutProvider.createLayoutOptions(layoutToolOptions = fgOptions.getOptions(layoutName = layoutProvider.getLayoutName()));
            if (layoutOptions == null) continue;
            layoutOptions.registerOptions(layoutToolOptions);
            layoutOptions.loadOptions(layoutToolOptions);
            this.functionGraphOptions.setLayoutOptions(layoutName, layoutOptions);
        }
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        Options fgOptions = options.getOptions(FUNCTION_GRAPH_NAME);
        this.functionGraphOptions.loadOptions(fgOptions);
        this.connectedProvider.optionsChanged();
        if (this.functionGraphOptions.optionChangeRequiresRelayout(optionName)) {
            this.connectedProvider.refreshAndKeepPerspective();
        } else if ("View Settings".equals(optionName)) {
            this.connectedProvider.clearViewSettings();
        } else {
            this.connectedProvider.refreshDisplayWithoutRebuilding();
        }
        this.connectedProvider.getComponent().repaint();
        for (FGProvider provider : this.disconnectedProviders) {
            provider.optionsChanged();
            provider.getComponent().repaint();
        }
    }

    protected void programActivated(Program program) {
        if (this.connectedProvider == null) {
            return;
        }
        this.connectedProvider.doSetProgram(program);
    }

    protected void programDeactivated(Program program) {
        if (this.connectedProvider == null) {
            return;
        }
        this.connectedProvider.doSetProgram(null);
    }

    protected void locationChanged(ProgramLocation location) {
        if (this.connectedProvider == null) {
            return;
        }
        this.connectedProvider.setLocation(location);
    }

    protected void selectionChanged(ProgramSelection selection) {
        if (this.connectedProvider == null) {
            return;
        }
        this.connectedProvider.setSelection(selection);
    }

    protected void highlightChanged(ProgramSelection highlight) {
        if (this.connectedProvider == null) {
            return;
        }
        this.connectedProvider.setHighlight(highlight);
    }

    protected void programClosed(Program program) {
        if (this.currentProgram == program) {
            this.currentProgram = null;
        }
        this.connectedProvider.programClosed(program);
        Iterator<FGProvider> iterator = this.disconnectedProviders.iterator();
        while (iterator.hasNext()) {
            FGProvider provider = iterator.next();
            if (provider.getProgram() != program) continue;
            iterator.remove();
            this.removeProvider(provider);
        }
    }

    void showProvider() {
        this.connectedProvider.setVisible(true);
        this.connectedProvider.setLocation(this.currentLocation);
    }

    void closeProvider(FGProvider provider) {
        if (provider == this.connectedProvider) {
            this.tool.showComponentProvider((ComponentProvider)provider, false);
        } else {
            this.disconnectedProviders.remove((Object)provider);
            this.removeProvider(provider);
        }
    }

    private void createNewProvider() {
        this.connectedProvider = new FGProvider(this, true);
        this.connectedProvider.doSetProgram(this.currentProgram);
        this.connectedProvider.setLocation(this.currentLocation);
        this.connectedProvider.setSelection(this.currentSelection);
    }

    FGProvider createNewDisconnectedProvider() {
        FGProvider provider = new FGProvider(this, false);
        this.disconnectedProviders.add(provider);
        this.tool.showComponentProvider((ComponentProvider)provider, true);
        return provider;
    }

    protected void dispose() {
        super.dispose();
        this.currentProgram = null;
        this.removeProvider(this.connectedProvider);
        for (FGProvider provider : this.disconnectedProviders) {
            this.removeProvider(provider);
        }
        this.disconnectedProviders.clear();
    }

    private void removeProvider(FGProvider provider) {
        if (provider == null) {
            return;
        }
        provider.dispose();
        this.tool.removeComponentProvider((ComponentProvider)provider);
    }

    public void handleProviderLocationChanged(FGProvider provider, ProgramLocation location) {
        if (provider != this.connectedProvider) {
            return;
        }
        this.firePluginEvent((PluginEvent)new ProgramLocationPluginEvent(this.getName(), location, location.getProgram()));
    }

    public void handleProviderSelectionChanged(FGProvider provider, ProgramSelection selection) {
        if (provider != this.connectedProvider) {
            return;
        }
        if (selection == null) {
            return;
        }
        this.firePluginEvent((PluginEvent)new ProgramSelectionPluginEvent(this.getName(), selection, provider.getProgram()));
    }

    public void handleProviderHighlightChanged(FGProvider provider, ProgramSelection highlight) {
        if (provider != this.connectedProvider) {
            return;
        }
        if (highlight == null) {
            return;
        }
        this.firePluginEvent((PluginEvent)new ProgramHighlightPluginEvent(this.getName(), highlight, provider.getProgram()));
    }

    public void setUserDefinedFormat(FormatManager formatManager) {
        this.userDefinedFormatManager = formatManager;
        this.tool.setConfigChanged(true);
    }

    public FormatManager getUserDefinedFormat() {
        return this.userDefinedFormatManager;
    }

    public void readConfigState(SaveState saveState) {
        Element formatElement = saveState.getXmlElement(USER_DEFINED_FORMAT_CONFIG_NAME);
        if (formatElement != null) {
            OptionsService options = (OptionsService)this.getTool().getService(OptionsService.class);
            ToolOptions displayOptions = options.getOptions("Listing Display");
            ToolOptions fieldOptions = options.getOptions("Listing Fields");
            this.userDefinedFormatManager = new FormatManager(displayOptions, fieldOptions);
            SaveState formatState = new SaveState(formatElement);
            this.userDefinedFormatManager.readState(formatState);
            this.connectedProvider.formatChanged();
        }
        this.colorProvider.savePluginColors(saveState);
        this.connectedProvider.readConfigState(saveState);
    }

    public void writeConfigState(SaveState saveState) {
        if (this.userDefinedFormatManager != null) {
            SaveState formatState = new SaveState();
            this.userDefinedFormatManager.saveState(formatState);
            Element element = formatState.saveToXml();
            saveState.putXmlElement(USER_DEFINED_FORMAT_CONFIG_NAME, element);
        }
        this.colorProvider.loadPluginColor(saveState);
        if (this.connectedProvider != null) {
            this.connectedProvider.writeConfigState(saveState);
        }
    }

    public void writeDataState(SaveState saveState) {
        if (this.connectedProvider != null) {
            this.connectedProvider.writeDataState(saveState);
            this.connectedProvider.writeConfigState(saveState);
        }
        saveState.putInt(DISCONNECTED_COUNT_ID, this.disconnectedProviders.size());
        int i = 0;
        for (FGProvider provider : this.disconnectedProviders) {
            SaveState providerSaveState = new SaveState();
            DomainFile df = provider.getProgram().getDomainFile();
            if (df.getParent() == null) continue;
            String programPathname = df.getPathname();
            providerSaveState.putString(PROGRAM_PATH_ID, programPathname);
            provider.writeDataState(providerSaveState);
            provider.writeConfigState(providerSaveState);
            String disconnectedName = PROVIDER_ID + i;
            saveState.putXmlElement(disconnectedName, providerSaveState.saveToXml());
            ++i;
        }
    }

    public void readDataState(SaveState saveState) {
        ProgramManager programManagerService = (ProgramManager)this.tool.getService(ProgramManager.class);
        if (this.connectedProvider != null) {
            this.connectedProvider.readDataState(saveState);
            this.connectedProvider.readConfigState(saveState);
        }
        int numDisconnected = saveState.getInt(DISCONNECTED_COUNT_ID, 0);
        for (int i = 0; i < numDisconnected; ++i) {
            Program program;
            String disconnectedName = PROVIDER_ID + i;
            Element xmlElement = saveState.getXmlElement(disconnectedName);
            SaveState providerSaveState = new SaveState(xmlElement);
            String programPath = providerSaveState.getString(PROGRAM_PATH_ID, "");
            DomainFile file = this.tool.getProject().getProjectData().getFile(programPath);
            if (file == null || (program = programManagerService.openProgram(file)) == null) continue;
            FGProvider provider = this.createNewDisconnectedProvider();
            provider.doSetProgram(program);
            provider.readDataState(providerSaveState);
            provider.readConfigState(providerSaveState);
        }
    }

    public FGColorProvider getColorProvider() {
        return this.colorProvider;
    }

    public FunctionGraphOptions getFunctionGraphOptions() {
        return this.functionGraphOptions;
    }

    public List<FGLayoutProvider> getLayoutProviders() {
        return Collections.unmodifiableList(this.layoutProviders);
    }
}

