/*
 * Decompiled with CFR 0.152.
 */
package generic.lsh.vector;

import generic.lsh.vector.IDFLookup;
import generic.lsh.vector.LSHVector;
import generic.lsh.vector.VectorCompare;
import generic.lsh.vector.WeightFactory;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import org.xml.sax.SAXException;

public abstract class LSHVectorFactory {
    protected WeightFactory weightFactory = null;
    protected IDFLookup idfLookup = null;
    protected int settings;

    public abstract LSHVector buildZeroVector();

    public abstract LSHVector buildVector(int[] var1);

    public abstract LSHVector restoreVectorFromXml(XmlPullParser var1);

    public abstract LSHVector restoreVectorFromSql(String var1) throws IOException;

    public void set(WeightFactory wFactory, IDFLookup iLookup, int settings) {
        this.weightFactory = wFactory;
        this.idfLookup = iLookup;
        this.settings = settings;
    }

    public boolean isLoaded() {
        return this.idfLookup != null && !this.idfLookup.empty();
    }

    public double getSignificanceScale() {
        return this.weightFactory.getScale();
    }

    public double getSignificanceAddend() {
        return this.weightFactory.getAddend();
    }

    public int getSettings() {
        return this.settings;
    }

    public double getSelfSignificance(LSHVector vector) {
        return vector.getLength() * vector.getLength() + this.weightFactory.getAddend();
    }

    public double calculateSignificance(VectorCompare data) {
        data.fillOut();
        return data.dotproduct - (double)data.numflip * (this.weightFactory.getFlipNorm0() + this.weightFactory.getFlipNorm1() / (double)data.max) - (double)data.diff * (this.weightFactory.getDiffNorm0() + this.weightFactory.getDiffNorm1() / (double)data.max) + this.weightFactory.getAddend();
    }

    public void readWeights(XmlPullParser parser) throws SAXException {
        this.weightFactory = new WeightFactory();
        this.idfLookup = new IDFLookup();
        boolean foundweights = false;
        boolean foundlookup = false;
        XmlElement el = parser.start(new String[0]);
        this.settings = Integer.decode(el.getAttribute("settings"));
        el = parser.peek();
        while (el.isStart()) {
            if (el.getName().equals("weightfactory")) {
                this.weightFactory.restoreXml(parser);
                foundweights = true;
            } else if (el.getName().equals("idflookup")) {
                this.idfLookup.restoreXml(parser);
                foundlookup = true;
            } else {
                parser.discardSubTree();
            }
            el = parser.peek();
        }
        if (!foundweights) {
            throw new SAXException("Could not find <weightfactory> tag in configuration");
        }
        if (!foundlookup) {
            throw new SAXException("Could not find <idflookup> tag in configuration");
        }
    }
}

