/*
 * Decompiled with CFR 0.152.
 */
package generic.theme.laf;

import generic.theme.ApplicationThemeManager;
import generic.theme.ColorValue;
import generic.theme.GColor;
import generic.theme.GThemeValueMap;
import generic.theme.LafType;
import generic.theme.laf.LookAndFeelManager;
import generic.theme.laf.UiDefaultsMapper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.UIDefaults;
import javax.swing.border.EmptyBorder;

public class MacLookAndFeelManager
extends LookAndFeelManager {
    public MacLookAndFeelManager(ApplicationThemeManager themeManager) {
        super(LafType.MAC, themeManager);
    }

    @Override
    protected UiDefaultsMapper getUiDefaultsMapper(UIDefaults defaults) {
        return new MacUiDefaultsMapper(defaults);
    }

    private static class MacUiDefaultsMapper
    extends UiDefaultsMapper {
        protected MacUiDefaultsMapper(UIDefaults defaults) {
            super(defaults);
        }

        @Override
        protected GThemeValueMap extractColorFontAndIconValuesFromDefaults() {
            Color menuSelectionColor = new Color(0, 103, 214);
            GThemeValueMap map = super.extractColorFontAndIconValuesFromDefaults();
            map.addColor(new ColorValue("Menu.selectionBackground", menuSelectionColor));
            map.addColor(new ColorValue("MenuBar.selectionBackground", menuSelectionColor));
            map.addColor(new ColorValue("MenuItem.selectionBackground", menuSelectionColor));
            map.addColor(new ColorValue("PopupMenu.selectionBackground", menuSelectionColor));
            map.addColor(new ColorValue("ComboBox.selectionBackground", menuSelectionColor));
            map.addColor(new ColorValue("RadioButtonMenuItem.selectionBackground", menuSelectionColor));
            map.addColor(new ColorValue("CheckBoxMenuItem.selectionBackground", menuSelectionColor));
            return map;
        }

        @Override
        public void installValuesIntoUIDefaults(GThemeValueMap currentValues) {
            super.installValuesIntoUIDefaults(currentValues);
            this.defaults.put("MenuBar.backgroundPainter", BorderFactory.createEmptyBorder());
            this.defaults.put("MenuBar.selectedBackgroundPainter", new BackgroundBorder(new GColor("laf.color.MenuBar.selectionBackground")));
            this.defaults.put("MenuItem.selectedBackgroundPainter", new BackgroundBorder(new GColor("laf.color.MenuItem.selectionBackground")));
        }
    }

    private static class BackgroundBorder
    extends EmptyBorder {
        private GColor selectedMenuBacgroundColor;

        public BackgroundBorder(GColor color) {
            super(0, 0, 0, 0);
            this.selectedMenuBacgroundColor = color;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(this.selectedMenuBacgroundColor);
            g.fillRect(x, y, width, height);
        }
    }
}

