/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.reachability;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.app.plugin.core.reachability.FRVertex;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.block.CodeBlockReference;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.PreviewTableCellData;
import ghidra.util.table.field.PreviewTableColumn;
import ghidra.util.task.TaskMonitor;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class FRPathsModel
extends AddressBasedTableModel<FRVertex> {
    private List<FRVertex> path = Collections.emptyList();

    protected FRPathsModel(ServiceProvider serviceProvider, Program program) {
        super("Function Reachability Paths Model", serviceProvider, program, null);
    }

    @Override
    protected TableColumnDescriptor<FRVertex> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new FunctionTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new FRPreviewTableColumn());
        return descriptor;
    }

    protected void doLoad(Accumulator<FRVertex> accumulator, TaskMonitor monitor) throws CancelledException {
        accumulator.addAll(this.path);
    }

    protected Comparator<FRVertex> createSortComparator(int columnIndex) {
        return (o1, o2) -> this.path.indexOf(o1) - this.path.indexOf(o2);
    }

    public boolean isSortable(int columnIndex) {
        return false;
    }

    void setPath(List<FRVertex> path) {
        this.path = path;
        this.reload();
    }

    @Override
    public Address getAddress(int row) {
        Address address = this.getReferentAddress(row);
        if (address != null) {
            return address;
        }
        FRVertex v = (FRVertex)this.getRowObject(row);
        return v.getAddress();
    }

    private Address getReferentAddress(int row) {
        FRVertex caller;
        if (row == 0) {
            return null;
        }
        FRVertex rowObject = (FRVertex)this.getRowObject(row);
        CodeBlockReference reference = rowObject.getReference(caller = (FRVertex)this.getRowObject(row - 1));
        if (reference == null) {
            return null;
        }
        return reference.getReferent();
    }

    private class FunctionTableColumn
    extends AbstractDynamicTableColumn<FRVertex, String, Program> {
        private FunctionTableColumn() {
        }

        public String getColumnName() {
            return "Function";
        }

        public String getValue(FRVertex rowObject, Settings settings, Program p, ServiceProvider sp) throws IllegalArgumentException {
            FunctionManager fm = p.getFunctionManager();
            Function f = fm.getFunctionAt(rowObject.getAddress());
            return f.toString();
        }
    }

    private class FRPreviewTableColumn
    extends AbstractDynamicTableColumn<FRVertex, PreviewTableCellData, Program> {
        private PreviewTableColumn previewTableColumn = new PreviewTableColumn();

        private FRPreviewTableColumn() {
        }

        public String getColumnName() {
            return "From";
        }

        public String getColumnDescription() {
            return "A preview of the code unit calling this function";
        }

        public PreviewTableCellData getValue(FRVertex rowObject, Settings settings, Program data, ServiceProvider sp) throws IllegalArgumentException {
            int row = FRPathsModel.this.getRowIndex(rowObject);
            if (row == 0) {
                return null;
            }
            FRVertex caller = (FRVertex)FRPathsModel.this.getRowObject(row - 1);
            CodeBlockReference reference = rowObject.getReference(caller);
            if (reference == null) {
                return null;
            }
            Address address = reference.getReferent();
            ProgramLocation location = new ProgramLocation(data, address);
            PreviewTableCellData preview = this.previewTableColumn.getValue(location, settings, data, sp);
            return preview;
        }
    }
}

