/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.services;

import ghidra.app.plugin.core.progmgr.ProgramManagerPlugin;
import ghidra.framework.model.DomainFile;
import ghidra.framework.plugintool.ServiceInfo;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import java.awt.Component;
import java.net.URL;

@ServiceInfo(defaultProvider={ProgramManagerPlugin.class}, description="Get the currently open program")
public interface ProgramManager {
    public static final int OPEN_HIDDEN = 0;
    public static final int OPEN_CURRENT = 1;
    public static final int OPEN_VISIBLE = 2;

    public Program getCurrentProgram();

    public boolean isVisible(Program var1);

    public boolean closeProgram();

    public Program openProgram(URL var1, int var2);

    public Program openProgram(DomainFile var1);

    @Deprecated
    public Program openProgram(DomainFile var1, Component var2);

    public Program openProgram(DomainFile var1, int var2);

    public Program openProgram(DomainFile var1, int var2, int var3);

    public void openProgram(Program var1);

    @Deprecated
    public void openProgram(Program var1, boolean var2);

    public void openProgram(Program var1, int var2);

    public void saveProgram();

    public void saveProgram(Program var1);

    public void saveProgramAs();

    public void saveProgramAs(Program var1);

    @Deprecated(forRemoval=true, since="10.2")
    public boolean setPersistentOwner(Program var1, Object var2);

    @Deprecated(forRemoval=true, since="10.2")
    public void releaseProgram(Program var1, Object var2);

    public boolean closeProgram(Program var1, boolean var2);

    public boolean closeOtherPrograms(boolean var1);

    public boolean closeAllPrograms(boolean var1);

    public void setCurrentProgram(Program var1);

    public Program getProgram(Address var1);

    public Program[] getAllOpenPrograms();

    @Deprecated
    public void lockDown(boolean var1);

    @Deprecated
    public boolean isLocked();
}

