/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti.types;

import ghidra.app.util.bin.format.golang.rtti.types.GoType;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.Markup;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import java.io.IOException;
import java.util.Set;

@StructureMapping(structureName="runtime.arraytype")
public class GoArrayType
extends GoType {
    @FieldMapping
    private long elem;
    @FieldMapping
    private long slice;
    @FieldMapping
    private long len;

    @Markup
    public GoType getElement() throws IOException {
        return this.programContext.getGoType(this.elem);
    }

    @Markup
    public GoType getSliceType() throws IOException {
        return this.programContext.getGoType(this.slice);
    }

    @Override
    public DataType recoverDataType() throws IOException {
        DataType elementDt = this.programContext.getRecoveredType(this.getElement());
        DataType self = this.programContext.getCachedRecoveredDataType(this);
        if (self != null) {
            return self;
        }
        return new ArrayDataType(elementDt, (int)this.len, -1);
    }

    @Override
    public boolean discoverGoTypes(Set<Long> discoveredTypes) throws IOException {
        if (!super.discoverGoTypes(discoveredTypes)) {
            return false;
        }
        GoType elementType = this.getElement();
        GoType sliceType = this.getSliceType();
        if (elementType != null) {
            elementType.discoverGoTypes(discoveredTypes);
        }
        if (sliceType != null) {
            sliceType.discoverGoTypes(discoveredTypes);
        }
        return true;
    }
}

