/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.DataDirectory;
import ghidra.app.util.bin.format.pe.DelayImportDescriptor;
import ghidra.app.util.bin.format.pe.ImportByName;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.PeUtils;
import ghidra.app.util.bin.format.pe.ThunkData;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer32DataType;
import ghidra.program.model.data.Pointer64DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DelayImportDataDirectory
extends DataDirectory {
    private static final String NAME = "IMAGE_DIRECTORY_ENTRY_DELAY_IMPORT";
    private DelayImportDescriptor[] descriptors;

    DelayImportDataDirectory(NTHeader ntHeader, BinaryReader reader) throws IOException {
        this.processDataDirectory(ntHeader, reader);
        if (this.descriptors == null) {
            this.descriptors = new DelayImportDescriptor[0];
        }
    }

    public DelayImportDescriptor[] getDelayImportDescriptors() {
        return this.descriptors;
    }

    @Override
    public String getDirectoryName() {
        return NAME;
    }

    @Override
    public boolean parse() throws IOException {
        DelayImportDescriptor did;
        int ptr = this.getPointer();
        if (ptr < 0) {
            return false;
        }
        ArrayList<DelayImportDescriptor> list = new ArrayList<DelayImportDescriptor>();
        while ((did = new DelayImportDescriptor(this.ntHeader, this.reader, ptr)).isValid() && did.getPointerToDLLName() != 0L) {
            list.add(did);
            ptr += did.sizeof();
        }
        this.descriptors = new DelayImportDescriptor[list.size()];
        list.toArray(this.descriptors);
        return true;
    }

    @Override
    public void markup(Program program, boolean isBinary, TaskMonitor monitor, MessageLog log, NTHeader ntHeader) throws DuplicateNameException, CodeUnitInsertionException, IOException {
        monitor.setMessage(program.getName() + ": delay import(s)...");
        Address addr = PeUtils.getMarkupAddress(program, isBinary, ntHeader, this.virtualAddress);
        if (!program.getMemory().contains(addr)) {
            return;
        }
        this.createDirectoryBookmark(program, addr);
        AddressSpace space = program.getAddressFactory().getDefaultAddressSpace();
        for (DelayImportDescriptor descriptor : this.descriptors) {
            if (monitor.isCancelled()) {
                return;
            }
            PeUtils.createData(program, addr, descriptor.toDataType(), log);
            this.createSymbol(program, addr, SymbolUtilities.getAddressAppendedName((String)"ImgDelayDescr", (Address)addr));
            Data data = program.getListing().getDataAt(addr);
            if (data == null || !data.isDefined()) continue;
            if (data.getNumComponents() < 7) {
                Msg.info((Object)this, (Object)("Unexpected data at " + addr));
                continue;
            }
            Address tmpAddr = this.addr(space, isBinary, descriptor, descriptor.getPointerToDLLName());
            this.createTerminatedString(program, tmpAddr, true, log);
            tmpAddr = this.addr(space, isBinary, descriptor, descriptor.getAddressOfModuleHandle());
            this.createSymbol(program, tmpAddr, SymbolUtilities.getAddressAppendedName((String)"ImgDelayDescr_Module_Handle", (Address)tmpAddr));
            tmpAddr = this.addr(space, isBinary, descriptor, descriptor.getAddressOfIAT());
            this.createSymbol(program, tmpAddr, SymbolUtilities.getAddressAppendedName((String)"ImgDelayDescr_IAT", (Address)tmpAddr));
            this.markupThunk(program, isBinary, space, descriptor, descriptor.getAddressOfIAT(), descriptor.getThunksIAT(), true, monitor, log);
            tmpAddr = this.addr(space, isBinary, descriptor, descriptor.getAddressOfINT());
            this.createSymbol(program, tmpAddr, SymbolUtilities.getAddressAppendedName((String)"ImgDelayDescr_INT", (Address)tmpAddr));
            this.markupThunk(program, isBinary, space, descriptor, descriptor.getAddressOfINT(), descriptor.getThunksINT(), false, monitor, log);
            if (descriptor.getAddressOfBoundIAT() != 0L) {
                tmpAddr = this.addr(space, isBinary, descriptor, descriptor.getAddressOfBoundIAT());
                this.createSymbol(program, tmpAddr, SymbolUtilities.getAddressAppendedName((String)"ImgDelayDescr_Bound_IAT", (Address)tmpAddr));
                this.markupThunk(program, isBinary, space, descriptor, descriptor.getAddressOfBoundIAT(), descriptor.getThunksBoundIAT(), false, monitor, log);
            }
            if (descriptor.getAddressOfOriginalIAT() != 0L) {
                tmpAddr = this.addr(space, isBinary, descriptor, descriptor.getAddressOfOriginalIAT());
                this.createSymbol(program, tmpAddr, SymbolUtilities.getAddressAppendedName((String)"ImgDelayDescr_Unload_IAT", (Address)tmpAddr));
                this.markupThunk(program, isBinary, space, descriptor, descriptor.getAddressOfOriginalIAT(), descriptor.getThunksUnloadIAT(), false, monitor, log);
            }
            this.markupImportByName(program, isBinary, space, descriptor, monitor, log);
            addr = addr.add((long)descriptor.sizeof());
        }
    }

    private void createSymbol(Program program, Address addr, String name) {
        try {
            program.getSymbolTable().createLabel(addr, name, SourceType.IMPORTED);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Address addr(AddressSpace space, boolean isBinary, DelayImportDescriptor descriptor, long addr) {
        if (!isBinary) {
            if (descriptor.isUsingRVA()) {
                return space.getAddress(addr + this.ntHeader.getOptionalHeader().getImageBase());
            }
            return space.getAddress(addr);
        }
        if (!descriptor.isUsingRVA()) {
            addr -= this.ntHeader.getOptionalHeader().getImageBase();
        }
        long va = this.va(addr, isBinary);
        return space.getAddress(va);
    }

    private void markupImportByName(Program program, boolean isBinary, AddressSpace space, DelayImportDescriptor descriptor, TaskMonitor monitor, MessageLog log) throws DuplicateNameException {
        Map<ThunkData, ImportByName> map = descriptor.getImportByNameMap();
        Iterator<ThunkData> thunks = map.keySet().iterator();
        while (thunks.hasNext()) {
            if (monitor.isCancelled()) {
                return;
            }
            ThunkData thunk = thunks.next();
            long thunkPtr = this.va(thunk.getAddressOfData(), isBinary);
            if (!descriptor.isUsingRVA()) {
                thunkPtr -= this.ntHeader.getOptionalHeader().getImageBase();
            }
            Address thunkAddress = space.getAddress(thunkPtr);
            ImportByName ibn = map.get(thunk);
            PeUtils.createData(program, thunkAddress, ibn.toDataType(), log);
        }
    }

    private void markupThunk(Program program, boolean isBinary, AddressSpace space, DelayImportDescriptor descriptor, long ptr, List<ThunkData> thunks, boolean isIAT, TaskMonitor monitor, MessageLog log) {
        boolean is64bit = this.ntHeader.getOptionalHeader().is64bit();
        long thunkPtr = this.va(ptr, isBinary);
        if (!descriptor.isUsingRVA()) {
            thunkPtr -= this.ntHeader.getOptionalHeader().getImageBase();
        }
        for (ThunkData thunk : thunks) {
            if (monitor.isCancelled()) {
                return;
            }
            Object dt = thunk.isOrdinal() || thunk.getAddressOfData() == 0L ? (is64bit ? QWORD : DWORD) : (isIAT ? (is64bit ? Pointer64DataType.dataType : Pointer32DataType.dataType) : (is64bit ? IBO64 : IBO32));
            Address thunkAddress = space.getAddress(thunkPtr);
            PeUtils.createData(program, thunkAddress, dt, log);
            this.setEolComment(program, thunkAddress, thunk.getStructName());
            thunkPtr += (long)thunk.getStructSize();
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        for (DelayImportDescriptor descriptor : this.descriptors) {
            struct.add(descriptor.toDataType(), "ImgDelayDescr", null);
        }
        struct.setCategoryPath(new CategoryPath("/PE"));
        return struct;
    }
}

