/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.exporter;

import ghidra.program.model.address.Address;

abstract class AbstractLineDispenser {
    protected boolean isHTML = false;
    protected int width = 0;
    protected int fillAmount = 0;
    protected String prefix;
    protected int index = 0;

    AbstractLineDispenser() {
    }

    abstract boolean hasMoreLines();

    abstract String getNextLine();

    abstract void dispose();

    static String getUniqueAddressString(Address addr) {
        return addr.toString();
    }

    static String getFill(int amt) {
        StringBuffer fill = new StringBuffer();
        for (int i = 0; i < amt; ++i) {
            fill.append(" ");
        }
        return fill.toString();
    }

    String getFill() {
        int amt = this.fillAmount + (this.hasMoreLines() ? 0 : this.width);
        return AbstractLineDispenser.getFill(amt);
    }

    static String clip(String s, int width) {
        return AbstractLineDispenser.clip(s, width, true, true);
    }

    static String clip(String s, int width, boolean padIfShorter, boolean leftJustify) {
        if (width < 0) {
            return "";
        }
        if (s.length() <= width) {
            if (leftJustify) {
                return s + (padIfShorter ? AbstractLineDispenser.getFill(width - s.length()) : "");
            }
            return (padIfShorter ? AbstractLineDispenser.getFill(width - s.length()) : "") + s;
        }
        switch (width) {
            case 0: {
                return "";
            }
            case 1: {
                return ".";
            }
            case 2: {
                return "..";
            }
            case 3: {
                return "...";
            }
        }
        return s.substring(0, width - 3) + "...";
    }
}

