/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pcode;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.CompositeAttributedString;
import generic.theme.GColor;
import ghidra.app.plugin.processors.sleigh.template.OpTpl;
import ghidra.app.util.pcode.AbstractAppender;
import ghidra.app.util.pcode.AbstractPcodeFormatter;
import ghidra.app.util.pcode.Appender;
import ghidra.app.util.viewer.field.ListingColors;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import java.awt.Color;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.List;

public class AttributedStringPcodeFormatter
extends AbstractPcodeFormatter<List<AttributedString>, ToAttributedStringsAppender> {
    private int maxDisplayLines = 0;
    private boolean displayRawPcode = false;
    private FontMetrics metrics;
    private AttributedString aSpace;
    private AttributedString aEquals;
    private AttributedString aComma;
    private AttributedString aLeftParen;
    private AttributedString aRightParen;
    private AttributedString aLeftBracket;
    private AttributedString aRightBracket;
    private AttributedString aStar;
    private AttributedString aColon;
    private AttributedString aQuote;

    public AttributedStringPcodeFormatter() {
        this.initPunctuation();
    }

    public void setFontMetrics(FontMetrics metrics) {
        this.metrics = metrics;
        this.initPunctuation();
    }

    public void setOptions(int maxDisplayLines, boolean displayRawPcode) {
        this.maxDisplayLines = maxDisplayLines;
        this.displayRawPcode = displayRawPcode;
    }

    private void initPunctuation() {
        this.aSpace = new AttributedString(" ", (Color)ListingColors.SEPARATOR, this.metrics);
        this.aEquals = new AttributedString(" = ", (Color)ListingColors.SEPARATOR, this.metrics);
        this.aComma = new AttributedString(",", (Color)ListingColors.SEPARATOR, this.metrics);
        this.aLeftParen = new AttributedString("(", (Color)ListingColors.SEPARATOR, this.metrics);
        this.aRightParen = new AttributedString(")", (Color)ListingColors.SEPARATOR, this.metrics);
        this.aLeftBracket = new AttributedString("[", (Color)ListingColors.SEPARATOR, this.metrics);
        this.aRightBracket = new AttributedString("]", (Color)ListingColors.SEPARATOR, this.metrics);
        this.aStar = new AttributedString("*", (Color)ListingColors.SEPARATOR, this.metrics);
        this.aColon = new AttributedString(":", (Color)ListingColors.SEPARATOR, this.metrics);
        this.aQuote = new AttributedString("\"", (Color)ListingColors.SEPARATOR, this.metrics);
    }

    protected ToAttributedStringsAppender createAppender(Language language, boolean indent) {
        return new ToAttributedStringsAppender(language, indent);
    }

    public boolean isFormatRaw() {
        return this.displayRawPcode;
    }

    protected AbstractPcodeFormatter.FormatResult formatOpTemplate(ToAttributedStringsAppender appender, OpTpl op) {
        if (this.maxDisplayLines > 0 && appender.getLineCount() >= this.maxDisplayLines) {
            return AbstractPcodeFormatter.FormatResult.TERMINATE;
        }
        appender.startLine();
        AbstractPcodeFormatter.FormatResult result = super.formatOpTemplate((Appender)appender, op);
        appender.endLine();
        return result;
    }

    class ToAttributedStringsAppender
    extends AbstractAppender<List<AttributedString>> {
        private final List<AttributedString> list;
        private List<AttributedString> lineList;

        public ToAttributedStringsAppender(Language language, boolean indent) {
            super(language, indent);
            this.list = new ArrayList<AttributedString>();
        }

        int getLineCount() {
            return this.list.size();
        }

        void startLine() {
            this.lineList = new ArrayList<AttributedString>();
        }

        void endLine() {
            this.list.add((AttributedString)new CompositeAttributedString(this.lineList));
        }

        public void appendLineLabelRef(long label) {
            this.lineList.add(new AttributedString(this.stringifyLineLabel(label), (Color)ListingColors.PcodeColors.LABEL, AttributedStringPcodeFormatter.this.metrics));
        }

        public void appendMnemonic(int opcode) {
            GColor color = opcode == 0 ? ListingColors.MnemonicColors.UNIMPLEMENTED : ListingColors.MnemonicColors.NORMAL;
            this.lineList.add(new AttributedString(this.stringifyOpMnemonic(opcode), (Color)color, AttributedStringPcodeFormatter.this.metrics));
        }

        public void appendUserop(int id) {
            this.lineList.add(new AttributedString(this.stringifyUserop(this.language, id), (Color)ListingColors.PcodeColors.USEROP, AttributedStringPcodeFormatter.this.metrics));
        }

        public void appendRawVarnode(AddressSpace space, long offset, long size) {
            this.lineList.add(new AttributedString(this.stringifyRawVarnode(space, offset, size), (Color)ListingColors.PcodeColors.VARNODE, AttributedStringPcodeFormatter.this.metrics));
        }

        private AttributedString getAttributedChar(char c) {
            switch (c) {
                case ' ': {
                    return AttributedStringPcodeFormatter.this.aSpace;
                }
                case '=': {
                    return AttributedStringPcodeFormatter.this.aEquals;
                }
                case ',': {
                    return AttributedStringPcodeFormatter.this.aComma;
                }
                case '(': {
                    return AttributedStringPcodeFormatter.this.aLeftParen;
                }
                case ')': {
                    return AttributedStringPcodeFormatter.this.aRightParen;
                }
                case '[': {
                    return AttributedStringPcodeFormatter.this.aLeftBracket;
                }
                case ']': {
                    return AttributedStringPcodeFormatter.this.aRightBracket;
                }
                case '*': {
                    return AttributedStringPcodeFormatter.this.aStar;
                }
                case ':': {
                    return AttributedStringPcodeFormatter.this.aColon;
                }
                case '\"': {
                    return AttributedStringPcodeFormatter.this.aQuote;
                }
            }
            throw new AssertionError();
        }

        public void appendCharacter(char c) {
            this.lineList.add(this.getAttributedChar(c));
        }

        public void appendAddressWordOffcut(long wordOffset, long offcut) {
            this.lineList.add(new AttributedString(this.stringifyWordOffcut(wordOffset, offcut), (Color)ListingColors.ADDRESS, AttributedStringPcodeFormatter.this.metrics));
        }

        public void appendLabel(String label) {
            this.lineList.add(new AttributedString(label, (Color)ListingColors.LabelColors.LOCAL, AttributedStringPcodeFormatter.this.metrics));
        }

        public void appendRegister(Register register) {
            this.lineList.add(new AttributedString(this.stringifyRegister(register), (Color)ListingColors.REGISTER, AttributedStringPcodeFormatter.this.metrics));
        }

        public void appendScalar(long value) {
            this.lineList.add(new AttributedString(this.stringifyScalarValue(value), (Color)ListingColors.CONSTANT, AttributedStringPcodeFormatter.this.metrics));
        }

        public void appendSpace(AddressSpace space) {
            this.lineList.add(new AttributedString(this.stringifySpace(space), (Color)ListingColors.PcodeColors.ADDRESS_SPACE, AttributedStringPcodeFormatter.this.metrics));
        }

        public void appendUnique(long offset) {
            this.lineList.add(new AttributedString(this.stringifyUnique(offset), (Color)ListingColors.LabelColors.LOCAL, AttributedStringPcodeFormatter.this.metrics));
        }

        public List<AttributedString> finish() {
            return this.list;
        }
    }
}

