/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.app.cmd.function.CallDepthChangeInfo;
import ghidra.pcode.opbehavior.BinaryOpBehavior;
import ghidra.pcode.opbehavior.OpBehaviorFactory;
import ghidra.pcode.opbehavior.UnaryOpBehavior;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.OverlayAddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DefaultDataType;
import ghidra.program.model.data.IntegerDataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.lang.InjectContext;
import ghidra.program.model.lang.InjectPayload;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.PcodeInjectLibrary;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.mem.ByteMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.util.ContextEvaluator;
import ghidra.program.util.ProgramContextImpl;
import ghidra.program.util.VarnodeContext;
import ghidra.util.BigEndianDataConverter;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.collections4.map.LRUMap;

public class SymbolicPropogator {
    private static int LRU_SIZE = 4096;
    private static final int _POINTER_MIN_BOUNDS = 256;
    private static long[] maskSize = new long[]{255L, 255L, 65535L, 0xFFFFFFL, 0xFFFFFFFFL, 0xFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, -1L};
    protected List<AddressSpace> memorySpaces;
    private boolean defaultSpacesAreTheSame = false;
    protected ContextEvaluator evaluator = null;
    protected Program program;
    protected ProgramContext programContext;
    protected ProgramContext spaceContext;
    protected ProgramContext savedProgramContext;
    protected ProgramContext savedSpaceContext;
    protected boolean canceled = false;
    protected boolean readExecutableAddress;
    protected VarnodeContext context;
    protected AddressSet visitedBody;
    protected boolean hitCodeFlow = false;
    protected boolean debug = false;
    private static final NotFoundException valueTooBigException = new NotFoundException("Value too big to fit in Scalar");
    private static final NotFoundException divideByZeroException = new NotFoundException("Divide by zero");
    private long pointerMask;
    private int pointerSize;
    private DataType pointerSizedDT = null;
    protected static final int MAX_EXACT_INSTRUCTIONS = 100;
    Map<Address, Address[]> instructionFlowsCache = new LRUMap(LRU_SIZE);
    Map<Address, PcodeOp[]> pcodeCache = new LRUMap(LRU_SIZE);
    Map<Address, Instruction> instructionAtCache = new LRUMap(LRU_SIZE);
    Map<Address, Instruction> instructionContainingCache = new LRUMap(LRU_SIZE);
    HashMap<Long, InjectPayload> injectPayloadCache = new HashMap();
    protected int lastFullHashCode = 0;
    protected int lastInstrCode = -1;
    protected int sameInstrCount = 0;
    private boolean checkForParamRefs = true;
    private boolean checkForParamPointerRefs = true;
    private boolean checkForReturnRefs = true;
    private boolean checkForStoredRefs = true;

    public SymbolicPropogator(Program program) {
        this.program = program;
        Language language = program.getLanguage();
        this.programContext = new ProgramContextImpl(language);
        this.spaceContext = new ProgramContextImpl(language);
        this.setPointerMask(program);
        this.context = new VarnodeContext(program, this.programContext, this.spaceContext);
        this.context.setDebug(this.debug);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
        this.context.setDebug(debug);
    }

    private void setPointerMask(Program program) {
        int ptrSize = program.getDefaultPointerSize();
        if (ptrSize > 8) {
            ptrSize = 8;
        }
        this.pointerSize = ptrSize;
        this.pointerMask = maskSize[ptrSize];
        this.pointerSizedDT = IntegerDataType.getUnsignedDataType((int)this.pointerSize, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddressSet flowConstants(Address startAddr, AddressSetView restrictSet, ContextEvaluator eval, boolean saveContext, TaskMonitor monitor) throws CancelledException {
        Register[] regWithVals;
        this.evaluator = eval;
        AddressSpace defaultDataSpace = this.program.getLanguage().getDefaultDataSpace();
        AddressSpace defaultSpace = this.program.getLanguage().getDefaultSpace();
        this.defaultSpacesAreTheSame = defaultSpace.equals(defaultDataSpace);
        AddressSpace defaultAddrSpace = this.program.getAddressFactory().getDefaultAddressSpace();
        this.memorySpaces = new ArrayList<AddressSpace>();
        for (AddressSpace space : this.program.getAddressFactory().getAddressSpaces()) {
            if (!space.isLoadedMemorySpace()) continue;
            if (space == defaultAddrSpace) {
                this.memorySpaces.add(0, space);
                continue;
            }
            this.memorySpaces.add(space);
        }
        this.savedProgramContext = this.programContext;
        this.savedSpaceContext = this.spaceContext;
        if (!saveContext) {
            this.context = this.saveOffCurrentContext(startAddr);
        }
        for (Register regWithVal : regWithVals = this.program.getProgramContext().getRegistersWithValues()) {
            RegisterValue regVal = this.program.getProgramContext().getRegisterValue(regWithVal, startAddr);
            if (regVal == null || !regVal.hasValue()) continue;
            this.context.setFutureRegisterValue(startAddr, regVal);
            if (!regVal.getRegister().getAddress().isMemoryAddress()) continue;
            Register reg = regVal.getRegister();
            this.context.putValue(this.context.getRegisterVarnode(reg), this.context.createConstantVarnode(regVal.getUnsignedValue().longValue(), reg.getMinimumByteSize()), false);
        }
        AddressSet bodyDone = null;
        try {
            bodyDone = this.flowConstants(startAddr, restrictSet, eval, this.context, monitor);
        }
        finally {
            this.programContext = this.savedProgramContext;
            this.spaceContext = this.savedSpaceContext;
        }
        this.readExecutableAddress = this.context.readExecutableCode();
        return bodyDone;
    }

    protected VarnodeContext saveOffCurrentContext(Address startAddr) {
        Register[] regWithVals;
        Language language = this.program.getLanguage();
        ProgramContextImpl newValueContext = new ProgramContextImpl(language);
        ProgramContextImpl newSpaceContext = new ProgramContextImpl(language);
        VarnodeContext newContext = new VarnodeContext(this.program, (ProgramContext)newValueContext, (ProgramContext)newSpaceContext);
        newContext.setDebug(this.debug);
        int constantSpaceID = this.program.getAddressFactory().getConstantSpace().getSpaceID();
        for (Register regWithVal : regWithVals = this.programContext.getRegistersWithValues()) {
            RegisterValue regVal = this.programContext.getRegisterValue(regWithVal, startAddr);
            RegisterValue spRegVal = this.spaceContext.getRegisterValue(regWithVal, startAddr);
            if (regVal == null || spRegVal != null && (spRegVal.getUnsignedValue() == null || spRegVal.getUnsignedValue().longValue() != (long)constantSpaceID)) continue;
            newContext.setFutureRegisterValue(startAddr, regVal);
        }
        this.programContext = newValueContext;
        this.spaceContext = newSpaceContext;
        return newContext;
    }

    public Value getRegisterValue(Address toAddr, Register reg) {
        Varnode val = this.context.getRegisterVarnodeValue(reg, Address.NO_ADDRESS, toAddr, true);
        if (val == null) {
            return null;
        }
        if (this.context.isConstant(val)) {
            return new Value(val.getOffset());
        }
        AddressSpace space = val.getAddress().getAddressSpace();
        if (space.getName().startsWith("track_")) {
            return new Value(val.getOffset());
        }
        Register relativeReg = this.program.getRegister(space.getName());
        if (relativeReg != null) {
            return new Value(relativeReg, val.getOffset());
        }
        return null;
    }

    public String getRegisterValueRepresentation(Address addr, Register reg) {
        Varnode val = this.context.getRegisterVarnodeValue(reg, Address.NO_ADDRESS, addr, true);
        if (val == null) {
            return "-";
        }
        if (val.isConstant()) {
            return this.context.getRegisterValue(reg, Address.NO_ADDRESS, addr).toString();
        }
        AddressSpace space = val.getAddress().getAddressSpace();
        if (space.getName().startsWith("track_")) {
            return reg + "+" + BigInteger.valueOf(val.getOffset()).toString(16);
        }
        if (this.context.isSymbol(val)) {
            return val.getAddress().getAddressSpace().getName() + " + " + val.getOffset();
        }
        return "-";
    }

    public void setRegister(Address addr, Register stackReg) {
        this.context.flowStart(Address.NO_ADDRESS, addr);
        int spaceID = this.context.getAddressSpace(stackReg.getName());
        Varnode vnode = this.context.createVarnode(0L, spaceID, stackReg.getBitLength() / 8);
        this.context.putValue(this.context.getRegisterVarnode(stackReg), vnode, false);
        this.context.propogateResults(false);
        this.context.flowEnd(addr);
    }

    public AddressSet flowConstants(Address startAddr, AddressSetView restrictSet, ContextEvaluator eval, VarnodeContext vContext, TaskMonitor monitor) throws CancelledException {
        return this.flowConstants(Address.NO_ADDRESS, startAddr, restrictSet, eval, vContext, monitor);
    }

    public AddressSet flowConstants(Address fromAddr, Address startAddr, AddressSetView restrictSet, ContextEvaluator eval, VarnodeContext vContext, TaskMonitor monitor) throws CancelledException {
        boolean callCouldCauseBadStackDepth;
        this.visitedBody = new AddressSet();
        AddressSet conflicts = new AddressSet();
        Stack<SavedFlowState> contextStack = new Stack<SavedFlowState>();
        contextStack.push(new SavedFlowState(vContext, fromAddr, startAddr, true));
        this.canceled = false;
        boolean bl = callCouldCauseBadStackDepth = this.program.getCompilerSpec().getDefaultCallingConvention().getExtrapop() == 32768;
        while (!contextStack.isEmpty()) {
            monitor.checkCancelled();
            if (this.canceled) {
                this.visitedBody.add((AddressSetView)conflicts);
                return this.visitedBody;
            }
            boolean hitOtherFlow = false;
            SavedFlowState nextFlow = (SavedFlowState)contextStack.pop();
            Address nextAddr = nextFlow.getDestination();
            Address flowFromAddr = nextFlow.getSource();
            boolean continueAfterHittingFlow = nextFlow.isContinueAfterHittingFlow();
            nextFlow.restoreState(vContext);
            if (this.visitedBody.contains(nextAddr)) {
                hitOtherFlow = true;
                if (!continueAfterHittingFlow) continue;
            }
            vContext.flowStart(flowFromAddr, nextAddr);
            this.lastFullHashCode = 0;
            this.lastInstrCode = -1;
            this.sameInstrCount = 0;
            Address maxAddr = null;
            while (nextAddr != null) {
                Function func;
                Instruction instr;
                monitor.checkCancelled();
                if (this.visitedBody.contains(nextAddr)) {
                    hitOtherFlow = true;
                    if (!continueAfterHittingFlow) break;
                }
                if (restrictSet != null && !restrictSet.contains(nextAddr) || (instr = this.getInstructionAt(nextAddr)) == null) break;
                FlowType originalFlowType = instr.getFlowType();
                if (this.checkSameInstructionRun(instr)) break;
                Address minInstrAddress = instr.getMinAddress();
                maxAddr = instr.getMaxAddress();
                if (instr.getPrototype().hasDelaySlots()) {
                    maxAddr = minInstrAddress.add((long)(instr.getDefaultFallThroughOffset() - 1));
                }
                vContext.setCurrentInstruction(instr);
                vContext.flowToAddress(flowFromAddr, maxAddr);
                if (this.evaluator != null && this.evaluator.evaluateContextBefore(vContext, instr)) {
                    this.visitedBody.add((AddressSetView)conflicts);
                    return this.visitedBody;
                }
                Address retAddr = this.applyPcode(vContext, instr, monitor);
                this.visitedBody.addRange(minInstrAddress, maxAddr);
                if (this.evaluator != null && this.evaluator.evaluateContext(vContext, instr)) {
                    this.visitedBody.add((AddressSetView)conflicts);
                    return this.visitedBody;
                }
                FlowType instrFlow = instr.getFlowType();
                if (!originalFlowType.equals((Object)instrFlow) && instrFlow.isCall()) {
                    Address[] targets;
                    for (Address address : targets = this.getInstructionFlows(instr)) {
                        this.handleFunctionSideEffects(instr, address, monitor);
                    }
                }
                Address callFlowAddr = null;
                boolean simpleFlow = this.isSimpleFallThrough(instrFlow);
                this.hitCodeFlow |= !simpleFlow;
                boolean doFallThruLast = false;
                if (!simpleFlow) {
                    Address[] flows = this.getInstructionFlows(instr);
                    if (flows != null && flows.length > 0) {
                        if (hitOtherFlow) {
                            nextAddr = null;
                            break;
                        }
                        if (!instrFlow.isCall()) {
                            for (Address flow : flows) {
                                contextStack.push(new SavedFlowState(vContext, minInstrAddress, flow, continueAfterHittingFlow));
                            }
                        } else if (flows.length > 1) {
                            Reference[] referenceArray;
                            for (Reference flowRef : referenceArray = instr.getReferencesFrom()) {
                                RefType referenceType = flowRef.getReferenceType();
                                if (!referenceType.isComputed() || !referenceType.isJump()) continue;
                                contextStack.push(new SavedFlowState(vContext, minInstrAddress, flowRef.getToAddress(), continueAfterHittingFlow));
                            }
                        } else {
                            callFlowAddr = flows[0];
                        }
                    } else if (instrFlow.isComputed() && instrFlow.isCall()) {
                        doFallThruLast = true;
                    }
                }
                if (callFlowAddr != null && (func = this.program.getFunctionManager().getFunctionAt(callFlowAddr)) != null && func.isInline()) {
                    vContext.mergeToFutureFlowState(maxAddr, callFlowAddr);
                    vContext.flowEnd(maxAddr);
                    AddressSet addressSet = this.visitedBody;
                    this.flowConstants(maxAddr, callFlowAddr, func.getBody(), eval, vContext, monitor);
                    this.visitedBody = addressSet;
                    vContext.mergeToFutureFlowState(minInstrAddress, maxAddr);
                    vContext.flowStart(minInstrAddress, maxAddr);
                }
                Address fallThru = instr.getFallThrough();
                nextAddr = null;
                if (retAddr != null) {
                    contextStack.push(new SavedFlowState(vContext, minInstrAddress, retAddr, continueAfterHittingFlow));
                    fallThru = null;
                }
                if (fallThru == null) continue;
                if (doFallThruLast) {
                    vContext.mergeToFutureFlowState(minInstrAddress, fallThru);
                    contextStack.push(new SavedFlowState(vContext, minInstrAddress, fallThru, !callCouldCauseBadStackDepth));
                    continue;
                }
                if (fallThru.compareTo((Object)maxAddr) < 0) {
                    vContext.mergeToFutureFlowState(minInstrAddress, fallThru);
                    contextStack.push(new SavedFlowState(vContext, minInstrAddress, fallThru, false));
                    continue;
                }
                nextAddr = fallThru;
                fallThru = null;
            }
            vContext.flowEnd(maxAddr);
        }
        this.visitedBody.add((AddressSetView)conflicts);
        return this.visitedBody;
    }

    private boolean isSimpleFallThrough(FlowType instrFlow) {
        return !instrFlow.isCall() && !instrFlow.isJump() && !instrFlow.isTerminal() && instrFlow.hasFallthrough();
    }

    private boolean checkSameInstructionRun(Instruction instr) {
        if (this.lastInstrCode == instr.getPrototype().hashCode()) {
            if (this.lastFullHashCode == 0) {
                this.lastFullHashCode = -1;
            } else {
                int instrByteHashCode = -1;
                try {
                    instrByteHashCode = Arrays.hashCode(instr.getBytes());
                }
                catch (MemoryAccessException e) {
                    instrByteHashCode = instr.toString().hashCode();
                }
                if (this.lastFullHashCode == -1) {
                    this.lastFullHashCode = instrByteHashCode;
                }
                if (this.lastFullHashCode == instrByteHashCode) {
                    ++this.sameInstrCount;
                    if (this.sameInstrCount > 100) {
                        return true;
                    }
                } else {
                    this.lastFullHashCode = 0;
                    this.sameInstrCount = 0;
                }
            }
        } else {
            this.sameInstrCount = 0;
            this.lastFullHashCode = 0;
        }
        this.lastInstrCode = instr.getPrototype().hashCode();
        return false;
    }

    private PcodeOp[] getInstructionPcode(Instruction instruction) {
        PcodeOp[] ops = this.pcodeCache.get(instruction.getMinAddress());
        if (ops == null) {
            ops = instruction.getPcode(true);
            this.pcodeCache.put(instruction.getMinAddress(), ops);
        }
        return ops;
    }

    private Instruction getInstructionAt(Address addr) {
        Instruction instr = this.instructionAtCache.get(addr);
        if (instr != null) {
            return instr;
        }
        if (this.instructionAtCache.containsKey(addr)) {
            return null;
        }
        instr = this.program.getListing().getInstructionAt(addr);
        this.instructionAtCache.put(addr, instr);
        if (instr != null) {
            this.instructionContainingCache.put(instr.getMaxAddress(), instr);
        }
        return instr;
    }

    private Instruction getInstructionContaining(Address addr) {
        Instruction instr = this.getInstructionAt(addr);
        if (instr != null) {
            return instr;
        }
        instr = this.instructionContainingCache.get(addr);
        if (instr != null) {
            return instr;
        }
        if (this.instructionContainingCache.containsKey(addr)) {
            return null;
        }
        instr = this.program.getListing().getInstructionContaining(addr);
        this.instructionContainingCache.put(addr, instr);
        return instr;
    }

    private Address[] getInstructionFlows(Instruction instruction) {
        Address addr = instruction.getMinAddress();
        Address[] flows = this.instructionFlowsCache.get(addr);
        if (flows != null) {
            return flows;
        }
        flows = instruction.getFlows();
        this.instructionFlowsCache.put(addr, flows);
        return flows;
    }

    /*
     * Unable to fully structure code
     */
    private Address applyPcode(VarnodeContext vContext, Instruction instruction, TaskMonitor monitor) {
        nextAddr = null;
        if (instruction == null) {
            return nextAddr;
        }
        ops = this.getInstructionPcode(instruction);
        if (ops.length <= 0) {
            return nextAddr;
        }
        minInstrAddress = instruction.getMinAddress();
        if (this.debug) {
            Msg.info((Object)this, (Object)(minInstrAddress + "   " + instruction));
        }
        previousInjectionTarget = new HashSet<Address>();
        mustClearAllUntil_PcodeIndex = -1;
        mustClearAll = false;
        injected = false;
        ptype = 0;
        block57: for (pcodeIndex = 0; pcodeIndex < ops.length; ++pcodeIndex) {
            mustClearAll = pcodeIndex < mustClearAllUntil_PcodeIndex;
            pcodeOp = ops[pcodeIndex];
            ptype = pcodeOp.getOpcode();
            out = pcodeOp.getOutput();
            in = pcodeOp.getInputs();
            suspectOffset = false;
            if (this.debug) {
                Msg.info((Object)this, (Object)("   " + pcodeOp));
            }
            try {
                switch (ptype) {
                    case 1: {
                        if (in[0].isAddress() && !in[0].getAddress().getAddressSpace().hasMappedRegisters()) {
                            this.makeReference(vContext, instruction, -1, in[0], null, RefType.READ, ptype, true, monitor);
                        }
                        vContext.copy(out, in[0], mustClearAll, this.evaluator);
                        break;
                    }
                    case 2: {
                        val1 = vContext.getValue(in[0], this.evaluator);
                        val2 = vContext.getValue(in[1], this.evaluator);
                        suspectOffset = vContext.isSuspectConstant(val2);
                        vt = vContext.getVarnode(in[0], val2, out.getSize(), this.evaluator);
                        this.addLoadStoreReference(vContext, instruction, ptype, vt, in[0], in[1], RefType.READ, suspectOffset == false, monitor);
                        memVal = vContext.getValue(vt, this.evaluator);
                        vContext.putValue(out, memVal, mustClearAll);
                        break;
                    }
                    case 3: {
                        offs = null;
                        try {
                            offs = vContext.getValue(in[1], true, this.evaluator);
                            suspectOffset = vContext.isSuspectConstant(offs);
                            out = this.getStoredLocation(vContext, in[0], offs, in[2]);
                        }
                        catch (NotFoundException var30_31) {
                            // empty catch block
                        }
                        this.addLoadStoreReference(vContext, instruction, ptype, out, in[0], in[1], RefType.WRITE, suspectOffset == false, monitor);
                        val3 = vContext.getValue(in[2], null);
                        if (!injected) {
                            this.addStoredReferences(vContext, instruction, out, val3, monitor);
                        }
                        vContext.putValue(out, val3, mustClearAll);
                        break;
                    }
                    case 6: {
                        try {
                            val1 = vContext.getValue(in[0], this.evaluator);
                            suspectOffset = vContext.isSuspectConstant(val1);
                            vt = this.getConstantOrExternal(vContext, minInstrAddress, val1);
                            this.makeReference(vContext, instruction, -1, vt, null, (RefType)instruction.getFlowType(), ptype, suspectOffset == false, monitor);
                        }
                        catch (NotFoundException var30_32) {
                            // empty catch block
                        }
                        vContext.propogateResults(false);
                        for (Reference flowRef : flowRefs = instruction.getReferencesFrom()) {
                            referenceType = flowRef.getReferenceType();
                            if (!referenceType.isComputed() || !referenceType.isJump()) continue;
                            vContext.mergeToFutureFlowState(flowRef.getFromAddress(), flowRef.getToAddress());
                        }
                        if (this.evaluator == null || !this.evaluator.evaluateDestination(vContext, instruction)) continue block57;
                        this.canceled = true;
                        return null;
                    }
                    case 7: 
                    case 8: {
                        target = null;
                        func = null;
                        val1 = in[0];
                        if (ptype != 8) ** GOTO lbl99
                        try {
                            val1 = vContext.getValue(val1, this.evaluator);
                            if (vContext.isConstant(val1)) {
                                suspectOffset = vContext.isSuspectConstant(val1);
                                target = instruction.getAddress().getNewTruncatedAddress(val1.getOffset(), true);
                            } else if (val1.isAddress()) {
                                target = this.resolveFunctionReference(val1.getAddress());
                            } else if (vContext.isExternalSpace(val1.getSpace())) {
                                target = val1.getAddress();
                            }
                            if (!(target == null || (refs = instruction.getReferencesFrom()).length > 0 && refs[0].getToAddress().equals((Object)target))) {
                                target = this.makeReference(vContext, instruction, -1, target.getAddressSpace().getSpaceID(), target.getAddressableWordOffset(), val1.getSize(), null, (RefType)instruction.getFlowType(), ptype, suspectOffset == false, false, monitor);
                            }
                            ** GOTO lbl100
                        }
                        catch (NotFoundException e) {
                            val1 = null;
                        }
                        ** GOTO lbl100
lbl99:
                        // 1 sources

                        target = val1.getAddress();
lbl100:
                        // 4 sources

                        prog = instruction.getProgram();
                        if (target != null) {
                            if (target.isMemoryAddress()) {
                                vContext.propogateResults(false);
                                vContext.mergeToFutureFlowState(minInstrAddress, target);
                            }
                            if ((func = prog.getFunctionManager().getFunctionAt(target)) == null && ptype == 8 && (refs = instruction.getReferencesFrom()) != null && refs.length > 0 && ((firstRef = refs[0]).getReferenceType().isData() || firstRef.getReferenceType().isIndirect())) {
                                target = firstRef.getToAddress();
                                func = prog.getFunctionManager().getFunctionAt(target);
                            }
                            if (!previousInjectionTarget.contains(target) && (injectionPcode = this.checkForCallFixup(prog, func, instruction)) != null && injectionPcode.length > 0) {
                                previousInjectionTarget.add(target);
                                ops = this.injectPcode(ops, pcodeIndex, injectionPcode);
                                pcodeIndex = -1;
                                injected = true;
                                continue block57;
                            }
                        }
                        this.handleFunctionSideEffects(instruction, target, monitor);
                        injectionPcode = this.checkForUponReturnCallMechanismInjection(prog, func, target, instruction);
                        if (injectionPcode == null || injectionPcode.length <= 0) continue block57;
                        ops = this.injectPcode(ops, pcodeIndex, injectionPcode);
                        pcodeIndex = -1;
                        injected = true;
                        continue block57;
                    }
                    case 9: {
                        callOtherPcode = this.doCallOtherPcodeInjection(instruction, in, out);
                        if (callOtherPcode != null) {
                            ops = this.injectPcode(ops, pcodeIndex, callOtherPcode);
                            pcodeIndex = -1;
                            injected = true;
                            break;
                        }
                        if (out == null) continue block57;
                        vContext.putValue(out, vContext.createBadVarnode(), mustClearAll);
                        break;
                    }
                    case 4: {
                        if (in[0].isConstant()) {
                            sequenceOffset = (int)in[0].getOffset();
                            if (sequenceOffset < 0) {
                                pcodeIndex = ops.length;
                                break;
                            }
                            pcodeIndex += sequenceOffset - 1;
                            ptype = 0;
                            break;
                        }
                        if (!in[0].isAddress()) {
                            throw new AssertException("Not a valid Address on instruction at " + instruction.getAddress());
                        }
                        vContext.propogateResults(false);
                        vContext.mergeToFutureFlowState(minInstrAddress, in[0].getAddress());
                        pcodeIndex = ops.length;
                        break;
                    }
                    case 5: {
                        vt = null;
                        internalBranch = in[0].isConstant();
                        if (internalBranch) {
                            sequenceOffset = (int)in[0].getOffset();
                            if (pcodeIndex + sequenceOffset >= ops.length) {
                                vContext.propogateResults(false);
                                vContext.mergeToFutureFlowState(minInstrAddress, instruction.getFallThrough());
                            }
                        } else if (in[0].isAddress()) {
                            vt = in[0];
                            vContext.propogateResults(false);
                            vContext.mergeToFutureFlowState(minInstrAddress, in[0].getAddress());
                        }
                        condition = null;
                        try {
                            condition = vContext.getValue(in[1], null);
                        }
                        catch (NotFoundException e) {
                            fallThru = instruction.getFallThrough();
                            if (fallThru != null && vt != null && vt.getOffset() == fallThru.getOffset()) {
                                op = ops[ops.length - 1].getOpcode();
                                if (op == 4 || op == 10 || op == 6) {
                                    ptype = op;
                                } else {
                                    mustClearAllUntil_PcodeIndex = ops.length;
                                }
                            } else if (internalBranch) {
                                sequenceOffset = pcodeIndex + (int)in[0].getOffset();
                                for (i = pcodeIndex + 1; i < sequenceOffset && !this.isBranch(ops[i]); ++i) {
                                }
                                if (i == sequenceOffset) {
                                    mustClearAllUntil_PcodeIndex = sequenceOffset;
                                    break;
                                }
                            }
                            throw e;
                        }
                        lval1 = vContext.getConstant(condition, null);
                        if (lval1 == 0L) continue block57;
                        if (internalBranch) {
                            sequenceOffset = (int)in[0].getOffset();
                            if (sequenceOffset > 0) {
                                pcodeIndex += sequenceOffset - 1;
                                break;
                            }
                            if (this.evaluator.followFalseConditionalBranches()) continue block57;
                            pcodeIndex = ops.length;
                            break;
                        }
                        if (this.evaluator.followFalseConditionalBranches()) continue block57;
                        nextAddr = minInstrAddress.getAddressSpace().getOverlayAddress(in[0].getAddress());
                        pcodeIndex = ops.length;
                        break;
                    }
                    case 10: {
                        try {
                            val1 = vContext.getValue(in[0], this.evaluator);
                            if (this.evaluator != null && this.evaluator.evaluateReturn(val1, vContext, instruction)) {
                                this.canceled = true;
                                return null;
                            }
                        }
                        catch (NotFoundException sequenceOffset) {
                            // empty catch block
                        }
                        this.addReturnReferences(instruction, vContext, monitor);
                        break;
                    }
                    case 17: {
                        if (in[0].isAddress()) {
                            this.makeReference(vContext, instruction, -1, in[0], null, RefType.READ, ptype, true, monitor);
                        }
                        val1 = vContext.extendValue(out, in, false, this.evaluator);
                        vContext.putValue(out, val1, mustClearAll);
                        break;
                    }
                    case 18: {
                        if (in[0].isAddress()) {
                            this.makeReference(vContext, instruction, -1, in[0], null, RefType.READ, ptype, true, monitor);
                        }
                        val1 = vContext.extendValue(out, in, true, this.evaluator);
                        vContext.putValue(out, val1, mustClearAll);
                        break;
                    }
                    case 19: {
                        try {
                            val1 = vContext.getValue(in[0], false, this.evaluator);
                        }
                        catch (NotFoundException exc) {
                            val1 = vContext.createBadVarnode();
                        }
                        try {
                            val2 = vContext.getValue(in[1], false, this.evaluator);
                        }
                        catch (NotFoundException exc) {
                            val2 = vContext.createBadVarnode();
                        }
                        if (val1.equals((Object)val2)) {
                            v = vContext.getConstant(val1, this.evaluator);
                            val1 = val2 = vContext.createConstantVarnode(v, val1.getSize());
                        }
                        result = vContext.add(val1, val2, this.evaluator);
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 20: {
                        val1 = vContext.getValue(in[0], false, this.evaluator);
                        val2 = vContext.getValue(in[1], false, this.evaluator);
                        result = vContext.subtract(val1, val2, this.evaluator);
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 21: 
                    case 22: 
                    case 23: {
                        binaryBehavior = (BinaryOpBehavior)OpBehaviorFactory.getOpBehavior((int)ptype);
                        val1 = vContext.getValue(in[0], false, this.evaluator);
                        val2 = vContext.getValue(in[1], false, this.evaluator);
                        lresult = binaryBehavior.evaluateBinary(out.getSize(), in[0].getSize(), vContext.getConstant(val1, this.evaluator), vContext.getConstant(val2, this.evaluator));
                        result = vContext.createConstantVarnode(lresult, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 24: {
                        unaryBehavior = (UnaryOpBehavior)OpBehaviorFactory.getOpBehavior((int)ptype);
                        val1 = vContext.getValue(in[0], false, this.evaluator);
                        lresult = unaryBehavior.evaluateUnary(out.getSize(), in[0].getSize(), vContext.getConstant(val1, this.evaluator));
                        result = vContext.createConstantVarnode(lresult, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 25: {
                        val1 = vContext.getValue(in[0], false, this.evaluator);
                        result = vContext.createConstantVarnode(vContext.getConstant(val1, this.evaluator) ^ -1L, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 26: {
                        if (in[0].isRegister() && in[0].equals((Object)in[1])) {
                            result = vContext.createConstantVarnode(0L, out.getSize());
                        } else {
                            val1 = vContext.getValue(in[0], false, this.evaluator);
                            val2 = vContext.getValue(in[1], false, this.evaluator);
                            lresult = vContext.getConstant(val1, this.evaluator) ^ vContext.getConstant(val2, this.evaluator);
                            result = vContext.createConstantVarnode(lresult, val1.getSize());
                        }
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 27: {
                        val1 = vContext.getValue(in[0], false, this.evaluator);
                        val2 = vContext.getValue(in[1], false, this.evaluator);
                        result = vContext.and(val1, val2, this.evaluator);
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 28: {
                        val1 = vContext.getValue(in[0], false, this.evaluator);
                        val2 = vContext.getValue(in[1], false, this.evaluator);
                        result = vContext.or(val1, val2, this.evaluator);
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 29: {
                        val1 = vContext.getValue(in[0], false, this.evaluator);
                        val2 = vContext.getValue(in[1], false, this.evaluator);
                        result = vContext.left(val1, val2, this.evaluator);
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 30: {
                        val1 = vContext.getValue(in[0], false, this.evaluator);
                        val2 = vContext.getValue(in[1], false, this.evaluator);
                        lresult = vContext.getConstant(val1, this.evaluator) >> (int)vContext.getConstant(val2, this.evaluator);
                        result = vContext.createConstantVarnode(lresult, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 31: {
                        val1 = vContext.getValue(in[0], true, this.evaluator);
                        val2 = vContext.getValue(in[1], false, this.evaluator);
                        lresult = vContext.getConstant(val1, this.evaluator) >>> (int)vContext.getConstant(val2, this.evaluator);
                        result = vContext.createConstantVarnode(lresult, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 32: {
                        val1 = vContext.getValue(in[0], true, this.evaluator);
                        val2 = vContext.getValue(in[1], true, this.evaluator);
                        lresult = vContext.getConstant(val1, this.evaluator) * vContext.getConstant(val2, this.evaluator);
                        result = vContext.createConstantVarnode(lresult, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 33: {
                        val1 = vContext.getValue(in[0], false, this.evaluator);
                        val2 = vContext.getValue(in[1], false, this.evaluator);
                        lval1 = vContext.getConstant(val1, this.evaluator);
                        lval2 = vContext.getConstant(val2, this.evaluator);
                        if (lval2 == 0L) {
                            throw SymbolicPropogator.divideByZeroException;
                        }
                        lresult = lval1 / lval2;
                        result = vContext.createConstantVarnode(lresult, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 34: {
                        val1 = vContext.getValue(in[0], true, this.evaluator);
                        val2 = vContext.getValue(in[1], true, this.evaluator);
                        lval1 = vContext.getConstant(val1, this.evaluator);
                        lval2 = vContext.getConstant(val2, this.evaluator);
                        if (lval2 == 0L) {
                            throw SymbolicPropogator.divideByZeroException;
                        }
                        lresult = lval1 / lval2;
                        result = vContext.createConstantVarnode(lresult, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 35: {
                        val1 = vContext.getValue(in[0], false, this.evaluator);
                        val2 = vContext.getValue(in[1], false, this.evaluator);
                        lval1 = vContext.getConstant(val1, this.evaluator);
                        lval2 = vContext.getConstant(val2, this.evaluator);
                        if (lval2 == 0L) {
                            throw SymbolicPropogator.divideByZeroException;
                        }
                        lresult = lval1 % lval2;
                        result = vContext.createConstantVarnode(lresult, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 36: {
                        val1 = vContext.getValue(in[0], true, this.evaluator);
                        val2 = vContext.getValue(in[1], true, this.evaluator);
                        lval1 = vContext.getConstant(val1, this.evaluator);
                        lval2 = vContext.getConstant(val2, this.evaluator);
                        if (lval2 == 0L) {
                            throw SymbolicPropogator.divideByZeroException;
                        }
                        lresult = lval1 % lval2;
                        result = vContext.createConstantVarnode(lresult, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 63: {
                        val1 = vContext.getValue(in[0], true, this.evaluator);
                        val2 = vContext.getValue(in[1], true, this.evaluator);
                        subbyte = 8L * vContext.getConstant(val2, this.evaluator);
                        if (vContext.isSymbol(val1) & subbyte == 0L && out.getSize() == instruction.getAddress().getPointerSize()) {
                            result = val1;
                        } else {
                            if (out.getSize() > 8) {
                                throw SymbolicPropogator.valueTooBigException;
                            }
                            lresult = vContext.getConstant(val1, this.evaluator) >> (int)subbyte & SymbolicPropogator.maskSize[out.getSize()];
                            result = vContext.createConstantVarnode(lresult, out.getSize());
                        }
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 15: {
                        val1 = vContext.getValue(in[0], false, this.evaluator);
                        val2 = vContext.getValue(in[1], false, this.evaluator);
                        lval1 = vContext.getConstant(val1, this.evaluator);
                        lval2 = vContext.getConstant(val2, this.evaluator);
                        lresult = Long.compareUnsigned(lval1, lval2) < 0 ? 1L : 0L;
                        result = vContext.createConstantVarnode(lresult, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 13: {
                        val1 = vContext.getValue(in[0], true, this.evaluator);
                        val2 = vContext.getValue(in[1], true, this.evaluator);
                        lval1 = vContext.getConstant(val1, this.evaluator);
                        lval2 = vContext.getConstant(val2, this.evaluator);
                        lresult = vContext.getConstant(val1, this.evaluator) < vContext.getConstant(val2, this.evaluator) ? 1L : 0L;
                        result = vContext.createConstantVarnode(lresult, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 16: {
                        val1 = vContext.getValue(in[0], false, this.evaluator);
                        val2 = vContext.getValue(in[1], false, this.evaluator);
                        lval1 = vContext.getConstant(val1, this.evaluator);
                        lval2 = vContext.getConstant(val2, this.evaluator);
                        lresult = Long.compareUnsigned(lval1, lval2) <= 0 ? 1L : 0L;
                        result = vContext.createConstantVarnode(lresult, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 14: {
                        val1 = vContext.getValue(in[0], true, this.evaluator);
                        val2 = vContext.getValue(in[1], true, this.evaluator);
                        lresult = vContext.getConstant(val1, this.evaluator) <= vContext.getConstant(val2, this.evaluator) ? 1L : 0L;
                        result = vContext.createConstantVarnode(lresult, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 11: {
                        val1 = vContext.getValue(in[0], false, this.evaluator);
                        val2 = vContext.getValue(in[1], false, this.evaluator);
                        lresult = vContext.getConstant(val1, this.evaluator) == vContext.getConstant(val2, this.evaluator) ? 1L : 0L;
                        result = vContext.createConstantVarnode(lresult, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 12: {
                        val1 = vContext.getValue(in[0], false, this.evaluator);
                        val2 = vContext.getValue(in[1], false, this.evaluator);
                        lresult = vContext.getConstant(val1, this.evaluator) != vContext.getConstant(val2, this.evaluator) ? 1L : 0L;
                        result = vContext.createConstantVarnode(lresult, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 37: {
                        val1 = vContext.getValue(in[0], false, this.evaluator);
                        lresult = vContext.getConstant(val1, this.evaluator) == 0L ? 1 : 0;
                        result = vContext.createConstantVarnode(lresult, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 38: {
                        val1 = vContext.getValue(in[0], false, this.evaluator);
                        val2 = vContext.getValue(in[1], false, this.evaluator);
                        lresult = vContext.getConstant(val1, this.evaluator) ^ vContext.getConstant(val2, this.evaluator);
                        result = vContext.createConstantVarnode(lresult, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 39: {
                        val1 = vContext.getValue(in[0], false, this.evaluator);
                        val2 = vContext.getValue(in[1], false, this.evaluator);
                        lresult = vContext.getConstant(val1, this.evaluator) & vContext.getConstant(val2, this.evaluator);
                        result = vContext.createConstantVarnode(lresult, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    case 40: {
                        val1 = vContext.getValue(in[0], false, this.evaluator);
                        val2 = vContext.getValue(in[1], false, this.evaluator);
                        lresult = vContext.getConstant(val1, this.evaluator) | vContext.getConstant(val2, this.evaluator);
                        result = vContext.createConstantVarnode(lresult, val1.getSize());
                        vContext.putValue(out, result, mustClearAll);
                        break;
                    }
                    default: {
                        if (out == null) continue block57;
                        vContext.putValue(out, null, false);
                    }
                }
                continue;
            }
            catch (NotFoundException e) {
                if (out == null) continue;
                vContext.putValue(out, vContext.createBadVarnode(), false);
                continue;
            }
            catch (AddressOutOfBoundsException e) {
                if (out == null) continue;
                vContext.putValue(out, null, false);
            }
        }
        vContext.propogateResults(true);
        fallthru = instruction.getFallThrough();
        if (ptype == 4 || ptype == 10 || ptype == 6) {
            nextAddr = fallthru;
        }
        return nextAddr;
    }

    private Varnode getConstantOrExternal(VarnodeContext vContext, Address minInstrAddress, Varnode val1) throws NotFoundException {
        Varnode vt;
        if (!this.context.isExternalSpace(val1.getSpace())) {
            long lval = vContext.getConstant(val1, this.evaluator);
            vt = vContext.getVarnode(minInstrAddress.getAddressSpace().getSpaceID(), lval, 0);
        } else {
            vt = val1;
        }
        return vt;
    }

    private Varnode getStoredLocation(VarnodeContext vContext, Varnode space, Varnode offset, Varnode size) {
        Varnode out = null;
        if (offset == null) {
            return null;
        }
        try {
            out = vContext.getVarnode(space, offset, size.getSize(), this.evaluator);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return out;
    }

    private void handleFunctionSideEffects(Instruction instruction, Address target, TaskMonitor monitor) {
        Address fallThruAddr;
        Function targetFunc = null;
        if (target != null) {
            targetFunc = this.program.getFunctionManager().getFunctionAt(target);
        }
        if ((fallThruAddr = instruction.getFallThrough()) == null || target == null || target.getOffset() != fallThruAddr.getOffset()) {
            Varnode[] killedVarnodes;
            Varnode[] returnVarnodes;
            if (this.checkForParamRefs && this.evaluator != null && this.evaluator.evaluateReference(this.context, instruction, 0, target == null ? Address.NO_ADDRESS : target, 0, null, (RefType)RefType.UNCONDITIONAL_CALL)) {
                this.addParamReferences(targetFunc, target, instruction, this.context, monitor);
            }
            if ((returnVarnodes = this.context.getReturnVarnode(targetFunc)) != null) {
                for (Varnode varnode : returnVarnodes) {
                    this.context.putValue(varnode, this.context.createBadVarnode(), false);
                }
            }
            if ((killedVarnodes = this.context.getKilledVarnodes(targetFunc)) != null) {
                for (Varnode varnode : killedVarnodes) {
                    this.context.putValue(varnode, this.context.createBadVarnode(), false);
                }
            }
        }
        if (targetFunc != null && targetFunc.isInline()) {
            return;
        }
        Varnode outStack = this.context.getStackVarnode();
        if (!(outStack == null || targetFunc != null && targetFunc.isInline())) {
            int purge = this.getFunctionPurge(this.program, targetFunc);
            purge = this.addStackOverride(this.program, instruction.getMinAddress(), purge);
            if (purge == Integer.MAX_VALUE || purge == 0x7FFFFFFE) {
                Varnode curVal = null;
                if (fallThruAddr != null) {
                    Address[] knownFlowToAddresses;
                    for (Address knownFlowToAddresse : knownFlowToAddresses = this.context.getKnownFlowToAddresses(fallThruAddr)) {
                        curVal = this.context.getRegisterVarnodeValue(this.context.getStackRegister(), knownFlowToAddresse, fallThruAddr, false);
                        if (curVal != null) break;
                    }
                }
                if (curVal != null) {
                    this.context.putValue(outStack, curVal, false);
                } else if (instruction.getLength() != 1) {
                    this.context.putValue(outStack, null, false);
                }
            } else if (purge != 0) {
                try {
                    Varnode purgeVar = this.context.createConstantVarnode(purge, outStack.getSize());
                    Varnode val1 = this.context.getValue(outStack, true, this.evaluator);
                    Varnode val2 = this.context.add(val1, purgeVar, this.evaluator);
                    this.context.putValue(outStack, val2, false);
                }
                catch (NotFoundException e) {
                    this.context.putValue(outStack, this.context.createBadVarnode(), false);
                }
            }
        }
    }

    private boolean isBranch(PcodeOp pcodeOp) {
        if (pcodeOp.isAssignment()) {
            return false;
        }
        int opcode = pcodeOp.getOpcode();
        return opcode != 3 && opcode != 2;
    }

    private Address resolveFunctionReference(Address addr) {
        Address extAddr = null;
        for (Reference ref : this.program.getReferenceManager().getReferencesFrom(addr)) {
            if (ref.isExternalReference()) {
                extAddr = ref.getToAddress();
                continue;
            }
            if (!ref.isMemoryReference() || !ref.getReferenceType().isCall()) continue;
            return ref.getToAddress();
        }
        return extAddr;
    }

    private PcodeOp[] checkForCallFixup(Program prog, Function func, Instruction instr) {
        if (func == null) {
            return null;
        }
        String callFixupName = func.getCallFixup();
        if (callFixupName == null) {
            return null;
        }
        PcodeInjectLibrary snippetLibrary = prog.getCompilerSpec().getPcodeInjectLibrary();
        InjectPayload payload = snippetLibrary.getPayload(1, callFixupName);
        if (payload == null) {
            return null;
        }
        InjectContext con = snippetLibrary.buildInjectContext();
        con.baseAddr = instr.getMinAddress();
        con.nextAddr = con.baseAddr.add((long)instr.getDefaultFallThroughOffset());
        con.refAddr = con.callAddr = func.getEntryPoint();
        try {
            return payload.getPcode(prog, con);
        }
        catch (Exception e) {
            Msg.warn((Object)this, (Object)e.getMessage());
            return null;
        }
    }

    private PcodeOp[] checkForUponReturnCallMechanismInjection(Program prog, Function func, Address target, Instruction instr) {
        PrototypeModel callingConvention = null;
        if (func != null) {
            callingConvention = func.getCallingConvention();
        }
        if (callingConvention == null) {
            callingConvention = prog.getCompilerSpec().getDefaultCallingConvention();
        }
        String injectionName = callingConvention.getName() + "@@inject_uponreturn";
        PcodeInjectLibrary snippetLibrary = prog.getCompilerSpec().getPcodeInjectLibrary();
        InjectPayload payload = snippetLibrary.getPayload(3, injectionName);
        if (payload == null) {
            return null;
        }
        InjectContext con = snippetLibrary.buildInjectContext();
        con.baseAddr = instr.getMinAddress();
        con.nextAddr = con.baseAddr.add((long)instr.getDefaultFallThroughOffset());
        con.refAddr = con.callAddr = target;
        try {
            return payload.getPcode(prog, con);
        }
        catch (Exception e) {
            Msg.warn((Object)this, (Object)e.getMessage());
            return null;
        }
    }

    private PcodeOp[] injectPcode(PcodeOp[] currentPcode, int pcodeIndex, PcodeOp[] replacePcode) {
        int opsRemaining = currentPcode.length - pcodeIndex - 1;
        if (opsRemaining == 0) {
            currentPcode = replacePcode;
        } else {
            PcodeOp[] replacePcodeExpanded = new PcodeOp[replacePcode.length + opsRemaining];
            System.arraycopy(replacePcode, 0, replacePcodeExpanded, 0, replacePcode.length);
            System.arraycopy(currentPcode, pcodeIndex + 1, replacePcodeExpanded, replacePcode.length, opsRemaining);
            currentPcode = replacePcodeExpanded;
        }
        return currentPcode;
    }

    private PcodeOp[] doCallOtherPcodeInjection(Instruction instr, Varnode[] ins, Varnode out) throws NotFoundException {
        PcodeInjectLibrary snippetLibrary;
        Program prog = instr.getProgram();
        InjectPayload payload = this.findPcodeInjection(prog, snippetLibrary = prog.getCompilerSpec().getPcodeInjectLibrary(), ins[0].getOffset());
        if (payload == null) {
            return null;
        }
        ArrayList<Varnode> inputs = new ArrayList<Varnode>();
        for (int i = 1; i < ins.length; ++i) {
            Varnode vval = this.context.getValue(ins[i], this.evaluator);
            if (!this.context.isConstant(vval)) {
                return null;
            }
            inputs.add(vval);
        }
        InjectContext con = snippetLibrary.buildInjectContext();
        con.baseAddr = instr.getMinAddress();
        con.nextAddr = con.baseAddr.add((long)instr.getDefaultFallThroughOffset());
        con.refAddr = con.callAddr = null;
        con.inputlist = inputs;
        con.output = new ArrayList();
        con.output.add(out);
        try {
            return payload.getPcode(prog, con);
        }
        catch (Exception e) {
            Msg.warn((Object)this, (Object)e.getMessage());
            return null;
        }
    }

    private InjectPayload findPcodeInjection(Program prog, PcodeInjectLibrary snippetLibrary, long callOtherIndex) {
        InjectPayload payload = this.injectPayloadCache.get(callOtherIndex);
        if (payload != null) {
            return payload;
        }
        if (this.injectPayloadCache.containsKey(callOtherIndex)) {
            return null;
        }
        String opName = prog.getLanguage().getUserDefinedOpName((int)callOtherIndex);
        payload = "segment".equals(opName) ? snippetLibrary.getPayload(4, "segment_pcode") : snippetLibrary.getPayload(2, opName);
        this.injectPayloadCache.put(callOtherIndex, payload);
        return payload;
    }

    private int getFunctionPurge(Program prog, Function function) {
        if (function == null) {
            return this.getDefaultStackDepthChange(prog, null, Integer.MAX_VALUE);
        }
        PrototypeModel conv = function.getCallingConvention();
        if (function.isStackPurgeSizeValid()) {
            int depth = function.getStackPurgeSize();
            return this.getDefaultStackDepthChange(prog, conv, depth);
        }
        return this.getDefaultStackDepthChange(prog, conv, Integer.MAX_VALUE);
    }

    private int getDefaultStackDepthChange(Program prog, PrototypeModel model, int depth) {
        if (model == null) {
            model = prog.getCompilerSpec().getDefaultCallingConvention();
        }
        if (model == null) {
            return Integer.MAX_VALUE;
        }
        int callStackMod = model.getExtrapop();
        int callStackShift = model.getStackshift();
        if (callStackMod != 32768) {
            return callStackShift;
        }
        if (depth == Integer.MAX_VALUE || depth == 0x7FFFFFFE) {
            return Integer.MAX_VALUE;
        }
        return callStackShift + depth;
    }

    private int addStackOverride(Program prog, Address addr, int purge) {
        Integer stackDepthChange = CallDepthChangeInfo.getStackDepthChange(prog, addr);
        if (stackDepthChange == null) {
            return purge;
        }
        int extrapop = CallDepthChangeInfo.getStackDepthChange(prog, addr);
        if (purge == Integer.MAX_VALUE || purge == 0x7FFFFFFE) {
            return extrapop;
        }
        return purge + extrapop;
    }

    private void addParamReferences(Function func, Address callTarget, Instruction instruction, VarnodeContext varnodeContext, TaskMonitor monitor) {
        block9: {
            long callOffset;
            PrototypeModel conv;
            block8: {
                boolean trustSignature;
                if (!this.checkForParamRefs) {
                    return;
                }
                if (callTarget != null && callTarget.isExternalAddress()) {
                    return;
                }
                conv = this.program.getCompilerSpec().getDefaultCallingConvention();
                Parameter[] params = new Parameter[]{};
                SourceType signatureSource = SourceType.DEFAULT;
                if (func != null) {
                    PrototypeModel funcConv = func.getCallingConvention();
                    if (funcConv != null) {
                        conv = funcConv;
                    }
                    params = func.getParameters();
                    signatureSource = func.getSignatureSource();
                } else if (this.checkForParamPointerRefs) {
                    return;
                }
                callOffset = callTarget == null ? -1L : callTarget.getOffset();
                boolean signatureAssigned = signatureSource != SourceType.DEFAULT;
                boolean bl = trustSignature = signatureAssigned || params.length > 0;
                if (!trustSignature || func.hasVarArgs()) break block8;
                for (Parameter param : params) {
                    Parameter p = param;
                    DataType dataType = p.getDataType();
                    if (!(dataType instanceof Pointer) && (!(dataType instanceof TypeDef) || !((TypeDef)dataType).isPointer()) && (this.checkForParamPointerRefs || !Undefined.isUndefined((DataType)dataType) && !(dataType instanceof IntegerDataType))) continue;
                    this.createVariableStorageReference(instruction, varnodeContext, monitor, conv, p.getVariableStorage(), dataType, callOffset);
                }
                break block9;
            }
            if (this.checkForParamPointerRefs) break block9;
            for (int pi = 0; pi < 8; ++pi) {
                VariableStorage var = conv.getArgLocation(pi, null, this.pointerSizedDT, this.program);
                if (var.isStackStorage()) continue;
                this.createVariableStorageReference(instruction, varnodeContext, monitor, conv, var, null, callOffset);
            }
        }
    }

    private void addReturnReferences(Instruction instruction, VarnodeContext varnodeContext, TaskMonitor monitor) {
        if (!this.checkForReturnRefs) {
            return;
        }
        Function func = this.program.getFunctionManager().getFunctionContaining(instruction.getMinAddress());
        VariableStorage returnLoc = this.getReturnLocationStorage(func);
        if (returnLoc == null) {
            return;
        }
        this.createVariableStorageReference(instruction, varnodeContext, monitor, null, returnLoc, null, 0L);
    }

    private void addLoadStoreReference(VarnodeContext vContext, Instruction instruction, int pcodeType, Varnode refLocation, Varnode targetSpaceID, Varnode assigningVarnode, RefType reftype, boolean knownReference, TaskMonitor monitor) {
        if (refLocation == null) {
            return;
        }
        int opIndex = this.findOperandWithVarnodeAssignment(instruction, assigningVarnode);
        if (instruction.getFlowType().isCall()) {
            this.makeReference(vContext, instruction, opIndex, refLocation, null, reftype, pcodeType, knownReference, monitor);
        } else {
            int spaceID = refLocation.getSpace();
            if (vContext.isSymbolicSpace(spaceID)) {
                Address constant;
                Address newTarget;
                long offset = refLocation.getOffset();
                if (this.evaluator != null && !vContext.isStackSymbolicSpace(refLocation) && this.evaluator != null && (newTarget = this.evaluator.evaluateConstant(vContext, instruction, pcodeType, constant = this.program.getAddressFactory().getAddress((int)targetSpaceID.getOffset(), offset), 0, null, reftype)) != null) {
                    this.makeReference(vContext, instruction, -1, newTarget.getAddressSpace().getSpaceID(), newTarget.getOffset(), 0, null, RefType.DATA, pcodeType, false, false, monitor);
                    return;
                }
            }
            this.makeReference(vContext, instruction, opIndex, refLocation, null, reftype, pcodeType, knownReference, monitor);
        }
    }

    private int findOperandWithVarnodeAssignment(Instruction instruction, Varnode assigningVarnode) {
        if (!assigningVarnode.isUnique()) {
            return -1;
        }
        for (int opIndex = 0; opIndex < instruction.getNumOperands(); ++opIndex) {
            PcodeOp[] pcode = instruction.getPcode(opIndex);
            for (int j = pcode.length - 1; j >= 0; --j) {
                if (!assigningVarnode.equals((Object)pcode[j].getOutput())) continue;
                return opIndex;
            }
        }
        return -1;
    }

    private boolean checkPossibleOffsetAddr(long offset) {
        long maxAddrOffset = this.pointerMask;
        return (offset < 0L || offset >= 256L) && Math.abs(maxAddrOffset - offset) >= 256L;
    }

    private void addStoredReferences(VarnodeContext vContext, Instruction instruction, Varnode storageLocation, Varnode valueToStore, TaskMonitor monitor) {
        if (!this.checkForStoredRefs) {
            return;
        }
        if (storageLocation != null && storageLocation.isRegister()) {
            return;
        }
        if (!vContext.isConstant(valueToStore)) {
            return;
        }
        long valueOffset = valueToStore.getOffset();
        this.makeReference(vContext, instruction, -1, -1L, valueOffset, 0, null, RefType.DATA, 3, false, false, monitor);
    }

    private void createVariableStorageReference(Instruction instruction, VarnodeContext varnodeContext, TaskMonitor monitor, PrototypeModel conv, VariableStorage storage, DataType dataType, long callOffset) {
        Address lastSetAddr;
        BigInteger bval;
        if (storage.isStackStorage()) {
            if (conv == null) {
                return;
            }
            Varnode sVnode = storage.getFirstVarnode();
            Varnode stackVarnode = varnodeContext.getStackVarnode();
            Varnode stackVal = null;
            try {
                stackVal = varnodeContext.getValue(stackVarnode, null);
                if (stackVal == null) {
                    return;
                }
            }
            catch (NotFoundException e) {
                return;
            }
            Varnode realSPVarnode = varnodeContext.createVarnode(stackVal.getOffset() + sVnode.getOffset(), stackVal.getSpace(), sVnode.getAddress().getAddressSpace().getPointerSize());
            Varnode value = null;
            try {
                value = varnodeContext.getValue(realSPVarnode, this.evaluator);
            }
            catch (NotFoundException e) {
                return;
            }
            if (!varnodeContext.isConstant(value)) {
                return;
            }
            bval = BigInteger.valueOf(value.getOffset());
            lastSetAddr = varnodeContext.getLastSetLocation(realSPVarnode, bval);
        } else if (storage.isRegisterStorage()) {
            RegisterValue lastRval;
            Register reg = storage.getRegister();
            RegisterValue rval = varnodeContext.getRegisterValue(reg);
            if (rval == null || !rval.hasValue()) {
                return;
            }
            reg = rval.getRegister();
            lastSetAddr = varnodeContext.getLastSetLocation(reg, bval = rval.getUnsignedValue());
            if (!(lastSetAddr == null || !instruction.getPrototype().hasDelaySlots() || (lastRval = varnodeContext.getRegisterValue(reg, lastSetAddr)) != null && lastRval.hasAnyValue() && lastRval.equals((Object)rval))) {
                lastSetAddr = instruction.getMaxAddress();
            }
        } else {
            return;
        }
        this.makeVariableStorageReference(storage, instruction, varnodeContext, monitor, callOffset, dataType, lastSetAddr, bval);
    }

    private void makeVariableStorageReference(VariableStorage storage, Instruction instruction, VarnodeContext varnodeContext, TaskMonitor monitor, long callOffset, DataType dataType, Address lastSetAddr, BigInteger bval) {
        Instruction instr;
        Object value;
        TypeDef typedef;
        if (lastSetAddr == null) {
            lastSetAddr = instruction.getMaxAddress();
        }
        if (bval == null) {
            return;
        }
        long val = bval.longValue();
        if (val == callOffset) {
            return;
        }
        if (lastSetAddr == null) {
            return;
        }
        int knownSpaceID = -1;
        boolean knownReference = false;
        if (dataType != null && dataType instanceof TypeDef && (typedef = (TypeDef)dataType).isPointer() && (value = this.getPointerDataTypeValue(dataType, lastSetAddr, bval)) instanceof Address) {
            Address addrVal = (Address)value;
            val = addrVal.getAddressableWordOffset();
            knownSpaceID = addrVal.getAddressSpace().getSpaceID();
            knownReference = true;
        }
        if (!(instr = instruction).contains(lastSetAddr)) {
            instr = this.getInstructionContaining(lastSetAddr);
        }
        Reference[] refs = instr.getReferencesFrom();
        boolean found = false;
        for (Reference ref : refs) {
            Address refAddr = ref.getToAddress();
            Address addr = refAddr.getAddressSpace().getTruncatedAddress(val, true);
            if (ref.getReferenceType() == RefType.PARAM && !this.visitedBody.contains(ref.getFromAddress())) {
                instr.removeOperandReference(ref.getOperandIndex(), refAddr);
                continue;
            }
            if (refAddr.getOffset() != addr.getOffset()) continue;
            found = true;
        }
        RefType refType = callOffset == 0L ? RefType.DATA : RefType.PARAM;
        this.makeReference(varnodeContext, instr, -1, knownSpaceID, val, 0, dataType, refType, 0, knownReference, found, monitor);
    }

    private Object getPointerDataTypeValue(DataType dataType, Address lastSetAddr, BigInteger bval) {
        int len = dataType.getLength();
        byte[] byteArray = new byte[len];
        BigEndianDataConverter.INSTANCE.putBigInteger(byteArray, 0, len, bval);
        ByteMemBufferImpl buf = new ByteMemBufferImpl(this.program.getMemory(), lastSetAddr, byteArray, true);
        if (len > byteArray.length) {
            return null;
        }
        Object value = dataType.getValue((MemBuffer)buf, dataType.getDefaultSettings(), len);
        return value;
    }

    private VariableStorage getReturnLocationStorage(Function func) {
        VariableStorage returnLoc = null;
        int pointerSize = this.program.getDefaultPointerSize();
        PrototypeModel conv = null;
        if (func != null) {
            conv = func.getCallingConvention();
            DataType returnType = func.getReturnType();
            if (returnType != null && !(returnType instanceof DefaultDataType) && returnType.getLength() < pointerSize) {
                return null;
            }
        }
        if (conv == null) {
            conv = this.program.getCompilerSpec().getDefaultCallingConvention();
        }
        returnLoc = conv.getReturnLocation((DataType)new PointerDataType(Undefined.DEFAULT, pointerSize), this.program);
        return returnLoc;
    }

    private int getReferenceSpaceID(Instruction instruction, long offset) {
        if (offset <= 4L && offset >= -1L) {
            return -1;
        }
        AddressSpace defaultSpace = this.program.getLanguage().getDefaultDataSpace();
        if (this.memorySpaces.size() == 1) {
            return defaultSpace.getSpaceID();
        }
        int realMemSpaceCnt = 0;
        int containingMemSpaceCnt = 0;
        Address containingAddr = null;
        int symbolTargetCnt = 0;
        Address symbolTarget = null;
        AddressSpace instrSpace = instruction.getMinAddress().getAddressSpace();
        if (instrSpace.isOverlaySpace() && ((OverlayAddressSpace)instrSpace).getBaseSpaceID() == defaultSpace.getSpaceID()) {
            defaultSpace = instrSpace;
        }
        for (AddressSpace space : this.memorySpaces) {
            if (space.isOverlaySpace()) {
                if (space != instrSpace) {
                    continue;
                }
            } else {
                ++realMemSpaceCnt;
            }
            Address addr = space.getTruncatedAddress(offset, true);
            if (space.isOverlaySpace() && !addr.getAddressSpace().equals(space)) continue;
            if (space.hasMappedRegisters() && this.program.getRegister(addr) != null) {
                if (space.isOverlaySpace()) continue;
                --realMemSpaceCnt;
                continue;
            }
            if (this.program.getMemory().contains(addr)) {
                ++containingMemSpaceCnt;
                containingAddr = addr;
            }
            if (!this.program.getReferenceManager().hasReferencesTo(addr) && this.program.getSymbolTable().getPrimarySymbol(addr) == null) continue;
            ++symbolTargetCnt;
            symbolTarget = addr;
        }
        if (containingMemSpaceCnt == 1 && containingAddr != null) {
            return containingAddr.getAddressSpace().getSpaceID();
        }
        if (symbolTargetCnt == 1 && symbolTarget != null) {
            return symbolTarget.getAddressSpace().getSpaceID();
        }
        if (realMemSpaceCnt != 1 && !this.defaultSpacesAreTheSame) {
            return -1;
        }
        return defaultSpace.getSpaceID();
    }

    public Address makeReference(VarnodeContext varnodeContext, Instruction instruction, int opIndex, Varnode vt, DataType dataType, RefType refType, int pcodeop, boolean knownReference, TaskMonitor monitor) {
        if (!vt.isAddress() && !varnodeContext.isExternalSpace(vt.getSpace())) {
            if (this.evaluator != null) {
                this.evaluator.evaluateSymbolicReference(varnodeContext, instruction, vt.getAddress());
            }
            return null;
        }
        return this.makeReference(varnodeContext, instruction, opIndex, vt.getSpace(), vt.getWordOffset(), vt.getSize(), dataType, refType, pcodeop, knownReference, false, monitor);
    }

    public Address makeReference(VarnodeContext vContext, Instruction instruction, int opIndex, long knownSpaceID, long wordOffset, int size, DataType dataType, RefType refType, int pcodeop, boolean knownReference, boolean preExisting, TaskMonitor monitor) {
        Address target;
        long spaceID = knownSpaceID;
        if (spaceID == -1L && (spaceID = (long)this.getReferenceSpaceID(instruction, wordOffset)) == -1L) {
            return null;
        }
        Address instructionAddress = instruction.getMinAddress();
        try {
            AddressSpace space = this.program.getAddressFactory().getAddressSpace((int)spaceID);
            if (space.isExternalSpace()) {
                target = space.getAddress(wordOffset, true);
            } else {
                if (!space.isLoadedMemorySpace()) {
                    return null;
                }
                if (wordOffset == 0L) {
                    return null;
                }
                target = wordOffset < 0L ? space.getTruncatedAddress(wordOffset, true) : space.getAddress(wordOffset, true);
                wordOffset = target.getAddressableWordOffset();
                if (space.hasMappedRegisters() && this.program.getRegister(target) != null) {
                    return null;
                }
                target = instructionAddress.getAddressSpace().getOverlayAddress(target);
                if (!(knownReference || this.program.getMemory().contains(target) || refType.isFlow() || this.program.getReferenceManager().hasReferencesTo(target))) {
                    return null;
                }
            }
            if (refType.isCall() && !refType.isComputed()) {
                return null;
            }
            if ((target = this.evaluateReference(vContext, instruction, knownSpaceID, wordOffset, size, dataType, refType, pcodeop, knownReference, target)) == null || preExisting) {
                return null;
            }
            if (refType.isData() && !this.evaluatePureDataRef(instruction, wordOffset, refType, target)) {
                return null;
            }
            if (refType.isJump() && refType.isComputed()) {
                Address[] flows = this.getInstructionFlows(instruction);
                if (flows.length > 1) {
                    return target;
                }
                for (Address address : flows) {
                    if (!address.equals((Object)target)) continue;
                    return target;
                }
            }
        }
        catch (AddressOutOfBoundsException e) {
            return null;
        }
        if ((opIndex = this.findOpIndexForRef(vContext, instruction, opIndex, wordOffset, refType)) == -1 && instruction.getPrototype().hasDelaySlots() && !instruction.getFlowType().equals((Object)refType)) {
            if ((instruction = instruction.getNext()) == null) {
                return target;
            }
            opIndex = this.findOpIndexForRef(vContext, instruction, opIndex, wordOffset, refType);
        }
        if (opIndex == -1 && (!refType.isFlow() || target.isExternalAddress())) {
            opIndex = instruction.getNumOperands() - 1;
            List list = instruction.getDefaultOperandRepresentationList(opIndex);
            if (list == null || list.size() == 0) {
                opIndex = -1;
            }
            if (target.isExternalAddress() && instruction.getReferencesFrom().length != 0) {
                opIndex = -1;
            }
        }
        if (opIndex == -1) {
            instruction.addMnemonicReference(target, refType, SourceType.ANALYSIS);
        } else {
            instruction.addOperandReference(opIndex, target, refType, SourceType.ANALYSIS);
        }
        return target;
    }

    private Address evaluateReference(VarnodeContext vContext, Instruction instruction, long knownSpaceID, long wordOffset, int size, DataType dataType, RefType refType, int pcodeop, boolean knownReference, Address target) {
        if (this.evaluator == null) {
            return target;
        }
        if (knownSpaceID == -1L || !knownReference) {
            Address constant = this.program.getAddressFactory().getConstantAddress(wordOffset);
            Address newTarget = this.evaluator.evaluateConstant(vContext, instruction, pcodeop, constant, size, dataType, refType);
            if (newTarget == null) {
                return null;
            }
            if (newTarget != constant) {
                target = newTarget;
            }
        }
        if (!this.evaluator.evaluateReference(vContext, instruction, pcodeop, target, size, dataType, refType)) {
            return null;
        }
        return target;
    }

    private boolean evaluatePureDataRef(Instruction instruction, long wordOffset, RefType refType, Address target) {
        Instruction targetInstr;
        long fallAddrOffset;
        if (refType.isRead() || refType.isWrite()) {
            return true;
        }
        if ((instruction.hasFallthrough() || instruction.getFlowOverride() != FlowOverride.NONE) && (fallAddrOffset = instruction.getMinAddress().getOffset() + (long)instruction.getDefaultFallThroughOffset()) == wordOffset) {
            return false;
        }
        if (this.program.getMemory().contains(target) && (targetInstr = this.getInstructionContaining(target)) != null) {
            if (!targetInstr.getMinAddress().equals((Object)target)) {
                return false;
            }
            if (targetInstr.isInDelaySlot()) {
                return false;
            }
            Function func = this.program.getFunctionManager().getFunctionContaining(target);
            if (func != null && !func.getEntryPoint().equals((Object)target)) {
                return false;
            }
        }
        return true;
    }

    private int findOpIndexForRef(VarnodeContext vcontext, Instruction instruction, int opIndex, long wordOffset, RefType refType) {
        int numOperands = instruction.getNumOperands();
        for (int i = 0; i < numOperands; ++i) {
            List list;
            int len;
            long val;
            Scalar s;
            Address opAddr;
            int opType = instruction.getOperandType(i);
            if ((opType & 0x2000) != 0 && (opAddr = instruction.getAddress(i)) != null && opAddr.getAddressableWordOffset() == wordOffset) {
                opIndex = i;
                break;
            }
            if ((opType & 0x4000) != 0 && (s = instruction.getScalar(i)) != null && ((val = s.getUnsignedValue()) == wordOffset || val == wordOffset >> 1)) {
                opIndex = i;
                break;
            }
            if (opIndex != -1) continue;
            if ((opType & 0x200) != 0) {
                Register reg = instruction.getRegister(i);
                if (refType.isFlow() && reg != null && reg.isProgramCounter()) {
                    opIndex = i;
                    break;
                }
                if (reg != null) {
                    if (this.checkOffByOne(reg, wordOffset)) {
                        opIndex = i;
                        if (refType.isFlow()) break;
                    }
                    if (this.checkOffByOne(reg.getParentRegister(), wordOffset)) {
                        opIndex = i;
                        if (refType.isFlow()) break;
                    }
                }
            }
            if ((opType & 0x400000) == 0 || (len = (list = instruction.getDefaultOperandRepresentationList(i)).size()) <= 0) continue;
            long baseRegVal = 0L;
            long offset_residue_pos = wordOffset;
            long offset_residue_neg = wordOffset;
            for (int idx = 0; idx < len; ++idx) {
                Register reg;
                BigInteger val2;
                Object obj = list.get(idx);
                if (obj instanceof Scalar) {
                    long val3 = ((Scalar)obj).getUnsignedValue();
                    if (val3 == wordOffset || val3 == wordOffset >> 1 || val3 + baseRegVal == wordOffset) {
                        opIndex = i;
                        break;
                    }
                    val3 = ((Scalar)obj).getSignedValue();
                    offset_residue_neg -= val3;
                    offset_residue_pos += val3;
                }
                if (!(obj instanceof Register) || (val2 = vcontext.getValue(reg = (Register)obj, false)) == null) continue;
                baseRegVal = val2.longValue();
                if ((baseRegVal & this.pointerMask) == wordOffset) {
                    opIndex = i;
                }
                offset_residue_neg -= baseRegVal;
                offset_residue_pos -= baseRegVal;
            }
            if (offset_residue_neg == 0L || offset_residue_pos == 0L) {
                opIndex = i;
                break;
            }
            if (opIndex != -1 || i != numOperands - 1) continue;
            opIndex = i;
        }
        return opIndex;
    }

    private boolean checkOffByOne(Register reg, long wordOffset) {
        if (reg == null) {
            return false;
        }
        BigInteger val = this.context.getValue(reg, false);
        if (val == null) {
            return false;
        }
        long lval = val.longValue() & this.pointerMask;
        return lval == wordOffset || (lval ^ wordOffset) == 1L;
    }

    public boolean encounteredBranch() {
        return this.hitCodeFlow;
    }

    public boolean readExecutable() {
        return this.readExecutableAddress;
    }

    public void setParamRefCheck(boolean checkParamRefsOption) {
        this.checkForParamRefs = checkParamRefsOption;
    }

    public void setParamPointerRefCheck(boolean checkParamRefsOption) {
        this.checkForParamPointerRefs = checkParamRefsOption;
    }

    public void setReturnRefCheck(boolean checkReturnRefsOption) {
        this.checkForReturnRefs = checkReturnRefsOption;
    }

    public void setStoredRefCheck(boolean checkStoredRefsOption) {
        this.checkForStoredRefs = checkStoredRefsOption;
    }

    public class Value {
        final Register relativeRegister;
        final long value;

        Value(Register relativeRegister, long value) {
            this.relativeRegister = relativeRegister;
            this.value = value;
        }

        Value(long value) {
            this.relativeRegister = null;
            this.value = value;
        }

        public long getValue() {
            return this.value;
        }

        public boolean isRegisterRelativeValue() {
            return this.relativeRegister != null;
        }

        public Register getRelativeRegister() {
            return this.relativeRegister;
        }
    }

    protected class SavedFlowState {
        Address source;
        Address destination;
        boolean continueAfterHittingFlow;

        public SavedFlowState(VarnodeContext vContext, Address source, Address destination, boolean continueAfterHittingFlow) {
            this.source = source;
            this.destination = destination;
            this.continueAfterHittingFlow = continueAfterHittingFlow;
            vContext.pushMemState();
        }

        public Address getSource() {
            return this.source;
        }

        public Address getDestination() {
            return this.destination;
        }

        public boolean isContinueAfterHittingFlow() {
            return this.continueAfterHittingFlow;
        }

        public void restoreState(VarnodeContext vContext) {
            vContext.popMemState();
        }
    }
}

