/*
 * Decompiled with CFR 0.152.
 */
package help.screenshot;

import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.DockingDialog;
import docking.Tool;
import docking.action.DockingActionIf;
import generic.jar.ResourceFile;
import generic.theme.GThemeDefaults;
import generic.util.WindowUtilities;
import ghidra.framework.Application;
import ghidra.framework.main.FrontEndTool;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import help.screenshot.AbstractScreenShotGenerator;
import help.screenshot.ImageDialogProvider;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.After;
import org.junit.Assert;

public abstract class GhidraScreenShotGenerator
extends AbstractScreenShotGenerator {
    private static final Color FG_COLOR_TEXT = GThemeDefaults.Colors.Palette.getColor((String)"color.palette.cornflowerblue");
    private static final String CAPTURE = "Capture";

    protected GhidraScreenShotGenerator() {
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.showResults();
    }

    protected void showResults() {
        if (!this.hasTestFailed()) {
            this.saveOrDisplayImage();
        } else {
            Msg.error((Object)((Object)this), (Object)("Not showing screenshot results--test failed " + this.getName()));
        }
    }

    public void saveOrDisplayImage() {
        String name = this.testName.getMethodName();
        this.saveOrDisplayImage(name);
    }

    public void saveOrDisplayImage(String name) {
        if ((name = name.substring(4)).startsWith(CAPTURE)) {
            name = name.substring(CAPTURE.length());
        }
        File topic = this.getHelpTopic();
        File imageFile = this.getImageFile(topic, name);
        this.finished(topic, imageFile.getName());
    }

    private File getImageFile(File helpTopic, String name) {
        String nameLowerCase;
        File imagesDir;
        File[] matchingFiles;
        File potentialFile = new File(helpTopic, "images/" + name + ".png");
        if (potentialFile.exists()) {
            return potentialFile;
        }
        potentialFile = new File(helpTopic, "images/" + name + ".gif");
        if (potentialFile.exists()) {
            this.handleGIFImage(potentialFile);
        }
        if ((potentialFile = new File(helpTopic, "images/" + name + ".jpg")).exists()) {
            this.handleJPGImage(potentialFile);
        }
        if ((matchingFiles = (imagesDir = new File(helpTopic, "images")).listFiles(arg_0 -> GhidraScreenShotGenerator.lambda$getImageFile$0(nameLowerCase = name.toLowerCase(), arg_0))).length == 1) {
            return matchingFiles[0];
        }
        if (matchingFiles.length == 0) {
            return new File("ImageNotFound/" + name + ".png");
        }
        Assert.fail((String)("Found multiple files, ignoring case, that match name: " + name + " for test case: " + this.testName.getMethodName()));
        return null;
    }

    protected void handleGIFImage(File gifFile) {
        String gifName = gifFile.getName();
        String pngName = gifName.replace(".gif", ".png");
        File pngFile = new File(gifFile.getParentFile(), pngName);
        this.writeFile(pngFile);
        Image gifImage = this.getGIFImage(gifFile);
        this.showGIFImage(pngFile, gifImage);
        Assert.fail((String)("No PNG, but did find ** GIF ** for test case: " + this.testName.getMethodName() + "\nWriting png image: " + pngFile));
    }

    private void handleJPGImage(File jpgFile) {
        String gifName = jpgFile.getName();
        String pngName = gifName.replace(".jpg", ".png");
        File pngFile = new File(jpgFile.getParentFile(), pngName);
        this.writeFile(pngFile);
        Image gifImage = this.getJPGImage(jpgFile);
        this.showGIFImage(pngFile, gifImage);
        Assert.fail((String)("No PNG, but did find ** JPG ** for test case: " + this.testName.getMethodName() + "\nWriting png image: " + pngFile));
    }

    protected File getHelpTopic() {
        String topicName = this.getHelpTopicName();
        File helpTopicDir = this.getHelpTopicDir(topicName);
        Assert.assertNotNull((String)("Unable to find help topic for test file: " + ((Object)((Object)this)).getClass().getName()), (Object)helpTopicDir);
        return helpTopicDir;
    }

    public void loadDefaultTool() {
        this.env.launchDefaultTool();
    }

    protected String getHelpTopicName() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        String simpleName = clazz.getSimpleName();
        return simpleName.replace("ScreenShots", "");
    }

    public void finished(File helpTopic, String oldImageName) {
        if (SAVE_CREATED_IMAGE_FILE) {
            this.maybeSaveToHelp(helpTopic, oldImageName);
        } else {
            this.doShowImage(helpTopic, oldImageName);
        }
    }

    private void doShowImage(File helpTopic, String oldImageName) {
        if (SAVE_CREATED_IMAGE_FILE) {
            Msg.error((Object)((Object)this), (Object)"Do not call showImage() directly");
            return;
        }
        Assert.assertNotNull((String)"No new image found", (Object)this.image);
        Image oldImage = this.getOldImage(helpTopic, oldImageName);
        File imageFile = new File(helpTopic, "/images/" + oldImageName);
        ImageDialogProvider dialog = new ImageDialogProvider(imageFile, oldImage, this.image);
        dialog.setTitle("help/topics/" + helpTopic.getName() + "/images/" + oldImageName);
        this.showDialog(dialog);
    }

    private void showGIFImage(File imageFile, Image gifImage) {
        ImageDialogProvider dialog = new ImageDialogProvider(imageFile, gifImage, this.image);
        this.showDialog(dialog);
    }

    private void showDialog(DialogComponentProvider dialogComponent) {
        GhidraScreenShotGenerator.runSwing(() -> {
            DockingDialog dialog = DockingDialog.createDialog(null, (DialogComponentProvider)dialogComponent, null);
            dialog.setLocation(WindowUtilities.centerOnScreen((Dimension)dialog.getSize()));
            dialog.setVisible(true);
        });
    }

    protected Image getOldImage(File helpTopicDir, String imageName) {
        if (helpTopicDir == null) {
            throw new AssertException("Invalid help topic name - null");
        }
        File imageFile = new File(helpTopicDir, "/images/" + imageName);
        if (!imageFile.exists()) {
            return this.createEmptyImage(10, 10);
        }
        return this.readImage(imageFile);
    }

    private Image getGIFImage(File imageFile) {
        BufferedImage gifImage = this.readImage(imageFile);
        Graphics2D g = (Graphics2D)gifImage.getGraphics();
        int width = gifImage.getWidth();
        int height = gifImage.getHeight();
        Font font = g.getFont().deriveFont((float)((double)height * 0.3));
        g.setFont(font);
        String text = "GIF!";
        FontMetrics fontMetrics = g.getFontMetrics(font);
        Rectangle bounds = fontMetrics.getStringBounds(text, g).getBounds();
        int stringWidth = (int)bounds.getWidth();
        int stringHeight = (int)bounds.getHeight();
        int x = width / 2 - stringWidth / 2;
        int y = height / 2 + stringHeight / 2;
        g.setColor(FG_COLOR_TEXT);
        g.drawString(text, x, y);
        return gifImage;
    }

    private Image getJPGImage(File imageFile) {
        BufferedImage gifImage = this.readImage(imageFile);
        Graphics2D g = (Graphics2D)gifImage.getGraphics();
        int width = gifImage.getWidth();
        int height = gifImage.getHeight();
        Font font = g.getFont().deriveFont((float)((double)height * 0.3));
        g.setFont(font);
        String text = "JPG!";
        FontMetrics fontMetrics = g.getFontMetrics(font);
        Rectangle bounds = fontMetrics.getStringBounds(text, g).getBounds();
        int stringWidth = (int)bounds.getWidth();
        int stringHeight = (int)bounds.getHeight();
        int x = width / 2 - stringWidth / 2;
        int y = height / 2 + stringHeight / 2;
        g.setColor(FG_COLOR_TEXT);
        g.drawString(text, x, y);
        return gifImage;
    }

    @Deprecated
    public void showImage(String helpTopic, String oldImageName) {
        this.doShowImage(this.getHelpTopicDir(helpTopic), oldImageName);
    }

    @Deprecated
    public void saveToHelp(String helpTopic, String imageName) {
        this.maybeSaveToHelp(this.getHelpTopicDir(helpTopic), imageName);
    }

    private void maybeSaveToHelp(File helpTopicDir, String imageName) {
        if (!SAVE_CREATED_IMAGE_FILE) {
            Msg.error((Object)((Object)this), (Object)"Do not call saveToHelp() directly");
            return;
        }
        this.reallySaveToHelp(helpTopicDir, imageName);
    }

    protected void reallySaveToHelp(File helpTopicDir, String imageName) {
        Msg.debug((Object)((Object)this), (Object)"\n\n\t\tWARNING!!!!\nOnly call this method if you need an 'out of band' help image saved.  If you don't know what that means, then don't!");
        if (helpTopicDir == null) {
            throw new AssertException("Invalid help topic name - null");
        }
        File imageFile = new File(helpTopicDir, "/images/" + imageName + NEW_FILENAME_SUFFIX);
        this.writeFile(imageFile);
    }

    protected File getHelpTopicDir(String helpTopic) {
        List<File> helpTopicDirs = this.getHelpTopicDirs();
        for (File file : helpTopicDirs) {
            File potential = new File(file, helpTopic);
            if (!potential.exists()) continue;
            return potential;
        }
        return null;
    }

    protected List<File> getHelpTopicDirs() {
        ArrayList<File> helpTopicDirs = new ArrayList<File>();
        Collection modules = Application.getModuleRootDirectories();
        for (ResourceFile file : modules) {
            File potential = new File(file.getFile(false), "src/main/help/help/topics");
            if (!potential.exists()) continue;
            helpTopicDirs.add(potential);
        }
        return helpTopicDirs;
    }

    protected FrontEndTool getFrontEndTool() {
        FrontEndTool frontEndTool = this.env.getFrontEndTool();
        GhidraScreenShotGenerator.runSwing(() -> frontEndTool.setVisible(true));
        return frontEndTool;
    }

    public void performFrontEndAction(String actionName, String owner, boolean wait) {
        FrontEndTool frontEnd = this.getFrontEndTool();
        DockingActionIf action = GhidraScreenShotGenerator.getAction((Tool)frontEnd, (String)owner, (String)actionName);
        ComponentProvider compProvider = (ComponentProvider)GhidraScreenShotGenerator.getInstanceField((String)"compProvider", (Object)frontEnd);
        GhidraScreenShotGenerator.performAction((DockingActionIf)action, (ComponentProvider)compProvider, (boolean)wait);
    }

    private static /* synthetic */ boolean lambda$getImageFile$0(String nameLowerCase, File f) {
        String filename = f.getName();
        String filenameLowerCase = filename.toLowerCase();
        return nameLowerCase.equals(filenameLowerCase);
    }
}

