/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data.ISF;

import com.google.gson.JsonObject;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.ISF.IsfComponent;
import ghidra.program.model.data.ISF.IsfDataTypeWriter;
import ghidra.program.model.data.ISF.IsfObject;
import ghidra.program.model.data.Structure;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class IsfComposite
implements IsfObject {
    public String kind;
    public Integer size;
    public JsonObject fields;
    @IsfDataTypeWriter.Exclude
    public int alignment;

    public IsfComposite(Composite composite, IsfDataTypeWriter writer, TaskMonitor monitor) {
        this.size = composite.getLength();
        this.kind = composite instanceof Structure ? "struct" : "union";
        this.alignment = composite.getAlignment();
        DataTypeComponent[] components = composite.getComponents();
        HashMap<String, DataTypeComponent> comps = new HashMap<String, DataTypeComponent>();
        for (DataTypeComponent component : components) {
            String key = component.getFieldName();
            if (key == null) {
                key = component.getDefaultFieldName();
            }
            comps.put(key, component);
        }
        ArrayList keylist = new ArrayList(comps.keySet());
        Collections.sort(keylist);
        this.fields = new JsonObject();
        for (String key : keylist) {
            DataTypeComponent component;
            if (monitor.isCancelled()) break;
            component = (DataTypeComponent)comps.get(key);
            IsfObject type = writer.getObjectTypeDeclaration(component);
            IsfComponent cobj = new IsfComponent(component, type);
            this.fields.add(key, writer.getTree(cobj));
        }
    }
}

