/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.remote.User;
import java.util.ArrayList;
import java.util.List;

class UserAccessTableModel
extends GDynamicColumnTableModel<User, List<User>> {
    private List<User> users;
    private String currentUser;
    public static final int USERS_COL = 0;
    public static final int READ_ONLY_COL = 1;
    public static final int READ_WRITE_COL = 2;
    public static final int ADMIN_COL = 3;

    public UserAccessTableModel(String currentUser, List<User> userList, ServiceProvider serviceProvider) {
        super(serviceProvider);
        this.currentUser = currentUser;
        this.users = new ArrayList<User>(userList);
    }

    public String getName() {
        return "User Access";
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.users.size()) {
            return;
        }
        User user = this.users.get(rowIndex);
        switch (columnIndex) {
            case 1: {
                user = new User(user.getName(), (Boolean)aValue != false ? 0 : 1);
                break;
            }
            case 2: {
                user = new User(user.getName(), (Boolean)aValue != false ? 1 : 0);
                break;
            }
            case 3: {
                user = new User(user.getName(), (Boolean)aValue != false ? 2 : 1);
            }
        }
        this.users.remove(rowIndex);
        this.users.add(rowIndex, user);
        this.refresh();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (!this.getCurrentUser().isAdmin()) {
            return false;
        }
        switch (columnIndex) {
            case 0: {
                return false;
            }
            case 1: 
            case 2: 
            case 3: {
                User rowUser = this.users.get(rowIndex);
                User currentUser = this.getCurrentUser();
                if (currentUser == null) break;
                return currentUser.isAdmin() && !rowUser.equals((Object)currentUser);
            }
        }
        return false;
    }

    protected TableColumnDescriptor<User> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new UserColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new ReadOnlyColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new ReadWriteColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AdminColumn());
        return descriptor;
    }

    public List<User> getDataSource() {
        return this.users;
    }

    void setUserList(List<User> users) {
        this.users = users;
        this.refresh();
    }

    void removeUsers(ArrayList<User> users) {
        this.users.removeAll(users);
        this.refresh();
    }

    void addUsers(ArrayList<User> users) {
        this.users.addAll(users);
        this.refresh();
    }

    private User getCurrentUser() {
        for (User user : this.users) {
            if (!user.getName().equals(this.currentUser)) continue;
            return user;
        }
        return null;
    }

    public List<User> getModelData() {
        return this.users;
    }

    class UserColumn
    extends AbstractDynamicTableColumn<User, String, List<User>> {
        UserColumn() {
        }

        public String getColumnName() {
            return "User";
        }

        public String getValue(User rowObject, Settings settings, List<User> data, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getName();
        }
    }

    class ReadOnlyColumn
    extends AbstractDynamicTableColumn<User, Boolean, List<User>> {
        ReadOnlyColumn() {
        }

        public String getColumnName() {
            return "Read Only";
        }

        public Boolean getValue(User rowObject, Settings settings, List<User> data, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.isReadOnly();
        }
    }

    class ReadWriteColumn
    extends AbstractDynamicTableColumn<User, Boolean, List<User>> {
        ReadWriteColumn() {
        }

        public String getColumnName() {
            return "Read/Write";
        }

        public Boolean getValue(User rowObject, Settings settings, List<User> data, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.hasWritePermission() && !rowObject.isAdmin();
        }
    }

    class AdminColumn
    extends AbstractDynamicTableColumn<User, Boolean, List<User>> {
        AdminColumn() {
        }

        public String getColumnName() {
            return "Admin";
        }

        public Boolean getValue(User rowObject, Settings settings, List<User> data, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.isAdmin();
        }
    }
}

