/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.gadp;

import agent.dbgeng.gadp.impl.DbgEngGadpServerImpl;
import ghidra.async.AsyncUtils;
import ghidra.dbg.agent.AgentWindow;
import ghidra.util.Msg;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.exception.ExceptionUtils;

public interface DbgEngGadpServer
extends AutoCloseable {
    public static final String USAGE = "This is the GADP server for Windows dbgeng.dll.  Usage:\n\n    gadp-agent-gdbeng [-H HOST/ADDR] [-p PORT] [-i ID] [-t TRANSPORT]\n                      [-r REMOTE]\n\nOptions:\n\n  --host/-H          The address of the interface on which to listen.\n  --port/-p          The TCP port on which to listen for GADP. Default is 12345\n  --transport/-t     The transport specification for the Process Server. Default\n                     is tcp:port=11200\n  --remote/-r        The transport specification for a remote server.\n\nStarts a dbgeng.dll-based GADP server \"agent\". Once the server has started, it\nwill print the interface IP and port.\n";
    public static final String DEFAULT_DBGSRV_TRANSPORT = "tcp:port=11200";

    public static void main(String[] args) throws Exception {
        try {
            new DbgEngRunner().run(args);
        }
        catch (Throwable t) {
            System.err.println(ExceptionUtils.getMessage((Throwable)t));
            System.exit(1);
        }
    }

    public static DbgEngGadpServer newInstance(SocketAddress addr) throws IOException {
        return new DbgEngGadpServerImpl(addr);
    }

    public CompletableFuture<Void> startDbgEng(String[] var1);

    public SocketAddress getLocalAddress();

    public void terminate() throws IOException;

    public boolean isRunning();

    @Override
    default public void close() throws IOException {
        this.terminate();
    }

    public static class DbgEngRunner {
        protected InetSocketAddress bindTo;
        protected List<String> dbgengArgs = new ArrayList<String>();
        protected String dbgSrvTransport = "tcp:port=11200";
        protected String remote = null;

        public void run(String[] args) throws IOException, InterruptedException, ExecutionException {
            this.parseArguments(args);
            try (DbgEngGadpServer server = DbgEngGadpServer.newInstance(this.bindTo);){
                server.startDbgEng(this.dbgengArgs.toArray(new String[0])).exceptionally(e -> {
                    e = AsyncUtils.unwrapThrowable((Throwable)e);
                    Msg.error((Object)this, (Object)("Error starting dbgeng/GADP: " + e));
                    System.exit(-1);
                    return null;
                });
                new AgentWindow("dbgeng.dll Agent for Ghidra", server.getLocalAddress());
                while (server.isRunning()) {
                    Thread.sleep(1000L);
                }
                System.exit(0);
            }
        }

        protected void parseArguments(String[] args) {
            String iface = "localhost";
            int port = 12345;
            Iterator<String> ait = Arrays.asList(args).iterator();
            while (ait.hasNext()) {
                String a = ait.next();
                if ("-h".equals(a) || "--help".equals(a)) {
                    this.printUsage();
                    System.exit(0);
                    continue;
                }
                if ("-p".equals(a) || "--port".equals(a)) {
                    if (!ait.hasNext()) {
                        System.err.println("Expected PORT");
                        this.printUsage();
                        System.exit(-1);
                    }
                    String portStr = ait.next();
                    try {
                        port = Integer.parseInt(portStr);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("Integer required. Got " + portStr);
                        this.printUsage();
                        System.exit(-1);
                    }
                    continue;
                }
                if ("-H".equals(a) || "--host".equals(a)) {
                    if (!ait.hasNext()) {
                        System.err.println("Expected HOST/ADDR");
                        this.printUsage();
                        System.exit(-1);
                    }
                    iface = ait.next();
                    continue;
                }
                if ("-t".equals(a) || "--transport".equals(a)) {
                    if (!ait.hasNext()) {
                        System.err.println("Expected TRANSPORT");
                        System.err.println("See the MSDN 'Activating a Process Server'");
                        this.printUsage();
                        System.exit(-1);
                    }
                    this.dbgSrvTransport = ait.next();
                    this.dbgengArgs.add(this.dbgSrvTransport);
                    continue;
                }
                if ("-r".equals(a) || "--remote".equals(a)) {
                    if (!ait.hasNext()) {
                        System.err.println("Expected TRANSPORT:HOST,PORT");
                        this.printUsage();
                        System.exit(-1);
                    }
                    this.remote = ait.next();
                    this.dbgengArgs.add(this.remote);
                    continue;
                }
                System.err.println("Unknown option: " + a);
                this.printUsage();
                System.exit(-1);
            }
            this.bindTo = new InetSocketAddress(iface, port);
        }

        protected void printUsage() {
            System.out.println(DbgEngGadpServer.USAGE);
        }
    }
}

