/*
 * Decompiled with CFR 0.152.
 */
package pdb.symbolserver;

import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import pdb.symbolserver.FindOption;
import pdb.symbolserver.SymbolFileInfo;
import pdb.symbolserver.SymbolFileLocation;
import pdb.symbolserver.SymbolServer;
import pdb.symbolserver.SymbolServerInputStream;
import pdb.symbolserver.SymbolServerInstanceCreatorContext;

public class DisabledSymbolServer
implements SymbolServer {
    private static String DISABLED_PREFIX = "disabled://";
    private SymbolServer delegate;

    public static boolean isDisabledSymbolServerLocation(String loc) {
        return loc.startsWith(DISABLED_PREFIX);
    }

    public static SymbolServer createInstance(String locationString, SymbolServerInstanceCreatorContext context) {
        SymbolServer delegate = context.getSymbolServerInstanceCreatorRegistry().newSymbolServer(locationString.substring(DISABLED_PREFIX.length()), context);
        return delegate != null ? new DisabledSymbolServer(delegate) : null;
    }

    public DisabledSymbolServer(SymbolServer delegate) {
        this.delegate = delegate;
    }

    public SymbolServer getSymbolServer() {
        return this.delegate;
    }

    @Override
    public String getName() {
        return DISABLED_PREFIX + this.delegate.getName();
    }

    @Override
    public String getDescriptiveName() {
        return "Disabled - " + this.delegate.getDescriptiveName();
    }

    @Override
    public boolean isValid(TaskMonitor monitor) {
        return this.delegate.isValid(monitor);
    }

    @Override
    public boolean exists(String filename, TaskMonitor monitor) {
        return false;
    }

    @Override
    public List<SymbolFileLocation> find(SymbolFileInfo fileInfo, Set<FindOption> findOptions, TaskMonitor monitor) {
        return List.of();
    }

    @Override
    public SymbolServerInputStream getFileStream(String filename, TaskMonitor monitor) throws IOException, CancelledException {
        return this.delegate.getFileStream(filename, monitor);
    }

    @Override
    public String getFileLocation(String filename) {
        return this.delegate.getFileLocation(filename);
    }

    @Override
    public boolean isLocal() {
        return this.delegate.isLocal();
    }

    public String toString() {
        return String.format("DisabledSymbolServer: [ %s ]", this.delegate.toString());
    }
}

