/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ext4;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class Ext4Extent
implements StructConverter {
    private int ee_block;
    private short ee_len;
    private short ee_start_hi;
    private int ee_start_lo;

    public Ext4Extent(ByteProvider provider) throws IOException {
        this(new BinaryReader(provider, true));
    }

    public Ext4Extent(BinaryReader reader) throws IOException {
        this.ee_block = reader.readNextInt();
        this.ee_len = reader.readNextShort();
        this.ee_start_hi = reader.readNextShort();
        this.ee_start_lo = reader.readNextInt();
    }

    public int getEe_block() {
        return this.ee_block;
    }

    public short getEe_len() {
        return this.ee_len;
    }

    public short getEe_start_hi() {
        return this.ee_start_hi;
    }

    public int getEe_start_lo() {
        return this.ee_start_lo;
    }

    public int getExtentBlockCount() {
        return Short.toUnsignedInt(this.ee_len);
    }

    public long getStreamBlockNumber() {
        return Integer.toUnsignedLong(this.ee_block);
    }

    public long getExtentStartBlockNumber() {
        return Short.toUnsignedLong(this.ee_start_hi) << 32 | Integer.toUnsignedLong(this.ee_start_lo);
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("ext4_extent", 0);
        structure.add(DWORD, "ee_block", null);
        structure.add(WORD, "ee_len", null);
        structure.add(WORD, "ee_start_hi", null);
        structure.add(DWORD, "ee_start_lo", null);
        return structure;
    }
}

