/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import docking.widgets.label.GDHtmlLabel;
import generic.theme.GColor;
import generic.theme.GColorUIResource;
import generic.theme.GThemeDefaults;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;

public abstract class AbstractGCellRenderer
extends GDHtmlLabel {
    private static final Color BACKGROUND_COLOR = new GColor("color.bg.table.row");
    private static final Color ALT_BACKGROUND_COLOR = new GColor("color.bg.table.row.alt");
    private static final String DISABLE_ALTERNATING_ROW_COLORS_PROPERTY = "disable.alternating.row.colors";
    protected static boolean systemAlternateRowColors = AbstractGCellRenderer.getAlternateRowColors();
    protected final Border focusBorder;
    protected final Border noFocusBorder = BorderFactory.createEmptyBorder(0, 5, 0, 5);
    protected Font defaultFont;
    protected Font fixedWidthFont;
    protected Font boldFont;
    protected int dropRow = -1;
    private boolean instanceAlternateRowColors = true;

    private static boolean getAlternateRowColors() {
        return !Boolean.getBoolean(DISABLE_ALTERNATING_ROW_COLORS_PROPERTY);
    }

    public AbstractGCellRenderer() {
        Border innerBorder = BorderFactory.createEmptyBorder(0, 4, 0, 4);
        Border outerBorder = BorderFactory.createLineBorder((Color)GThemeDefaults.Colors.Palette.YELLOW, 1);
        this.focusBorder = BorderFactory.createCompoundBorder(outerBorder, innerBorder);
        this.setBorder(this.noFocusBorder);
        this.setHTMLRenderingEnabled(false);
        this.setShouldAlternateRowBackgroundColors(true);
        this.setOpaque(true);
    }

    public void setShouldAlternateRowBackgroundColors(boolean alternate) {
        this.instanceAlternateRowColors = alternate;
    }

    public boolean shouldAlternateRowBackgroundColor() {
        if (systemAlternateRowColors) {
            return this.instanceAlternateRowColors;
        }
        return false;
    }

    protected Color getAlternatingBackgroundColor(JComponent parent, int row) {
        if (!this.shouldAlternateRowBackgroundColor()) {
            return this.getDefaultBackgroundColor();
        }
        return this.getBackgroundColorForRow(row);
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.defaultFont = f;
        this.fixedWidthFont = new Font("monospaced", this.defaultFont.getStyle(), this.defaultFont.getSize());
        this.boldFont = f.deriveFont(1);
    }

    protected void superSetFont(Font font) {
        super.setFont(font);
    }

    protected void setBold() {
        super.setFont(this.boldFont);
    }

    public void setDropRow(int dropRow) {
        this.dropRow = dropRow;
    }

    protected Border getNoFocusBorder() {
        return this.noFocusBorder;
    }

    protected Font getDefaultFont() {
        return this.defaultFont;
    }

    public Font getFixedWidthFont() {
        return this.fixedWidthFont;
    }

    public Font getBoldFont() {
        return this.boldFont;
    }

    protected Color getDefaultBackgroundColor() {
        return BACKGROUND_COLOR;
    }

    protected Color getBackgroundColorForRow(int row) {
        if ((row & 1) == 1) {
            return this.getDefaultBackgroundColor();
        }
        return ALT_BACKGROUND_COLOR;
    }

    protected Color getErrorForegroundColor(boolean isSelected) {
        return isSelected ? GThemeDefaults.Colors.Tables.ERROR_SELECTED : GThemeDefaults.Colors.Tables.ERROR_UNSELECTED;
    }

    protected Color getUneditableForegroundColor(boolean isSelected) {
        return isSelected ? GThemeDefaults.Colors.Tables.UNEDITABLE_SELECTED : GThemeDefaults.Colors.Tables.UNEDITABLE_UNSELECTED;
    }

    @Override
    public void invalidate() {
    }

    protected void superValidate() {
        super.invalidate();
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    public void repaint() {
    }

    @Override
    protected void firePropertyChange(String property, Object oldValue, Object newValue) {
        if (property.equals("text") || property.equals("labelFor") || property.equals("displayedMnemonic") || property.equals("html")) {
            super.firePropertyChange(property, oldValue, newValue);
        } else if (this.getClientProperty("html") != null && (property.equals("font") || property.equals("foreground"))) {
            super.firePropertyChange(property, oldValue, newValue);
        }
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(this.fromUiResource(fg));
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(this.fromUiResource(bg));
    }

    private Color fromUiResource(Color color) {
        if (color instanceof GColorUIResource) {
            GColorUIResource uiResource = (GColorUIResource)color;
            return uiResource.toGColor();
        }
        return color;
    }
}

