/*
 * Decompiled with CFR 0.152.
 */
package help;

import ghidra.util.Msg;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.JHelpSearchNavigator;
import javax.help.NavigatorView;
import javax.help.SearchView;
import javax.help.plaf.HelpNavigatorUI;
import javax.help.plaf.basic.BasicSearchNavigatorUI;
import javax.help.search.SearchEvent;

public class CustomSearchView
extends SearchView {
    public CustomSearchView(HelpSet hs, String name, String label, Locale locale, Hashtable params) {
        super(hs, name, label, locale, params);
    }

    public Component createNavigator(HelpModel model) {
        return new CustomHelpSearchNavigator((NavigatorView)this, model);
    }

    class CustomHelpSearchNavigator
    extends JHelpSearchNavigator {
        public CustomHelpSearchNavigator(NavigatorView view, HelpModel model) {
            super(view, model);
        }

        public void setUI(HelpNavigatorUI ui) {
            super.setUI((HelpNavigatorUI)new CustomSearchNavigatorUI(this));
        }
    }

    class CustomSearchNavigatorUI
    extends BasicSearchNavigatorUI {
        private boolean hasResults;

        public CustomSearchNavigatorUI(JHelpSearchNavigator navigator) {
            super(navigator);
        }

        public synchronized void searchStarted(SearchEvent e) {
            this.hasResults = false;
            super.searchStarted(e);
        }

        public synchronized void itemsFound(SearchEvent e) {
            super.itemsFound(e);
            Enumeration searchItems = e.getSearchItems();
            if (searchItems == null) {
                return;
            }
            this.hasResults |= e.getSearchItems().hasMoreElements();
        }

        public synchronized void searchFinished(SearchEvent e) {
            super.searchFinished(e);
            if (!this.hasResults) {
                KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                Window activeWindow = kfm.getActiveWindow();
                Msg.showInfo((Object)((Object)this), (Component)activeWindow, (String)"No Results Founds", (Object)("No search results found for \"" + e.getParams() + "\""));
            }
        }
    }
}

