/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.Msg;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;

public class ListenerMap<K, P, V extends P> {
    private static final boolean DEBUG_INCEPTION = false;
    public static final Executor CALLING_THREAD = new Executor(){

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    };
    protected static final AtomicReference<Throwable> firstExc = new AtomicReference();
    private final Object lock = new Object();
    private final Class<P> iface;
    private final Executor executor;
    private Map<K, ? extends ListenerEntry<? extends V>> map = this.createMap();
    public final P fire;
    protected final Map<Class<? extends P>, P> extFires = new HashMap<Class<? extends P>, P>();

    protected static void reportError(Object listener, Throwable e) {
        if (e instanceof RejectedExecutionException) {
            Msg.trace((Object)listener, (Object)("Listener invocation rejected: " + e));
        } else {
            Msg.error((Object)listener, (Object)("Listener " + listener + " caused unexpected exception"), (Throwable)e);
            firstExc.accumulateAndGet(e, (o, n) -> o == null ? n : o);
        }
    }

    public static void clearErr() {
        firstExc.set(null);
    }

    public static void checkErr() {
        Throwable exc = firstExc.getAndSet(null);
        if (exc != null) {
            throw new AssertionError("Listener caused an exception", exc);
        }
    }

    public ListenerMap(Class<P> iface) {
        this(iface, CALLING_THREAD);
    }

    public ListenerMap(Class<P> iface, Executor executor) {
        this.iface = Objects.requireNonNull(iface);
        this.executor = executor;
        this.fire = iface.cast(Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{iface}, new ListenerHandler<P>(iface)));
    }

    public String toString() {
        return this.map.toString();
    }

    protected Map<K, ListenerEntry<? extends V>> createMap() {
        return new HashMap();
    }

    protected void notifyRemoved(ListenerEntry<? extends V> entry) {
        Msg.warn((Object)this, (Object)("Listener garbage collected before removal: " + entry.desc));
    }

    public <T extends P> T fire(Class<T> ext) {
        if (ext == this.iface) {
            return ext.cast(this.fire);
        }
        if (!this.iface.isAssignableFrom(ext)) {
            throw new IllegalArgumentException("Cannot fire on less-specific interface");
        }
        return (T)this.extFires.computeIfAbsent(ext, e -> Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this.iface, ext}, new ListenerHandler(ext)));
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    protected void doPutAllInto(Map<? super K, ? super ListenerEntry<? extends V>> newMap) {
        for (Map.Entry<K, ListenerEntry<V>> ent : this.map.entrySet()) {
            if (ent.getValue().get() == null) {
                this.notifyRemoved(ent.getValue());
                continue;
            }
            newMap.put(ent.getKey(), ent.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K key, V val) {
        Object object = this.lock;
        synchronized (object) {
            if (this.map.get(key) == val) {
                return val;
            }
            Map<K, ListenerEntry<ListenerEntry<V>>> newMap = this.createMap();
            this.doPutAllInto(newMap);
            ListenerEntry<V> result = newMap.put(key, new ListenerEntry<V>(val));
            this.map = newMap;
            return result == null ? null : (V)result.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(ListenerMap<? extends K, P, ? extends V> that) {
        Object object = this.lock;
        synchronized (object) {
            Map<K, ListenerEntry<V>> newMap = this.createMap();
            this.doPutAllInto(newMap);
            that.doPutAllInto(newMap);
            this.map = newMap;
        }
    }

    public V get(K key) {
        ListenerEntry<? extends V> entry = this.map.get(key);
        return entry == null ? null : (V)entry.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K key) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.map.containsKey(key)) {
                return null;
            }
            Map<K, ListenerEntry<V>> newMap = this.createMap();
            this.doPutAllInto(newMap);
            ListenerEntry<V> result = newMap.remove(key);
            this.map = newMap;
            return result == null ? null : (V)result.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            if (this.map.isEmpty()) {
                return;
            }
            this.map = this.createMap();
        }
    }

    protected class ListenerHandler<T extends P>
    implements InvocationHandler {
        protected final Class<T> ext;

        public ListenerHandler(Class<T> ext) {
            this.ext = ext;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            ListenerMap.this.executor.execute(() -> {
                Collection listenersVolatile;
                Iterator iterator = ListenerMap.this.lock;
                synchronized (iterator) {
                    listenersVolatile = ListenerMap.this.map.values();
                }
                for (ListenerEntry wl : listenersVolatile) {
                    Object l = wl.get();
                    if (l == null || !this.ext.isAssignableFrom(l.getClass())) continue;
                    try {
                        method.invoke(l, args);
                    }
                    catch (InvocationTargetException e) {
                        Throwable cause = e.getCause();
                        ListenerMap.reportError(l, cause);
                    }
                    catch (Throwable e) {
                        ListenerMap.reportError(l, e);
                    }
                }
            });
            return null;
        }
    }

    public static class ListenerEntry<V>
    extends WeakReference<V> {
        final String desc;
        final Throwable inception;

        public ListenerEntry(V referent) {
            super(referent);
            this.desc = referent.toString();
            this.inception = null;
        }
    }
}

