/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.cmd;

import agent.dbgeng.dbgeng.DebugProcessId;
import agent.dbgeng.dbgeng.DebugSystemObjects;
import agent.dbgeng.dbgeng.DebugThreadId;
import agent.dbgeng.manager.DbgCommand;
import agent.dbgeng.manager.DbgEvent;
import agent.dbgeng.manager.DbgProcess;
import agent.dbgeng.manager.DbgState;
import agent.dbgeng.manager.DbgThread;
import agent.dbgeng.manager.cmd.DbgPendingCommand;
import agent.dbgeng.manager.evt.DbgCommandDoneEvent;
import agent.dbgeng.manager.impl.DbgManagerImpl;

public abstract class AbstractDbgCommand<T>
implements DbgCommand<T> {
    protected final DbgManagerImpl manager;
    DbgProcess previousProcess;
    Long previousProcessOffset;
    DebugProcessId previousProcessId;
    DbgThread previousThread;
    Long previousThreadOffset;
    DebugThreadId previousThreadId;

    protected AbstractDbgCommand(DbgManagerImpl manager) {
        this.manager = manager;
    }

    @Override
    public boolean validInState(DbgState state) {
        return true;
    }

    @Override
    public boolean handle(DbgEvent<?> evt, DbgPendingCommand<?> pending) {
        return evt instanceof DbgCommandDoneEvent && pending.getCommand().equals(((DbgCommandDoneEvent)evt).getCmd());
    }

    @Override
    public T complete(DbgPendingCommand<?> pending) {
        return null;
    }

    @Override
    public void invoke() {
    }

    public void setProcess(DbgProcess process) {
        DebugSystemObjects so = this.manager.getSystemObjects();
        this.previousProcess = process;
        if (this.manager.isKernelMode() && !process.getId().isSystem()) {
            this.previousProcessOffset = so.getCurrentProcessDataOffset();
            so.setImplicitProcessDataOffset(process.getOffset());
        } else {
            this.previousProcessId = so.getCurrentProcessId();
            so.setCurrentProcessId(process.getId());
        }
    }

    public void resetProcess() {
        DebugSystemObjects so = this.manager.getSystemObjects();
        if (this.manager.isKernelMode() && !this.previousProcess.getId().isSystem()) {
            so.setImplicitProcessDataOffset(this.previousProcessOffset);
        } else {
            so.setCurrentProcessId(this.previousProcessId);
        }
    }

    public void setThread(DbgThread thread) {
        DebugSystemObjects so = this.manager.getSystemObjects();
        this.previousThread = thread;
        if (this.manager.isKernelMode() && !thread.getId().isSystem()) {
            this.previousThreadOffset = so.getCurrentThreadDataOffset();
            so.setImplicitThreadDataOffset(thread.getOffset());
        } else {
            this.previousThreadId = so.getCurrentThreadId();
            so.setCurrentThreadId(thread.getId());
        }
    }

    public void resetThread() {
        DebugSystemObjects so = this.manager.getSystemObjects();
        if (this.manager.isKernelMode() && !this.previousThread.getId().isSystem()) {
            so.setImplicitThreadDataOffset(this.previousThreadOffset);
        } else {
            so.setCurrentThreadId(this.previousThreadId);
        }
    }
}

