/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.cmd;

import agent.dbgeng.dbgeng.DebugControl;
import agent.dbgeng.manager.DbgEvent;
import agent.dbgeng.manager.DbgStackFrame;
import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.cmd.DbgPendingCommand;
import agent.dbgeng.manager.evt.AbstractDbgCompletedCommandEvent;
import agent.dbgeng.manager.evt.DbgConsoleOutputEvent;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.manager.impl.DbgStackFrameImpl;
import agent.dbgeng.manager.impl.DbgThreadImpl;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class DbgStackListOSFramesCommand
extends AbstractDbgCommand<List<DbgStackFrame>> {
    protected final DbgThreadImpl thread;
    private List<DbgStackFrame> result = new ArrayList<DbgStackFrame>();

    public DbgStackListOSFramesCommand(DbgManagerImpl manager, DbgThreadImpl thread) {
        super(manager);
        this.thread = thread;
    }

    @Override
    public boolean handle(DbgEvent<?> evt, DbgPendingCommand<?> pending) {
        if (evt instanceof AbstractDbgCompletedCommandEvent && pending.getCommand().equals(this)) {
            return true;
        }
        if (evt instanceof DbgConsoleOutputEvent) {
            pending.steal(evt);
        }
        return false;
    }

    @Override
    public List<DbgStackFrame> complete(DbgPendingCommand<?> pending) {
        StringBuilder builder = new StringBuilder();
        for (DbgConsoleOutputEvent out : pending.findAllOf(DbgConsoleOutputEvent.class)) {
            builder.append(out.getOutput());
        }
        this.parse(builder.toString());
        return this.result;
    }

    private void parse(String output) {
        String[] lines = output.split("\n");
        int fcount = 0;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (!line.contains(" : ") || line.startsWith("Child") || line.startsWith("THREAD")) continue;
            String[] fields = line.trim().split("\\s+");
            DbgStackFrameImpl frame = new DbgStackFrameImpl(this.thread, fcount++, this.parseToBig(fields[1]), fields.length > 8 ? fields[8] : "");
            this.result.add(frame);
        }
    }

    private BigInteger parseToBig(String lval) {
        if (lval.contains("`")) {
            lval = lval.replaceAll("`", "");
        }
        return new BigInteger(lval, 16);
    }

    @Override
    public void invoke() {
        DebugControl control = this.manager.getControl();
        control.execute("!thread " + Long.toHexString(this.thread.getOffset()) + " 6");
    }
}

