/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.model.impl;

import agent.dbgeng.manager.impl.DbgProcessImpl;
import agent.dbgeng.model.iface2.DbgModelTargetConnector;
import agent.dbgeng.model.impl.DbgModelTargetConnectorContainerImpl;
import agent.dbgeng.model.impl.DbgModelTargetObjectImpl;
import ghidra.async.AsyncUtils;
import ghidra.async.TypeSpec;
import ghidra.async.seq.AsyncSequenceHandlerForRunner;
import ghidra.dbg.error.DebuggerUserException;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="ProcessAttachConnector", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(type=Void.class)})
public class DbgModelTargetProcessAttachConnectorImpl
extends DbgModelTargetObjectImpl
implements DbgModelTargetConnector {
    protected final DbgModelTargetConnectorContainerImpl connectors;
    protected final TargetMethod.TargetParameterMap paramDescs;

    public DbgModelTargetProcessAttachConnectorImpl(DbgModelTargetConnectorContainerImpl connectors, String name) {
        super(connectors.getModel(), (TargetObject)connectors, name, name);
        this.connectors = connectors;
        this.paramDescs = TargetMethod.TargetParameterMap.copyOf(this.computeParameters());
        this.changeAttributes(List.of(), List.of(), Map.of("_display", this.getDisplay(), "_parameters", this.paramDescs), "Initialized");
    }

    @Override
    public CompletableFuture<Void> setActive() {
        this.connectors.setDefaultConnector(this);
        return CompletableFuture.completedFuture(null);
    }

    protected Map<String, TargetMethod.ParameterDescription<?>> computeParameters() {
        HashMap map = new HashMap();
        TargetMethod.ParameterDescription param = TargetMethod.ParameterDescription.create(String.class, (String)"Pid", (boolean)true, (Object)"", (String)"Pid", (String)"process id for the target process");
        map.put("Pid", param);
        return map;
    }

    @Override
    public TargetMethod.TargetParameterMap getParameters() {
        return TargetMethod.getParameters((TargetObject)this);
    }

    @Override
    public CompletableFuture<Void> launch(Map<String, ?> args) {
        String pidstr = (String)args.get("Pid");
        int pid = Integer.decode(pidstr);
        return AsyncUtils.sequence((TypeSpec)TypeSpec.VOID).then(seq -> {
            DbgProcessImpl process = new DbgProcessImpl(this.getManager());
            process.attach(pid).handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForRunner)seq).nextIgnore(arg_0, arg_1));
        }).finish().exceptionally(exc -> {
            throw new DebuggerUserException("Launch failed for " + args);
        });
    }
}

