/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.impl.cmd;

import agent.gdb.manager.evt.GdbCommandDoneEvent;
import agent.gdb.manager.evt.GdbThreadExitedEvent;
import agent.gdb.manager.evt.GdbThreadGroupExitedEvent;
import agent.gdb.manager.impl.GdbEvent;
import agent.gdb.manager.impl.GdbInferiorImpl;
import agent.gdb.manager.impl.GdbManagerImpl;
import agent.gdb.manager.impl.GdbPendingCommand;
import agent.gdb.manager.impl.GdbThreadImpl;
import agent.gdb.manager.impl.cmd.AbstractGdbCommandWithThreadId;
import java.util.ArrayList;

public class GdbDetachCommand
extends AbstractGdbCommandWithThreadId<Void> {
    private final GdbInferiorImpl inferior;

    public GdbDetachCommand(GdbManagerImpl manager, GdbInferiorImpl inferior, Integer threadId) {
        super(manager, threadId);
        this.inferior = inferior;
    }

    @Override
    public String encode(String threadPart) {
        return "-target-detach" + threadPart;
    }

    @Override
    public boolean handle(GdbEvent<?> evt, GdbPendingCommand<?> pending) {
        if (super.handle(evt, pending)) {
            return true;
        }
        if (evt instanceof GdbThreadExitedEvent) {
            pending.claim(evt);
        } else if (evt instanceof GdbThreadGroupExitedEvent) {
            pending.claim(evt);
        }
        return false;
    }

    @Override
    public Void complete(GdbPendingCommand<?> pending) {
        pending.checkCompletion(GdbCommandDoneEvent.class);
        ArrayList<GdbThreadImpl> threads = new ArrayList<GdbThreadImpl>(this.inferior.getKnownThreadsImpl().values());
        for (GdbThreadImpl t : threads) {
            this.manager.fireThreadExited(t.getId(), this.inferior, pending);
            t.remove();
        }
        return null;
    }
}

