/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.art;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.art.ArtField;
import ghidra.file.formats.android.art.ArtFieldGroup;
import ghidra.file.formats.android.art.ArtHeader;
import ghidra.file.formats.android.art.ArtImageSection;
import ghidra.file.formats.android.art.ArtMethod;
import ghidra.file.formats.android.art.ArtMethodGroup;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.QWordDataType;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public abstract class ArtImageSections {
    public static final int UNSUPPORTED_SECTION = -1;
    protected ArtHeader header;
    protected List<ArtImageSection> sectionList = new ArrayList<ArtImageSection>();
    protected List<ArtFieldGroup> fieldGroupList = new ArrayList<ArtFieldGroup>();
    protected List<ArtMethodGroup> methodGroupList = new ArrayList<ArtMethodGroup>();
    protected List<ArtField> fieldList = new ArrayList<ArtField>();
    protected List<ArtMethod> methodList = new ArrayList<ArtMethod>();

    protected ArtImageSections(BinaryReader reader, ArtHeader header) {
        this.header = header;
    }

    protected String getSectionName(int sectionOrdinal) {
        for (Field field : this.getClass().getDeclaredFields()) {
            if (!field.getName().startsWith("kSection")) continue;
            try {
                Object value = field.get(null);
                if ((Integer)value != sectionOrdinal) continue;
                return field.getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "unknown_section_0x" + Integer.toHexString(sectionOrdinal);
    }

    public abstract int get_kSectionObjects();

    public abstract int get_kSectionArtFields();

    public abstract int get_kSectionArtMethods();

    public abstract int get_kSectionRuntimeMethods();

    public abstract int get_kSectionImTables();

    public abstract int get_kSectionIMTConflictTables();

    public abstract int get_kSectionDexCacheArrays();

    public abstract int get_kSectionInternedStrings();

    public abstract int get_kSectionClassTable();

    public abstract int get_kSectionStringReferenceOffsets();

    public abstract int get_kSectionMetadata();

    public abstract int get_kSectionImageBitmap();

    public abstract int get_kSectionCount();

    public final List<ArtImageSection> getSectionList() {
        return this.sectionList;
    }

    public final void parseSections(BinaryReader reader) throws IOException {
        for (int i = 0; i < this.get_kSectionCount(); ++i) {
            this.sectionList.add(new ArtImageSection(reader));
        }
    }

    public final void parse(BinaryReader reader) throws IOException {
        this.parseArtFields(reader);
        this.parseArtMethods(reader);
    }

    private void parseArtFields(BinaryReader reader) throws IOException {
        ArtImageSection kSectionArtFields = this.sectionList.get(this.get_kSectionArtFields());
        if (kSectionArtFields.getSize() > 0 && reader.length() > (long)kSectionArtFields.getOffset()) {
            reader.setPointerIndex(kSectionArtFields.getOffset());
            while (reader.getPointerIndex() < Integer.toUnsignedLong(kSectionArtFields.getEnd())) {
                if ("017".equals(this.header.getVersion())) {
                    ArtField field = new ArtField(reader);
                    this.fieldList.add(field);
                    continue;
                }
                ArtFieldGroup group = new ArtFieldGroup(reader);
                this.fieldGroupList.add(group);
            }
        }
    }

    private void parseArtMethods(BinaryReader reader) throws IOException {
        ArtImageSection kSectionArtMethods = this.sectionList.get(this.get_kSectionArtMethods());
        if (kSectionArtMethods.getSize() > 0 && reader.length() > (long)kSectionArtMethods.getOffset()) {
            reader.setPointerIndex(kSectionArtMethods.getOffset());
            while (reader.getPointerIndex() < Integer.toUnsignedLong(kSectionArtMethods.getEnd())) {
                if ("017".equals(this.header.getVersion())) {
                    ArtMethod method = new ArtMethod(reader, this.header.getPointerSize(), this.header.getVersion());
                    this.methodList.add(method);
                    continue;
                }
                ArtMethodGroup group = new ArtMethodGroup(reader, this.header.getPointerSize(), this.header.getVersion());
                this.methodGroupList.add(group);
            }
        }
    }

    public void markup(Program program, TaskMonitor monitor) throws Exception {
        this.markupSections(program, monitor);
        this.markupFields(program, monitor);
        this.markupMethods(program, monitor);
        this.markupImTables(program, monitor);
        this.markupIMTConflictTables(program, monitor);
        this.markupRuntimeMethods(program, monitor);
        this.markupDexCacheArrays(program, monitor);
        this.markupInternedStrings(program, monitor);
        this.markupClassTables(program, monitor);
    }

    private void markupSections(Program program, TaskMonitor monitor) throws Exception {
        monitor.setMessage("ART - markup sections...");
        monitor.setProgress(0L);
        monitor.setMaximum((long)this.sectionList.size());
        for (int i = 0; i < this.sectionList.size(); ++i) {
            monitor.checkCancelled();
            monitor.incrementProgress(1L);
            ArtImageSection section = this.sectionList.get(i);
            if (section.getSize() == 0) continue;
            String name = this.getSectionName(i);
            Address address = program.getMinAddress().getNewAddress((long)(this.header.getImageBegin() + section.getOffset()));
            program.getSymbolTable().createLabel(address, name, SourceType.ANALYSIS);
            program.getListing().setComment(address, 3, "Size: " + section.getSize());
            this.createFragment(program, address, section, name, monitor);
        }
    }

    private void markupFields(Program program, TaskMonitor monitor) throws Exception {
        DataType dataType;
        int i;
        Address address;
        if (this.get_kSectionArtFields() == -1) {
            return;
        }
        monitor.setMessage("ART - markup fields...");
        monitor.setProgress(0L);
        monitor.setMaximum((long)this.fieldList.size());
        ArtImageSection section = this.sectionList.get(this.get_kSectionArtFields());
        if (section.getSize() > 0) {
            address = program.getMinAddress().getNewAddress((long)(this.header.getImageBegin() + section.getOffset()));
            for (i = 0; i < this.fieldList.size(); ++i) {
                monitor.checkCancelled();
                ArtField field = this.fieldList.get(i);
                dataType = field.toDataType();
                program.getListing().createData(address, dataType);
                String comment = "Declaring Class: 0x" + Integer.toHexString(field.getDeclaringClass());
                program.getListing().setComment(address, 3, comment);
                address = address.add((long)dataType.getLength());
                monitor.incrementProgress(1L);
            }
        }
        if (section.getSize() > 0) {
            address = program.getMinAddress().getNewAddress((long)(this.header.getImageBegin() + section.getOffset()));
            for (i = 0; i < this.fieldGroupList.size(); ++i) {
                monitor.checkCancelled();
                ArtFieldGroup fieldGroup = this.fieldGroupList.get(i);
                dataType = fieldGroup.toDataType();
                program.getListing().createData(address, dataType);
                if (fieldGroup.getFieldCount() > 0) {
                    ArtField artField = fieldGroup.getFieldList().get(0);
                    String comment = "Declaring Class: 0x" + Integer.toHexString(artField.getDeclaringClass());
                    program.getListing().setComment(address, 3, comment);
                }
                address = address.add((long)dataType.getLength());
                monitor.incrementProgress(1L);
            }
        }
    }

    private void markupMethods(Program program, TaskMonitor monitor) throws Exception {
        DataType dataType;
        int i;
        Address address;
        if (this.get_kSectionArtMethods() == -1) {
            return;
        }
        monitor.setMessage("ART - markup methods...");
        monitor.setProgress(0L);
        monitor.setMaximum((long)this.methodGroupList.size());
        ArtImageSection section = this.sectionList.get(this.get_kSectionArtMethods());
        if (section.getSize() > 0) {
            address = program.getMinAddress().getNewAddress((long)(this.header.getImageBegin() + section.getOffset()));
            for (i = 0; i < this.methodList.size(); ++i) {
                monitor.checkCancelled();
                ArtMethod method = this.methodList.get(i);
                dataType = method.toDataType();
                program.getListing().createData(address, dataType);
                String comment = "Declaring Class: 0x" + Integer.toHexString(method.getDeclaringClass());
                program.getListing().setComment(address, 3, comment);
                address = address.add((long)dataType.getLength());
                monitor.incrementProgress(1L);
            }
        }
        if (section.getSize() > 0) {
            address = program.getMinAddress().getNewAddress((long)(this.header.getImageBegin() + section.getOffset()));
            for (i = 0; i < this.methodGroupList.size(); ++i) {
                monitor.checkCancelled();
                ArtMethodGroup methodGroup = this.methodGroupList.get(i);
                dataType = methodGroup.toDataType();
                program.getListing().createData(address, dataType);
                if (methodGroup.getMethodCount() > 0L) {
                    ArtMethod artMethod = methodGroup.getMethodList().get(0);
                    String comment = "Declaring Class: 0x" + Integer.toHexString(artMethod.getDeclaringClass());
                    program.getListing().setComment(address, 3, comment);
                }
                address = address.add((long)dataType.getLength());
                monitor.incrementProgress(1L);
            }
        }
    }

    private void markupImTables(Program program, TaskMonitor monitor) throws Exception {
        if (this.get_kSectionImTables() == -1) {
            return;
        }
        ArtImageSection section = this.sectionList.get(this.get_kSectionImTables());
        monitor.setMessage("ART - markup IM tables...");
        monitor.setProgress(0L);
        monitor.setMaximum((long)section.getSize());
        int pointerSize = this.header.getPointerSize();
        if (section.getSize() > 0) {
            Address address = program.getMinAddress().getNewAddress((long)(this.header.getImageBegin() + section.getOffset()));
            if (!program.getMemory().contains(address)) {
                return;
            }
            Address endAddress = address.add((long)section.getSize());
            while (address.compareTo((Object)endAddress) < 0) {
                monitor.checkCancelled();
                monitor.incrementProgress((long)pointerSize);
                this.createDataAt(program, address, pointerSize);
                address = address.add((long)pointerSize);
            }
        }
    }

    private void markupIMTConflictTables(Program program, TaskMonitor monitor) throws Exception {
        if (this.get_kSectionIMTConflictTables() == -1) {
            return;
        }
        ArtImageSection section = this.sectionList.get(this.get_kSectionIMTConflictTables());
        monitor.setMessage("ART - markup IMT conflict tables...");
        monitor.setProgress(0L);
        monitor.setMaximum((long)section.getSize());
        int pointerSize = this.header.getPointerSize();
        if (section.getSize() > 0) {
            Address address = program.getMinAddress().getNewAddress((long)(this.header.getImageBegin() + section.getOffset()));
            if (!program.getMemory().contains(address)) {
                return;
            }
            Address endAddress = address.add((long)section.getSize());
            while (address.compareTo((Object)endAddress) < 0) {
                monitor.checkCancelled();
                monitor.incrementProgress((long)pointerSize);
                this.createDataAt(program, address, pointerSize);
                address = address.add((long)pointerSize);
            }
        }
    }

    private void markupRuntimeMethods(Program program, TaskMonitor monitor) throws Exception {
        if (this.get_kSectionRuntimeMethods() == -1) {
            return;
        }
        ArtImageSection section = this.sectionList.get(this.get_kSectionRuntimeMethods());
        monitor.setMessage("ART - markup runtime methods...");
        monitor.setProgress(0L);
        monitor.setMaximum((long)section.getSize());
        int pointerSize = this.header.getPointerSize();
        if (section.getSize() > 0) {
            Address address = program.getMinAddress().getNewAddress((long)(this.header.getImageBegin() + section.getOffset()));
            if (!program.getMemory().contains(address)) {
                return;
            }
            Address endAddress = address.add((long)section.getSize());
            while (address.compareTo((Object)endAddress) < 0) {
                monitor.checkCancelled();
                monitor.incrementProgress((long)pointerSize);
                this.createDataAt(program, address, pointerSize);
                address = address.add((long)pointerSize);
            }
        }
    }

    private void markupDexCacheArrays(Program program, TaskMonitor monitor) throws Exception {
        if (this.get_kSectionDexCacheArrays() == -1) {
            return;
        }
        ArtImageSection section = this.sectionList.get(this.get_kSectionDexCacheArrays());
        monitor.setMessage("ART - markup dex cache arrays...");
        monitor.setProgress(0L);
        monitor.setMaximum((long)section.getSize());
        if (section.getSize() > 0) {
            Address address = program.getMinAddress().getNewAddress((long)(this.header.getImageBegin() + section.getOffset()));
            if (!program.getMemory().contains(address)) {
                return;
            }
            Address endAddress = address.add((long)section.getSize());
            while (address.compareTo((Object)endAddress) < 0) {
                monitor.checkCancelled();
                monitor.incrementProgress(4L);
                this.createDataAt(program, address, 4);
                address = address.add(4L);
            }
        }
    }

    private void markupInternedStrings(Program program, TaskMonitor monitor) throws Exception {
        if (this.get_kSectionInternedStrings() == -1) {
            return;
        }
        ArtImageSection section = this.sectionList.get(this.get_kSectionInternedStrings());
        monitor.setMessage("ART - markup interned strings...");
        monitor.setProgress(0L);
        monitor.setMaximum((long)section.getSize());
        if (section.getSize() > 0) {
            Address address = program.getMinAddress().getNewAddress((long)(this.header.getImageBegin() + section.getOffset()));
            if (!program.getMemory().contains(address)) {
                return;
            }
            Address endAddress = address.add((long)section.getSize());
            while (address.compareTo((Object)endAddress) < 0) {
                monitor.checkCancelled();
                monitor.incrementProgress(4L);
                this.createDataAt(program, address, 4);
                address = address.add(4L);
            }
        }
    }

    private void markupClassTables(Program program, TaskMonitor monitor) throws Exception {
        if (this.get_kSectionClassTable() == -1) {
            return;
        }
        ArtImageSection section = this.sectionList.get(this.get_kSectionClassTable());
        monitor.setMessage("ART - markup class tables...");
        monitor.setProgress(0L);
        monitor.setMaximum((long)section.getSize());
        if (section.getSize() > 0) {
            Address address = program.getMinAddress().getNewAddress((long)(this.header.getImageBegin() + section.getOffset()));
            if (!program.getMemory().contains(address)) {
                return;
            }
            Address endAddress = address.add((long)section.getSize());
            while (address.compareTo((Object)endAddress) < 0) {
                monitor.checkCancelled();
                monitor.incrementProgress(4L);
                address = address.add(4L);
            }
        }
    }

    private void createDataAt(Program program, Address address, int pointerSize) throws Exception {
        if (pointerSize == 4) {
            program.getListing().createData(address, (DataType)new DWordDataType());
        } else if (pointerSize == 8) {
            program.getListing().createData(address, (DataType)new QWordDataType());
        } else {
            throw new RuntimeException("invalid pointer size");
        }
    }

    private void createFragment(Program program, Address address, ArtImageSection section, String sectionName, TaskMonitor monitor) {
        try {
            ProgramModule rootModule = program.getListing().getDefaultRootModule();
            ProgramFragment fragment = null;
            for (Group group : rootModule.getChildren()) {
                if (!group.getName().equals(sectionName)) continue;
                fragment = (ProgramFragment)group;
            }
            if (fragment == null) {
                fragment = rootModule.createFragment(sectionName);
            }
            Address endAddress = address.add(Integer.toUnsignedLong(section.getSize()) - 1L);
            if (this.sectionList.indexOf(section) == this.sectionList.size() - 1 && endAddress.compareTo((Object)program.getMaxAddress()) > 0) {
                endAddress = program.getMaxAddress();
            }
            fragment.move(address, endAddress);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

