/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.edge;

import docking.DockingWindowManager;
import generic.concurrent.GThreadPool;
import ghidra.graph.GDirectedGraph;
import ghidra.graph.GraphAlgorithms;
import ghidra.graph.VisualGraph;
import ghidra.graph.algo.ChkDominanceAlgorithm;
import ghidra.graph.algo.ChkPostDominanceAlgorithm;
import ghidra.graph.graphs.GroupingVisualGraph;
import ghidra.graph.viewer.PathHighlightMode;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.edge.PathHighlightListener;
import ghidra.graph.viewer.edge.PathHighlighterWorkPauser;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.CallbackAccumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.MonitoredRunnable;
import ghidra.util.task.RunManager;
import ghidra.util.task.SwingRunnable;
import ghidra.util.task.SwingUpdateManager;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import ghidra.util.task.TimeoutTaskMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import utility.function.Callback;

public class VisualGraphPathHighlighter<V extends VisualVertex, E extends VisualEdge<V>> {
    private static final int ALGORITHM_TIMEOUT = 5;
    private PathHighlightMode vertexFocusMode = PathHighlightMode.OFF;
    private PathHighlightMode vertexHoverMode = PathHighlightMode.OFF;
    private Map<V, Set<E>> forwardFlowEdgeCache = new HashMap<V, Set<E>>();
    private Map<V, Set<E>> reverseFlowEdgeCache = new HashMap<V, Set<E>>();
    private Map<V, Set<E>> forwardScopedFlowEdgeCache = new HashMap<V, Set<E>>();
    private Map<V, Set<E>> reverseScopedFlowEdgeCache = new HashMap<V, Set<E>>();
    private VisualGraph<V, E> graph;
    private RunManager hoverRunManager = new RunManager("Graph Decorator", null);
    private RunManager focusRunManager = new RunManager("Graph Decorator", null);
    private CompletableFuture<ChkDominanceAlgorithm<V, E>> dominanceFuture;
    private CompletableFuture<ChkDominanceAlgorithm<V, E>> postDominanceFuture;
    private CompletableFuture<Circuits> circuitFuture;
    private PathHighlightListener listener = isHover -> {};
    private PathHighlighterWorkPauser workPauser = () -> false;
    private SwingUpdateManager focusedVertexUpdater = new SwingUpdateManager(() -> this.doUpdateFocusedVertex());

    public VisualGraphPathHighlighter(VisualGraph<V, E> graph, PathHighlightListener listener) {
        this.graph = graph;
        if (listener != null) {
            this.listener = listener;
        }
    }

    public void setWorkPauser(PathHighlighterWorkPauser pauser) {
        if (pauser != null) {
            this.workPauser = pauser;
        }
    }

    private Executor getGraphExecutor() {
        GThreadPool pool = GThreadPool.getSharedThreadPool((String)"Graph Decorator");
        return pool.getExecutor();
    }

    private CompletableFuture<ChkDominanceAlgorithm<V, E>> lazyCreateDominaceFuture() {
        if (this.dominanceFuture != null) {
            return this.dominanceFuture;
        }
        Executor executor = this.getGraphExecutor();
        this.dominanceFuture = CompletableFuture.supplyAsync(() -> {
            TimeoutTaskMonitor timeoutMonitor = TimeoutTaskMonitor.timeoutIn((long)5L, (TimeUnit)TimeUnit.SECONDS, (TaskMonitor)new TaskMonitorAdapter(true));
            GDirectedGraph<V, E> dominanceGraph = this.getDominanceGraph(this.graph, true);
            if (dominanceGraph == null) {
                Msg.debug((Object)this, (Object)("No sources found for graph; cannot calculate dominance: " + this.graph.getClass().getSimpleName()));
                return null;
            }
            try {
                return new ChkDominanceAlgorithm<V, E>(dominanceGraph, (TaskMonitor)timeoutMonitor);
            }
            catch (CancelledException e) {
                Msg.debug((Object)this, (Object)("Domiance calculation timed-out for " + this.graph.getClass().getSimpleName()));
                return null;
            }
        }, executor);
        return this.dominanceFuture;
    }

    protected GDirectedGraph<V, E> getDominanceGraph(VisualGraph<V, E> visualGraph, boolean forward) {
        Set<V> sources = GraphAlgorithms.getSources(visualGraph);
        if (!sources.isEmpty()) {
            return visualGraph;
        }
        return null;
    }

    private CompletableFuture<ChkDominanceAlgorithm<V, E>> lazyCreatePostDominanceFuture() {
        if (this.postDominanceFuture != null) {
            return this.postDominanceFuture;
        }
        Executor executor = this.getGraphExecutor();
        this.postDominanceFuture = CompletableFuture.supplyAsync(() -> {
            TimeoutTaskMonitor timeoutMonitor = TimeoutTaskMonitor.timeoutIn((long)5L, (TimeUnit)TimeUnit.SECONDS, (TaskMonitor)new TaskMonitorAdapter(true));
            try {
                return new ChkPostDominanceAlgorithm<V, E>(this.graph, (TaskMonitor)timeoutMonitor);
            }
            catch (CancelledException e) {
                Msg.debug((Object)this, (Object)("Post-domiance calculation timed-out for " + this.graph.getClass().getSimpleName()));
                return null;
            }
        }, executor);
        return this.postDominanceFuture;
    }

    private CompletableFuture<Circuits> lazyCreateCircuitFuture() {
        if (this.circuitFuture != null) {
            return this.circuitFuture;
        }
        Executor executor = this.getGraphExecutor();
        this.circuitFuture = CompletableFuture.supplyAsync(() -> {
            TimeoutTaskMonitor timeoutMonitor = TimeoutTaskMonitor.timeoutIn((long)5L, (TimeUnit)TimeUnit.SECONDS, (TaskMonitor)new TaskMonitorAdapter(true));
            Circuits circuits = this.calculateCircuitsAsync((TaskMonitor)timeoutMonitor);
            if (!circuits.complete) {
                this.setStatusTextSwing("Unable to calculate all loops - timed-out");
            }
            return circuits;
        }, executor);
        return this.circuitFuture;
    }

    private void setStatusTextSwing(String message) {
        DockingWindowManager dwm = DockingWindowManager.getActiveInstance();
        if (dwm != null) {
            dwm.setStatusText(message);
        }
    }

    public void stop() {
        this.hoverRunManager.cancelAllRunnables();
        this.focusRunManager.cancelAllRunnables();
        if (this.dominanceFuture != null) {
            this.dominanceFuture.cancel(true);
        }
        if (this.postDominanceFuture != null) {
            this.postDominanceFuture.cancel(true);
        }
        if (this.circuitFuture != null) {
            this.circuitFuture.cancel(true);
        }
    }

    public void dispose() {
        this.hoverRunManager.dispose();
        this.focusRunManager.dispose();
        this.clearCacheSwing();
    }

    public boolean isBusy() {
        return this.hoverRunManager.isInProgress() || this.focusRunManager.isInProgress();
    }

    public PathHighlightMode getVertexHoverPathHighlightMode() {
        return this.vertexHoverMode;
    }

    public PathHighlightMode getVertexFocusPathHighlightMode() {
        return this.vertexFocusMode;
    }

    public void setVertexFocusMode(PathHighlightMode mode) {
        this.vertexFocusMode = Objects.requireNonNull(mode);
        V focusedVertex = this.graph.getFocusedVertex();
        this.setFocusedVertex(focusedVertex);
    }

    public void setVertexHoverMode(PathHighlightMode mode) {
        this.vertexHoverMode = Objects.requireNonNull(mode);
        if (this.vertexHoverMode == PathHighlightMode.OFF) {
            this.clearHoveredEdgesSwing();
        }
    }

    public void setHoveredVertex(V hoveredVertex) {
        this.clearHoveredEdgesSwing();
        if (this.workPauser.isPaused()) {
            return;
        }
        if (hoveredVertex == null) {
            return;
        }
        switch (this.vertexHoverMode) {
            case IN: {
                this.setInHoveredEdgesSwing(hoveredVertex);
                break;
            }
            case OUT: {
                this.setOutHoveredEdgesSwing(hoveredVertex);
                break;
            }
            case INOUT: {
                this.setInOutHoveredEdgesSwing(hoveredVertex);
                break;
            }
            case CYCLE: {
                this.setVertexCycleHoveredEdgesSwing(hoveredVertex);
                break;
            }
            case SCOPED_FORWARD: {
                this.setForwardScopedFlowHoveredEdgesSwing(hoveredVertex);
                break;
            }
            case SCOPED_REVERSE: {
                this.setReverseScopedFlowHoveredEdgesSwing(hoveredVertex);
                break;
            }
            case PATH: {
                V focusedVertex = this.graph.getFocusedVertex();
                if (focusedVertex == null) break;
                this.setVertexToVertexPathHoveredEdgesSwing(focusedVertex, hoveredVertex);
                break;
            }
        }
    }

    public void setFocusedVertex(V focusedVertex) {
        if (this.workPauser.isPaused()) {
            this.focusedVertexUpdater.updateLater();
            return;
        }
        this.clearFocusedEdgesSwing();
        if (this.vertexFocusMode == PathHighlightMode.ALLCYCLE) {
            this.setAllCycleFocusedEdgesSwing();
            return;
        }
        if (focusedVertex == null) {
            return;
        }
        switch (this.vertexFocusMode) {
            case IN: {
                this.setInFocusedEdges(focusedVertex);
                break;
            }
            case OUT: {
                this.setOutFocusedEdgesSwing(focusedVertex);
                break;
            }
            case INOUT: {
                this.setInOutFocusedEdgesSwing(focusedVertex);
                break;
            }
            case SCOPED_FORWARD: {
                this.setForwardScopedFlowFocusedEdgesSwing(focusedVertex);
                break;
            }
            case SCOPED_REVERSE: {
                this.setReverseScopedFlowFocusedEdgesSwing(focusedVertex);
                break;
            }
            case CYCLE: {
                this.setVertexCycleFocusedEdgesSwing(focusedVertex);
                break;
            }
        }
    }

    private void doUpdateFocusedVertex() {
        V focusedVertex = this.graph.getFocusedVertex();
        this.setFocusedVertex(focusedVertex);
    }

    private void clearHoveredEdgesSwing() {
        for (VisualEdge edge : this.graph.getEdges()) {
            edge.setInHoveredVertexPath(false);
        }
    }

    private void clearFocusedEdgesSwing() {
        for (VisualEdge edge : this.graph.getEdges()) {
            edge.setInFocusedVertexPath(false);
        }
    }

    public void clearEdgeCache() {
        HashSet newAllCircuitFlowEdgeCache = new HashSet();
        HashMap newCircuitFlowEdgeCache = new HashMap();
        this.accumulateCircuitEdgesForCurrentStateOfGraphSwing(newAllCircuitFlowEdgeCache, newCircuitFlowEdgeCache);
        this.clearCacheSwing();
        this.setEdgeCircuitsSwing(newAllCircuitFlowEdgeCache, newCircuitFlowEdgeCache);
    }

    private void accumulateCircuitEdgesForCurrentStateOfGraphSwing(Set<E> newAllCircuits, Map<V, Set<E>> newCircuitsByVertex) {
        CompletableFuture<Circuits> f = this.circuitFuture;
        if (f == null || !f.isDone() || f.isCancelled()) {
            return;
        }
        Circuits circuits = this.getAsync(this.circuitFuture);
        this.accumulateAllCircuitsSwing(circuits, newAllCircuits);
        this.accumulateVertexCircuitsSwing(circuits, newCircuitsByVertex);
    }

    private void accumulateAllCircuitsSwing(Circuits circuits, Set<E> results) {
        Set edges = circuits.allCircuits;
        for (VisualEdge e : edges) {
            VisualEdge currentEdge = this.ensureEdgeUpToDateSwing(e);
            if (currentEdge == null) continue;
            results.add(currentEdge);
        }
    }

    private void accumulateVertexCircuitsSwing(Circuits circuits, Map<V, Set<E>> results) {
        Map circuitsByVertex = circuits.circuitsByVertex;
        Set entrySet = circuitsByVertex.entrySet();
        for (Map.Entry entry : entrySet) {
            VisualVertex v = (VisualVertex)entry.getKey();
            if (!this.graph.containsVertex(v)) {
                VisualVertex newVertex = this.findMatchingVertexSwing(v);
                if (newVertex == null) continue;
                v = newVertex;
            }
            HashSet<VisualEdge> newEdgeSet = new HashSet<VisualEdge>();
            Set oldEdgeSet = entry.getValue();
            for (VisualEdge e : oldEdgeSet) {
                VisualEdge currentEdge = this.ensureEdgeUpToDateSwing(e);
                if (currentEdge == null) continue;
                newEdgeSet.add(currentEdge);
            }
            results.put(v, newEdgeSet);
        }
    }

    private E ensureEdgeUpToDateSwing(E edge) {
        VisualVertex start = (VisualVertex)edge.getStart();
        VisualVertex end = (VisualVertex)edge.getEnd();
        boolean containsStart = this.graph.containsVertex(start);
        boolean containsDestination = this.graph.containsVertex(end);
        if (containsStart && containsDestination) {
            return edge;
        }
        VisualVertex newStart = this.findMatchingVertexSwing(start);
        VisualVertex newEnd = this.findMatchingVertexSwing(end);
        return (E)((VisualEdge)this.graph.findEdge(newStart, newEnd));
    }

    private V findMatchingVertexSwing(V v) {
        if (!(this.graph instanceof GroupingVisualGraph)) {
            return v;
        }
        V matchingVertex = ((GroupingVisualGraph)this.graph).findMatchingVertex(v);
        return matchingVertex;
    }

    private void clearCacheSwing() {
        this.forwardFlowEdgeCache.clear();
        this.reverseFlowEdgeCache.clear();
        this.forwardScopedFlowEdgeCache.clear();
        this.reverseScopedFlowEdgeCache.clear();
        this.disposeSwing(this.circuitFuture, Circuits::clear);
        this.disposeSwing(this.dominanceFuture, ChkDominanceAlgorithm::clear);
        this.disposeSwing(this.postDominanceFuture, ChkDominanceAlgorithm::clear);
        this.dominanceFuture = null;
        this.postDominanceFuture = null;
    }

    private void setInFocusedEdges(V vertex) {
        Supplier supplier = () -> this.getReverseFlowEdgesForVertexAsync(vertex);
        this.focusRunManager.runNow((MonitoredRunnable)new SetFocusedEdgesRunnable(supplier), null);
    }

    private void setOutFocusedEdgesSwing(V vertex) {
        Supplier supplier = () -> this.getForwardFlowEdgesForVertexAsync(vertex);
        this.focusRunManager.runNow((MonitoredRunnable)new SetFocusedEdgesRunnable(supplier), null);
    }

    private void setForwardScopedFlowFocusedEdgesSwing(V vertex) {
        Supplier supplier = () -> this.getForwardScopedFlowEdgesForVertexAsync(vertex);
        this.focusRunManager.runNow((MonitoredRunnable)new SetFocusedEdgesRunnable(supplier), null);
    }

    private void setReverseScopedFlowFocusedEdgesSwing(V vertex) {
        Supplier supplier = () -> this.getReverseScopedFlowEdgesForVertexAsync(vertex);
        this.focusRunManager.runNow((MonitoredRunnable)new SetFocusedEdgesRunnable(supplier), null);
    }

    private void setInOutFocusedEdgesSwing(V vertex) {
        Supplier inSupplier = () -> this.getReverseFlowEdgesForVertexAsync(vertex);
        this.focusRunManager.runNow((MonitoredRunnable)new SetFocusedEdgesRunnable(inSupplier), null);
        Supplier outSupplier = () -> this.getForwardFlowEdgesForVertexAsync(vertex);
        this.focusRunManager.runNext((MonitoredRunnable)new SetFocusedEdgesRunnable(outSupplier), null);
    }

    private void setVertexCycleFocusedEdgesSwing(V vertex) {
        Supplier supplier = () -> this.getCircuitEdgesAsync(vertex);
        this.focusRunManager.runNow((MonitoredRunnable)new SetFocusedEdgesRunnable(supplier), null);
    }

    private void setAllCycleFocusedEdgesSwing() {
        Supplier supplier = () -> this.getAllCircuitFlowEdgesAsync();
        this.focusRunManager.runNow((MonitoredRunnable)new SetFocusedEdgesRunnable(supplier), null);
    }

    private void setInHoveredEdgesSwing(V vertex) {
        Supplier supplier = () -> this.getReverseFlowEdgesForVertexAsync(vertex);
        this.hoverRunManager.runNow((MonitoredRunnable)new SetHoveredEdgesRunnable(supplier), null);
    }

    private void setOutHoveredEdgesSwing(V vertex) {
        Supplier supplier = () -> this.getForwardFlowEdgesForVertexAsync(vertex);
        this.hoverRunManager.runNow((MonitoredRunnable)new SetHoveredEdgesRunnable(supplier), null);
    }

    private void setForwardScopedFlowHoveredEdgesSwing(V vertex) {
        Supplier supplier = () -> this.getForwardScopedFlowEdgesForVertexAsync(vertex);
        this.hoverRunManager.runNow((MonitoredRunnable)new SetHoveredEdgesRunnable(supplier), null);
    }

    private void setReverseScopedFlowHoveredEdgesSwing(V vertex) {
        Supplier supplier = () -> this.getReverseScopedFlowEdgesForVertexAsync(vertex);
        this.hoverRunManager.runNow((MonitoredRunnable)new SetHoveredEdgesRunnable(supplier), null);
    }

    private void setInOutHoveredEdgesSwing(V vertex) {
        Supplier inSupplier = () -> this.getReverseFlowEdgesForVertexAsync(vertex);
        this.hoverRunManager.runNow((MonitoredRunnable)new SetHoveredEdgesRunnable(inSupplier), null);
        Supplier outSupplier = () -> this.getForwardFlowEdgesForVertexAsync(vertex);
        this.hoverRunManager.runNext((MonitoredRunnable)new SetHoveredEdgesRunnable(outSupplier), null);
    }

    private void setVertexCycleHoveredEdgesSwing(V vertex) {
        Supplier supplier = () -> this.getCircuitEdgesAsync(vertex);
        this.hoverRunManager.runNow((MonitoredRunnable)new SetHoveredEdgesRunnable(supplier), null);
    }

    private void setVertexToVertexPathHoveredEdgesSwing(V start, V end) {
        Callback callback = () -> this.calculatePathsBetweenVerticesAsync(start, end);
        this.focusRunManager.runNow((MonitoredRunnable)new SlowSetHoveredEdgesRunnable(callback), null);
    }

    private void setInFocusedPathOnSwing(Collection<E> edges) {
        edges.forEach(e -> e.setInFocusedVertexPath(true));
        this.listener.pathHighlightChanged(false);
    }

    private void setInHoverPathOnSwing(Collection<E> edges) {
        edges.forEach(e -> e.setInHoveredVertexPath(true));
        this.listener.pathHighlightChanged(true);
    }

    private void setEdgeCircuitsSwing(Set<E> allCircuitResults, Map<V, Set<E>> circuitFlowResults) {
        if (this.vertexFocusMode == PathHighlightMode.ALLCYCLE) {
            this.setAllCycleFocusedEdgesSwing();
        } else if (this.vertexFocusMode == PathHighlightMode.CYCLE) {
            V focused = this.graph.getFocusedVertex();
            this.setVertexCycleFocusedEdgesSwing(focused);
        }
    }

    private <T> void disposeSwing(CompletableFuture<T> cf, Consumer<T> clearer) {
        if (cf == null) {
            return;
        }
        if (!cf.isDone()) {
            cf.cancel(true);
            return;
        }
        if (cf.isCompletedExceptionally()) {
            return;
        }
        Object result = cf.getNow(null);
        if (result != null) {
            clearer.accept(result);
        }
    }

    private Set<E> getForwardScopedFlowEdgesForVertexAsync(V v) {
        if (v == null) {
            return null;
        }
        Set<E> flowEdges = this.forwardScopedFlowEdgeCache.get(v);
        if (flowEdges == null) {
            flowEdges = this.findForwardScopedFlowAsync(v);
            this.forwardScopedFlowEdgeCache.put((Set<E>)v, flowEdges);
        }
        return Collections.unmodifiableSet(flowEdges);
    }

    private Set<E> getForwardFlowEdgesForVertexAsync(V v) {
        return this.getFlowEdgesForVertexAsync(true, this.forwardFlowEdgeCache, v);
    }

    private Set<E> getReverseFlowEdgesForVertexAsync(V v) {
        return this.getFlowEdgesForVertexAsync(false, this.reverseFlowEdgeCache, v);
    }

    private Set<E> getFlowEdgesForVertexAsync(boolean isForward, Map<V, Set<E>> cache, V v) {
        if (v == null) {
            return null;
        }
        Set<E> flowEdges = cache.get(v);
        if (flowEdges == null) {
            flowEdges = new HashSet();
            Set<E> pathsToVertex = GraphAlgorithms.getEdgesFrom(this.graph, v, isForward);
            flowEdges.addAll(pathsToVertex);
            cache.put((Set<E>)v, flowEdges);
        }
        return Collections.unmodifiableSet(flowEdges);
    }

    private Set<E> getAllCircuitFlowEdgesAsync() {
        CompletableFuture<Circuits> future = this.lazyCreateCircuitFuture();
        Circuits circuits = this.getAsync(future);
        if (circuits == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(circuits.allCircuits);
    }

    private Set<E> getReverseScopedFlowEdgesForVertexAsync(V v) {
        if (v == null) {
            return null;
        }
        Set<E> flowEdges = this.reverseScopedFlowEdgeCache.get(v);
        if (flowEdges == null) {
            flowEdges = this.findReverseScopedFlowAsync(v);
            this.reverseScopedFlowEdgeCache.put((Set<E>)v, flowEdges);
        }
        return Collections.unmodifiableSet(flowEdges);
    }

    private Set<E> getCircuitEdgesAsync(V v) {
        if (v == null) {
            return null;
        }
        CompletableFuture<Circuits> future = this.lazyCreateCircuitFuture();
        Circuits circuits = this.getAsync(future);
        if (circuits == null) {
            return Collections.emptySet();
        }
        Set set = circuits.circuitsByVertex.get(v);
        if (set == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(set);
    }

    private <T> T getAsync(CompletableFuture<T> cf) {
        try {
            T t = cf.get();
            return t;
        }
        catch (InterruptedException e) {
            Msg.trace((Object)this, (Object)"Unable to calculate graph path highlights - interrupted", (Throwable)e);
        }
        catch (ExecutionException e) {
            Msg.debug((Object)this, (Object)"Unable to calculate graph path highlights", (Throwable)e);
        }
        return null;
    }

    private Circuits calculateCircuitsAsync(TaskMonitor monitor) {
        Circuits result = new Circuits();
        monitor.setMessage("Finding all loops");
        Set<Set<V>> strongs = GraphAlgorithms.getStronglyConnectedComponents(this.graph);
        for (Set<V> vertices : strongs) {
            if (monitor.isCancelled()) {
                return result;
            }
            if (vertices.size() == 1) continue;
            GDirectedGraph<V, E> subGraph = GraphAlgorithms.createSubGraph(this.graph, vertices);
            Collection<E> edges = subGraph.getEdges();
            result.allCircuits.addAll(edges);
            HashSet<E> asSet = new HashSet<E>(edges);
            Collection<V> subVertices = subGraph.getVertices();
            for (VisualVertex v : subVertices) {
                if (monitor.isCancelled()) {
                    return result;
                }
                result.circuitsByVertex.put((HashSet<E>)((Object)v), asSet);
            }
        }
        result.complete = true;
        return result;
    }

    private List<E> pathToEdgesAsync(List<V> path) {
        ArrayList<VisualEdge> results = new ArrayList<VisualEdge>();
        Iterator<V> it = path.iterator();
        VisualVertex from = (VisualVertex)it.next();
        while (it.hasNext()) {
            VisualVertex to = (VisualVertex)it.next();
            VisualEdge e = (VisualEdge)this.graph.findEdge(from, to);
            results.add(e);
            from = to;
        }
        return results;
    }

    private Set<E> findForwardScopedFlowAsync(V v) {
        CompletableFuture<ChkDominanceAlgorithm<V, E>> future = this.lazyCreateDominaceFuture();
        try {
            ChkDominanceAlgorithm<V, E> dominanceAlgorithm = this.getAsync(future);
            if (dominanceAlgorithm != null) {
                Set<V> dominated = dominanceAlgorithm.getDominated(v);
                return GraphAlgorithms.retainEdges(this.graph, dominated);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptySet();
    }

    private Set<E> findReverseScopedFlowAsync(V v) {
        CompletableFuture<ChkDominanceAlgorithm<V, E>> future = this.lazyCreatePostDominanceFuture();
        try {
            ChkDominanceAlgorithm<V, E> postDominanceAlgorithm = this.getAsync(future);
            if (postDominanceAlgorithm != null) {
                Set<V> dominated = postDominanceAlgorithm.getDominated(v);
                return GraphAlgorithms.retainEdges(this.graph, dominated);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptySet();
    }

    private void calculatePathsBetweenVerticesAsync(V v1, V v2) {
        if (v1.equals(v2)) {
            return;
        }
        CallbackAccumulator accumulator = new CallbackAccumulator(path -> {
            List<E> edges = this.pathToEdgesAsync((List<V>)path);
            SystemUtilities.runSwingLater(() -> this.setInHoverPathOnSwing(edges));
        });
        TimeoutTaskMonitor timeoutMonitor = TimeoutTaskMonitor.timeoutIn((long)5L, (TimeUnit)TimeUnit.SECONDS, (TaskMonitor)new TaskMonitorAdapter(true));
        try {
            GraphAlgorithms.findPaths(this.graph, v1, v2, accumulator, (TaskMonitor)timeoutMonitor);
        }
        catch (ConcurrentModificationException concurrentModificationException) {
        }
        catch (CancelledException e) {
            SystemUtilities.runSwingLater(() -> this.setStatusTextSwing("Path computation halted by user or timeout.\nPaths shown in graph are not complete!"));
        }
    }

    private class Circuits {
        private boolean complete;
        private Set<E> allCircuits = new HashSet();
        private Map<V, Set<E>> circuitsByVertex = new HashMap();

        private Circuits() {
        }

        void clear() {
            this.allCircuits.clear();
            this.circuitsByVertex.clear();
        }

        public String toString() {
            return "{\n\tall circuits: " + this.allCircuits + "\n\tby vertex: " + this.circuitsByVertex + "\n}";
        }
    }

    private class SetFocusedEdgesRunnable
    implements SwingRunnable {
        private Supplier<Set<E>> edgeSupplier;
        private Set<E> edges;

        SetFocusedEdgesRunnable(Supplier<Set<E>> edgeSupplier) {
            this.edgeSupplier = edgeSupplier;
        }

        public void monitoredRun(TaskMonitor monitor) {
            try {
                this.edges = this.edgeSupplier.get();
            }
            catch (CancellationException e) {
                monitor.cancel();
            }
        }

        public void swingRun(boolean isCancelled) {
            if (isCancelled) {
                return;
            }
            VisualGraphPathHighlighter.this.setInFocusedPathOnSwing(this.edges);
        }
    }

    private class SetHoveredEdgesRunnable
    implements SwingRunnable {
        private Supplier<Set<E>> edgeSupplier;
        private Set<E> edges;

        SetHoveredEdgesRunnable(Supplier<Set<E>> edgeSupplier) {
            this.edgeSupplier = edgeSupplier;
        }

        public void monitoredRun(TaskMonitor monitor) {
            try {
                this.edges = this.edgeSupplier.get();
            }
            catch (CancellationException e) {
                monitor.cancel();
            }
        }

        public void swingRun(boolean isCancelled) {
            if (isCancelled) {
                return;
            }
            VisualGraphPathHighlighter.this.setInHoverPathOnSwing(this.edges);
        }
    }

    private class SlowSetHoveredEdgesRunnable
    implements MonitoredRunnable {
        private Callback callback;

        SlowSetHoveredEdgesRunnable(Callback callback) {
            this.callback = callback;
        }

        public void monitoredRun(TaskMonitor monitor) {
            try {
                this.callback.call();
            }
            catch (CancellationException e) {
                monitor.cancel();
            }
        }
    }
}

