/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.WeakSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Stream;

class CopyOnReadWeakSet<T>
extends WeakSet<T> {
    protected CopyOnReadWeakSet() {
    }

    private synchronized Collection<T> createCopy() {
        Set ks = this.weakHashStorage.keySet();
        return new ArrayList(ks);
    }

    @Override
    public synchronized void add(T t) {
        this.maybeWarnAboutAnonymousValue(t);
        this.weakHashStorage.put(t, null);
    }

    @Override
    public synchronized void remove(T t) {
        this.weakHashStorage.remove(t);
    }

    @Override
    public synchronized void clear() {
        this.weakHashStorage.clear();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.weakHashStorage.isEmpty();
    }

    @Override
    public synchronized int size() {
        return this.weakHashStorage.size();
    }

    @Override
    public synchronized boolean contains(T t) {
        return this.weakHashStorage.containsKey(t);
    }

    public synchronized String toString() {
        return this.weakHashStorage.keySet().toString();
    }

    @Override
    public synchronized Iterator<T> iterator() {
        return this.createCopy().iterator();
    }

    @Override
    public synchronized Collection<T> values() {
        return this.createCopy();
    }

    @Override
    public synchronized Stream<T> stream() {
        return this.createCopy().stream();
    }
}

