/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.expr;

import ghidra.app.plugin.assembler.sleigh.expr.AbstractBinaryExpressionSolver;
import ghidra.app.plugin.assembler.sleigh.expr.DefaultSolverHint;
import ghidra.app.plugin.assembler.sleigh.expr.MaskedLong;
import ghidra.app.plugin.assembler.sleigh.expr.NeedsBackfillException;
import ghidra.app.plugin.assembler.sleigh.expr.SolverException;
import ghidra.app.plugin.assembler.sleigh.expr.SolverHint;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedPatterns;
import ghidra.app.plugin.processors.sleigh.expression.MultExpression;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import java.util.Map;
import java.util.Set;

public class MultExpressionSolver
extends AbstractBinaryExpressionSolver<MultExpression> {
    public MultExpressionSolver() {
        super(MultExpression.class);
    }

    protected AssemblyResolution tryRep(PatternExpression lexp, MaskedLong rval, MaskedLong repGoal, MaskedLong goal, Map<String, Long> vals, AssemblyResolvedPatterns cur, Set<SolverHint> hints, String description) throws NeedsBackfillException {
        MaskedLong lval = repGoal.divideUnsigned(rval);
        if (lval.multiply(rval).agrees(goal)) {
            return this.solver.solve(lexp, lval, vals, cur, hints, description);
        }
        return null;
    }

    @Override
    protected AssemblyResolution solveLeftSide(PatternExpression lexp, MaskedLong rval, MaskedLong goal, Map<String, Long> vals, AssemblyResolvedPatterns cur, Set<SolverHint> hints, String description) throws NeedsBackfillException, SolverException {
        ResultTracker tracker = new ResultTracker();
        AssemblyResolution sol = tracker.trySolverFunc(() -> super.solveLeftSide(lexp, rval, goal, vals, cur, hints, description));
        if (sol != null) {
            return sol;
        }
        if (hints.contains(DefaultSolverHint.GUESSING_REPETITION)) {
            return tracker.returnBest(rval, goal);
        }
        int unksToRight = Long.numberOfTrailingZeros(goal.msk);
        int unksToLeft = Long.numberOfLeadingZeros(goal.msk);
        int numBitsKnown = 64 - unksToRight - unksToLeft;
        if (Long.bitCount(goal.msk) == numBitsKnown) {
            MaskedLong repRightGoal;
            int i;
            Set<SolverHint> hintsWithRepetition = SolverHint.with(hints, DefaultSolverHint.GUESSING_REPETITION);
            int reps = (unksToRight + numBitsKnown - 1) / numBitsKnown;
            long repMsk = goal.msk;
            long repVal = goal.val;
            for (i = 0; i < reps; ++i) {
                repMsk = repMsk >>> numBitsKnown | repMsk;
                repVal = repVal >>> numBitsKnown | repVal;
            }
            if (reps > 0 && (sol = tracker.trySolverFunc(() -> this.lambda$solveLeftSide$1(lexp, rval, repRightGoal = MaskedLong.fromMaskAndValue(repMsk, repVal), goal, vals, cur, hintsWithRepetition, description))) != null) {
                return sol;
            }
            reps = (unksToLeft + numBitsKnown - 1) / numBitsKnown;
            for (i = 0; i < reps; ++i) {
                repVal = repVal << numBitsKnown | repVal;
            }
            for (i = unksToLeft - 1; i >= 0; --i) {
                repMsk = -1L >>> i;
                MaskedLong repLeftGoal = MaskedLong.fromMaskAndValue(repMsk, repVal);
                sol = tracker.trySolverFunc(() -> this.tryRep(lexp, rval, repLeftGoal, goal, vals, cur, hintsWithRepetition, description));
                if (sol == null) continue;
                return sol;
            }
        }
        return tracker.returnBest(rval, goal);
    }

    @Override
    protected AssemblyResolution solveRightSide(PatternExpression rexp, MaskedLong lval, MaskedLong goal, Map<String, Long> vals, AssemblyResolvedPatterns cur, Set<SolverHint> hints, String description) throws NeedsBackfillException, SolverException {
        return this.solveLeftSide(rexp, lval, goal, vals, cur, hints, description);
    }

    @Override
    public MaskedLong computeLeft(MaskedLong rval, MaskedLong goal) throws SolverException {
        MaskedLong lval = goal.invMultiplyUnsigned(rval);
        if (lval.multiply(rval).agrees(goal)) {
            return lval;
        }
        throw new SolverException("Encountered unsolvable multiplication: " + rval + "*x = " + goal);
    }

    @Override
    public MaskedLong compute(MaskedLong lval, MaskedLong rval) {
        return lval.multiply(rval);
    }

    private /* synthetic */ AssemblyResolution lambda$solveLeftSide$1(PatternExpression lexp, MaskedLong rval, MaskedLong repRightGoal, MaskedLong goal, Map vals, AssemblyResolvedPatterns cur, Set hintsWithRepetition, String description) throws NeedsBackfillException, SolverException {
        return this.tryRep(lexp, rval, repRightGoal, goal, vals, cur, hintsWithRepetition, description);
    }

    private static class ResultTracker {
        AssemblyResolution firstBackfillRes = null;
        NeedsBackfillException firstBackfillExc = null;
        AssemblyResolution firstErrorRes = null;
        Throwable firstErrorExc = null;

        private ResultTracker() {
        }

        AssemblyResolution trySolverFunc(SolverFunc func) {
            block9: {
                try {
                    AssemblyResolution sol = func.solve();
                    if (sol == null) {
                        return null;
                    }
                    if (sol.isBackfill()) {
                        if (this.firstBackfillRes == null && this.firstBackfillExc == null) {
                            this.firstBackfillRes = sol;
                        }
                        break block9;
                    }
                    if (sol.isError()) {
                        if (this.firstErrorRes == null && this.firstErrorExc == null) {
                            this.firstErrorRes = sol;
                        }
                        break block9;
                    }
                    return sol;
                }
                catch (NeedsBackfillException e) {
                    if (this.firstBackfillRes == null && this.firstBackfillExc == null) {
                        this.firstBackfillExc = e;
                    }
                }
                catch (SolverException | UnsupportedOperationException e) {
                    if (this.firstErrorRes != null || this.firstErrorExc != null) break block9;
                    this.firstErrorExc = e;
                }
            }
            return null;
        }

        AssemblyResolution returnBest(MaskedLong rval, MaskedLong goal) throws NeedsBackfillException, SolverException {
            if (this.firstBackfillExc != null) {
                throw this.firstBackfillExc;
            }
            if (this.firstBackfillRes != null) {
                return this.firstBackfillRes;
            }
            if (this.firstErrorExc != null && this.firstErrorExc instanceof SolverException) {
                throw (SolverException)this.firstErrorExc;
            }
            if (this.firstErrorExc != null && this.firstErrorExc instanceof UnsupportedOperationException) {
                throw (UnsupportedOperationException)this.firstErrorExc;
            }
            if (this.firstErrorExc != null) {
                throw new AssertionError();
            }
            if (this.firstErrorRes != null) {
                return this.firstErrorRes;
            }
            throw new SolverException("Encountered unsolvable multiplication: " + rval + "*x = " + goal);
        }
    }

    private static interface SolverFunc {
        public AssemblyResolution solve() throws NeedsBackfillException, SolverException;
    }
}

