/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.function;

import ghidra.program.database.function.FunctionDB;
import ghidra.program.database.function.VariableDB;
import ghidra.program.database.symbol.SymbolDB;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.listing.AutoParameterType;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;

class ParameterDB
extends VariableDB
implements Parameter {
    ParameterDB(FunctionDB function, SymbolDB s) {
        super(function, s);
    }

    @Override
    public int getFirstUseOffset() {
        return 0;
    }

    @Override
    public int getOrdinal() {
        int baseOrdinal = this.function.getAutoParamCount();
        int ordinal = this.symbol.getOrdinal();
        return baseOrdinal + ordinal;
    }

    void setOrdinal(int ordinal) {
        if (this.getOrdinal() == ordinal) {
            return;
        }
        int baseOrdinal = this.function.getAutoParamCount();
        this.symbol.setOrdinal(ordinal - baseOrdinal);
    }

    @Override
    void setDynamicStorage(VariableStorage storage) {
        this.storage = storage;
    }

    @Override
    public DataType getDataType() {
        DataType dt = this.getFormalDataType();
        VariableStorage varStorage = this.getVariableStorage();
        if (varStorage.isForcedIndirect()) {
            Program program = this.function.getProgram();
            ProgramBasedDataTypeManager dtm = program.getDataTypeManager();
            int ptrSize = varStorage.size();
            dt = ptrSize != dtm.getDataOrganization().getPointerSize() ? dtm.getPointer(dt, ptrSize) : dtm.getPointer(dt);
        }
        return dt;
    }

    @Override
    public DataType getFormalDataType() {
        return super.getDataType();
    }

    @Override
    public boolean isForcedIndirect() {
        VariableStorage varStorage = this.getVariableStorage();
        return varStorage != null ? varStorage.isForcedIndirect() : false;
    }

    @Override
    public boolean isAutoParameter() {
        return false;
    }

    @Override
    public AutoParameterType getAutoParameterType() {
        return null;
    }
}

