/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableOffset;
import ghidra.program.util.CodeUnitLocation;
import java.util.Objects;

public class OperandFieldLocation
extends CodeUnitLocation {
    private String rep;
    private int subOpIndex = -1;
    private VariableOffset variableOffset;

    public OperandFieldLocation(Program program, Address addr, int[] componentPath, Address refAddr, String rep, int opIndex, int characterOffset) {
        super(program, addr, componentPath, refAddr, 0, opIndex, characterOffset);
        this.rep = rep;
        this.subOpIndex = -1;
    }

    public OperandFieldLocation(Program program, Address addr, int[] componentPath, Address refAddr, String rep, int opIndex, int subOpIndex, int characterOffset) {
        super(program, addr, componentPath, refAddr, 0, opIndex, characterOffset);
        this.rep = rep;
        this.subOpIndex = subOpIndex;
    }

    public OperandFieldLocation(Program program, Address addr, VariableOffset variableOffset, Address refAddr, String rep, int opIndex, int subOpIndex, int characterOffset) {
        super(program, addr, null, refAddr, 0, opIndex, characterOffset);
        this.rep = rep;
        this.subOpIndex = subOpIndex;
        this.variableOffset = variableOffset;
    }

    public OperandFieldLocation() {
    }

    public VariableOffset getVariableOffset() {
        return this.variableOffset;
    }

    public String getOperandRepresentation() {
        return this.rep;
    }

    public int getOperandIndex() {
        return this.getColumn();
    }

    public int getSubOperandIndex() {
        return this.subOpIndex;
    }

    @Override
    public String toString() {
        return super.toString() + ", OpRep = " + this.rep + ", subOpIndex = " + this.subOpIndex + ", VariableOffset = " + this.variableOffset;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.rep == null ? 0 : this.rep.hashCode());
        result = 31 * result + this.subOpIndex;
        result = 31 * result + (this.variableOffset == null ? 0 : this.variableOffset.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OperandFieldLocation other = (OperandFieldLocation)obj;
        if (!Objects.equals(this.rep, other.rep)) {
            return false;
        }
        if (this.subOpIndex != other.subOpIndex) {
            return false;
        }
        return Objects.equals(this.variableOffset, other.variableOffset);
    }

    @Override
    public void restoreState(Program p, SaveState obj) {
        super.restoreState(p, obj);
        this.rep = obj.getString("_REP", "");
        this.subOpIndex = obj.getInt("_SUBOPINDEX", this.subOpIndex);
    }

    @Override
    public void saveState(SaveState obj) {
        super.saveState(obj);
        obj.putString("_REP", this.rep);
        obj.putInt("_SUBOPINDEX", this.subOpIndex);
    }
}

