/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.BigEndianDataConverter;
import ghidra.util.DataConverter;
import ghidra.util.LittleEndianDataConverter;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public class ProgramUtilities {
    private static Map<Program, Object> openProgramsWeakMap = new WeakHashMap<Program, Object>();

    private ProgramUtilities() {
    }

    public static DataConverter getDataConverter(Program program) {
        if (program.getMemory().isBigEndian()) {
            return BigEndianDataConverter.INSTANCE;
        }
        return LittleEndianDataConverter.INSTANCE;
    }

    public static void addTrackedProgram(Program program) {
        if (SystemUtilities.isInTestingMode()) {
            openProgramsWeakMap.put(program, null);
        }
    }

    public static Iterator<Program> getSystemPrograms() {
        return Collections.unmodifiableSet(openProgramsWeakMap.keySet()).iterator();
    }

    public static Address parseAddress(Program program, String addressString) {
        Address[] addrs = program.parseAddress(addressString);
        if (addrs != null && addrs.length > 0) {
            return addrs[0];
        }
        String stackPrefix = "Stack[";
        if (addressString.startsWith(stackPrefix)) {
            String offsetString = addressString.substring(stackPrefix.length(), addressString.length() - 1);
            try {
                long offset = NumericUtilities.parseLong((String)offsetString);
                return program.getAddressFactory().getStackSpace().getAddress(offset);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public static String getByteCodeString(CodeUnit cu) {
        int length = cu.getLength();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            String hex;
            if (i != 0) {
                buffer.append(" ");
            }
            try {
                hex = Integer.toHexString(cu.getByte(i) & 0xFF);
                if (hex.length() == 1) {
                    buffer.append("0");
                }
            }
            catch (MemoryAccessException e) {
                hex = "??";
            }
            buffer.append(hex);
        }
        return buffer.toString();
    }

    public static void convertFunctionWrappedExternalPointer(Symbol functionSymbol) {
        if (functionSymbol.getSymbolType() != SymbolType.FUNCTION) {
            return;
        }
        Program program = functionSymbol.getProgram();
        Listing listing = program.getListing();
        SymbolTable symbolTable = program.getSymbolTable();
        Data data = listing.getDefinedDataAt(functionSymbol.getAddress());
        if (data == null || !data.isPointer()) {
            return;
        }
        Reference ref = data.getPrimaryReference(0);
        if (ref == null || !ref.isExternalReference()) {
            return;
        }
        Address extAddr = ref.getToAddress();
        Symbol s = symbolTable.getPrimarySymbol(extAddr);
        if (s == null) {
            program.getReferenceManager().delete(ref);
            return;
        }
        Function func = (Function)functionSymbol.getObject();
        if (func == null) {
            return;
        }
        try {
            if (s.getSymbolType() != SymbolType.LABEL) {
                functionSymbol.delete();
                return;
            }
            ExternalLocation extLoc = (ExternalLocation)s.getObject();
            Function extFunc = extLoc.createFunction();
            extFunc.setComment(func.getComment());
            func.setComment(null);
            extFunc.setStackPurgeSize(func.getStackPurgeSize());
            extFunc.setCallingConvention(func.getCallingConventionName());
            extFunc.setNoReturn(func.hasNoReturn());
            extFunc.setReturnType(func.getReturnType(), SourceType.ANALYSIS);
            for (Parameter param : func.getParameters()) {
                extFunc.addParameter(param, param.getSource());
            }
            extFunc.setVarArgs(func.hasVarArgs());
            functionSymbol.delete();
        }
        catch (InvalidInputException e) {
            Msg.error(ProgramUtilities.class, (Object)"Unexpected Exception", (Throwable)e);
        }
        catch (DuplicateNameException e) {
            Msg.error(ProgramUtilities.class, (Object)"Unexpected Exception", (Throwable)e);
        }
    }
}

