/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model;

import com.sun.jdi.Location;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.jdi.manager.JdiCause;
import ghidra.dbg.jdi.manager.JdiEventsListenerAdapter;
import ghidra.dbg.jdi.manager.breakpoint.JdiBreakpointInfo;
import ghidra.dbg.jdi.model.JdiModelTargetBreakpointSpec;
import ghidra.dbg.jdi.model.JdiModelTargetField;
import ghidra.dbg.jdi.model.JdiModelTargetLocation;
import ghidra.dbg.jdi.model.JdiModelTargetObjectImpl;
import ghidra.dbg.jdi.model.JdiModelTargetVM;
import ghidra.dbg.jdi.model.iface2.JdiModelTargetObject;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetBreakpointSpecContainer;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.program.model.address.AddressRange;
import ghidra.util.datastruct.WeakValueHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="BreakpointContainer", elements={@TargetElementType(type=JdiModelTargetBreakpointSpec.class)}, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class JdiModelTargetBreakpointContainer
extends JdiModelTargetObjectImpl
implements TargetBreakpointSpecContainer,
JdiEventsListenerAdapter {
    protected static final TargetBreakpointSpecContainer.TargetBreakpointKindSet SUPPORTED_KINDS = TargetBreakpointSpecContainer.TargetBreakpointKindSet.of((TargetBreakpointSpec.TargetBreakpointKind[])TargetBreakpointSpec.TargetBreakpointKind.values());
    protected final Map<JdiBreakpointInfo, JdiModelTargetBreakpointSpec> specsByInfo = new WeakValueHashMap();

    public JdiModelTargetBreakpointContainer(JdiModelTargetVM vm) {
        super(vm, "Breakpoints");
        this.impl.getManager().addEventsListener(null, this);
        this.changeAttributes(List.of(), List.of(), Map.of("_supported_breakpoint_kinds", SUPPORTED_KINDS), "Initialized");
    }

    @Override
    public void breakpointCreated(JdiBreakpointInfo info, JdiCause cause) {
        this.changeElements(List.of(), List.of(this.getTargetBreakpointSpec(info)), Map.of(), "Created");
    }

    @Override
    public void breakpointModified(JdiBreakpointInfo newInfo, JdiBreakpointInfo oldInfo, JdiCause cause) {
        this.getTargetBreakpointSpec(oldInfo).updateInfo(oldInfo, newInfo, "Modified");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void breakpointDeleted(JdiBreakpointInfo info, JdiCause cause) {
        JdiModelTargetBreakpointContainer jdiModelTargetBreakpointContainer = this;
        synchronized (jdiModelTargetBreakpointContainer) {
            this.specsByInfo.remove(info);
        }
        this.changeElements(List.of(info.toString()), List.of(), Map.of(), "Deleted");
    }

    public CompletableFuture<Void> placeBreakpoint(AddressRange range, Set<TargetBreakpointSpec.TargetBreakpointKind> kinds) {
        if (kinds.contains(TargetBreakpointSpec.TargetBreakpointKind.SW_EXECUTE)) {
            Location location = this.impl.getLocation(range.getMinAddress());
            JdiModelTargetLocation targetLocation = (JdiModelTargetLocation)this.getTargetObject(location);
            if (targetLocation == null) {
                targetLocation = new JdiModelTargetLocation(this, location, true);
            }
            JdiBreakpointInfo info = targetLocation.addBreakpoint();
            this.breakpointCreated(info, JdiCause.Causes.UNCLAIMED);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> placeBreakpoint(String expression, Set<TargetBreakpointSpec.TargetBreakpointKind> kinds) {
        JdiModelTargetObject targetObject = this.getTargetObject(expression);
        if (targetObject != null) {
            JdiModelTargetField targetField;
            JdiBreakpointInfo info;
            if (kinds.contains(TargetBreakpointSpec.TargetBreakpointKind.SW_EXECUTE) && targetObject instanceof JdiModelTargetLocation) {
                JdiModelTargetLocation targetLocation = (JdiModelTargetLocation)targetObject;
                info = targetLocation.addBreakpoint();
                this.breakpointCreated(info, JdiCause.Causes.UNCLAIMED);
            }
            if ((kinds.contains(TargetBreakpointSpec.TargetBreakpointKind.READ) || kinds.contains(TargetBreakpointSpec.TargetBreakpointKind.HW_EXECUTE)) && targetObject instanceof JdiModelTargetField && this.targetVM.vm.canWatchFieldAccess()) {
                targetField = (JdiModelTargetField)targetObject;
                info = targetField.addAccessWatchpoint();
                this.breakpointCreated(info, JdiCause.Causes.UNCLAIMED);
            }
            if (kinds.contains(TargetBreakpointSpec.TargetBreakpointKind.WRITE) && targetObject instanceof JdiModelTargetField && this.targetVM.vm.canWatchFieldModification()) {
                targetField = (JdiModelTargetField)targetObject;
                info = targetField.addModificationWatchpoint();
                this.breakpointCreated(info, JdiCause.Causes.UNCLAIMED);
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    public synchronized JdiModelTargetBreakpointSpec getTargetBreakpointSpec(JdiBreakpointInfo info) {
        return this.specsByInfo.computeIfAbsent(info, i -> new JdiModelTargetBreakpointSpec(this, info, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateUsingBreakpoints(Map<Long, JdiBreakpointInfo> byNumber) {
        List specs;
        JdiModelTargetBreakpointContainer jdiModelTargetBreakpointContainer = this;
        synchronized (jdiModelTargetBreakpointContainer) {
            specs = byNumber.values().stream().map(this::getTargetBreakpointSpec).collect(Collectors.toList());
        }
        this.setElements(specs, Map.of(), "Refreshed");
    }

    public CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        return CompletableFuture.completedFuture(null);
    }
}

